/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.components.toolbar.actions;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import jd.controlling.TaskQueue;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.downloadcontroller.DownloadSession;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogJob;
import jd.controlling.downloadcontroller.DownloadWatchDogProperty;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.downloadcontroller.event.DownloadWatchdogListener;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.MainTabbedPane;
import jd.gui.swing.jdgui.interfaces.View;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.components.ExtButton;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.gui.event.GUIEventSender;
import org.jdownloader.gui.event.GUIListener;
import org.jdownloader.gui.toolbar.action.AbstractToolBarAction;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberView;
import org.jdownloader.gui.views.linkgrabber.contextmenu.ConfirmLinksContextAction;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.translate._JDT;

public class StartDownloadsAction
extends AbstractToolBarAction
implements DownloadWatchdogListener,
GUIListener,
GenericConfigEventListener<Enum>,
ActionContext {
    private boolean hideIfDownloadsAreRunning = false;
    public static final String HIDE_IF_DOWNLOADS_ARE_RUNNING = "HideIfDownloadsAreRunning";
    private final Icon normalSmall = new AbstractIcon("media-playback-start", 18);
    private final Icon forcedSmall = new AbstractIcon("play_breakup_forced_only", 18);
    private final Icon normalLarge = new AbstractIcon("media-playback-start", 24);
    private final Icon forcedLarge = new AbstractIcon("play_breakup_forced_only", 24);
    private Icon smallIcon = this.normalSmall;
    private Icon largeIcon = this.normalLarge;

    public StartDownloadsAction() {
        this.setName(_JDT.T.StartDownloadsAction_createTooltip_());
        DownloadWatchDog.getInstance().getEventSender().addListener((EventListener)((Object)this), true);
        DownloadWatchDog.getInstance().notifyCurrentState((DownloadWatchdogListener)this);
        CFG_GUI.START_BUTTON_ACTION_IN_LINKGRABBER_CONTEXT.getEventSender().addListener((EventListener)((Object)this), true);
        GUIEventSender.getInstance().addListener((EventListener)((Object)this), true);
        this.onGuiMainTabSwitch(null, MainTabbedPane.getInstance().getSelectedView());
        this.setAccelerator(83);
        this.updateEnableState();
    }

    public void initContextDefaults() {
        this.setHideIfDownloadsAreRunning(false);
    }

    public void onKeyModifier(int parameter) {
    }

    public void actionPerformed(ActionEvent e) {
        if (JDGui.getInstance().isCurrentPanel(JDGui.Panels.LINKGRABBER)) {
            TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    switch (CFG_GUI.CFG.getStartButtonActionInLinkgrabberContext()) {
                        case ADD_ALL_LINKS_AND_START_DOWNLOADS: {
                            LinkGrabberTable.getInstance().getSelectionInfo((PackageControllerTable.SelectionInfoCallback)new PackageControllerTable.SelectionInfoCallback<CrawledPackage, CrawledLink>(){

                                public void onSelectionInfo(SelectionInfo<CrawledPackage, CrawledLink> selectionInfo) {
                                    LinkCollector.ConfirmLinksSettings cls = new LinkCollector.ConfirmLinksSettings(LinkCollector.MoveLinksMode.MANUAL);
                                    cls.setAutoStartDownloads(Boolean.valueOf(true));
                                    cls.setClearLinkgrabberlistOnConfirm(Boolean.valueOf(false));
                                    cls.setSwitchToDownloadlistOnConfirm(Boolean.valueOf(true));
                                    cls.setForceDownloads(Boolean.valueOf(false));
                                    ConfirmLinksContextAction.confirmSelection(selectionInfo, (LinkCollector.ConfirmLinksSettings)cls);
                                }

                                public boolean isCancelled() {
                                    return false;
                                }
                            }, PackageControllerTable.SelectionType.ALL);
                            break;
                        }
                        case START_DOWNLOADS_ONLY: {
                            DownloadWatchDog.getInstance().startDownloads();
                            break;
                        }
                    }
                    return null;
                }
            });
        } else {
            DownloadWatchDog.getInstance().startDownloads();
        }
        DownloadSession session = DownloadWatchDog.getInstance().getSession();
        if (session != null && session.isForcedOnlyModeEnabled()) {
            DownloadWatchDog.getInstance().enqueueJob(new DownloadWatchDogJob(){

                public void interrupt() {
                }

                public void execute(DownloadSession currentSession) {
                    currentSession.setForcedOnlyModeEnabled(false);
                    StartDownloadsAction.this.updateEnableState();
                }

                public boolean isHighPriority() {
                    return true;
                }
            });
        }
    }

    public String createTooltip() {
        DownloadSession session = DownloadWatchDog.getInstance().getSession();
        if (session != null && session.isForcedOnlyModeEnabled()) {
            return _JDT.T.StartDownloadsAction_forced_createTooltip_();
        }
        return _JDT.T.StartDownloadsAction_createTooltip_();
    }

    public static String getHideIfDownloadsAreRunningTranslation() {
        return _JDT.T.StartDownloadsAction_getHideIfDownloadsAreRunningTranslation_();
    }

    @Customizer(link="#getHideIfDownloadsAreRunningTranslation")
    public boolean isHideIfDownloadsAreRunning() {
        return this.hideIfDownloadsAreRunning;
    }

    public void setHideIfDownloadsAreRunning(boolean showIfDownloadsAreRunning) {
        this.hideIfDownloadsAreRunning = showIfDownloadsAreRunning;
        this.updateEnableState();
    }

    public void onDownloadWatchdogDataUpdate() {
    }

    public void onDownloadWatchdogStateIsIdle() {
        this.updateEnableState();
    }

    public String getIconKey() {
        return null;
    }

    private void updateEnableState() {
        DownloadWatchDog.getInstance().enqueueJob(new DownloadWatchDogJob(){

            public boolean isHighPriority() {
                return false;
            }

            public void interrupt() {
            }

            public void execute(final DownloadSession session) {
                new EDTRunner(){

                    protected void runInEDT() {
                        boolean isRunning = DownloadWatchDog.getInstance().isRunning();
                        boolean enable = !isRunning;
                        Icon newSmall = StartDownloadsAction.this.normalSmall;
                        if (session != null && isRunning) {
                            enable |= session.isForcedOnlyModeEnabled();
                            if (session.isForcedOnlyModeEnabled()) {
                                newSmall = StartDownloadsAction.this.forcedSmall;
                            }
                        }
                        if (newSmall != StartDownloadsAction.this.smallIcon) {
                            if (newSmall == StartDownloadsAction.this.forcedSmall) {
                                StartDownloadsAction.this.smallIcon = StartDownloadsAction.this.forcedSmall;
                                StartDownloadsAction.this.largeIcon = StartDownloadsAction.this.forcedLarge;
                            } else {
                                StartDownloadsAction.this.smallIcon = StartDownloadsAction.this.normalSmall;
                                StartDownloadsAction.this.largeIcon = StartDownloadsAction.this.normalLarge;
                            }
                            StartDownloadsAction.this.firePropertyChange("SmallIcon", new Object(), new Object());
                            StartDownloadsAction.this.firePropertyChange("SwingLargeIconKey", new Object(), new Object());
                        }
                        if (StartDownloadsAction.this.smallIcon == StartDownloadsAction.this.forcedSmall) {
                            StartDownloadsAction.this.setTooltipText(_JDT.T.StartDownloadsAction_forced_createTooltip_());
                        } else {
                            StartDownloadsAction.this.setTooltipText(_JDT.T.StartDownloadsAction_createTooltip_());
                        }
                        View view = JDGui.getInstance().getMainTabbedPane().getSelectedView();
                        if (enable && view instanceof LinkGrabberView && CFG_GUI.CFG.getStartButtonActionInLinkgrabberContext() == GraphicalUserInterfaceSettings.StartButtonAction.DISABLED) {
                            enable = false;
                        }
                        StartDownloadsAction.this.setEnabled(enable);
                        if (StartDownloadsAction.this.isHideIfDownloadsAreRunning()) {
                            StartDownloadsAction.this.setVisible(enable);
                        }
                    }
                };
            }
        });
    }

    protected Icon getSmallIconForToolbar() {
        return this.smallIcon;
    }

    protected Icon getLargeIconForToolbar() {
        return this.largeIcon;
    }

    public Object getValue(String key) {
        return super.getValue(key);
    }

    public AbstractButton createButton() {
        ExtButton bt = new ExtButton((AbstractAction)((Object)this));
        bt.setHideActionText(true);
        return bt;
    }

    public void onDownloadWatchdogStateIsPause() {
    }

    public void onDownloadWatchdogStateIsRunning() {
        this.updateEnableState();
    }

    public void onDownloadWatchdogStateIsStopped() {
        this.updateEnableState();
    }

    public void onDownloadWatchdogStateIsStopping() {
    }

    public void onGuiMainTabSwitch(View oldView, View newView) {
        DownloadWatchDog.getInstance().notifyCurrentState((DownloadWatchdogListener)this);
    }

    public void onConfigValidatorError(KeyHandler<Enum> keyHandler, Enum invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Enum> keyHandler, Enum newValue) {
        this.onGuiMainTabSwitch(null, MainTabbedPane.getInstance().getSelectedView());
    }

    public void onDownloadControllerStart(SingleDownloadController downloadController, DownloadLinkCandidate candidate) {
    }

    public void onDownloadControllerStopped(SingleDownloadController downloadController, DownloadLinkCandidate candidate, DownloadLinkCandidateResult result) {
    }

    public void onDownloadWatchDogPropertyChange(DownloadWatchDogProperty propertyChange) {
    }
}

