/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.myjd.panels;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.swing.MigPanel;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTableHeaderRenderer;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtComponentColumn;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.uio.UIOManager;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.renderer.RenderLabel;
import org.appwork.utils.swing.renderer.RendererMigPanel;
import org.jdownloader.api.RemoteAPIController;
import org.jdownloader.api.useragent.ConnectedDevice;
import org.jdownloader.api.useragent.UserAgentListener;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;

public class ConnectedDevicesTableModel
extends ExtTableModel<ConnectedDevice> {
    private DelayedRunnable delayer;

    public ConnectedDevicesTableModel() {
        super("SolverOrderTableModel");
        this.update();
        this.delayer = new DelayedRunnable(1000L){

            public void delayedrun() {
                ConnectedDevicesTableModel.this.update();
            }
        };
        RemoteAPIController.getInstance().getUaController().getEventSender().addListener((EventListener)new UserAgentListener(){

            public void onRemovedAPIUserAgent(ConnectedDevice ua) {
                ConnectedDevicesTableModel.this.delayer.resetAndStart();
            }

            public void onNewAPIUserAgent(ConnectedDevice ua) {
                ConnectedDevicesTableModel.this.delayer.resetAndStart();
            }

            public void onAPIUserAgentUpdate(ConnectedDevice fua) {
                ConnectedDevicesTableModel.this.delayer.resetAndStart();
            }
        });
    }

    private void update() {
        new EDTRunner(){

            protected void runInEDT() {
                List lst = RemoteAPIController.getInstance().getUaController().list();
                List tableData = ConnectedDevicesTableModel.this.refreshSort(lst);
                ConnectedDevicesTableModel.this._replaceTableData(tableData, false);
            }
        };
    }

    protected void initColumns() {
        this.addColumn((ExtColumn)new ExtTextColumn<ConnectedDevice>(_GUI.T.ConnectedDevicesTableModel_frontend()){

            public String getStringValue(ConnectedDevice value) {
                return value.getFrontendName();
            }
        });
        this.addColumn((ExtColumn)new ExtTextColumn<ConnectedDevice>(_GUI.T.ConnectedDevicesTableModel_device()){

            public String getStringValue(ConnectedDevice value) {
                return value.getDeviceName();
            }
        });
        this.addColumn((ExtColumn)new ExtTextColumn<ConnectedDevice>(_GUI.T.ConnectedDevicesTableModel_connection()){

            public String getStringValue(ConnectedDevice value) {
                return value.getConnectionString();
            }
        });
        this.addColumn((ExtColumn)new ExtComponentColumn<ConnectedDevice>(_GUI.T.ConnectedDevicesTableModel_kill()){
            private JButton editorBtn;
            private JButton rendererBtn;
            private ConnectedDevice device;
            protected MigPanel editor;
            protected RendererMigPanel renderer;
            private RenderLabel label;
            {
                this.editorBtn = new JButton("");
                this.editorBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.stopCellEditing();
                        if (device != null && UIOManager.I().showConfirmDialog(0, _GUI.T.lit_are_you_sure(), _GUI.T.myjd_kill_connections_are_you_sure(), (Icon)new AbstractIcon("question", 32), _GUI.T.lit_yes(), null)) {
                            RemoteAPIController.getInstance().getUaController().disconnectDecice(device);
                            ConnectedDevicesTableModel.this.update();
                        }
                    }
                });
                this.label = new RenderLabel();
                this.rendererBtn = new JButton("");
                this.editor = new MigPanel("ins 1", "[grow,fill]", "[18!]"){

                    public void requestFocus() {
                    }
                };
                this.editor.add((Component)this.editorBtn);
                this.renderer = new RendererMigPanel("ins 1", "[grow,fill]", "[18!]");
                this.renderer.add((Component)this.rendererBtn);
                this.setClickcount(1);
            }

            public boolean isEditable(ConnectedDevice obj) {
                return true;
            }

            protected boolean isDefaultResizable() {
                return false;
            }

            public boolean isHidable() {
                return false;
            }

            public int getDefaultWidth() {
                return 100;
            }

            public boolean isSortable(ConnectedDevice obj) {
                return false;
            }

            protected JComponent getInternalEditorComponent(ConnectedDevice value, boolean isSelected, int row, int column) {
                return this.editor;
            }

            public boolean onSingleClick(MouseEvent e, ConnectedDevice obj) {
                return super.onSingleClick(e, (Object)obj);
            }

            protected JComponent getInternalRendererComponent(ConnectedDevice value, boolean isSelected, boolean hasFocus, int row, int column) {
                return this.renderer;
            }

            public boolean isEnabled(ConnectedDevice obj) {
                return true;
            }

            public void configureRendererComponent(ConnectedDevice value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.rendererBtn.setText(_GUI.T.lit_disconnect());
            }

            public void configureEditorComponent(ConnectedDevice value, boolean isSelected, int row, int column) {
                this.device = value;
                this.editorBtn.setText(_GUI.T.lit_disconnect());
            }

            public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
                ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer((ExtColumn)this, jTableHeader){

                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        this.setIcon((Icon)new AbstractIcon("cancel", 14));
                        this.setHorizontalAlignment(0);
                        this.setText(_GUI.T.ConnectedDevicesTableModel_kill());
                        return this;
                    }
                };
                return ret;
            }

            public void resetEditor() {
            }

            public void resetRenderer() {
            }
        });
    }
}

