/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import jd.config.ConfigContainer;
import jd.config.ConfigEntry;
import jd.config.ConfigGroup;
import jd.config.SubConfiguration;
import jd.gui.UserIO;
import jd.gui.swing.Factory;
import jd.gui.swing.jdgui.interfaces.SwitchPanel;
import jd.gui.swing.jdgui.views.settings.GUIConfigEntry;
import net.miginfocom.swing.MigLayout;
import org.appwork.shutdown.ShutdownController;
import org.appwork.swing.MigPanel;
import org.appwork.utils.ColorUtils;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.updatev2.RestartController;
import org.jdownloader.updatev2.RestartRequest;
import org.jdownloader.updatev2.SmartRlyRestartRequest;

public abstract class ConfigPanel
extends SwitchPanel {
    private static final long serialVersionUID = 3383448498625377495L;
    public static final int ICON_SIZE = 32;
    private List<GUIConfigEntry> entries = new ArrayList<GUIConfigEntry>();
    protected JPanel panel;
    private ConfigGroup currentGroup;
    protected GUIConfigEntry over;
    private MouseMotionListener ml;

    public ConfigPanel() {
        this.setLayout((LayoutManager)new MigLayout("ins 0", "[fill,grow]", "[fill,grow]"));
        this.setOpaque(false);
        this.panel = new ScrollablePanel(){

            protected void paintComponent(Graphics g) {
                GUIConfigEntry p = ConfigPanel.this.over;
                if (p != null) {
                    Graphics2D g2 = (Graphics2D)((Graphics2D)g).create(0, p.getYMin(), this.getWidth(), p.getYMax() - p.getYMin());
                    g2.setClip(null);
                    g2.setColor(ColorUtils.getAlphaInstance((Color)this.getForeground(), (int)15));
                    g2.fillRect(0, 0, this.getWidth(), p.getYMax() - p.getYMin());
                }
                super.paintComponent(g);
            }
        };
        this.panel.setOpaque(false);
        this.ml = new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                boolean found = false;
                Point point = e.getPoint();
                point = SwingUtilities.convertPoint(e.getComponent(), point, ConfigPanel.this.panel);
                for (GUIConfigEntry p : ConfigPanel.this.entries) {
                    if (point.y < p.getYMin() - 5 || point.y >= p.getYMax()) continue;
                    found = true;
                    if (ConfigPanel.this.over == p) break;
                    GUIConfigEntry last = ConfigPanel.this.over;
                    ConfigPanel.this.over = p;
                    int yMin = p.getYMin();
                    if (last != null) {
                        yMin = Math.min(yMin, last.getYMin());
                    }
                    int yMax = p.getYMax();
                    if (last != null) {
                        yMax = Math.max(yMax, last.getYMax());
                    }
                    ConfigPanel.this.repaint(0, yMin - 10, ConfigPanel.this.getWidth(), yMax - yMin + 20);
                    break;
                }
                if (!found && ConfigPanel.this.over != null) {
                    GUIConfigEntry last = ConfigPanel.this.over;
                    ConfigPanel.this.over = null;
                    ConfigPanel.this.repaint(0, last.getYMin(), ConfigPanel.this.getWidth(), last.getYMax() - last.getYMin());
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        };
        this.panel.addMouseMotionListener(this.ml);
    }

    public void init() {
        for (ConfigEntry cfgEntry : this.setupContainer().getEntries()) {
            this.addConfigEntry(cfgEntry);
        }
        this.add(this.panel);
        this.load();
    }

    protected abstract ConfigContainer setupContainer();

    protected boolean showGroups() {
        return true;
    }

    private void addConfigEntry(ConfigEntry entry) {
        String gapLeft;
        ConfigGroup group;
        GUIConfigEntry guiEntry = new GUIConfigEntry(entry);
        guiEntry.addMouseMotionListener(this.ml);
        ConfigGroup configGroup = group = this.showGroups() ? entry.getGroup() : null;
        if (this.currentGroup != group) {
            if (group != null) {
                this.panel.add((Component)Factory.createHeader(group), "spanx");
            } else {
                this.panel.add((Component)new JSeparator(), "spanx, gapbottom 15, gaptop 15");
            }
            this.currentGroup = group;
        }
        String string = gapLeft = group == null ? "" : "gapleft 37,";
        if (guiEntry.getDecoration() != null) {
            switch (entry.getType()) {
                case 10: {
                    this.panel.add((Component)guiEntry.getDecoration(), gapLeft + "spanx");
                    break;
                }
                case 12: {
                    this.panel.add((Component)guiEntry.getDecoration(), gapLeft + "spanx," + guiEntry.getConfigEntry().getConstraints());
                    break;
                }
                default: {
                    this.panel.add((Component)guiEntry.getDecoration(), gapLeft + (guiEntry.getInput() == null ? "spanx" : ""));
                }
            }
        }
        if (guiEntry.getInput() != null) {
            switch (entry.getType()) {
                case 2: {
                    this.panel.add((Component)guiEntry.getInput(), (guiEntry.getDecoration() == null ? gapLeft + "spanx," : "") + "wmax 250");
                    break;
                }
                case 10: {
                    this.panel.add((Component)new JScrollPane(guiEntry.getInput()), gapLeft + "gaptop 0,spanx,growy,pushy,gapbottom 5,wmin 10");
                    break;
                }
                default: {
                    this.panel.add((Component)guiEntry.getInput(), guiEntry.getDecoration() == null ? gapLeft + "spanx" : "");
                }
            }
        }
        this.entries.add(guiEntry);
    }

    public final void load() {
        this.loadConfigEntries();
        this.loadSpecial();
    }

    public void reload() {
        for (GUIConfigEntry akt : this.entries) {
            akt.reload();
        }
        this.loadSpecial();
    }

    private final void loadConfigEntries() {
        for (GUIConfigEntry akt : this.entries) {
            akt.load();
        }
    }

    public final void save() {
        this.saveConfigEntries();
        this.saveSpecial();
    }

    protected void loadSpecial() {
    }

    protected void saveSpecial() {
    }

    @Override
    public void onShow() {
        this.load();
    }

    @Override
    public void onHide() {
        int answer;
        ConfigEntry.PropertyType changes = this.hasChanges();
        this.save();
        if (changes == ConfigEntry.PropertyType.NEEDS_RESTART && !ShutdownController.getInstance().isShutDownRequested() && UserIO.isOK(answer = UserIO.getInstance().requestConfirmDialog(0, _GUI.T.jd_gui_swing_jdgui_settings_ConfigPanel_restartquestion_title(), _GUI.T.jd_gui_swing_jdgui_settings_ConfigPanel_restartquestion(), null, _GUI.T.jd_gui_swing_jdgui_settings_ConfigPanel_restartquestion_ok(), null))) {
            RestartController.getInstance().asyncRestart((RestartRequest)new SmartRlyRestartRequest(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigEntry.PropertyType hasChanges() {
        ConfigEntry.PropertyType ret = ConfigEntry.PropertyType.NONE;
        List<GUIConfigEntry> list = this.entries;
        synchronized (list) {
            for (GUIConfigEntry akt : this.entries) {
                if (akt.getConfigEntry().getPropertyInstance() == null || akt.getConfigEntry().getPropertyName() == null) continue;
                Object old = akt.getConfigEntry().getPropertyInstance().getProperty(akt.getConfigEntry().getPropertyName());
                if (old == null && akt.getText() != null) {
                    ret = ret.getMax(akt.getConfigEntry().getPropertyType());
                    continue;
                }
                if (old == null || old.equals(akt.getText())) continue;
                ret = ret.getMax(akt.getConfigEntry().getPropertyType());
            }
        }
        return ret;
    }

    private final void saveConfigEntries() {
        HashSet<SubConfiguration> subs = new HashSet<SubConfiguration>();
        for (GUIConfigEntry akt : this.entries) {
            if (akt.getConfigEntry().getPropertyInstance() instanceof SubConfiguration && !subs.contains(akt.getConfigEntry().getPropertyInstance())) {
                subs.add((SubConfiguration)akt.getConfigEntry().getPropertyInstance());
            }
            akt.save();
        }
        for (SubConfiguration subConfiguration : subs) {
            subConfiguration.save();
        }
    }

    public String getTitle() {
        return "No Title set!";
    }

    public Icon getIcon() {
        return new AbstractIcon("settings", 32);
    }

    public class ScrollablePanel
    extends MigPanel
    implements Scrollable {
        public ScrollablePanel() {
            super("ins 0, wrap 2", "[fill,grow 10]10[fill,grow]", "[]");
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 16;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return (orientation == 1 ? visibleRect.height : visibleRect.width) - 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

