/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jd.SecondLevelLaunch;
import jd.gui.swing.jdgui.interfaces.SwitchPanel;
import jd.gui.swing.jdgui.views.settings.RightPanel;
import jd.gui.swing.jdgui.views.settings.panels.GeneralSettingsConfigPanel;
import jd.gui.swing.jdgui.views.settings.sidebar.ConfigSidebar;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.MigPanel;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.extensions.ExtensionConfigPanel;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.updatev2.gui.LAFOptions;

public class ConfigurationPanel
extends SwitchPanel
implements ListSelectionListener {
    private static final long serialVersionUID = -6554600142198250742L;
    private ConfigSidebar sidebar = new ConfigSidebar();
    private SwitchPanel panel;
    private GraphicalUserInterfaceSettings cfg;
    private MigPanel right = new RightPanel();
    private String lastE;

    public ConfigurationPanel() {
        super((LayoutManager)new MigLayout("ins 0", "[][grow,fill]", "[grow,fill]"));
        this.add((Component)this.sidebar, "");
        JScrollPane sp = new JScrollPane((Component)this.right);
        this.add(sp);
        sp.setBorder(null);
        sp.setHorizontalScrollBarPolicy(30);
        this.cfg = (GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class);
        this.sidebar.addListener(this);
        Color c = LAFOptions.getInstance().getColorForPanelBackground();
        if (c != null) {
            this.setBackground(c.brighter());
            super.setOpaque(true);
        }
    }

    @Override
    public void setOpaque(boolean isOpaque) {
    }

    @Override
    protected void onShow() {
        if (!this.sidebar.treeInitiated()) {
            SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(new Runnable(){

                @Override
                public void run() {
                    ConfigurationPanel.this.sidebar.updateAddons();
                }
            });
        }
        new EDTRunner(){

            protected void runInEDT() {
                if (ConfigurationPanel.this.sidebar.getSelectedPanel() == null) {
                    ConfigurationPanel.this.sidebar.getTreeCompleteState().executeWhenReached(new Runnable(){

                        @Override
                        public void run() {
                            new EDTRunner(){

                                protected void runInEDT() {
                                    if (ConfigurationPanel.this.sidebar.getSelectedPanel() == null) {
                                        ConfigurationPanel.this.restoreSelection(true);
                                    }
                                }
                            };
                        }
                    });
                }
            }
        };
    }

    public void restoreSelection(final boolean onlyOnEmptySelection) {
        Class selected = GeneralSettingsConfigPanel.class;
        try {
            String panelClass = this.cfg.getActiveConfigPanel();
            selected = Class.forName(panelClass);
        }
        catch (Throwable panelClass) {
            // empty catch block
        }
        final Class<GeneralSettingsConfigPanel> finalSelected = selected;
        if (finalSelected != null) {
            new EDTRunner(){

                protected void runInEDT() {
                    if (onlyOnEmptySelection && ConfigurationPanel.this.sidebar.getSelectedPanel() != null) {
                        return;
                    }
                    ConfigurationPanel.this.sidebar.setSelectedTreeEntry(finalSelected);
                }
            };
        }
    }

    @Override
    protected void onHide() {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.lastE != null && this.lastE.equals(e.toString())) {
            return;
        }
        this.lastE = e.toString();
        new EDTRunner(){

            protected void runInEDT() {
                SwitchPanel p = ConfigurationPanel.this.sidebar.getSelectedPanel();
                if (p == null) {
                    return;
                }
                ConfigurationPanel.this.setContent(p);
            }
        };
    }

    private void setContent(SwitchPanel selectedPanel) {
        if (selectedPanel == null || selectedPanel == this.panel) {
            return;
        }
        if (this.panel != null) {
            this.panel.setHidden();
        }
        if (selectedPanel instanceof ExtensionConfigPanel) {
            this.cfg.setActiveConfigPanel(((ExtensionConfigPanel)selectedPanel).getExtension().getClass().getName());
        } else {
            this.cfg.setActiveConfigPanel(selectedPanel.getClass().getName());
        }
        this.right.removeAll();
        this.right.add((Component)selectedPanel, (Object)"pushx,growx,pushy,growy");
        this.right.revalidate();
        this.right.repaint();
        this.panel = selectedPanel;
        this.panel.setShown();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    public <T> T getSubPanel(Class<T> class1) {
        return this.sidebar.getTreeEntry(class1);
    }

    public void setSelectedSubPanel(Class<?> class1) {
        this.sidebar.setSelectedTreeEntry(class1);
    }
}

