/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jd.config.ConfigEntry;
import jd.config.GuiConfigListener;
import jd.gui.swing.components.JDLabelContainer;
import jd.gui.swing.components.JDTextArea;
import jd.gui.swing.components.JDTextField;
import jd.gui.swing.jdgui.views.settings.JDLabelListRenderer;
import org.jdownloader.logging.LogController;

public class GUIConfigEntry
implements GuiConfigListener,
ActionListener,
ChangeListener,
DocumentListener {
    private final ConfigEntry configEntry;
    private JComponent input;
    private JComponent decoration;

    public GUIConfigEntry(ConfigEntry configEntry) {
        this.configEntry = configEntry;
        configEntry.setGuiListener((GuiConfigListener)this);
        if (configEntry.getLabel() != null && configEntry.getLabel().trim().length() > 0) {
            String text = configEntry.getLabel().trim();
            if (!text.startsWith("<html>")) {
                text = "<html>" + text.replaceAll("\r\n", "<br>") + "</html>";
            }
            this.decoration = new JLabel(text);
        }
        block0 : switch (configEntry.getType()) {
            case 11: {
                this.input = new JPasswordField();
                ((JPasswordField)this.input).setHorizontalAlignment(4);
                Document doc = ((JPasswordField)this.input).getDocument();
                doc.addDocumentListener(this);
                break;
            }
            case 0: {
                this.input = new JDTextField();
                ((JDTextField)this.input).setHorizontalAlignment(4);
                Document doc = ((JDTextField)this.input).getDocument();
                doc.addDocumentListener(this);
                break;
            }
            case 10: {
                this.input = new JDTextArea();
                ((JDTextArea)this.input).setLineWrap(true);
                ((JDTextArea)this.input).setWrapStyleWord(true);
                Document doc = ((JDTextArea)this.input).getDocument();
                doc.addDocumentListener(this);
                break;
            }
            case 3: {
                this.input = new JCheckBox();
                ((JCheckBox)this.input).addActionListener(this);
                break;
            }
            case 8: {
                this.input = new JSpinner(new SpinnerNumberModel(configEntry.getStart(), configEntry.getStart(), configEntry.getEnd(), configEntry.getStep()));
                ((JSpinner)this.input).addChangeListener(this);
                break;
            }
            case 2: {
                this.input = new JButton(configEntry.getDescription());
                if (configEntry.getImageIcon() != null) {
                    ((JButton)this.input).setIcon(configEntry.getImageIcon());
                }
                ((JButton)this.input).addActionListener(this);
                ((JButton)this.input).addActionListener(configEntry.getActionListener());
                break;
            }
            case 15: {
                Object v;
                this.input = new JComboBox<Object>(configEntry.getList());
                if (configEntry.getList().length > 0 && configEntry.getList()[0] instanceof JDLabelContainer) {
                    ((JComboBox)this.input).setRenderer(new JDLabelListRenderer());
                    ((JComboBox)this.input).setMaximumRowCount(10);
                }
                if ((v = configEntry.getPropertyInstance().getProperty(configEntry.getPropertyName())) instanceof String) {
                    for (int i = 0; i < configEntry.getList().length; ++i) {
                        if (!configEntry.getList()[i].toString().equals(configEntry.getPropertyInstance().getStringProperty(configEntry.getPropertyName()))) continue;
                        ((JComboBox)this.input).setSelectedIndex(i);
                        break block0;
                    }
                } else {
                    for (int i = 0; i < configEntry.getList().length; ++i) {
                        if (!configEntry.getList()[i].equals(v)) continue;
                        ((JComboBox)this.input).setSelectedIndex(i);
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                break;
            }
            case 6: {
                this.decoration = new JSeparator(0);
                break;
            }
            case 12: {
                this.decoration = configEntry.getComponent();
            }
        }
        if (this.input != null) {
            boolean state = configEntry.isConditionalEnabled(null, null);
            this.enableComponent(this.input, configEntry.isEnabled() && state);
            this.enableComponent(this.decoration, configEntry.isEnabled() && state);
        }
    }

    public JComponent getInput() {
        return this.input;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.configEntry.valueChanged(this.getText());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.configEntry.valueChanged(this.getText());
    }

    public ConfigEntry getConfigEntry() {
        return this.configEntry;
    }

    public Object getText() {
        switch (this.configEntry.getType()) {
            case 11: {
                return new String(((JPasswordField)this.input).getPassword());
            }
            case 0: 
            case 10: {
                return ((JTextComponent)this.input).getText();
            }
            case 3: {
                return ((JCheckBox)this.input).isSelected();
            }
            case 15: {
                return ((JComboBox)this.input).getSelectedIndex();
            }
            case 8: {
                return ((JSpinner)this.input).getValue();
            }
            case 2: 
            case 4: 
            case 6: 
            case 12: {
                return null;
            }
        }
        return null;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.configEntry.valueChanged(this.getText());
    }

    private final void enableComponent(JComponent cmp, boolean enabled) {
        if (cmp == null) {
            return;
        }
        cmp.setEnabled(enabled);
        if (cmp.getComponents() != null) {
            for (Component c : cmp.getComponents()) {
                c.setEnabled(enabled);
            }
        }
    }

    public void dataChanged(ConfigEntry source, Object newData) {
        if (this.input == null) {
            return;
        }
        boolean state = this.configEntry.isConditionalEnabled(source, newData);
        this.enableComponent(this.input, state);
        this.enableComponent(this.decoration, state);
    }

    public JComponent getDecoration() {
        return this.decoration;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.configEntry.valueChanged(this.getText());
    }

    /*
     * Unable to fully structure code
     */
    public void setData(Object text) {
        if (text == null) {
            text = this.configEntry.getDefaultValue();
        }
        switch (this.configEntry.getType()) {
            case 0: 
            case 10: 
            case 11: {
                ((JTextComponent)this.input).setText(text == null ? "" : text.toString());
                break;
            }
            case 3: {
                if (text == null) {
                    text = false;
                }
                try {
                    if (text instanceof String) {
                        if ("true".equalsIgnoreCase(text.toString())) {
                            ((JCheckBox)this.input).setSelected(true);
                            ** break;
                        }
                        if ("false".equalsIgnoreCase(text.toString())) {
                            ((JCheckBox)this.input).setSelected(false);
                            ** break;
                        }
                        throw new Exception("Invalid value: " + text);
                    }
                    if (text instanceof Boolean) {
                        ((JCheckBox)this.input).setSelected((Boolean)text);
                        ** break;
                    }
                    throw new Exception("Unsupported type:" + text.getClass());
lbl23:
                    // 3 sources

                }
                catch (Exception e) {
                    LogController.CL().severe("Falcher Wert: " + text);
                    LogController.CL().log((Throwable)e);
                    ((JCheckBox)this.input).setSelected(false);
                }
                break;
            }
            case 15: {
                if (text instanceof Number) {
                    ((JComboBox)this.input).setSelectedIndex(((Number)text).intValue());
                    break;
                }
                ((JComboBox)this.input).setSelectedItem(text);
                break;
            }
            case 8: {
                value = text instanceof Number != false ? ((Number)text).intValue() : Integer.parseInt(text.toString());
                try {
                    value = Math.min((Integer)((SpinnerNumberModel)((JSpinner)this.input).getModel()).getMaximum(), value);
                    value = Math.max((Integer)((SpinnerNumberModel)((JSpinner)this.input).getModel()).getMinimum(), value);
                    ((JSpinner)this.input).setModel(new SpinnerNumberModel(value, this.configEntry.getStart(), this.configEntry.getEnd(), this.configEntry.getStep()));
                }
                catch (Exception e) {
                    LogController.CL().log((Throwable)e);
                }
                break;
            }
        }
        this.configEntry.valueChanged(this.getText());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.configEntry.valueChanged(this.getText());
    }

    public void reload() {
        this.load();
        if (this.input != null) {
            boolean state = this.configEntry.isConditionalEnabled(null, null);
            this.enableComponent(this.input, this.configEntry.isEnabled() && state);
            this.enableComponent(this.decoration, this.configEntry.isEnabled() && state);
        }
    }

    public void load() {
        this.configEntry.setNotifyChanges(false);
        try {
            if (this.configEntry.getPropertyInstance() != null && this.configEntry.getPropertyName() != null) {
                this.setData(this.configEntry.getPropertyInstance().getProperty(this.configEntry.getPropertyName(), this.configEntry.getDefaultValue()));
            } else if (this.configEntry.getListController() != null) {
                this.setData(this.configEntry.getListController().getList());
            }
        }
        finally {
            this.configEntry.setNotifyChanges(true);
        }
    }

    public void save() {
        if (this.configEntry.getPropertyInstance() != null && this.configEntry.getPropertyName() != null) {
            this.configEntry.getPropertyInstance().setProperty(this.configEntry.getPropertyName(), this.getText());
        } else if (this.configEntry.getListController() != null) {
            this.configEntry.getListController().setList(this.getText() + "");
        }
    }

    public int getYMin() {
        if (this.input == null) {
            return -1;
        }
        int min = this.input.getY();
        if (this.decoration != null) {
            min = Math.min(min, this.decoration.getY());
        }
        return min;
    }

    public int getYMax() {
        if (this.input == null) {
            return -1;
        }
        int max = this.input.getY() + this.input.getHeight();
        if (this.decoration != null) {
            max = Math.max(max, this.decoration.getY() + this.decoration.getHeight());
        }
        return max;
    }

    public void addMouseMotionListener(MouseMotionListener ml) {
        if (this.decoration != null) {
            this.decoration.addMouseMotionListener(ml);
        }
        if (this.input != null) {
            this.input.addMouseMotionListener(ml);
        }
    }
}

