/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.components;

import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jd.gui.swing.jdgui.views.settings.components.SettingsComponent;
import jd.gui.swing.jdgui.views.settings.components.StateUpdateEvent;
import jd.gui.swing.jdgui.views.settings.components.StateUpdateEventSender;
import jd.gui.swing.jdgui.views.settings.components.StateUpdateListener;
import org.appwork.storage.config.handler.IntegerKeyHandler;
import org.appwork.storage.config.swing.models.ConfigIntSpinnerModel;
import org.appwork.swing.components.ExtSpinner;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.reflection.Clazz;

public class Spinner
extends ExtSpinner
implements SettingsComponent {
    private static final long serialVersionUID = 1L;
    private StateUpdateEventSender<Spinner> eventSender;
    private final AtomicInteger setting = new AtomicInteger(0);

    public Spinner(int min, int max) {
        this(new SpinnerNumberModel(min, min, max, 1));
    }

    public Spinner(SpinnerNumberModel extSpinnerConfigModel) {
        super(extSpinnerConfigModel);
        this.init();
    }

    protected String getDecimalFormatPattern(SpinnerModel model) {
        Number stepSize;
        if (model instanceof SpinnerNumberModel && (stepSize = ((SpinnerNumberModel)model).getStepSize()) != null && Clazz.isFloatingPointNumber(stepSize.getClass())) {
            HashSet<String> numbers = new HashSet<String>();
            Comparable<?> max = ((SpinnerNumberModel)model).getMaximum();
            Comparable<?> min = ((SpinnerNumberModel)model).getMinimum();
            if (max instanceof Number) {
                numbers.add(max.toString());
            }
            if (min instanceof Number) {
                numbers.add(min.toString());
            }
            numbers.add(stepSize.toString());
            int nachKomma = 1;
            int vorKomma = 1;
            for (String number : numbers) {
                nachKomma = Math.max(nachKomma, number.contains(".") ? number.length() - number.indexOf(46) - 1 : 0);
                vorKomma = Math.max(vorKomma, number.contains(".") ? number.indexOf(46) : number.length());
            }
            char[] arr = new char[vorKomma + 1 + nachKomma];
            Arrays.fill(arr, '#');
            arr[vorKomma] = 46;
            return String.valueOf(arr);
        }
        return "#";
    }

    protected void init() {
        this.setEditor(new JSpinner.NumberEditor((JSpinner)((Object)this), this.getDecimalFormatPattern(this.getModel())));
        this.eventSender = new StateUpdateEventSender();
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (Spinner.this.setting.get() == 0) {
                    Spinner.this.eventSender.fireEvent((DefaultEvent)new StateUpdateEvent<Spinner>(Spinner.this));
                }
            }
        });
    }

    public Spinner(IntegerKeyHandler cfg) {
        this((SpinnerNumberModel)new ConfigIntSpinnerModel(cfg));
    }

    public void setModel(SpinnerModel model) {
        this.setting.getAndIncrement();
        try {
            super.setModel(model);
        }
        finally {
            this.setting.decrementAndGet();
        }
    }

    public void setValue(Number value) {
        this.setting.getAndIncrement();
        try {
            super.setValue((Object)value);
        }
        finally {
            this.setting.decrementAndGet();
        }
    }

    public void setValue(long value) {
        this.setting.getAndIncrement();
        try {
            super.setValue((Object)value);
        }
        finally {
            this.setting.decrementAndGet();
        }
    }

    public void setValue(int value) {
        this.setting.getAndIncrement();
        try {
            super.setValue((Object)value);
        }
        finally {
            this.setting.decrementAndGet();
        }
    }

    public void setValue(Object value) {
        super.setValue(value);
    }

    @Override
    public String getConstraints() {
        return "sgy LINE";
    }

    @Override
    public boolean isMultiline() {
        return false;
    }

    public void setFormat(String formatString) {
        this.setEditor(new JSpinner.NumberEditor((JSpinner)((Object)this), formatString));
    }

    public void addStateUpdateListener(StateUpdateListener listener) {
        this.eventSender.addListener(listener);
    }
}

