/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.views.settings.components.Checkbox;
import jd.gui.swing.jdgui.views.settings.components.ComboBox;
import jd.gui.swing.jdgui.views.settings.components.SettingsButton;
import jd.gui.swing.jdgui.views.settings.components.StateUpdateListener;
import jd.gui.swing.jdgui.views.settings.panels.UrlOrderContainer;
import jd.gui.swing.jdgui.views.settings.panels.urlordertable.UrlOrderTable;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.StorageException;
import org.appwork.txtresource.TranslationFactory;
import org.appwork.uio.ComboBoxDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.ComboBoxDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.ProgressDialog;
import org.appwork.utils.swing.locationstore.LocationStorageManager;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.actions.AppAction;
import org.jdownloader.gui.jdtrayicon.CFG_TRAY_CONFIG;
import org.jdownloader.gui.jdtrayicon.MenuManagerTrayIcon;
import org.jdownloader.gui.mainmenu.MenuManagerMainmenu;
import org.jdownloader.gui.settings.AbstractConfigPanel;
import org.jdownloader.gui.toolbar.MenuManagerMainToolbar;
import org.jdownloader.gui.translate.GuiTranslation;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.MenuManagerDownloadTabBottomBar;
import org.jdownloader.gui.views.downloads.contextmenumanager.MenuManagerDownloadTableContext;
import org.jdownloader.gui.views.linkgrabber.bottombar.MenuManagerLinkgrabberTabBottombar;
import org.jdownloader.gui.views.linkgrabber.contextmenu.MenuManagerLinkgrabberTableContext;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.settings.staticreferences.CFG_SILENTMODE;
import org.jdownloader.translate.JdownloaderTranslation;
import org.jdownloader.updatev2.RestartController;
import org.jdownloader.updatev2.RestartRequest;
import org.jdownloader.updatev2.SmartRlyRestartRequest;

public class GUISettings
extends AbstractConfigPanel
implements StateUpdateListener {
    private static final long serialVersionUID = 1L;
    private SettingsButton lng = new SettingsButton(new AppAction(){
        {
            String value = TranslationFactory.getDesiredLanguage();
            Locale loc = TranslationFactory.stringToLocale((String)value);
            String set = loc.getDisplayName(Locale.ENGLISH);
            if (StringUtils.isEmpty((String)set)) {
                String tmp;
                Locale tmpLoc;
                int tmpIndex = value.indexOf("_");
                if (tmpIndex >= 0 && (tmpLoc = TranslationFactory.stringToLocale((String)(tmp = value.substring(0, tmpIndex)))) != null) {
                    set = tmpLoc.getDisplayName(Locale.ENGLISH);
                }
                set = StringUtils.isEmpty((String)set) ? value : set + "(" + value + ")";
            }
            this.setName(_GUI.T.change_language(set));
        }

        public void actionPerformed(ActionEvent e) {
            String newLng;
            final AtomicReference languages = new AtomicReference();
            ProgressDialog p = new ProgressDialog(new ProgressDialog.ProgressGetter(){

                public void run() throws Exception {
                    List list = TranslationFactory.listAvailableTranslations((Class[])new Class[]{JdownloaderTranslation.class, GuiTranslation.class});
                    Collections.sort(list, new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            Locale lc1 = TranslationFactory.stringToLocale((String)o1);
                            Locale lc2 = TranslationFactory.stringToLocale((String)o2);
                            String v1 = lc1.getDisplayName(Locale.ENGLISH);
                            String v2 = lc2.getDisplayName(Locale.ENGLISH);
                            if (StringUtils.isEmpty((String)v1) && StringUtils.isEmpty((String)v2)) {
                                return 0;
                            }
                            if (StringUtils.isEmpty((String)v1) && !StringUtils.isEmpty((String)v2)) {
                                return 1;
                            }
                            if (StringUtils.isEmpty((String)v2) && !StringUtils.isEmpty((String)v1)) {
                                return -11;
                            }
                            return v1.compareToIgnoreCase(v2);
                        }
                    });
                    languages.set(list);
                }

                public String getString() {
                    return null;
                }

                public int getProgress() {
                    return -1;
                }

                public String getLabelString() {
                    return null;
                }
            }, 16, _GUI.T.lit_please_wait(), "", null);
            UIOManager.I().show(null, (UserIODefinition)p);
            ComboBoxDialog comboDialog = new ComboBoxDialog(0, _GUI.T.languages_dialog_title(), _GUI.T.languages_dialog_title(), ((List)languages.get()).toArray(new String[0]), ((List)languages.get()).indexOf(TranslationFactory.getDesiredLanguage()), (Icon)new AbstractIcon("language", 32), _GUI.T.languages_dialog_change_and_restart(), null, null){

                protected ListCellRenderer getRenderer(final ListCellRenderer orgRenderer) {
                    return new ListCellRenderer(){

                        public Component getListCellRendererComponent(JList list, Object v, int index, boolean isSelected, boolean cellHasFocus) {
                            if (v instanceof String) {
                                String value = (String)v;
                                Locale loc = TranslationFactory.stringToLocale((String)value);
                                String set = loc.getDisplayName(Locale.ENGLISH);
                                if (StringUtils.isEmpty((String)set)) {
                                    String tmp;
                                    Locale tmpLoc;
                                    int tmpIndex = value.indexOf("_");
                                    if (tmpIndex >= 0 && (tmpLoc = TranslationFactory.stringToLocale((String)(tmp = value.substring(0, tmpIndex)))) != null) {
                                        set = tmpLoc.getDisplayName(Locale.ENGLISH);
                                    }
                                    set = StringUtils.isEmpty((String)set) ? value : set + "(" + value + ")";
                                }
                                return orgRenderer.getListCellRendererComponent(list, set, index, isSelected, cellHasFocus);
                            }
                            return orgRenderer.getListCellRendererComponent(list, v, index, isSelected, cellHasFocus);
                        }
                    };
                }

                public boolean isRemoteAPIEnabled() {
                    return false;
                }
            };
            int index = ((ComboBoxDialogInterface)UIOManager.I().show(ComboBoxDialogInterface.class, (UserIODefinition)comboDialog)).getSelectedIndex();
            if (index >= 0 && !(newLng = (String)((List)languages.get()).get(index)).equals(TranslationFactory.getDesiredLanguage())) {
                try {
                    Dialog.getInstance().showConfirmDialog(0, _GUI.T.GUISettings_save_language_changed_restart_required_title(), _GUI.T.GUISettings_save_language_changed_restart_required_msg(), NewTheme.getInstance().getIcon("language", 32), null, null);
                    try {
                        IO.secureWrite((File)Application.getResource((String)"cfg/language.json"), (byte[])JSonStorage.serializeToJsonByteArray((Object)newLng), (IO.SYNC)IO.SYNC.NONE);
                    }
                    catch (IOException e1) {
                        throw new WTFException((Throwable)e1);
                    }
                    RestartController.getInstance().asyncRestart((RestartRequest)new SmartRlyRestartRequest(true));
                }
                catch (DialogClosedException dialogClosedException) {
                }
                catch (DialogCanceledException dialogCanceledException) {
                    // empty catch block
                }
            }
        }
    });
    private SettingsButton resetDialogs = new SettingsButton(new AppAction(){
        {
            this.setName(_GUI.T.GUISettings_GUISettings_resetdialogs_());
        }

        public void actionPerformed(ActionEvent e) {
            try {
                AbstractDialog.resetDialogInformations();
                CFG_TRAY_CONFIG.ON_CLOSE_ACTION.setValue((Object)CFG_TRAY_CONFIG.ON_CLOSE_ACTION.getDefaultValue());
                Dialog.getInstance().showMessageDialog(_GUI.T.GUISettings_actionPerformed_reset_done());
            }
            catch (StorageException e1) {
                e1.printStackTrace();
            }
        }
    });
    private SettingsButton contextMenuManagerDownloadList;
    private SettingsButton contextMenuManagerLinkgrabber;
    private SettingsButton toolbarManager;
    private SettingsButton mainMenuManager;
    private SettingsButton trayMenuManager;
    private SettingsButton resetDialogPosition = new SettingsButton(new AppAction(){
        {
            this.setName(_GUI.T.GUISettings_GUISettings_resetdialog_positions_());
        }

        public void actionPerformed(ActionEvent e) {
            boolean reset = LocationStorageManager.INSTANCE.reset();
            Application.getResource((String)"cfg/").listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String fileName = file.getName();
                    boolean deleteFlag = fileName.startsWith("org.appwork.utils.swing.locator.") ? true : (fileName.startsWith("org.appwork.utils.swing.dimensor.") ? true : (fileName.startsWith("RememberRelativeLocator") ? true : (fileName.startsWith("RememberAbsoluteLocator-") ? true : (fileName.startsWith("RememberAbsoluteLocator-") ? true : (fileName.startsWith("gui.windows.dimensionsandlocations") ? true : (fileName.startsWith("RememberLastDimensor-") ? true : fileName.startsWith("CaptchaDialogDimensions")))))));
                    if (deleteFlag) {
                        file.deleteOnExit();
                    }
                    return deleteFlag;
                }
            });
            if (reset) {
                Dialog.getInstance().showMessageDialog(_GUI.T.GUISettings_actionPerformed_reset_location_done());
            }
        }
    });
    private ComboBox<WindowManager.FrameState> focus;
    private ComboBox<GraphicalUserInterfaceSettings.NewLinksInLinkgrabberAction> linkgrabberfocus;
    private boolean setting;
    private SettingsButton downloadBottomManager;
    private SettingsButton linkgrabberBottomManager;

    public String getTitle() {
        return _GUI.T.GUISettings_getTitle();
    }

    public GUISettings() {
        this.contextMenuManagerDownloadList = new SettingsButton(new AppAction(){
            {
                this.setName(_GUI.T.gui_config_menumanager_downloadlist());
            }

            public void actionPerformed(ActionEvent e) {
                new EDTRunner(){

                    protected void runInEDT() {
                        JDGui.getInstance().requestPanel(JDGui.Panels.DOWNLOADLIST);
                        MenuManagerDownloadTableContext.getInstance().openGui();
                    }
                };
            }
        });
        this.contextMenuManagerLinkgrabber = new SettingsButton(new AppAction(){
            {
                this.setName(_GUI.T.gui_config_menumanager_linkgrabber());
            }

            public void actionPerformed(ActionEvent e) {
                new EDTRunner(){

                    protected void runInEDT() {
                        JDGui.getInstance().requestPanel(JDGui.Panels.LINKGRABBER);
                        MenuManagerLinkgrabberTableContext.getInstance().openGui();
                    }
                };
            }
        });
        this.toolbarManager = new SettingsButton(new AppAction(){
            {
                this.setName(_GUI.T.gui_config_menumanager_toolbar());
            }

            public void actionPerformed(ActionEvent e) {
                new EDTRunner(){

                    protected void runInEDT() {
                        MenuManagerMainToolbar.getInstance().openGui();
                    }
                };
            }
        });
        this.mainMenuManager = new SettingsButton(new AppAction(){
            {
                this.setName(_GUI.T.gui_config_menumanager_mainmenu());
            }

            public void actionPerformed(ActionEvent e) {
                new EDTRunner(){

                    protected void runInEDT() {
                        MenuManagerMainmenu.getInstance().openGui();
                    }
                };
            }
        });
        this.trayMenuManager = new SettingsButton(new AppAction(){
            {
                this.setName(_GUI.T.gui_config_menumanager_traymenu());
            }

            public void actionPerformed(ActionEvent e) {
                new EDTRunner(){

                    protected void runInEDT() {
                        MenuManagerTrayIcon.getInstance().openGui();
                    }
                };
            }
        });
        this.downloadBottomManager = new SettingsButton(new AppAction(){
            {
                this.setName(_GUI.T.gui_config_menumanager_downloadBottom());
            }

            public void actionPerformed(ActionEvent e) {
                new EDTRunner(){

                    protected void runInEDT() {
                        MenuManagerDownloadTabBottomBar.getInstance().openGui();
                    }
                };
            }
        });
        this.linkgrabberBottomManager = new SettingsButton(new AppAction(){
            {
                this.setName(_GUI.T.gui_config_menumanager_linkgrabberBottom());
            }

            public void actionPerformed(ActionEvent e) {
                new EDTRunner(){

                    protected void runInEDT() {
                        MenuManagerLinkgrabberTabBottombar.getInstance().openGui();
                    }
                };
            }
        });
        this.addHeader(this.getTitle(), (Icon)new AbstractIcon("gui", 32));
        this.addDescription(_GUI.T.GUISettings_GUISettings_description());
        this.addPair(_GUI.T.gui_config_language(), null, this.lng);
        this.addPair(_GUI.T.gui_config_dialogs(), null, this.resetDialogs);
        this.addPair("", null, this.resetDialogPosition);
        this.addHeader(_GUI.T.GUISettings_GUISettings_object_urls(), NewTheme.I().getIcon("url", 32));
        this.addDescription(_GUI.T.GUISettings_GUISettings_object_urls_description());
        UrlOrderContainer container = new UrlOrderContainer(new UrlOrderTable());
        this.add((Component)((Object)container));
        this.addHeader(_GUI.T.gui_config_menumanager_header(), (Icon)new AbstractIcon("menu", 32));
        this.addDescription(_GUI.T.gui_config_menumanager_desc());
        this.addPair("", null, this.contextMenuManagerDownloadList);
        this.addPair("", null, this.contextMenuManagerLinkgrabber);
        this.addPair("", null, this.toolbarManager);
        this.addPair("", null, this.mainMenuManager);
        this.addPair("", null, this.trayMenuManager);
        this.addPair("", null, this.downloadBottomManager);
        this.addPair("", null, this.linkgrabberBottomManager);
        this.addHeader(_GUI.T.GUISettings_GUISettings_object_frames(), (Icon)new AbstractIcon("desktop", 32));
        this.addDescription(_GUI.T.GUISettings_GUISettings_object_frames_description());
        this.addDescriptionPlain(_GUI.T.GUISettings_GUISettings_sielntMode_description());
        this.addPair(_GUI.T.GUISettings_GUISettings_sielntMode(), null, new Checkbox(CFG_SILENTMODE.MANUAL_ENABLED, new JComponent[0]));
        this.focus = new ComboBox<WindowManager.FrameState>(new WindowManager.FrameState[]{WindowManager.FrameState.OS_DEFAULT, WindowManager.FrameState.TO_BACK, WindowManager.FrameState.TO_FRONT, WindowManager.FrameState.TO_FRONT_FOCUSED}, new String[]{_GUI.T.GUISettings_GUISettings_framestate_os_default(System.getProperty("os.name")), _GUI.T.GUISettings_GUISettings_framestate_back(), _GUI.T.GUISettings_GUISettings_framestate_front(), _GUI.T.GUISettings_GUISettings_framestate_focus()}){};
        this.focus.addStateUpdateListener(this);
        this.addPair(_GUI.T.GUISettings_GUISettings_dialog_focus(), null, this.focus);
        this.linkgrabberfocus = new ComboBox<GraphicalUserInterfaceSettings.NewLinksInLinkgrabberAction>((ContentType[])new GraphicalUserInterfaceSettings.NewLinksInLinkgrabberAction[]{GraphicalUserInterfaceSettings.NewLinksInLinkgrabberAction.NOTHING, GraphicalUserInterfaceSettings.NewLinksInLinkgrabberAction.SWITCH, GraphicalUserInterfaceSettings.NewLinksInLinkgrabberAction.TO_FRONT, GraphicalUserInterfaceSettings.NewLinksInLinkgrabberAction.FOCUS}, new String[]{_GUI.T.GUISettings_GUISettings_newlinks_nothing(), _GUI.T.GUISettings_GUISettings_newlinks_switch(), _GUI.T.GUISettings_GUISettings_newlinks_front(), _GUI.T.GUISettings_GUISettings_newlinks_focus()});
        this.linkgrabberfocus.addStateUpdateListener(this);
        this.addPair(_GUI.T.GUISettings_GUISettings_dialog_linkgrabber_on_new_links(), null, this.linkgrabberfocus);
    }

    protected void loadLanguages() {
        List list = TranslationFactory.listAvailableTranslations((Class[])new Class[]{JdownloaderTranslation.class, GuiTranslation.class});
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Locale lc1 = TranslationFactory.stringToLocale((String)o1);
                Locale lc2 = TranslationFactory.stringToLocale((String)o2);
                String v1 = lc1.getDisplayName(Locale.ENGLISH);
                String v2 = lc2.getDisplayName(Locale.ENGLISH);
                if (StringUtils.isEmpty((String)v1) && StringUtils.isEmpty((String)v2)) {
                    return 0;
                }
                if (StringUtils.isEmpty((String)v1) && !StringUtils.isEmpty((String)v2)) {
                    return 1;
                }
                if (StringUtils.isEmpty((String)v2) && !StringUtils.isEmpty((String)v1)) {
                    return -11;
                }
                return v1.compareToIgnoreCase(v2);
            }
        });
        String[] languages = list.toArray(new String[0]);
        new EDTRunner(){

            protected void runInEDT() {
            }
        };
    }

    public Icon getIcon() {
        return new AbstractIcon("gui", 32);
    }

    public void save() {
        CFG_GUI.CFG.setNewDialogFrameState(this.focus.getSelectedItem());
        CFG_GUI.CFG.setNewLinksActionV2(this.linkgrabberfocus.getSelectedItem());
    }

    public void updateContents() {
        this.setting = true;
        try {
            this.focus.setSelectedItem(CFG_GUI.CFG.getNewDialogFrameState());
            GraphicalUserInterfaceSettings.NewLinksInLinkgrabberAction newvalue = CFG_GUI.CFG.getNewLinksActionV2();
            this.linkgrabberfocus.setSelectedItem(newvalue);
        }
        finally {
            this.setting = false;
        }
    }

    @Override
    public void onStateUpdated() {
        if (!this.setting) {
            this.save();
        }
    }
}

