/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.accountmanager;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import jd.gui.swing.jdgui.BasicJDTable;
import jd.gui.swing.jdgui.components.premiumbar.ServiceCollection;
import jd.gui.swing.jdgui.components.premiumbar.ServicePanel;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.AccountEntry;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.AccountListPanel;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.BuyAction;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.EditAction;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.NewAction;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.PremiumAccountTableModel;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.RefreshAction;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.RemoveAction;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.swing.components.tooltips.ToolTipHandler;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtComponentRowHighlighter;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.updatev2.gui.LAFOptions;

public class PremiumAccountTable
extends BasicJDTable<AccountEntry> {
    private static final long serialVersionUID = -2166408567306279016L;

    public PremiumAccountTable(AccountListPanel accountListPanel) {
        this(new PremiumAccountTableModel(accountListPanel));
    }

    public PremiumAccountTable(PremiumAccountTableModel premiumAccountTableModel) {
        super(premiumAccountTableModel);
        this.setSearchEnabled(true);
        this.addRowHighlighterSelected();
        this.getModel().addExtComponentRowHighlighter((ExtComponentRowHighlighter)new ExtComponentRowHighlighter<AccountEntry>(LAFOptions.getInstance().getColorForTableAccountTempErrorRowForeground(), LAFOptions.getInstance().getColorForTableAccountTempErrorRowBackground(), null){

            public int getPriority() {
                return Integer.MAX_VALUE;
            }

            protected Color getBackground(Color current) {
                return super.getBackground(current);
            }

            public boolean accept(ExtColumn<AccountEntry> column, AccountEntry value, boolean selected, boolean focus, int row) {
                return value.getAccount().isTempDisabled();
            }
        });
        this.getModel().addExtComponentRowHighlighter((ExtComponentRowHighlighter)new ExtComponentRowHighlighter<AccountEntry>(LAFOptions.getInstance().getColorForTableAccountErrorRowForeground(), LAFOptions.getInstance().getColorForTableAccountErrorRowBackground(), null){

            public int getPriority() {
                return Integer.MAX_VALUE;
            }

            protected Color getBackground(Color current) {
                return super.getBackground(current);
            }

            public boolean accept(ExtColumn<AccountEntry> column, AccountEntry value, boolean selected, boolean focus, int row) {
                return !value.getAccount().isValid();
            }
        });
    }

    protected void addRowHighlighterSelected() {
        this.getModel().addExtComponentRowHighlighter((ExtComponentRowHighlighter)new ExtComponentRowHighlighter<AccountEntry>(LAFOptions.getInstance().getColorForTableSelectedRowsForeground(), LAFOptions.getInstance().getColorForTableSelectedRowsBackground(), null){

            public int getPriority() {
                return 0x7FFFFFFE;
            }

            public boolean accept(ExtColumn<AccountEntry> column, AccountEntry value, boolean selected, boolean focus, int row) {
                return selected;
            }
        });
    }

    @Override
    protected void addSelectionHighlighter() {
        super.addSelectionHighlighter();
    }

    protected boolean onShortcutDelete(List<AccountEntry> selectedObjects, KeyEvent evt, boolean direct) {
        new RemoveAction(selectedObjects, direct).actionPerformed(null);
        return true;
    }

    protected boolean onDoubleClick(MouseEvent e, AccountEntry obj) {
        ToolTipController.getInstance().show((ToolTipHandler)this);
        return true;
    }

    protected ExtTooltip createToolTip(ExtColumn<AccountEntry> col, int row, Point position, AccountEntry elementAt) {
        if (elementAt == null || elementAt.getAccount() == null) {
            return null;
        }
        try {
            List<ServiceCollection<?>> services = ServicePanel.getInstance().groupServices(GraphicalUserInterfaceSettings.PremiumStatusBarDisplay.GROUP_BY_ACCOUNT_TYPE, false, elementAt.getAccount().getHoster(), elementAt.getAccount());
            if (services.size() > 0) {
                return services.get(0).createTooltip(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected JPopupMenu onContextMenu(JPopupMenu popup, AccountEntry contextObject, List<AccountEntry> selection, ExtColumn<AccountEntry> column, MouseEvent ev) {
        if (popup != null) {
            if (selection == null) {
                popup.add((Action)((Object)new NewAction()));
                this.addRemovePopupItem(popup);
                popup.add(new BuyAction());
                popup.add(new RefreshAction(null));
            } else {
                popup.add((Action)((Object)new NewAction()));
                popup.add(new EditAction(selection));
                popup.add((Action)((Object)new RemoveAction(selection, false)));
                popup.add(new RefreshAction(selection));
            }
        }
        return popup;
    }

    protected void addRemovePopupItem(JPopupMenu popup) {
        popup.add((Action)((Object)new RemoveAction(null, false)));
    }
}

