/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.accountmanager.orderpanel;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import jd.controlling.AccountController;
import jd.controlling.AccountFilter;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.orderpanel.ChooseHosterDialog;
import jd.plugins.AccountInfo;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.DomainInfo;
import org.jdownloader.controlling.hosterrule.AccountUsageRule;
import org.jdownloader.controlling.hosterrule.HosterRuleController;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.AbstractAddAction;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;

public class NewRuleAction
extends AbstractAddAction {
    private static final long serialVersionUID = 1L;

    public void actionPerformed(ActionEvent e) {
        DomainInfo di;
        ArrayList<DomainInfo> list = this.getAvailableDomainInfoList();
        HosterRuleController hrc = HosterRuleController.getInstance();
        ChooseHosterDialog d = new ChooseHosterDialog(_GUI.T.NewRuleAction_actionPerformed_choose_hoster_message(), list.toArray(new DomainInfo[0]));
        try {
            Dialog.getInstance().showDialog((AbstractDialog)d);
            di = (DomainInfo)d.getSelectedItem();
            if (di == null) {
                return;
            }
        }
        catch (DialogClosedException e1) {
            e1.printStackTrace();
            return;
        }
        catch (DialogCanceledException e1) {
            e1.printStackTrace();
            return;
        }
        String domain = di.getTld();
        AccountUsageRule rule = new AccountUsageRule(domain);
        rule.setEnabled(true);
        if (!HosterRuleController.getInstance().validateRule(rule)) {
            return;
        }
        if (!HosterRuleController.getInstance().showEditPanel(rule)) {
            return;
        }
        hrc.removeRulesByDomain(domain);
        hrc.add(rule);
    }

    protected ArrayList<DomainInfo> getAvailableDomainInfoList() {
        HashSet<DomainInfo> domains = new HashSet<DomainInfo>();
        ArrayList all_mhosts = new ArrayList();
        ArrayList multihoster_accounts = AccountController.getInstance().listAccounts(new AccountFilter().setFeature(new LazyPlugin.FEATURE[]{LazyPlugin.FEATURE.MULTIHOST}));
        for (Object acc : multihoster_accounts) {
            List this_mhosts;
            AccountInfo ai = acc.getAccountInfo();
            if (ai == null || (this_mhosts = ai.getMultiHostSupportV2()) == null || this_mhosts.isEmpty()) continue;
            all_mhosts.addAll(this_mhosts);
        }
        HashSet multihosterSupportedDomains = new HashSet();
        for (Object mhost : all_mhosts) {
            multihosterSupportedDomains.addAll(mhost.getDomains());
        }
        Collection plugins = HostPluginController.getInstance().list();
        for (LazyHostPlugin plg : plugins) {
            if (plg.hasFeature(new LazyPlugin.FEATURE[]{LazyPlugin.FEATURE.MULTIHOST}) || plg.isOfflinePlugin() || plg.hasFeature(new LazyPlugin.FEATURE[]{LazyPlugin.FEATURE.USENET}) && !plg.getHost().equals("usenet") || plg.hasFeature(new LazyPlugin.FEATURE[]{LazyPlugin.FEATURE.INTERNAL}) || !plg.isPremium() && !multihosterSupportedDomains.contains(plg.getHost()) || plg.hasFeature(new LazyPlugin.FEATURE[]{LazyPlugin.FEATURE.CAPTCHA_SOLVER})) continue;
            domains.add(plg.getDomainInfo());
        }
        ArrayList<DomainInfo> lst = new ArrayList<DomainInfo>(domains);
        Collections.sort(lst, new Comparator<DomainInfo>(){

            @Override
            public int compare(DomainInfo o1, DomainInfo o2) {
                return o1.getTld().compareTo(o2.getTld());
            }
        });
        return lst;
    }

    public String getTooltipText() {
        return _GUI.T.NewRuleAction_getTooltipText_tt_();
    }
}

