/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.advanced;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.annotations.EnumLabel;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.sunwrapper.sun.swing.SwingUtilities2Wrapper;
import org.appwork.swing.components.CheckBoxIcon;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.columns.ExtCheckColumn;
import org.appwork.swing.exttable.columns.ExtCompoundColumn;
import org.appwork.swing.exttable.columns.ExtSpinnerColumn;
import org.appwork.swing.exttable.columns.ExtTextAreaColumn;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.reflection.Clazz;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.contextmenu.gui.ExtPopupMenu;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.advanced.AdvancedConfigEntry;
import org.jdownloader.settings.advanced.RangeValidator;
import org.jdownloader.updatev2.gui.LAFOptions;

public class AdvancedValueColumn
extends ExtCompoundColumn<AdvancedConfigEntry> {
    private static final long serialVersionUID = 1L;
    private ExtTextColumn<AdvancedConfigEntry> stringColumn;
    private ExtCheckColumn<AdvancedConfigEntry> booleanColumn;
    private ExtTextAreaColumn<AdvancedConfigEntry> defaultColumn;
    private List<ExtColumn<AdvancedConfigEntry>> columns = new ArrayList<ExtColumn<AdvancedConfigEntry>>();
    private ExtSpinnerColumn<AdvancedConfigEntry> numberColumn;
    private ExtTextColumn<AdvancedConfigEntry> enumColumn;
    private ExtTextColumn<AdvancedConfigEntry> colorColumn;

    public AdvancedValueColumn() {
        super(_GUI.T.AdvancedValueColumn_AdvancedValueColumn_object_());
        this.initColumns();
    }

    public boolean isEnabled(AdvancedConfigEntry obj) {
        return true;
    }

    public boolean isHidable() {
        return false;
    }

    private void initColumns() {
        this.stringColumn = new ExtTextColumn<AdvancedConfigEntry>(this.getName()){
            private static final long serialVersionUID = 1L;
            {
                this.rendererField.setHorizontalAlignment(4);
            }

            public boolean isEditable(AdvancedConfigEntry obj) {
                return obj.isEditable();
            }

            public String getStringValue(AdvancedConfigEntry value) {
                return value.getValue() + "";
            }

            protected String getTooltipText(AdvancedConfigEntry obj) {
                return obj.getDescription();
            }

            protected void setStringValue(String value, AdvancedConfigEntry object) {
                object.setValue((Object)value);
                AdvancedValueColumn.this.getModel().getTable().repaint();
            }
        };
        this.register((ExtColumn<AdvancedConfigEntry>)this.stringColumn);
        this.colorColumn = new ExtTextColumn<AdvancedConfigEntry>(this.getName()){
            private static final long serialVersionUID = 1L;
            {
                this.rendererField.setHorizontalAlignment(4);
            }

            public boolean onDoubleClick(MouseEvent e, AdvancedConfigEntry value) {
                Object v = value.getValue();
                Color c = v == null ? null : LAFOptions.createColor((String)v.toString());
                Color newColor = JColorChooser.showDialog((Component)this.getModel().getTable(), _GUI.T.AdvancedValueColumn_onSingleClick_colorchooser_title_(), c);
                if (newColor != null) {
                    this.setStringValue("#" + LAFOptions.toHex((Color)newColor), value);
                }
                return true;
            }

            public boolean isEditable(AdvancedConfigEntry obj) {
                return false;
            }

            public Color getContrastColor(Color color) {
                double y = (299 * color.getRed() + 587 * color.getGreen() + 114 * color.getBlue()) / 1000;
                if (color.getAlpha() < 128) {
                    return Color.BLACK;
                }
                return y >= 128.0 ? Color.black : Color.white;
            }

            public void configureEditorComponent(AdvancedConfigEntry value, boolean isSelected, int row, int column) {
                Color c;
                super.configureEditorComponent((Object)value, isSelected, row, column);
                Object v = value.getValue();
                Color color = c = v == null ? null : LAFOptions.createColor((String)v.toString());
                if (c != null) {
                    this.editorField.setBackground(c);
                    this.editorField.setForeground(this.getContrastColor(c));
                    this.editorField.setOpaque(true);
                } else {
                    this.editorField.setBackground(null);
                    this.editorField.setForeground(null);
                    this.editorField.setOpaque(false);
                }
            }

            public void configureRendererComponent(AdvancedConfigEntry value, boolean isSelected, boolean hasFocus, int row, int column) {
                Color c;
                super.configureRendererComponent((Object)value, isSelected, hasFocus, row, column);
                Object v = value.getValue();
                Color color = c = v == null ? null : LAFOptions.createColor((String)v.toString());
                if (c != null) {
                    this.rendererField.setBackground(c);
                    this.rendererField.setForeground(this.getContrastColor(c));
                    this.rendererField.setOpaque(true);
                } else {
                    this.rendererField.setBackground(null);
                    this.rendererField.setForeground(null);
                    this.rendererField.setOpaque(false);
                }
            }

            public String getStringValue(AdvancedConfigEntry value) {
                if (value.getValue() == null || value.getValue().toString() == null) {
                    return null;
                }
                return value.getValue() + "";
            }

            protected String getTooltipText(AdvancedConfigEntry obj) {
                return obj.getDescription();
            }

            protected void setStringValue(String value, AdvancedConfigEntry object) {
                Color c;
                Color color = c = value == null ? null : LAFOptions.createColor((String)value);
                if (c != null) {
                    object.setValue((Object)value);
                    AdvancedValueColumn.this.getModel().getTable().repaint();
                }
            }
        };
        this.register((ExtColumn<AdvancedConfigEntry>)this.colorColumn);
        this.defaultColumn = new ExtTextAreaColumn<AdvancedConfigEntry>(this.getName()){
            private static final long serialVersionUID = 1L;
            {
                this.renderer.setHorizontalAlignment(4);
            }

            protected String getTooltipText(AdvancedConfigEntry obj) {
                return obj.getDescription();
            }

            public boolean isEditable(AdvancedConfigEntry obj) {
                return obj.isEditable();
            }

            public String getStringValue(AdvancedConfigEntry value) {
                return JSonStorage.toString((Object)value.getValue());
            }

            protected void setStringValue(String value, AdvancedConfigEntry object) {
                Class clazz;
                if (object.getType() instanceof Class && ((clazz = (Class)object.getType()).isArray() || clazz.isAssignableFrom(List.class) || clazz.isAssignableFrom(Set.class)) && value != null && !"null".equalsIgnoreCase(value.trim()) && !value.matches("(?s)^\\s*\\[.+\\]\\s*$")) {
                    value = "[" + value + "]";
                }
                try {
                    Object newValue = JSonStorage.restoreFromString((String)value, (TypeRef)new TypeRef<Object>(object.getType()){});
                    object.setValue(newValue);
                    AdvancedValueColumn.this.getModel().getTable().repaint();
                }
                catch (Throwable e) {
                    Dialog.getInstance().showErrorDialog("'" + value + "' is not a valid '" + object.getTypeString() + "'");
                }
            }
        };
        this.register((ExtColumn<AdvancedConfigEntry>)this.defaultColumn);
        this.booleanColumn = new ExtCheckColumn<AdvancedConfigEntry>(this.getName()){
            private static final long serialVersionUID = 1L;
            {
                this.renderer.setHorizontalAlignment(4);
                this.renderer.setHorizontalTextPosition(2);
                this.editor.setHorizontalAlignment(4);
            }

            protected boolean getBooleanValue(AdvancedConfigEntry value) {
                return (Boolean)value.getValue();
            }

            public boolean isEditable(AdvancedConfigEntry obj) {
                return obj.isEditable();
            }

            protected void setBooleanValue(boolean value, AdvancedConfigEntry object) {
                object.setValue((Object)value);
                AdvancedValueColumn.this.getModel().getTable().repaint();
            }
        };
        this.register((ExtColumn<AdvancedConfigEntry>)this.booleanColumn);
        this.numberColumn = new ExtSpinnerColumn<AdvancedConfigEntry>(this.getName()){
            private static final long serialVersionUID = 1L;

            public boolean isEditable(AdvancedConfigEntry obj) {
                return obj.isEditable();
            }

            protected SpinnerNumberModel getModel(AdvancedConfigEntry value, Number n) {
                SpinnerNumberModel ret = super.getModel((Object)value, n);
                if (value.getValidator() != null && value.getValidator() instanceof RangeValidator) {
                    if (Clazz.isDouble(n.getClass())) {
                        ret.setMaximum(Double.valueOf(((RangeValidator)value.getValidator()).getMax().doubleValue()));
                        ret.setMinimum(Double.valueOf(((RangeValidator)value.getValidator()).getMin().doubleValue()));
                        ret.setStepSize(((RangeValidator)value.getValidator()).getSteps().doubleValue());
                    } else if (Clazz.isFloat(n.getClass())) {
                        ret.setMaximum(Float.valueOf(((RangeValidator)value.getValidator()).getMax().floatValue()));
                        ret.setMinimum(Float.valueOf(((RangeValidator)value.getValidator()).getMin().floatValue()));
                        ret.setStepSize(Float.valueOf(((RangeValidator)value.getValidator()).getSteps().floatValue()));
                    } else if (Clazz.isLong(n.getClass())) {
                        ret.setMaximum(Long.valueOf(((RangeValidator)value.getValidator()).getMax().longValue()));
                        ret.setMinimum(Long.valueOf(((RangeValidator)value.getValidator()).getMin().longValue()));
                        ret.setStepSize(((RangeValidator)value.getValidator()).getSteps().longValue());
                    } else if (Clazz.isInteger(n.getClass())) {
                        ret.setMaximum(Integer.valueOf(((RangeValidator)value.getValidator()).getMax().intValue()));
                        ret.setMinimum(Integer.valueOf(((RangeValidator)value.getValidator()).getMin().intValue()));
                        ret.setStepSize(((RangeValidator)value.getValidator()).getSteps().intValue());
                    } else if (Clazz.isShort(n.getClass())) {
                        ret.setMaximum(Short.valueOf(((RangeValidator)value.getValidator()).getMax().shortValue()));
                        ret.setMinimum(Short.valueOf(((RangeValidator)value.getValidator()).getMin().shortValue()));
                        ret.setStepSize(((RangeValidator)value.getValidator()).getSteps().shortValue());
                    } else if (Clazz.isByte(n.getClass())) {
                        ret.setMaximum(Byte.valueOf(((RangeValidator)value.getValidator()).getMax().byteValue()));
                        ret.setMinimum(Byte.valueOf(((RangeValidator)value.getValidator()).getMin().byteValue()));
                        ret.setStepSize(((RangeValidator)value.getValidator()).getSteps().byteValue());
                    }
                }
                return ret;
            }

            protected Number getNumber(AdvancedConfigEntry value) {
                return (Number)value.getValue();
            }

            protected void setNumberValue(Number value, AdvancedConfigEntry object) {
                object.setValue((Object)value);
                AdvancedValueColumn.this.getModel().getTable().repaint();
            }

            public String getStringValue(AdvancedConfigEntry value) {
                return value.getValue() + "";
            }
        };
        this.register((ExtColumn<AdvancedConfigEntry>)this.numberColumn);
        this.enumColumn = new ExtTextColumn<AdvancedConfigEntry>(this.getName(), null){
            private static final long serialVersionUID = 1L;
            {
                this.renderer.removeAll();
                this.renderer.setLayout((LayoutManager)new MigLayout("ins 0", "[grow,fill]0[12]5", "[grow,fill]"));
                this.renderer.add(this.rendererField);
                this.renderer.add(this.rendererIcon);
            }

            public void configureRendererComponent(AdvancedConfigEntry value, boolean isSelected, boolean hasFocus, int row, int column) {
                Icon icon = this.getIcon(value);
                this.rendererIcon.setIcon(icon);
                String str = this.getStringValue(value);
                if (str == null) {
                    str = "";
                }
                if (this.getTableColumn() != null) {
                    try {
                        this.rendererField.setText(SwingUtilities2Wrapper.clipStringIfNecessary((JComponent)this.rendererField, (FontMetrics)this.rendererField.getFontMetrics(this.rendererField.getFont()), (String)str, (int)(this.getTableColumn().getWidth() - 18 - (icon != null ? icon.getIconWidth() : 0))));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        this.rendererField.setText(str);
                    }
                } else {
                    this.rendererField.setText(str);
                }
            }

            public boolean onSingleClick(MouseEvent e, final AdvancedConfigEntry value) {
                ExtPopupMenu popup = new ExtPopupMenu();
                try {
                    Object[] values;
                    for (final Object o : values = (Object[])value.getClazz().getMethod("values", new Class[0]).invoke(null, new Object[0])) {
                        popup.add(new JMenuItem((Action)new AppAction(){
                            {
                                EnumLabel lbl = value.getClazz().getDeclaredField(o.toString()).getAnnotation(EnumLabel.class);
                                if (lbl != null) {
                                    this.setName(lbl.value());
                                } else if (o instanceof LabelInterface) {
                                    this.setName(((LabelInterface)o).getLabel());
                                } else {
                                    this.setName(o.toString());
                                }
                                if (value.getValue() == o) {
                                    this.setSmallIcon(CheckBoxIcon.TRUE);
                                } else {
                                    this.setSmallIcon(CheckBoxIcon.FALSE);
                                }
                            }

                            public void actionPerformed(ActionEvent e) {
                                value.setValue(o);
                                AdvancedValueColumn.this.getModel().getTable().repaint();
                            }
                        }));
                    }
                    Rectangle bounds = this.getModel().getTable().getCellRect(this.getModel().getTable().rowAtPoint(new Point(e.getX(), e.getY())), this.getModel().getTable().columnAtPoint(new Point(e.getX(), e.getY())), true);
                    Dimension pref = popup.getPreferredSize();
                    popup.setPreferredSize(new Dimension(Math.max(pref.width, bounds.width), pref.height));
                    popup.show((Component)this.getModel().getTable(), bounds.x, bounds.y + bounds.height);
                    return true;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    return false;
                }
            }

            protected int getSelectedIndex(AdvancedConfigEntry value) {
                return ((Enum)value.getValue()).ordinal();
            }

            protected void setSelectedIndex(int value, AdvancedConfigEntry object) {
                try {
                    Object[] values = (Object[])object.getClazz().getMethod("values", new Class[0]).invoke(null, new Object[0]);
                    object.setValue(values[value]);
                    AdvancedValueColumn.this.getModel().getTable().repaint();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }

            protected Icon getIcon(AdvancedConfigEntry value) {
                return NewTheme.I().getIcon("popDownLarge", -1);
            }

            public String getStringValue(AdvancedConfigEntry value) {
                try {
                    EnumLabel lbl = value.getClazz().getDeclaredField(value.getValue().toString()).getAnnotation(EnumLabel.class);
                    if (lbl != null) {
                        return lbl.value();
                    }
                    if (value.getValue() instanceof LabelInterface) {
                        return ((LabelInterface)value.getValue()).getLabel();
                    }
                    if (value instanceof LabelInterface) {
                        return ((LabelInterface)value).getLabel();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return value.getValue().toString();
            }
        };
        this.register((ExtColumn<AdvancedConfigEntry>)this.enumColumn);
    }

    private void register(ExtColumn<AdvancedConfigEntry> col) {
        col.setClickcount(1);
        this.columns.add(col);
    }

    public String getSortString(AdvancedConfigEntry o1) {
        return null;
    }

    public ExtColumn<AdvancedConfigEntry> selectColumn(AdvancedConfigEntry object) {
        if (object == null) {
            return this.defaultColumn;
        }
        if (Clazz.isBoolean((Type)object.getType())) {
            return this.booleanColumn;
        }
        if (object.getType() == String.class) {
            if (object.hasHexColorString()) {
                return this.colorColumn;
            }
            if (object.isMultiLineString()) {
                return this.defaultColumn;
            }
            return this.stringColumn;
        }
        if (Clazz.isDouble((Type)object.getType()) || Clazz.isFloat((Type)object.getType()) || Clazz.isLong((Type)object.getType()) || Clazz.isInteger((Type)object.getType()) || Clazz.isByte((Type)object.getType())) {
            return this.numberColumn;
        }
        if (Enum.class.isAssignableFrom(object.getClazz())) {
            return this.enumColumn;
        }
        return this.defaultColumn;
    }
}

