/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction;

import java.awt.Color;
import jd.plugins.LinkInfo;
import org.appwork.utils.StringUtils;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionStatus;

public class MissingArchiveFile
implements ArchiveFile {
    private final String name;
    private final String filePath;
    private String archiveID = null;
    private final Archive missingOrIncompleteArchive;
    private volatile ExtractionStatus status = null;

    public Archive getMissingOrIncompleteArchive() {
        return this.missingOrIncompleteArchive;
    }

    @Override
    public Boolean isComplete() {
        return Boolean.FALSE;
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public long getFileSize() {
        return -1L;
    }

    public MissingArchiveFile(String name, String filePath) {
        this.name = name;
        this.filePath = filePath;
        this.missingOrIncompleteArchive = null;
    }

    public MissingArchiveFile(Archive missingArchive, String filePath) {
        this.name = missingArchive.getName();
        this.missingOrIncompleteArchive = missingArchive;
        this.filePath = filePath;
    }

    @Override
    public LinkInfo getLinkInfo() {
        return LinkInfo.getLinkInfo((String)this.getName());
    }

    @Override
    public void deleteFile(FileCreationManager.DeleteOption option) {
    }

    @Override
    public boolean contains(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof String) {
            return this.getFilePath().equals(obj);
        }
        if (obj instanceof ArchiveFile && StringUtils.equals((String)this.getFilePath(), (String)((ArchiveFile)obj).getFilePath())) {
            return true;
        }
        if (obj instanceof MissingArchiveFile) {
            return StringUtils.equals((String)this.getName(), (String)((MissingArchiveFile)obj).getName());
        }
        return false;
    }

    public String toString() {
        if (this.missingOrIncompleteArchive != null) {
            return "MissingArchiveFile:" + this.missingOrIncompleteArchive + "|" + this.missingOrIncompleteArchive.getArchiveFiles();
        }
        return "MissingArchiveFile:" + this.getName();
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public boolean exists(boolean ignoreCache) {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setStatus(ExtractionController controller, ExtractionStatus status) {
        this.status = status;
    }

    @Override
    public ExtractionStatus getStatus() {
        ExtractionStatus status = this.status;
        if (status != null) {
            return status;
        }
        return ExtractionStatus.NA;
    }

    @Override
    public void setMessage(ExtractionController controller, String plugins_optional_extraction_status_notenoughspace) {
    }

    @Override
    public void setProgress(ExtractionController controller, long value, long max, Color color) {
    }

    @Override
    public void removePluginProgress(ExtractionController controller) {
    }

    @Override
    public void onCleanedUp(ExtractionController controller) {
    }

    @Override
    public void setArchive(Archive archive) {
        this.archiveID = archive.getArchiveID();
    }

    @Override
    public void notifyChanges(Object type) {
    }

    @Override
    public void invalidateExists() {
    }

    @Override
    public void setPartOfAnArchive(Boolean b) {
    }

    @Override
    public Boolean isPartOfAnArchive() {
        return null;
    }

    @Override
    public String getArchiveID() {
        return this.archiveID;
    }

    @Override
    public boolean isFileArchiveFileExists() {
        return false;
    }
}

