/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.actions.AppAction;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.DummyArchive;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.gui.DummyArchiveDialog;
import org.jdownloader.extensions.extraction.multi.CheckException;
import org.jdownloader.extensions.extraction.translate.T;
import org.jdownloader.images.NewTheme;

public class ValidateArchiveAction<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>>
extends AppAction {
    private final ExtractionExtension extractor;
    private final List<Archive> archives;

    public ValidateArchiveAction(ExtractionExtension extractionExtension, Archive ... as) {
        if (as.length > 1) {
            this.setName(T.T.ValidateArchiveAction_ValidateArchiveAction_multi());
        } else {
            this.setName(T.T.ValidateArchiveAction_ValidateArchiveAction(as[0].getName()));
        }
        this.setSmallIcon(new ImageIcon(ImageProvider.merge((Image)NewTheme.I().getImage("extract", 20), (Image)NewTheme.I().getImage("ok", 12), (int)0, (int)0, (int)10, (int)10)));
        this.extractor = extractionExtension;
        this.archives = new ArrayList<Archive>();
        for (Archive a : as) {
            this.archives.add(a);
        }
        this.setEnabled(this.archives.size() > 0);
    }

    public ExtractionExtension getExtractionExtension() {
        return this.extractor;
    }

    public DummyArchive createDummyArchive(Archive a) throws CheckException {
        if (this.extractor != null) {
            return this.extractor.createDummyArchive(a);
        }
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        new Thread("ValidateArchiveAction"){
            {
                this.setDaemon(true);
            }

            @Override
            public void run() {
                try {
                    for (Archive archive : ValidateArchiveAction.this.archives) {
                        try {
                            DummyArchive da = ValidateArchiveAction.this.createDummyArchive(archive);
                            if (da == null) continue;
                            DummyArchiveDialog d = new DummyArchiveDialog(da);
                            try {
                                Dialog.getInstance().showDialog((AbstractDialog)d);
                            }
                            catch (DialogCanceledException dialogCanceledException) {
                            }
                        }
                        catch (CheckException e1) {
                            Dialog.getInstance().showExceptionDialog("Error", "Cannot Check Archive", (Throwable)e1);
                        }
                    }
                }
                catch (DialogClosedException e1) {
                    e1.printStackTrace();
                }
            }
        }.start();
    }

    public List<Archive> getArchives() {
        return this.archives;
    }
}

