/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.bindings.downloadlink;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jd.plugins.DownloadLink;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.bindings.downloadlink.DownloadLinkArchiveFile;
import org.jdownloader.extensions.extraction.multi.ArchiveType;
import org.jdownloader.extensions.extraction.split.SplitType;

public class DownloadLinkArchive
extends Archive {
    private List<DownloadLink> disabledLinks;

    public DownloadLinkArchive(ArchiveFactory link, ArchiveType archiveType) {
        super(link, archiveType);
    }

    public DownloadLinkArchive(ArchiveFactory link, SplitType splitType) {
        super(link, splitType);
    }

    public void onControllerAssigned(ExtractionController extractionController) {
        this.disabledLinks = new CopyOnWriteArrayList<DownloadLink>();
        for (ArchiveFile af : this.getArchiveFiles()) {
            if (!(af instanceof DownloadLinkArchiveFile)) continue;
            List<DownloadLink> dlinks = ((DownloadLinkArchiveFile)af).getDownloadLinks();
            for (DownloadLink dl : dlinks) {
                if (!dl.isEnabled() || dl.getFinalLinkState() != null) continue;
                dl.setEnabled(false);
                this.disabledLinks.add(dl);
            }
        }
    }

    @Override
    public void onStartExtracting() {
    }

    @Override
    public void onCleanUp() {
        if (this.disabledLinks != null) {
            for (DownloadLink dl : this.disabledLinks) {
                dl.setEnabled(true);
            }
        }
    }
}

