/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.contextmenu.downloadlist.action;

import java.awt.event.ActionEvent;
import java.util.List;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.WarnLevel;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.BooleanStatus;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.AbstractExtractionContextAction;
import org.jdownloader.extensions.extraction.translate.T;
import org.jdownloader.gui.views.SelectionInfo;

public class CleanupAutoDeleteLinksEnabledToggleAction
extends AbstractExtractionContextAction {
    public CleanupAutoDeleteLinksEnabledToggleAction() {
        this.setName(T.T.contextmenu_autodeletelinks());
        this.setIconKey("link");
        this.setSelected(false);
    }

    @Override
    protected void onAsyncInitDone(List<Archive> archives, SelectionInfo<?, ?> selectionInfo) {
        super.onAsyncInitDone(archives, selectionInfo);
        if (archives == null || archives.size() == 0) {
            return;
        }
        this.setSelected(((ExtractionExtension)this._getExtension()).isRemoveDownloadLinksAfterExtractEnabled(archives.get(0)));
    }

    @Override
    protected void onActionPerformed(ActionEvent e, List<Archive> archives, SelectionInfo<?, ?> selectionInfo) {
        for (Archive archive : archives) {
            archive.getSettings().setRemoveDownloadLinksAfterExtraction(this.isSelected() ? BooleanStatus.TRUE : BooleanStatus.FALSE);
        }
        if (JDGui.bugme((WarnLevel)WarnLevel.NORMAL)) {
            Dialog.getInstance().showMessageDialog(32, this.isSelected() ? T.T.set_autoremovelinks_true() : T.T.set_autoremovelinks_false());
        }
    }
}

