/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.gui;

import javax.swing.Icon;
import jd.plugins.DownloadLink;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.jdownloader.extensions.extraction.DummyArchive;
import org.jdownloader.extensions.extraction.DummyArchiveFile;
import org.jdownloader.extensions.extraction.bindings.file.FileArchiveFile;
import org.jdownloader.extensions.extraction.translate.T;
import org.jdownloader.images.AbstractIcon;

public class DummyArchiveContentsTableModel
extends ExtTableModel<DummyArchiveFile> {
    private ExtTextColumn<DummyArchiveFile> local;
    private ExtTextColumn<DummyArchiveFile> linkStatus;
    private ExtTextColumn<DummyArchiveFile> name;

    public ExtTextColumn<DummyArchiveFile> getLocal() {
        return this.local;
    }

    public DummyArchiveContentsTableModel(DummyArchive da) {
        super("DummyArchiveContentsTableModel");
        this._fireTableStructureChanged(da.getList(), true);
    }

    protected void initColumns() {
        this.name = new ExtTextColumn<DummyArchiveFile>(T.T.filename()){

            public String getStringValue(DummyArchiveFile value) {
                return value.getName();
            }

            protected String getTooltipText(DummyArchiveFile value) {
                if (value.getArchiveFile() instanceof FileArchiveFile) {
                    if (((FileArchiveFile)value.getArchiveFile()).getFile().exists()) {
                        return T.T.file_exists();
                    }
                    return T.T.file_exists_not();
                }
                if (value.getArchiveFile() == null) {
                    if (value.isMissing() || Boolean.TRUE.equals(value.isIncomplete())) {
                        return T.T.file_exists_not();
                    }
                    return T.T.unknown_tt();
                }
                if (value.isMissing() || Boolean.TRUE.equals(value.isIncomplete())) {
                    return T.T.offline_tt();
                }
                if (value.getOnlineStatus() == DownloadLink.AvailableStatus.TRUE) {
                    return T.T.online_tt();
                }
                return T.T.unknown_tt();
            }
        };
        this.addColumn((ExtColumn)this.name);
        this.linkStatus = new ExtTextColumn<DummyArchiveFile>(T.T.exists()){
            private Icon unknown;
            private Icon online;
            private Icon offline;
            {
                this.unknown = new AbstractIcon("help", 16);
                this.online = new AbstractIcon("true", 16);
                this.offline = new AbstractIcon("error", 16);
            }

            protected Icon getIcon(DummyArchiveFile value) {
                if (value.getOnlineStatus() == DownloadLink.AvailableStatus.TRUE) {
                    return this.online;
                }
                if (value.isMissing() || Boolean.TRUE.equals(value.isIncomplete())) {
                    return this.offline;
                }
                return this.unknown;
            }

            public String getStringValue(DummyArchiveFile value) {
                if (value.getOnlineStatus() == DownloadLink.AvailableStatus.TRUE) {
                    return T.T.online();
                }
                if (value.isMissing() || Boolean.TRUE.equals(value.isIncomplete())) {
                    return T.T.offline();
                }
                return T.T.unknown();
            }

            protected String getTooltipText(DummyArchiveFile value) {
                if (value.getOnlineStatus() == DownloadLink.AvailableStatus.TRUE) {
                    return T.T.online_tt();
                }
                if (value.isMissing() || Boolean.TRUE.equals(value.isIncomplete())) {
                    return T.T.offline_tt();
                }
                return T.T.unknown_tt();
            }
        };
        this.addColumn((ExtColumn)this.linkStatus);
        this.local = new ExtTextColumn<DummyArchiveFile>(T.T.local()){

            protected Icon getIcon(DummyArchiveFile value) {
                if (value.isLocalFileAvailable()) {
                    return new AbstractIcon("true", 16);
                }
                return new AbstractIcon("false", 16);
            }

            public String getStringValue(DummyArchiveFile value) {
                if (value.isLocalFileAvailable()) {
                    return T.T.downloadedok();
                }
                return T.T.downloadedbad();
            }

            protected String getTooltipText(DummyArchiveFile value) {
                return this.getStringValue(value);
            }
        };
        this.addColumn((ExtColumn)this.local);
    }

    public ExtTextColumn<DummyArchiveFile> getLinkStatus() {
        return this.linkStatus;
    }

    public ExtTextColumn<DummyArchiveFile> getName() {
        return this.name;
    }
}

