/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.gui.bubble;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Timer;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionEvent;
import org.jdownloader.extensions.extraction.gui.bubble.ExtractionBubbleContent;
import org.jdownloader.extensions.extraction.gui.bubble.ExtractionBubbleSupport;
import org.jdownloader.extensions.extraction.translate.T;
import org.jdownloader.gui.notify.AbstractBubbleContentPanel;
import org.jdownloader.gui.notify.AbstractBubbleSupport;
import org.jdownloader.gui.notify.BubbleNotify;
import org.jdownloader.gui.notify.gui.AbstractNotifyWindow;

public class ExtractionBubble
extends AbstractNotifyWindow<ExtractionBubbleContent> {
    protected long createdTime;
    private final Timer updateTimer;
    private final ExtractionController caller;
    private volatile ExtractionEvent latestEvent = null;

    protected void onMouseClicked(MouseEvent m) {
        super.onMouseClicked(m);
    }

    public void hideBubble(int timeout) {
        super.hideBubble(timeout);
        this.updateTimer.stop();
    }

    public ExtractionBubble(ExtractionBubbleSupport extractionBubbleSupport, final ExtractionController caller) {
        super((AbstractBubbleSupport)extractionBubbleSupport, T.T.bubble_text(), (AbstractBubbleContentPanel)new ExtractionBubbleContent());
        this.caller = caller;
        this.updateTimer = new Timer(1000, new ActionListener(){
            private ExtractionEvent lastEvent = null;

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtractionEvent currentEvent = ExtractionBubble.this.latestEvent;
                ((ExtractionBubbleContent)ExtractionBubble.this.getContentComponent()).update(caller, currentEvent);
                if (this.lastEvent != currentEvent) {
                    ExtractionBubble.this.pack();
                    BubbleNotify.getInstance().relayout();
                }
                this.lastEvent = currentEvent;
            }
        });
        this.updateTimer.setRepeats(true);
        this.updateTimer.start();
    }

    protected int getTimeout() {
        return 0;
    }

    public void dispose() {
        try {
            this.updateTimer.stop();
        }
        finally {
            super.dispose();
        }
    }

    public void stop() {
        this.updateTimer.stop();
        this.startTimeout(super.getTimeout());
        ((ExtractionBubbleContent)this.getContentComponent()).stop();
    }

    public void refresh(final ExtractionEvent event) {
        new EDTRunner(){

            protected void runInEDT() {
                ExtractionBubble.this.latestEvent = event;
                ((ExtractionBubbleContent)ExtractionBubble.this.getContentComponent()).update(ExtractionBubble.this.caller, event);
                ExtractionBubble.this.pack();
                BubbleNotify.getInstance().relayout();
            }
        };
    }
}

