/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.gui.iffileexistsdialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jd.controlling.downloadcontroller.IfFileExistsDialogInterface;
import jd.plugins.DownloadLink;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtTextArea;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Files;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.CFG_EXTRACTION;
import org.jdownloader.extensions.extraction.Item;
import org.jdownloader.extensions.extraction.bindings.downloadlink.DownloadLinkArchiveFile;
import org.jdownloader.extensions.extraction.translate.T;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.table.DownloadsTableModel;
import org.jdownloader.settings.IfFileExistsAction;
import org.jdownloader.translate._JDT;

public class IfFileExistsDialog
extends AbstractDialog<IfFileExistsAction>
implements IfFileExistsDialogInterface,
FocusListener {
    private final String path;
    private IfFileExistsAction result;
    private String packagename;
    private JRadioButton skip;
    private JRadioButton overwrite;
    private JRadioButton rename;
    private String packageID;
    private DownloadLink downloadLink;
    private final Archive archive;
    private final Item item;
    private JTextField newName;
    private String newNameString;

    public boolean isRemoteAPIEnabled() {
        return true;
    }

    public String getPackagename() {
        return this.packagename;
    }

    public String getPackageID() {
        return this.packageID;
    }

    protected String getDontShowAgainLabelText() {
        return T.T.if_file_exists_dont_show_again();
    }

    public IfFileExistsDialog(File extractTo, Item item, Archive archive) {
        super(32, _JDT.T.jd_controlling_SingleDownloadController_askexists_title(), null, null, null);
        this.archive = archive;
        for (ArchiveFile af : archive.getArchiveFiles()) {
            if (!(af instanceof DownloadLinkArchiveFile)) continue;
            this.downloadLink = ((DownloadLinkArchiveFile)af).getDownloadLinks().get(0);
            this.packagename = this.downloadLink.getFilePackage().getName();
            this.packageID = this.downloadLink.getFilePackage().getName() + "_" + this.downloadLink.getFilePackage().getCreated();
            break;
        }
        this.item = item;
        this.path = extractTo.getAbsolutePath();
        String extension = Files.getExtension((String)extractTo.getName());
        String name = StringUtils.isEmpty((String)extension) ? extractTo.getName() : extractTo.getName().substring(0, extractTo.getName().length() - extension.length() - 1);
        int i = 1;
        while (extractTo.exists()) {
            extractTo = StringUtils.isEmpty((String)extension) ? new File(extractTo.getParentFile(), name + "_" + i) : new File(extractTo.getParentFile(), name + "_" + i + "." + extension);
            ++i;
        }
        this.newNameString = extractTo.getName();
    }

    public Dialog.ModalityType getModalityType() {
        return Dialog.ModalityType.MODELESS;
    }

    public String getDontShowAgainKey() {
        return null;
    }

    public void dispose() {
        super.dispose();
        if (this.okButton != null) {
            this.okButton.removeFocusListener(this);
        }
        if (this.result != null) {
            CFG_EXTRACTION.CFG.setLatestIfFileExistsAction(this.result);
        }
    }

    public JComponent layoutDialogContent() {
        MigPanel p = new MigPanel("ins 0,wrap 2", "[][grow,fill]", "[]");
        ExtTextArea txt = new ExtTextArea();
        txt.setLabelMode(true);
        txt.setToolTipText(this.path);
        File localFile = new File(this.path);
        txt.setText(T.T.file_exists_message());
        p.add((Component)txt, (Object)"spanx");
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.IfFileExistsDialog_layoutDialogContent_filename())), (Object)"sg 1");
        p.add((Component)new JLabel(new File(this.path).getName()));
        if (this.item != null) {
            p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.IfFileExistsDialog_layoutDialogContent_filesize2())), (Object)"sg 1");
            if (this.item.getSize() >= 0L) {
                p.add((Component)new JLabel(SizeFormatter.formatBytes((long)this.item.getSize())));
            } else {
                p.add((Component)new JLabel(_GUI.T.OriginFilter_toString_nothing()));
            }
        }
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.IfFileExistsDialog_layoutDialogContent_filesize_existing())), (Object)"sg 1");
        p.add((Component)new JLabel(SizeFormatter.formatBytes((long)localFile.length())));
        if (this.packagename != null) {
            p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.IfFileExistsDialog_layoutDialogContent_package())), (Object)"sg 1");
            p.add((Component)new JLabel(this.packagename));
        }
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(T.T.IfFileExistsDialog_layoutDialogContent_archive())), (Object)"sg 1");
        p.add((Component)new JLabel(this.archive.getName()));
        this.skip = new JRadioButton(_GUI.T.IfFileExistsDialog_layoutDialogContent_skip_());
        this.skip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IfFileExistsDialog.this.result = IfFileExistsAction.SKIP_FILE;
                IfFileExistsDialog.this.newName.setEnabled(false);
            }
        });
        this.overwrite = new JRadioButton(_GUI.T.IfFileExistsDialog_layoutDialogContent_overwrite_());
        this.overwrite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IfFileExistsDialog.this.result = IfFileExistsAction.OVERWRITE_FILE;
                IfFileExistsDialog.this.newName.setEnabled(false);
            }
        });
        this.rename = new JRadioButton(_GUI.T.IfFileExistsDialog_layoutDialogContent_rename_());
        this.rename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IfFileExistsDialog.this.result = IfFileExistsAction.AUTO_RENAME;
                IfFileExistsDialog.this.newName.setEnabled(true);
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.skip);
        group.add(this.overwrite);
        group.add(this.rename);
        p.add((Component)new JSeparator(), (Object)"spanx,pushx,growx");
        p.add((Component)this.skip, (Object)"skip 1");
        p.add((Component)this.overwrite, (Object)"skip 1");
        p.add((Component)this.rename, (Object)"skip 1");
        this.newName = new JTextField(this.newNameString);
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(T.T.IfFileExistsDialog_layoutDialogContent_newName())), (Object)"sg 1");
        p.add((Component)this.newName);
        IfFileExistsAction def = CFG_EXTRACTION.CFG.getLatestIfFileExistsAction();
        if (def == null) {
            def = IfFileExistsAction.SKIP_FILE;
        }
        switch (def) {
            case AUTO_RENAME: {
                this.rename.setSelected(true);
                break;
            }
            case OVERWRITE_FILE: {
                this.overwrite.setSelected(true);
                break;
            }
            default: {
                this.skip.setSelected(true);
            }
        }
        this.newName.setEnabled(this.rename.isSelected());
        this.result = def;
        if (this.okButton != null) {
            this.okButton.addFocusListener(this);
        }
        return p;
    }

    public String getNewName() {
        return this.newName.getText();
    }

    public IfFileExistsAction getAction() {
        return this.result;
    }

    public String getFilePath() {
        return this.path;
    }

    public IfFileExistsDialogInterface show() {
        return (IfFileExistsDialogInterface)UIOManager.I().show(IfFileExistsDialogInterface.class, (UserIODefinition)this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.downloadLink != null) {
            DownloadsTableModel.getInstance().setSelectedObject((Object)this.downloadLink);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    protected IfFileExistsAction createReturnValue() {
        return null;
    }

    public String getHost() {
        return this.downloadLink.getHost();
    }
}

