/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.multi;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.extensions.extraction.multi.FilePermissionSet;

public class FilePermission17 {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setFilePermission(File file, FilePermissionSet filePermissionSet) throws IOException {
        if (file == null || !file.exists() || filePermissionSet == null) return;
        if (CrossSystem.isUnix() || CrossSystem.isMac()) {
            HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
            if (filePermissionSet.isUserRead()) {
                permissions.add(PosixFilePermission.OWNER_READ);
            }
            if (filePermissionSet.isUserWrite()) {
                permissions.add(PosixFilePermission.OWNER_WRITE);
            }
            if (filePermissionSet.isUserExecute()) {
                permissions.add(PosixFilePermission.OWNER_EXECUTE);
            }
            if (filePermissionSet.isGroupRead()) {
                permissions.add(PosixFilePermission.GROUP_READ);
            }
            if (filePermissionSet.isGroupWrite()) {
                permissions.add(PosixFilePermission.GROUP_WRITE);
            }
            if (filePermissionSet.isGroupExecute()) {
                permissions.add(PosixFilePermission.GROUP_EXECUTE);
            }
            if (filePermissionSet.isOtherRead()) {
                permissions.add(PosixFilePermission.OTHERS_READ);
            }
            if (filePermissionSet.isOtherWrite()) {
                permissions.add(PosixFilePermission.OTHERS_WRITE);
            }
            if (filePermissionSet.isOtherExecute()) {
                permissions.add(PosixFilePermission.OTHERS_EXECUTE);
            }
            try {
                Files.setPosixFilePermissions(file.toPath(), permissions);
                return;
            }
            catch (UnsupportedOperationException e) {
                if (file.setExecutable(true, !filePermissionSet.isOtherExecute() && !filePermissionSet.isOtherExecute())) return;
                throw new IOException("Failed to set " + filePermissionSet + " to " + file);
            }
        } else {
            if (file.setExecutable(true, !filePermissionSet.isOtherExecute() && !filePermissionSet.isOtherExecute())) return;
            throw new IOException("Failed to set " + filePermissionSet + " to " + file);
        }
    }
}

