/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.multi;

import java.io.Closeable;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.sf.sevenzipjbinding.IArchiveOpenVolumeCallback;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.SevenZipException;

public class ModdedVolumedArchiveInStream
implements IInStream,
Closeable {
    private long absoluteOffset;
    private long absoluteLength = -1L;
    private int currentIndex = -1;
    private IInStream currentInStream;
    private long currentVolumeOffset;
    private long currentVolumeLength;
    private List<Long> volumePositions = new ArrayList<Long>();
    private final IArchiveOpenVolumeCallback archiveOpenVolumeCallback;
    private String cuttedVolumeFilename;

    public ModdedVolumedArchiveInStream(String firstVolumeFilename, IArchiveOpenVolumeCallback archiveOpenVolumeCallback) throws SevenZipException {
        this.archiveOpenVolumeCallback = archiveOpenVolumeCallback;
        this.volumePositions.add(0L);
        this.cuttedVolumeFilename = firstVolumeFilename.substring(0, firstVolumeFilename.length() - 3);
        this.openVolume(1, true);
    }

    private void openVolume(int index, boolean seekToBegin) throws SevenZipException {
        if (this.currentIndex == index) {
            return;
        }
        for (int i = this.volumePositions.size(); i < index && this.absoluteLength == -1L; ++i) {
            this.openVolume(i, false);
        }
        if (this.absoluteLength != -1L && this.volumePositions.size() <= index) {
            return;
        }
        String volumeFilename = this.cuttedVolumeFilename + MessageFormat.format("{0,number,000}", index);
        IInStream newInStream = this.archiveOpenVolumeCallback.getStream(volumeFilename);
        if (newInStream == null) {
            this.absoluteLength = this.volumePositions.get(this.volumePositions.size() - 1);
            return;
        }
        this.currentInStream = newInStream;
        if (this.volumePositions.size() == index) {
            this.currentVolumeLength = this.currentInStream.seek(0L, 2);
            if (this.currentVolumeLength == 0L) {
                throw new RuntimeException("Volume " + index + " is empty");
            }
            this.volumePositions.add(this.volumePositions.get(index - 1) + this.currentVolumeLength);
            if (seekToBegin) {
                this.currentInStream.seek(0L, 0);
            }
        } else {
            this.currentVolumeLength = this.volumePositions.get(index) - this.volumePositions.get(index - 1);
        }
        if (seekToBegin) {
            this.currentVolumeOffset = 0L;
            this.absoluteOffset = this.volumePositions.get(index - 1);
        }
        this.currentIndex = index;
    }

    private void openVolumeToAbsoluteOffset() throws SevenZipException {
        int index = this.volumePositions.size() - 1;
        if (this.absoluteLength != -1L && this.absoluteOffset >= this.absoluteLength) {
            return;
        }
        while (this.volumePositions.get(index) > this.absoluteOffset) {
            --index;
        }
        if (index < this.volumePositions.size() - 1) {
            this.openVolume(index + 1, false);
            return;
        }
        do {
            this.openVolume(++index, false);
        } while ((this.absoluteLength == -1L || this.absoluteOffset < this.absoluteLength) && this.volumePositions.get(index) <= this.absoluteOffset);
    }

    public long seek(long offset, int seekOrigin) throws SevenZipException {
        long newOffset;
        boolean proceedWithSeek = false;
        switch (seekOrigin) {
            case 0: {
                newOffset = offset;
                break;
            }
            case 1: {
                newOffset = this.absoluteOffset + offset;
                break;
            }
            case 2: {
                if (this.absoluteLength == -1L) {
                    this.openVolume(Integer.MAX_VALUE, false);
                    proceedWithSeek = true;
                }
                newOffset = this.absoluteLength + offset;
                break;
            }
            default: {
                throw new RuntimeException("Seek: unknown origin: " + seekOrigin);
            }
        }
        if (newOffset == this.absoluteOffset && !proceedWithSeek) {
            return newOffset;
        }
        this.absoluteOffset = newOffset;
        this.openVolumeToAbsoluteOffset();
        if (this.absoluteLength != -1L && this.absoluteLength <= this.absoluteOffset) {
            this.absoluteOffset = this.absoluteLength;
            return this.absoluteLength;
        }
        this.currentVolumeOffset = this.absoluteOffset - this.volumePositions.get(this.currentIndex - 1);
        this.currentInStream.seek(this.currentVolumeOffset, 0);
        return newOffset;
    }

    public int read(byte[] data) throws SevenZipException {
        if (this.absoluteLength != -1L && this.absoluteOffset >= this.absoluteLength) {
            return 0;
        }
        int read = this.currentInStream.read(data);
        this.absoluteOffset += (long)read;
        this.currentVolumeOffset += (long)read;
        if (this.currentVolumeOffset >= this.currentVolumeLength) {
            this.openVolume(this.currentIndex + 1, true);
        }
        return read;
    }

    @Override
    public void close() throws IOException {
    }
}

