/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.multi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import jd.controlling.downloadcontroller.IfFileExistsDialogInterface;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.sf.sevenzipjbinding.SevenZipException;
import org.appwork.utils.Files;
import org.appwork.utils.Regex;
import org.appwork.utils.ReusableByteArrayOutputStream;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.DummyArchive;
import org.jdownloader.extensions.extraction.DummyArchiveFile;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionException;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.IExtraction;
import org.jdownloader.extensions.extraction.Item;
import org.jdownloader.extensions.extraction.MissingArchiveFile;
import org.jdownloader.extensions.extraction.Signature;
import org.jdownloader.extensions.extraction.content.ContentView;
import org.jdownloader.extensions.extraction.content.PackedFile;
import org.jdownloader.extensions.extraction.gui.iffileexistsdialog.IfFileExistsDialog;
import org.jdownloader.extensions.extraction.multi.ArchiveException;
import org.jdownloader.extensions.extraction.multi.ArchiveType;
import org.jdownloader.extensions.extraction.multi.CheckException;
import org.jdownloader.extensions.extraction.multi.FilesBytesCacheWriter;
import org.jdownloader.extensions.extraction.multi.MultiSevenZipException;
import org.jdownloader.extensions.extraction.multi.SignatureCheckingOutStream;
import org.jdownloader.settings.IfFileExistsAction;

public class Zip4J
extends IExtraction {
    private volatile int crack = 0;
    private ZipFile zipFile = null;
    private static final ArchiveType[] SUPPORTED_ARCHIVE_TYPES = new ArchiveType[]{ArchiveType.ZIP_MULTI2};
    private final ExtractionExtension extension;

    @Override
    public Archive buildArchive(ArchiveFactory link, boolean allowDeepInspection) throws ArchiveException {
        return ArchiveType.createArchive(link, allowDeepInspection, SUPPORTED_ARCHIVE_TYPES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean findPassword(ExtractionController ctl, String password, boolean optimized) throws ExtractionException {
        Archive archive = this.getExtractionController().getArchive();
        ++this.crack;
        if (StringUtils.isEmpty((String)password)) {
            password = "";
        }
        AtomicReference<Object> passwordFound = new AtomicReference<Object>(null);
        try {
            List items = this.zipFile.getFileHeaders();
            HashSet<String> checkedExtensions = new HashSet<String>();
            ReusableByteArrayOutputStream buffer = new ReusableByteArrayOutputStream(65536);
            SignatureCheckingOutStream signatureOutStream = new SignatureCheckingOutStream(ctl, passwordFound, ctl.getFileSignatures(), buffer, this.getConfig().getMaxCheckedFileSizeDuringOptimizedPasswordFindingInBytes(), optimized);
            byte[] readBuffer = new byte[Short.MAX_VALUE];
            for (int index = 0; index < items.size(); ++index) {
                FileHeader item = (FileHeader)items.get(index);
                if (item == null || item.isDirectory() || !item.isEncrypted()) continue;
                if (ctl.gotKilled() || passwordFound.get() != null) break;
                String path = item.getFileName();
                String ext = Files.getExtension((String)path);
                if (!checkedExtensions.add(ext) && optimized) continue;
                try {
                    ZipInputStream is;
                    long remaining = item.getUncompressedSize();
                    signatureOutStream.reset();
                    signatureOutStream.setSignatureLength(path, remaining);
                    this.logger.fine("Validating password: " + path + "|" + password);
                    this.zipFile.setPassword(password);
                    try {
                        is = this.zipFile.getInputStream(item);
                    }
                    catch (ZipException e) {
                        throw new IOException(e.getMessage(), e);
                    }
                    try {
                        while (passwordFound.get() == null) {
                            int read = is.read(readBuffer);
                            if (read == -1) {
                                break;
                            }
                            int write = signatureOutStream.write(readBuffer, 0, read);
                            if (write == 0) {
                                break;
                            }
                            remaining -= (long)write;
                        }
                    }
                    finally {
                        is.close();
                    }
                    if (remaining != 0L) continue;
                    passwordFound.compareAndSet(null, new Signature("UNKNOWN:Extraction:OK", null, null, ext));
                    break;
                }
                catch (SevenZipException e) {
                    this.logger.log((Throwable)e);
                    continue;
                }
                catch (IOException e) {
                    if (StringUtils.startsWithCaseInsensitive((String)e.getMessage(), (String)"Wrong Password")) {
                        this.logger.log((Throwable)e);
                        continue;
                    }
                    throw e;
                }
                finally {
                    if (passwordFound.get() != null) {
                        this.logger.info("Verified Password:" + password + "|" + path + "|" + passwordFound.get());
                    }
                }
            }
            boolean bl = passwordFound.get() != null;
            return bl;
        }
        catch (Throwable e) {
            throw new ExtractionException(e, null);
        }
        finally {
            if (passwordFound.get() != null) {
                archive.setFinalPassword(password);
            }
        }
    }

    public Zip4J(ExtractionExtension extension) {
        this.extension = extension;
    }

    public File getExtractFilePath(FileHeader item, ExtractionController ctrl, AtomicBoolean skipped) throws MultiSevenZipException, ZipException {
        Archive archive = this.getExtractionController().getArchive();
        String itemPath = item.getFileName();
        ArchiveFile firstArchiveFile = archive.getArchiveFiles().get(0);
        Matcher filter = null;
        filter = this.isFiltered(itemPath);
        if (filter != null) {
            this.logger.info("Filtering item:" + itemPath + " from " + firstArchiveFile + "|pattern:" + filter.pattern());
            skipped.set(true);
            return null;
        }
        itemPath = ctrl.getCleanedExtractionPath(itemPath);
        Long size = item.getUncompressedSize();
        String extractToRoot = this.getExtractionController().getExtractToFolder().getAbsoluteFile() + File.separator;
        File extractToFile = new File(extractToRoot + itemPath);
        this.logger.info("Extract " + extractToFile);
        if (extractToFile.exists()) {
            IfFileExistsAction action = this.getExtractionController().getIfFileExistsAction();
            while (action == null || action == IfFileExistsAction.ASK_FOR_EACH_FILE) {
                if (ctrl.gotKilled()) {
                    throw new MultiSevenZipException("Extraction has been aborted", 255);
                }
                IfFileExistsDialog dialog = new IfFileExistsDialog(extractToFile, new Item(itemPath, size, extractToFile), archive);
                IfFileExistsDialogInterface dialogInterface = dialog.show();
                try {
                    dialogInterface.throwCloseExceptions();
                }
                catch (DialogNoAnswerException e) {
                    throw new ZipException((Throwable)e);
                }
                action = dialogInterface.getAction();
                if (action == null) {
                    throw new ZipException("cannot handle if file exists: " + extractToFile);
                }
                if (dialogInterface.isDontShowAgainSelected()) {
                    this.logger.info("Remember IfFileExistsAction:" + action + " for current archive");
                    this.getExtractionController().setIfFileExistsAction(action);
                }
                if (action != IfFileExistsAction.AUTO_RENAME || dialogInterface != dialog) continue;
                String newName = dialog.getNewName();
                if (StringUtils.equals((String)extractToFile.getName(), (String)newName)) continue;
                if ((extractToFile = new File(extractToFile.getParentFile(), newName)).exists()) {
                    action = IfFileExistsAction.ASK_FOR_EACH_FILE;
                    continue;
                }
                action = null;
                break;
            }
            if (extractToFile.exists() && action != null) {
                block2 : switch (action) {
                    case OVERWRITE_FILE: {
                        if (FileCreationManager.getInstance().delete(extractToFile, null)) break;
                        throw new MultiSevenZipException("Could not overwrite(delete) " + extractToFile, 9);
                    }
                    case SKIP_FILE: {
                        archive.addSkippedFiles(extractToFile);
                        skipped.set(true);
                        return null;
                    }
                    case AUTO_RENAME: {
                        String sourceFileName;
                        String[] splitName = CrossSystem.splitFileName((String)extractToFile.getName());
                        String fileRoot = extractToFile.getParent();
                        String extension = StringUtils.isEmpty((String)splitName[1]) ? "" : "." + splitName[1];
                        long duplicateFilenameCounter = 2L;
                        String alreadyDuplicated = new Regex(splitName[0], ".*_(\\d+)$").getMatch(0);
                        if (alreadyDuplicated != null) {
                            duplicateFilenameCounter = Long.parseLong(alreadyDuplicated) + 1L;
                            sourceFileName = new Regex(splitName[0], "(.*)_\\d+$").getMatch(0);
                        } else {
                            sourceFileName = splitName[0];
                        }
                        do {
                            String newFileName;
                            File checkFileExists;
                            if ((checkFileExists = new File(fileRoot, newFileName = sourceFileName + "_" + duplicateFilenameCounter++ + extension)).exists()) continue;
                            extractToFile = checkFileExists;
                            break block2;
                        } while (!ctrl.gotKilled());
                        throw new MultiSevenZipException("Extraction has been aborted", 255);
                    }
                }
            }
        }
        if (!extractToFile.getParentFile().exists() && !extractToFile.getParentFile().mkdirs()) {
            throw new MultiSevenZipException("could not create folder for file:" + extractToFile, 9);
        }
        while (true) {
            try {
                if (!extractToFile.createNewFile()) {
                    throw new MultiSevenZipException("could not create file:" + extractToFile, 9);
                }
                extractToFile.delete();
                return extractToFile;
            }
            catch (IOException e) {
                this.logger.log((Throwable)e);
                File parent = extractToFile.getParentFile();
                String brokenFilename = extractToFile.getName();
                String fixedFilename = new String(brokenFilename.replaceAll("[^\\w\\s\\.\\(\\)\\[\\],]", ""));
                if (!StringUtils.equals((String)brokenFilename, (String)fixedFilename)) {
                    this.logger.severe("Invalid Chars could have occured, try to remove them");
                    this.logger.severe("Replaced " + brokenFilename + " with " + fixedFilename);
                    extractToFile = new File(parent, fixedFilename);
                    continue;
                }
                throw new MultiSevenZipException(e, 9);
            }
            break;
        }
    }

    public void setLastModifiedDate(FileHeader item, File extractTo) {
        try {
            int date;
            long modified = this.getConfig().isUseOriginalFileDate() ? ((date = item.getLastModFileTime()) >= 0 ? (long)date * 1000L : -1L) : System.currentTimeMillis();
            if (modified == 0L) {
                return;
            }
            if (!extractTo.setLastModified(modified)) {
                this.logger.warning("Could not set last write/modified time(" + modified + "/" + new Date(modified) + ") for " + item.getFileName());
            } else {
                this.logger.warning("Set last write/modified time(" + modified + "/" + new Date(modified) + ")  for " + item.getFileName());
            }
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extract(final ExtractionController ctrl) {
        Archive archive = this.getExtractionController().getArchive();
        try {
            ctrl.setCompleteBytes(archive.getContentView().getTotalSize());
            ctrl.setProcessedBytes(0L);
            if (this.zipFile.isEncrypted()) {
                String pw = archive.getFinalPassword();
                this.zipFile.setPassword(pw);
            }
            List items = this.zipFile.getFileHeaders();
            byte[] readBuffer = new byte[Short.MAX_VALUE];
            for (int index = 0; index < items.size(); ++index) {
                FileHeader item = (FileHeader)items.get(index);
                if (item == null || item.isDirectory()) continue;
                if (ctrl.gotKilled()) {
                    throw new MultiSevenZipException("Extraction has been aborted", 255);
                }
                AtomicBoolean skippedFlag = new AtomicBoolean(false);
                Long size = item.getUncompressedSize();
                File extractTo = this.getExtractFilePath(item, ctrl, skippedFlag);
                if (skippedFlag.get()) {
                    if (size == null || size < 0L) continue;
                    ctrl.addProcessedBytesAndPauseIfNeeded(size);
                    continue;
                }
                if (extractTo == null) {
                    throw new ZipException("Extraction error, extractTo == null");
                }
                String itemPath = item.getFileName();
                ctrl.setCurrentActiveItem(new Item(itemPath, size, extractTo));
                try {
                    FilesBytesCacheWriter call = new FilesBytesCacheWriter(extractTo, this.getExtractionController(), this.getConfig()){

                        @Override
                        public int write(byte[] data, int length) throws SevenZipException {
                            if (ctrl.gotKilled()) {
                                throw new MultiSevenZipException("Extraction has been aborted", 255);
                            }
                            int ret = super.write(data, length);
                            ctrl.addProcessedBytesAndPauseIfNeeded(ret);
                            return ret;
                        }
                    };
                    archive.addExtractedFiles(extractTo);
                    ZipInputStream is = null;
                    try {
                        is = this.zipFile.getInputStream(item);
                        if (is == null) {
                            throw new IOException("no InputStream for " + item.getFileName());
                        }
                        int readLen = -1;
                        while ((readLen = is.read(readBuffer)) != -1) {
                            call.write(readBuffer, readLen);
                        }
                        is.close();
                        is = null;
                    }
                    finally {
                        call.close();
                        if (is != null) {
                            is.close(true);
                        }
                    }
                    this.setLastModifiedDate(item, extractTo);
                    continue;
                }
                finally {
                    ctrl.setCurrentActiveItem(null);
                }
            }
            archive.setExitCode(0);
        }
        catch (MultiSevenZipException e) {
            this.logger.log((Throwable)((Object)e));
            this.setException((Exception)((Object)e));
            archive.setExitCode(e.getExitCode());
        }
        catch (SevenZipException e) {
            this.logger.log((Throwable)e);
            this.setException((Exception)((Object)e));
            archive.setExitCode(2);
        }
        catch (ZipException e) {
            this.logger.log((Throwable)e);
            this.setException((Exception)((Object)e));
            archive.setExitCode(2);
        }
        catch (IOException e) {
            this.logger.log((Throwable)e);
            this.setException(e);
            archive.setExitCode(9);
        }
    }

    @Override
    public boolean isAvailable(ExtractionExtension extractionExtension) {
        return true;
    }

    @Override
    public int getCrackProgress() {
        return this.crack;
    }

    @Override
    public boolean prepare() throws ExtractionException {
        Archive archive = this.getExtractionController().getArchive();
        ArchiveFile firstArchiveFile = archive.getArchiveFiles().get(0);
        try {
            this.zipFile = new ZipFile(firstArchiveFile.getFilePath());
            archive.setProtected(this.zipFile.isEncrypted());
            this.updateContentView(this.zipFile);
        }
        catch (Throwable e) {
            this.logger.log(e);
            throw new ExtractionException(e, firstArchiveFile);
        }
        return true;
    }

    private void updateContentView(ZipFile zipFile) {
        Archive archive = this.getExtractionController().getArchive();
        try {
            if (archive != null) {
                this.initFilters();
                ContentView newView = new ContentView();
                List fileHeaders = zipFile.getFileHeaders();
                for (int index = 0; index < fileHeaders.size(); ++index) {
                    String itemPath;
                    FileHeader fileHeader = (FileHeader)fileHeaders.get(index);
                    if (fileHeader == null || StringUtils.isEmpty((String)(itemPath = fileHeader.getFileName())) || this.isFiltered(itemPath) != null) continue;
                    newView.add(new PackedFile(fileHeader.isDirectory(), itemPath, fileHeader.getUncompressedSize()));
                }
                archive.setContentView(newView);
            }
        }
        catch (ZipException e) {
            this.logger.log((Throwable)e);
        }
    }

    @Override
    public Boolean isSupported(ArchiveFactory factory, boolean allowDeepInspection) {
        if (allowDeepInspection) {
            try {
                Archive archive = this.buildArchive(factory, allowDeepInspection);
                return archive != null && Arrays.asList(SUPPORTED_ARCHIVE_TYPES).contains(archive.getArchiveType());
            }
            catch (ArchiveException e) {
                this.getLogger().log((Throwable)e);
                return false;
            }
        }
        for (ArchiveType archiveType : SUPPORTED_ARCHIVE_TYPES) {
            if (!archiveType.matches(factory.getFilePath())) continue;
            return null;
        }
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public DummyArchive checkComplete(Archive archive) throws CheckException {
        if (archive.getArchiveType() != null) {
            try {
                ZipFile zipFile;
                ArrayList splitZipFiles;
                DummyArchive ret = new DummyArchive(archive, archive.getArchiveType());
                boolean hasMissingArchiveFiles = false;
                for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
                    if (archiveFile instanceof MissingArchiveFile) {
                        hasMissingArchiveFiles = true;
                    }
                    ret.add(new DummyArchiveFile(archiveFile));
                }
                if (!hasMissingArchiveFiles) {
                    ArchiveType archiveType = archive.getArchiveType();
                    String firstArchiveFile = archive.getArchiveFiles().get(0).getFilePath();
                    String partNumberOfFirstArchiveFile = archiveType.getPartNumberString(firstArchiveFile);
                    if (archiveType.getFirstPartIndex() != archiveType.getPartNumber(partNumberOfFirstArchiveFile)) {
                        throw new CheckException("Wrong firstArchiveFile(" + firstArchiveFile + ") for Archive(" + archive.getName() + ")");
                    }
                }
                if (ret.isComplete() && (splitZipFiles = (zipFile = new ZipFile(archive.getArchiveFiles().get(0).getFilePath())).getSplitZipFiles()) != null) {
                    for (String splitZipFile : splitZipFiles) {
                        if (splitZipFile.endsWith("z010")) {
                            splitZipFile = splitZipFile.replaceFirst("z010$", "z10");
                        }
                        if (archive.getArchiveFileByPath(splitZipFile) != null) continue;
                        File missingFile = new File(splitZipFile);
                        ret.add(new DummyArchiveFile(new MissingArchiveFile(missingFile.getName(), splitZipFile)));
                    }
                }
                return ret;
            }
            catch (CheckException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new CheckException("Cannot check Archive(" + archive.getName() + ")", e);
            }
        }
        return null;
    }
}

