/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.eventscripter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtButton;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.contextmenu.gui.ExtPopupMenu;
import org.jdownloader.extensions.AbstractExtension;
import org.jdownloader.extensions.ExtensionConfigPanel;
import org.jdownloader.extensions.eventscripter.EventScripterExtension;
import org.jdownloader.extensions.eventscripter.EventScripterTable;
import org.jdownloader.extensions.eventscripter.EventScripterTableModel;
import org.jdownloader.extensions.eventscripter.EventTrigger;
import org.jdownloader.extensions.eventscripter.ExampleMenuEntry;
import org.jdownloader.extensions.eventscripter.ScriptEntry;
import org.jdownloader.extensions.eventscripter.T;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.AbstractAddAction;
import org.jdownloader.gui.views.components.AbstractRemoveAction;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.updatev2.gui.LAFOptions;

public class EventScripterConfigPanel
extends ExtensionConfigPanel<EventScripterExtension> {
    private static final long serialVersionUID = 1L;
    private EventScripterTableModel model;
    private ExtButton btnAdd;
    private EventScripterTable table;
    private AbstractRemoveAction deleteSelectionAction;

    public EventScripterConfigPanel(EventScripterExtension extension) {
        super((AbstractExtension)extension);
        this.model = new EventScripterTableModel(extension);
        this.table = new EventScripterTable(this.model){

            protected boolean onShortcutDelete(List<ScriptEntry> selectedObjects, KeyEvent evt, boolean direct) {
                EventScripterConfigPanel.this.deleteSelectionAction.actionPerformed(null);
                return true;
            }
        };
        this.add(new JScrollPane((Component)((Object)this.table)));
        MigPanel toolbar = new MigPanel("ins 0", "0[][][][grow,fill]", "[]");
        toolbar.setOpaque(false);
        this.btnAdd = new ExtButton((AbstractAction)new AbstractAddAction(){

            public void actionPerformed(ActionEvent e) {
                ScriptEntry newScript = new ScriptEntry();
                ((EventScripterExtension)EventScripterConfigPanel.this.getExtension()).addScriptEntry(newScript);
            }
        });
        this.deleteSelectionAction = new AbstractRemoveAction(){

            public void actionPerformed(ActionEvent e) {
                List entries = EventScripterConfigPanel.this.model.getSelectedObjects();
                if (entries == null || entries.size() == 0) {
                    return;
                }
                try {
                    Dialog.getInstance().showConfirmDialog(0, _GUI.T.lit_are_you_sure(), T.T.sure_delete_entries(entries.size()), (Icon)new AbstractIcon("question", 32), null, null);
                    ((EventScripterExtension)EventScripterConfigPanel.this.getExtension()).removeScriptEntries(entries);
                }
                catch (DialogClosedException e1) {
                    e1.printStackTrace();
                }
                catch (DialogCanceledException e1) {
                    e1.printStackTrace();
                }
            }
        };
        ExtButton btnRemove = new ExtButton((AbstractAction)this.deleteSelectionAction);
        ExtButton btnDefault = new ExtButton((AbstractAction)new AppAction(){
            {
                this.setIconKey("wizard");
                this.setName(T.T.btnExampleScripts());
            }

            public void actionPerformed(ActionEvent e) {
                ExtPopupMenu p = new ExtPopupMenu();
                ArrayList<ExampleMenuEntry> lst = new ArrayList<ExampleMenuEntry>();
                lst.add(new ExampleMenuEntry((EventScripterExtension)EventScripterConfigPanel.this.getExtension(), "infofile.js", EventTrigger.ON_PACKAGE_FINISHED, T.T.example_infoFile()));
                lst.add(new ExampleMenuEntry((EventScripterExtension)EventScripterConfigPanel.this.getExtension(), "playsound.js", EventTrigger.ON_DOWNLOAD_CONTROLLER_STOPPED, T.T.example_play_sound()));
                lst.add(new ExampleMenuEntry((EventScripterExtension)EventScripterConfigPanel.this.getExtension(), "playWavWhenInactive.js", EventTrigger.INTERVAL, T.T.example_play_sound_when_inactive()));
                lst.add(new ExampleMenuEntry((EventScripterExtension)EventScripterConfigPanel.this.getExtension(), "speedReset.js", EventTrigger.INTERVAL, T.T.reset_link_on_low_speed()));
                Collections.sort(lst, new Comparator<ExampleMenuEntry>(){

                    @Override
                    public int compare(ExampleMenuEntry o1, ExampleMenuEntry o2) {
                        int ret = o1.getName().compareTo(o2.getName());
                        return ret;
                    }
                });
                for (ExampleMenuEntry ee : lst) {
                    p.add((Action)((Object)ee));
                }
                if (e.getSource() instanceof Component) {
                    Component button = (Component)e.getSource();
                    Dimension prefSize = p.getPreferredSize();
                    Insets insets = LAFOptions.getInstance().getExtension().customizePopupBorderInsets();
                    p.show(button, -insets.left, -insets.top - prefSize.height);
                }
            }
        });
        toolbar.add((Component)this.btnAdd, (Object)"sg 1,height 26!");
        toolbar.add((Component)btnRemove, (Object)"sg 1,height 26!");
        toolbar.add((Component)btnDefault, (Object)"sg 1,height 26!");
        toolbar.add(Box.createHorizontalGlue(), (Object)"pushx,growx");
        this.add((Component)toolbar, "gapleft" + this.getLeftGap() + ",spanx,growx,pushx,height 60:n:n,pushy,growy");
    }

    public void save() {
    }

    public void updateContents() {
    }

    public void refresh() {
        this.model.update();
    }
}

