/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.eventscripter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.extensions.eventscripter.EventScripterExtension;
import org.jdownloader.extensions.eventscripter.EventTrigger;
import org.jdownloader.extensions.eventscripter.ScriptEntry;
import org.jdownloader.extensions.eventscripter.ScriptThread;

public class IntervalController {
    private final EventScripterExtension extension;
    private final AtomicReference<Thread> scheduler = new AtomicReference<Object>(null);
    private final AtomicReference<ArrayList<ScriptEntry>> scriptEntries = new AtomicReference<Object>(null);
    private final LogSource logger;
    private static final String LASTFIRE = "lastFire";
    private static final String INTERVAL = "interval";
    private final WeakHashMap<ScriptThread, Long> scriptThreads = new WeakHashMap();

    public IntervalController(EventScripterExtension eventScripterExtension) {
        this.extension = eventScripterExtension;
        this.logger = this.extension.getLogger();
        this.update();
    }

    public synchronized void update() {
        ArrayList<ScriptEntry> scriptEntries = new ArrayList<ScriptEntry>();
        for (ScriptEntry e : this.extension.getEntries()) {
            if (e.getEventTrigger() != EventTrigger.INTERVAL || !e.isEnabled()) continue;
            scriptEntries.add(e);
        }
        this.scriptEntries.set(scriptEntries);
        Thread thread = this.scheduler.get();
        if (scriptEntries.size() > 0) {
            if (thread == null || !thread.isAlive()) {
                thread = new Thread("EventScripterScheduler"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            List scriptEntries;
                            while (Thread.currentThread() == IntervalController.this.scheduler.get() && (scriptEntries = (List)IntervalController.this.scriptEntries.get()) != null && scriptEntries.size() > 0) {
                                long minwait = Long.MAX_VALUE;
                                for (ScriptEntry scriptEntry : scriptEntries) {
                                    if (scriptEntry.getEventTrigger() != EventTrigger.INTERVAL || !scriptEntry.isEnabled()) continue;
                                    try {
                                        long lastTs;
                                        Map<String, Object> settings = scriptEntry.getEventTriggerSettings();
                                        long interval = 1000L;
                                        interval = settings.get(IntervalController.INTERVAL) instanceof Number ? Math.max(1000L, ((Number)settings.get(IntervalController.INTERVAL)).longValue()) : 1000L;
                                        Object last = settings.get(IntervalController.LASTFIRE);
                                        if (last != null && last instanceof Number) {
                                            lastTs = ((Number)last).longValue();
                                        } else {
                                            lastTs = System.currentTimeMillis();
                                            settings.put(IntervalController.LASTFIRE, lastTs);
                                        }
                                        long waitFor = interval - (System.currentTimeMillis() - lastTs);
                                        if (waitFor <= 0L) {
                                            if (IntervalController.this.fire(scriptEntry, interval)) {
                                                settings.put(IntervalController.LASTFIRE, System.currentTimeMillis());
                                            }
                                            waitFor = interval;
                                        }
                                        minwait = Math.max(500L, Math.min(minwait, waitFor));
                                    }
                                    catch (Throwable e2) {
                                        IntervalController.this.logger.log(e2);
                                        minwait = 5000L;
                                    }
                                }
                                try {
                                    Thread.sleep(minwait);
                                }
                                catch (InterruptedException e1) {
                                    break;
                                }
                            }
                        }
                        finally {
                            IntervalController.this.scheduler.compareAndSet(Thread.currentThread(), null);
                        }
                    }
                };
                thread.setDaemon(true);
                this.scheduler.set(thread);
                thread.start();
            }
        } else {
            this.scheduler.set(null);
            if (thread != null) {
                thread.interrupt();
            }
        }
    }

    protected synchronized boolean fire(final ScriptEntry scriptEntry, long interval) {
        if (scriptEntry.isEnabled() && StringUtils.isNotEmpty((String)scriptEntry.getScript())) {
            try {
                final boolean isSynchronous = scriptEntry.getEventTrigger().isSynchronous(scriptEntry.getEventTriggerSettings());
                if (isSynchronous) {
                    for (Map.Entry<ScriptThread, Long> scriptThread : this.scriptThreads.entrySet()) {
                        if (scriptEntry.getID() != scriptThread.getValue().longValue() || !scriptThread.getKey().isAlive()) continue;
                        return false;
                    }
                }
                final HashMap<String, Long> props = new HashMap<String, Long>();
                props.put(INTERVAL, interval);
                ScriptThread thread = new ScriptThread(this.extension, scriptEntry, props, this.logger){

                    @Override
                    public boolean isSynchronous() {
                        return isSynchronous;
                    }

                    @Override
                    public void start() {
                        this.startThread();
                    }

                    @Override
                    protected void finalizeEnvironment() throws IllegalAccessException {
                        super.finalizeEnvironment();
                        try {
                            Map<String, Object> settings = scriptEntry.getEventTriggerSettings();
                            settings.put(IntervalController.INTERVAL, Math.max(1000L, ((Number)props.get(IntervalController.INTERVAL)).longValue()));
                        }
                        catch (Throwable e) {
                            IntervalController.this.logger.log(e);
                        }
                    }
                };
                if (isSynchronous) {
                    this.scriptThreads.put(thread, scriptEntry.getID());
                }
                thread.start();
                return true;
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
        }
        return false;
    }
}

