/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.eventscripter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.text.EditorKit;
import jd.gui.swing.jdgui.views.settings.components.Checkbox;
import jd.gui.swing.jdgui.views.settings.components.SettingsComponent;
import jsyntaxpane.DefaultSyntaxKit;
import jsyntaxpane.syntaxkits.JavaSyntaxKit;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtButton;
import org.appwork.utils.DebugMode;
import org.appwork.utils.IO;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.dimensor.DialogDimensor;
import org.appwork.utils.swing.dialog.dimensor.RememberLastDialogDimension;
import org.appwork.utils.swing.dialog.locator.DialogLocator;
import org.appwork.utils.swing.dialog.locator.RememberAbsoluteDialogLocator;
import org.jdownloader.actions.AppAction;
import org.jdownloader.extensions.eventscripter.CFG_EVENT_CALLER;
import org.jdownloader.extensions.eventscripter.EventScripterExtension;
import org.jdownloader.extensions.eventscripter.ScriptEntry;
import org.jdownloader.extensions.eventscripter.T;
import org.jdownloader.extensions.eventscripter.TriggerSetupPanel;
import org.jdownloader.extensions.eventscripter.sandboxobjects.ScriptEnvironment;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.logging.LogController;
import org.jdownloader.scripting.JSRhinoPermissionRestricter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.shell.Global;

public class JavaScriptEditorDialog
extends AbstractDialog<Object> {
    private static final String CLEANUP = "[^\\w\\d\\(\\)\\+\\-\\[\\]\\;\\,/\\\\]";
    private final ScriptEntry entry;
    private final Map<String, Object> testEventTriggerSettings = new HashMap<String, Object>();
    private JEditorPane editor;
    private DelayedRunnable delayer;
    private JToolBar toolbar;
    private Global scope;
    private MigPanel p;
    private JScrollPane apiScrollbar;
    private JScrollPane scrollpane;
    private EventScripterExtension extension;
    private TriggerSetupPanel settingsPanel;

    public JavaScriptEditorDialog(EventScripterExtension extension, ScriptEntry entry) {
        super(256, T.T.script_editor_title(entry.getName()), null, _GUI.T.lit_save(), null);
        this.entry = entry;
        this.extension = extension;
        this.setLocator((DialogLocator)new RememberAbsoluteDialogLocator(((Object)((Object)this)).getClass().getSimpleName()));
        this.setDimensor((DialogDimensor)new RememberLastDialogDimension(((Object)((Object)this)).getClass().getSimpleName()));
    }

    protected ScriptEntry createReturnValue() {
        return null;
    }

    protected int getPreferredHeight() {
        return 300;
    }

    protected int getPreferredWidth() {
        return 1024;
    }

    public TriggerSetupPanel createDefaultTriggerSetupPanel(final ScriptEntry entry, final Map<String, Object> testEventTriggerSettings) {
        TriggerSetupPanel settingsPanel = new TriggerSetupPanel(0);
        if (entry.getEventTrigger().isSynchronousSupported()) {
            Map<String, Object> settingsMap = entry.getEventTriggerSettings();
            final Checkbox synchronousCheckBox = new Checkbox(entry.getEventTrigger().isSynchronous(settingsMap));
            settingsPanel.addDescriptionPlain(T.T.synchronous_desc());
            settingsPanel.addPair(T.T.synchronous(), null, (SettingsComponent)synchronousCheckBox);
            settingsPanel.executeOnSave(new Runnable(){

                @Override
                public void run() {
                    entry.getEventTrigger().setSynchronous(entry.getEventTriggerSettings(), synchronousCheckBox.isSelected());
                }
            });
            settingsPanel.executeOnTestRun(new Runnable(){

                @Override
                public void run() {
                    entry.getEventTrigger().setSynchronous(testEventTriggerSettings, synchronousCheckBox.isSelected());
                }
            });
        }
        return settingsPanel;
    }

    public JComponent layoutDialogContent() {
        this.p = new MigPanel("ins 0,wrap 1", "[grow,fill]", "[][][grow,fill][grow,fill]");
        this.toolbar = new JToolBar();
        this.toolbar.setRollover(true);
        this.toolbar.setFloatable(false);
        this.toolbar.setPreferredSize(new Dimension(-1, 22));
        this.p.add((Component)this.toolbar);
        this.settingsPanel = this.entry.getEventTrigger().createSettingsPanel(this.entry, this.testEventTriggerSettings, this);
        final JEditorPane defaults = new JEditorPane();
        JavaSyntaxKit javaSyntaxKit = new JavaSyntaxKit();
        try {
            Font defaultFont = (Font)ReflectionUtils.getFieldValue(DefaultSyntaxKit.class, (String)"DEFAULT_FONT", (Object)javaSyntaxKit, Font.class);
            ReflectionUtils.setField((Object)javaSyntaxKit, (String)"DEFAULT_FONT", (Object)new JLabel().getFont().deriveFont(defaultFont.getStyle(), defaultFont.getSize()));
        }
        catch (Exception e) {
            LogController.CL().log((Throwable)e);
            DebugMode.debugger((Exception)e);
        }
        defaults.setEditorKit((EditorKit)javaSyntaxKit);
        this.apiScrollbar = new JScrollPane(defaults){

            @Override
            public Dimension getPreferredSize() {
                Dimension ret = defaults.getPreferredSize();
                ret.width += 10;
                ret.height += 10;
                return super.getPreferredSize();
            }
        };
        this.p.add((Component)this.apiScrollbar);
        defaults.setEditable(false);
        defaults.setContentType("text/javascript; charset=UTF-8");
        defaults.setText(ScriptEnvironment.getAPIDescription(this.entry.getEventTrigger().getAPIClasses()) + "\r\n" + this.entry.getEventTrigger().getAPIDescription());
        this.editor = new JEditorPane();
        this.editor.setEditorKit((EditorKit)javaSyntaxKit);
        this.scrollpane = new JScrollPane(this.editor){

            @Override
            public Dimension getPreferredSize() {
                Dimension ret = JavaScriptEditorDialog.this.editor.getPreferredSize();
                ret.width += 10;
                ret.height += 10;
                ret.height = Math.max(ret.height, 200);
                return super.getPreferredSize();
            }
        };
        this.p.add((Component)this.scrollpane);
        this.delayer = new DelayedRunnable(1000L, 5000L){

            public void delayedrun() {
                JavaScriptEditorDialog.this.updateHighlighter();
            }
        };
        this.editor.setContentType("text/javascript; charset=UTF-8");
        String txt = this.entry.getScript();
        if (StringUtils.isEmpty((String)txt)) {
            txt = T.T.emptyScript();
        }
        this.editor.setText(txt);
        this.editor.setCaretPosition(0);
        this.toolbar.add((Component)new ExtButton((AbstractAction)new AppAction(){
            {
                this.setSelected(CFG_EVENT_CALLER.CFG.isAPIPanelVisible());
                this.setName(T.T.editor_showhelp());
            }

            public void actionPerformed(ActionEvent e) {
                CFG_EVENT_CALLER.CFG.setAPIPanelVisible(!CFG_EVENT_CALLER.CFG.isAPIPanelVisible());
                JavaScriptEditorDialog.this.relayout();
            }
        }));
        this.toolbar.add((Component)new ExtButton((AbstractAction)new AppAction(){
            {
                this.setName(T.T.editor_autoformat());
            }

            public void actionPerformed(ActionEvent e) {
                JavaScriptEditorDialog.this.delayer.resetAndStart();
            }
        }));
        this.toolbar.add((Component)new ExtButton((AbstractAction)new AppAction(){
            {
                this.setName(T.T.editor_testcompile());
            }

            public void actionPerformed(ActionEvent e) {
                JavaScriptEditorDialog.this.extension.runTestCompile(JavaScriptEditorDialog.this.entry.getEventTrigger(), JavaScriptEditorDialog.this.editor.getText());
            }
        }));
        this.toolbar.add((Component)new ExtButton((AbstractAction)new AppAction(){
            {
                this.setName(T.T.editor_testrun());
            }

            public void actionPerformed(ActionEvent e) {
                JavaScriptEditorDialog.this.testEventTriggerSettings.clear();
                if (JavaScriptEditorDialog.this.settingsPanel != null) {
                    JavaScriptEditorDialog.this.settingsPanel.testRun();
                }
                ScriptEntry testEntry = new ScriptEntry();
                testEntry.setEnabled(true);
                testEntry.setEventTrigger(JavaScriptEditorDialog.this.entry.getEventTrigger());
                testEntry.setEventTriggerSettings(JavaScriptEditorDialog.this.testEventTriggerSettings);
                testEntry.setName(JavaScriptEditorDialog.this.entry.getName());
                testEntry.setScript(JavaScriptEditorDialog.this.getScript());
                HashMap<String, Object> testProperties = JavaScriptEditorDialog.this.entry.getEventTrigger().getTestProperties();
                testProperties.putAll(JavaScriptEditorDialog.this.testEventTriggerSettings);
                JavaScriptEditorDialog.this.extension.runScript(testEntry, testProperties, true);
            }
        }));
        this.relayout();
        return this.p;
    }

    protected void relayout() {
        this.p.removeAll();
        if (CFG_EVENT_CALLER.CFG.isAPIPanelVisible()) {
            this.p.setLayout("ins 0,wrap 1", "[grow,fill]", "[][][][grow,fill]");
        } else {
            this.p.setLayout("ins 0,wrap 1", "[grow,fill]", "[][][grow,fill]");
        }
        this.p.add((Component)this.toolbar);
        if (this.settingsPanel != null) {
            this.p.add((Component)((Object)this.settingsPanel));
        } else {
            this.p.add(Box.createGlue());
        }
        if (CFG_EVENT_CALLER.CFG.isAPIPanelVisible()) {
            this.p.add((Component)this.apiScrollbar, (Object)"height 200:n:n");
        }
        this.p.add((Component)this.scrollpane, (Object)"height 200:n:n");
        this.p.revalidate();
        this.p.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateHighlighter() {
        block5: {
            block4: {
                final AtomicInteger caretPosition = new AtomicInteger();
                try {
                    String text = (String)new EDTHelper<String>(){

                        public String edtRun() {
                            JavaScriptEditorDialog.this.editor.setEditable(false);
                            caretPosition.set(JavaScriptEditorDialog.this.editor.getCaretPosition());
                            return JavaScriptEditorDialog.this.editor.getText();
                        }
                    }.getReturnValue();
                    String before = text.substring(0, caretPosition.get()).replaceAll(CLEANUP, "");
                    final String formatedText = this.format(text);
                    if (formatedText.equals(text)) break block4;
                    int max = Math.min(caretPosition.get(), formatedText.length());
                    for (int i = 0; i < max; ++i) {
                        String sb = formatedText.substring(0, i).replaceAll(CLEANUP, "");
                        if (sb.length() != before.length()) continue;
                        final int caret = i;
                        new EDTRunner(){

                            protected void runInEDT() {
                                JavaScriptEditorDialog.this.editor.setText(formatedText);
                                JavaScriptEditorDialog.this.editor.setCaretPosition(caret);
                            }
                        }.waitForEDT();
                        break block5;
                    }
                    new EDTRunner(){

                        protected void runInEDT() {
                            JavaScriptEditorDialog.this.editor.setText(formatedText);
                        }
                    }.waitForEDT();
                }
                catch (Throwable throwable) {
                    new EDTRunner(){

                        protected void runInEDT() {
                            JavaScriptEditorDialog.this.editor.setEditable(true);
                        }
                    }.waitForEDT();
                    throw throwable;
                }
            }
            new /* invalid duplicate definition of identical inner class */.waitForEDT();
            return;
        }
        new /* invalid duplicate definition of identical inner class */.waitForEDT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String format(String script) {
        try {
            String formated;
            Context cx = Context.enter();
            cx.setOptimizationLevel(9);
            cx.setLanguageVersion(150);
            if (this.scope == null) {
                this.scope = new Global();
                this.scope.init(cx);
                String lib = IO.readURLToString((URL)ScriptEntry.class.getResource("js_beautifier.js"));
                Script compiledLibrary = JSRhinoPermissionRestricter.compileTrustedString((Context)cx, (Global)this.scope, (String)lib, (String)"", (int)1, null);
                JSRhinoPermissionRestricter.evaluateTrustedString((Context)cx, (Global)this.scope, (String)"global=this;", (String)"", (int)1, null);
                compiledLibrary.exec(cx, (Scriptable)this.scope);
            }
            ScriptableObject.putProperty((Scriptable)this.scope, (String)"text", (Object)script);
            String string = formated = (String)JSRhinoPermissionRestricter.evaluateTrustedString((Context)cx, (Global)this.scope, (String)"js_beautify(text, {   });", (String)"", (int)1, null);
            return string;
        }
        catch (Throwable e) {
            LogController.CL().log(e);
        }
        finally {
            Context.exit();
        }
        return script;
    }

    protected boolean isResizable() {
        return true;
    }

    public void pack() {
        this.getDialog().pack();
    }

    public String getScript() {
        return (String)new EDTHelper<String>(){

            public String edtRun() {
                return JavaScriptEditorDialog.this.editor.getText();
            }
        }.getReturnValue();
    }

    public Map<String, Object> getEventTriggerSetup() {
        if (this.settingsPanel != null) {
            this.settingsPanel.save();
            return this.entry.getEventTriggerSettings();
        }
        return null;
    }
}

