/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.eventscripter.sandboxobjects;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jd.http.Browser;
import jd.http.Request;
import jd.http.requests.HeadRequest;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.jdownloader.extensions.eventscripter.EnvironmentException;

public class BrowserSandBox {
    private final Browser br;

    public BrowserSandBox() {
        this.br = new Browser();
    }

    private BrowserSandBox(Browser br) {
        this.br = br != null ? br : new Browser();
    }

    public int hashCode() {
        if (this.br != null) {
            return this.br.hashCode();
        }
        return super.hashCode();
    }

    public void setCookie(String host, String key, String value) {
        this.br.setCookie(host, key, value);
    }

    public String getCookie(String host, String key) {
        return this.br.getCookie(host, key);
    }

    public void setLoadLimit(int limit) {
        this.br.setLoadLimit(limit);
    }

    public int getLoadLimit() {
        return this.br.getLoadLimit();
    }

    public void getDownload(String LocalFile, String urlString) throws EnvironmentException {
        try {
            this.br.getDownload(new File(LocalFile), urlString);
        }
        catch (IOException e) {
            throw new EnvironmentException(e);
        }
    }

    public void setHeader(String field, String value) {
        this.br.setHeader(field, value);
    }

    public Map<String, List<String>> getResponseHeaders() {
        Request request = this.br.getRequest();
        return request != null ? new HashMap(request.getResponseHeaders()) : null;
    }

    public String getResponseHeader(String field) {
        Request request = this.br.getRequest();
        return request != null ? request.getResponseHeader(field) : null;
    }

    public int getResponseCode() {
        return this.br.getHttpConnection().getResponseCode();
    }

    public String getRequestMethod() {
        return this.br.getHttpConnection().getRequestMethod().toString();
    }

    public long getContentLength() {
        return this.br.getHttpConnection().getContentLength();
    }

    public long getRequestTime() {
        return this.br.getHttpConnection().getRequestTime();
    }

    public String getContentType() {
        return this.br.getHttpConnection().getContentType();
    }

    public boolean isSSLTrustALL() {
        return this.br.getHttpConnection().isSSLTrustALL();
    }

    public int getConnectTimeout() {
        return this.br.getConnectTimeout();
    }

    public void setConnectTimeout(int connectTimeout) {
        this.br.setConnectTimeout(connectTimeout);
    }

    public int getReadTimeout() {
        return this.br.getReadTimeout();
    }

    public void setReadTimeout(int readTimeout) {
        this.br.setReadTimeout(readTimeout);
    }

    public void setFollowRedirects(boolean b) {
        this.br.setFollowRedirects(b);
    }

    public boolean isFollowingRedirects() {
        return this.br.isFollowingRedirects();
    }

    public String getRedirectLocation() {
        return this.br.getRedirectLocation();
    }

    public void setDefaultSSLTrustALL(Boolean defaultSSLTrustALL) {
        this.br.setDefaultSSLTrustALL(defaultSSLTrustALL);
    }

    public boolean getDefaultSSLTrustALL() {
        return this.br.getDefaultSSLTrustALL();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BrowserSandBox) {
            return ((BrowserSandBox)obj).br == this.br;
        }
        return super.equals(obj);
    }

    public String getPage(String url) throws EnvironmentException {
        try {
            String ret = this.br.getPage(url);
            return ret;
        }
        catch (IOException e) {
            throw new EnvironmentException(e);
        }
    }

    public String headPage(String url) throws EnvironmentException {
        try {
            HeadRequest headRequest = this.br.createHeadRequest(url);
            return this.br.getPage((Request)headRequest);
        }
        catch (IOException e) {
            throw new EnvironmentException(e);
        }
    }

    public BrowserSandBox cloneBrowser() {
        return new BrowserSandBox(this.br.cloneBrowser());
    }

    public boolean setProxy(String proxyString) {
        HTTPProxy proxy = HTTPProxy.parseHTTPProxy((String)proxyString);
        if (proxy != null) {
            this.br.setProxy(proxy);
            return true;
        }
        return false;
    }

    public String postPage(String url, String postData) throws EnvironmentException {
        try {
            String ret = this.br.postPage(url, postData);
            return ret;
        }
        catch (IOException e) {
            throw new EnvironmentException(e);
        }
    }

    public String getURL() {
        return this.br.getURL();
    }

    public String getHTML() {
        return this.br.toString();
    }

    protected void finalize() throws Throwable {
        Browser br = this.br;
        if (br != null) {
            br.disconnect();
        }
    }
}

