/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.eventscripter.sandboxobjects;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.PackageController;
import jd.plugins.DownloadLink;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JsonKeyValueStorage;
import org.appwork.storage.Storable;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.reflection.Clazz;
import org.jdownloader.api.linkcollector.v2.CrawledLinkAPIStorableV2;
import org.jdownloader.api.linkcollector.v2.LinkCollectorAPIImplV2;
import org.jdownloader.controlling.Priority;
import org.jdownloader.extensions.eventscripter.ScriptAPI;
import org.jdownloader.extensions.eventscripter.sandboxobjects.ArchiveSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.CrawledPackageSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.CrawlerJobSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.DownloadLinkSandBox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.LinkInfoSandbox;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.bindings.crawledlink.CrawledLinkFactory;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.ArchiveValidator;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.myjdownloader.client.json.AvailableLinkState;
import org.jdownloader.myjdownloader.client.json.JsonMap;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.CustomConditionalSkipReasonMessageIcon;
import org.jdownloader.settings.UrlDisplayType;

@ScriptAPI(description="The context linkgrabber list link")
public class CrawledLinkSandbox {
    protected final CrawledLink link;
    private static final WeakHashMap<CrawledLink, HashMap<String, Object>> SESSIONPROPERTIES = new WeakHashMap();
    private DownloadLinkSandBox downloadLinkSandbox = null;

    public CrawledLinkSandbox(CrawledLink link) {
        this.link = link;
    }

    public String getAvailableState() {
        if (this.link != null) {
            return this.link.getLinkState().name();
        }
        return AvailableLinkState.UNKNOWN.name();
    }

    public String getPriority() {
        if (this.link != null) {
            return this.link.getPriority().name();
        }
        return Priority.DEFAULT.name();
    }

    public void setPriority(String priority) {
        if (this.link != null) {
            try {
                this.link.setPriority(Priority.valueOf((String)priority));
            }
            catch (Throwable e) {
                this.link.setPriority(Priority.DEFAULT);
            }
        }
    }

    private CrawledLinkAPIStorableV2 _getStatus() {
        if (this.link != null) {
            CrawledLinkAPIStorableV2 ret = new CrawledLinkAPIStorableV2(this.link);
            LinkCollectorAPIImplV2.setStatus((CrawledLinkAPIStorableV2)ret, (CrawledLink)this.link, (Object)new CustomConditionalSkipReasonMessageIcon(){

                public String getMessage(ConditionalSkipReason conditionalSkipReason, AbstractNode node) {
                    return conditionalSkipReason.getMessage((Object)conditionalSkipReason, node);
                }

                public Icon getIcon(ConditionalSkipReason conditionalSkipReason, AbstractNode node) {
                    return conditionalSkipReason.getIcon((Object)conditionalSkipReason, node);
                }
            });
            return ret;
        }
        return null;
    }

    public JsonMap getAdvancedStatus() {
        CrawledLinkAPIStorableV2 ret = this._getStatus();
        if (ret != null) {
            return ret.getAdvancedStatus();
        }
        return null;
    }

    public CrawlerJobSandbox getSourceJob() {
        if (this.link != null) {
            LinkCollectingJob job = this.link.getSourceJob();
            if (job != null) {
                return new CrawlerJobSandbox(job);
            }
            return null;
        }
        return null;
    }

    public String getArchiveID() {
        return this.link != null ? this.link.getArchiveID() : null;
    }

    public Boolean isPartOfAnArchive() {
        DownloadLink downloadLink;
        if (this.link != null && (downloadLink = this.link.getDownloadLink()) != null) {
            return downloadLink.isPartOfAnArchive();
        }
        return null;
    }

    public long getAddedDate() {
        if (this.link != null) {
            return this.link.getCreated();
        }
        return -1L;
    }

    public CrawledLinkSandbox() {
        this(null);
    }

    public int hashCode() {
        if (this.link != null) {
            return this.link.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CrawledLinkSandbox) {
            return ((CrawledLinkSandbox)obj).link == this.link;
        }
        return super.equals(obj);
    }

    public Object getProperty(String key) {
        DownloadLink downloadLink;
        if (this.link != null && (downloadLink = this.link.getDownloadLink()) != null) {
            return downloadLink.getProperty(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSessionProperty(String key) {
        if (this.link != null) {
            WeakHashMap<CrawledLink, HashMap<String, Object>> weakHashMap = SESSIONPROPERTIES;
            synchronized (weakHashMap) {
                HashMap<String, Object> properties = SESSIONPROPERTIES.get(this.link);
                if (properties != null) {
                    return properties.get(key);
                }
            }
        }
        return null;
    }

    public String getContentURL() {
        if (this.link != null) {
            return LinkTreeUtils.getUrlByType((UrlDisplayType)UrlDisplayType.CONTENT, (AbstractNode)this.link);
        }
        return null;
    }

    public String getContainerURL() {
        if (this.link != null) {
            return LinkTreeUtils.getUrlByType((UrlDisplayType)UrlDisplayType.CONTAINER, (AbstractNode)this.link);
        }
        return null;
    }

    public String getPluginURL() {
        DownloadLink downloadLink;
        if (this.link != null && (downloadLink = this.link.getDownloadLink()) != null) {
            return downloadLink.getPluginPatternMatcher();
        }
        return null;
    }

    public DownloadLinkSandBox getDownloadLink() {
        if (this.downloadLinkSandbox != null) {
            return this.downloadLinkSandbox;
        }
        if (this.link != null) {
            DownloadLink downloadLink = this.link.getDownloadLink();
            if (downloadLink != null) {
                this.downloadLinkSandbox = new DownloadLinkSandBox(downloadLink);
                return this.downloadLinkSandbox;
            }
            return null;
        }
        return null;
    }

    public String getDownloadHost() {
        if (this.link != null) {
            DownloadLink downloadLink = this.link.getDownloadLink();
            return downloadLink != null ? downloadLink.getServiceHost(true) : this.link.getHost();
        }
        return null;
    }

    public String getOriginURL() {
        if (this.link != null) {
            return LinkTreeUtils.getUrlByType((UrlDisplayType)UrlDisplayType.ORIGIN, (AbstractNode)this.link);
        }
        return null;
    }

    public String getReferrerURL() {
        if (this.link != null) {
            return LinkTreeUtils.getUrlByType((UrlDisplayType)UrlDisplayType.REFERRER, (AbstractNode)this.link);
        }
        return null;
    }

    public boolean remove() {
        PackageController controller;
        CrawledPackage pkg;
        if (this.link != null && (pkg = this.link.getParentNode()) != null && (controller = pkg.getControlledBy()) != null) {
            ArrayList<CrawledLink> children = new ArrayList<CrawledLink>();
            children.add(this.link);
            controller.removeChildren(children);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionProperty(String key, Object value) {
        if (this.link != null) {
            if (value != null && !this.canStore(value)) {
                throw new WTFException("Type " + value.getClass().getSimpleName() + " is not supported");
            }
            WeakHashMap<CrawledLink, HashMap<String, Object>> weakHashMap = SESSIONPROPERTIES;
            synchronized (weakHashMap) {
                HashMap<String, Object> properties = SESSIONPROPERTIES.get(this.link);
                if (properties == null) {
                    properties = new HashMap();
                    SESSIONPROPERTIES.put(this.link, properties);
                }
                properties.put(key, value);
            }
        }
    }

    public String getUUID() {
        if (this.link != null) {
            return this.link.getUniqueID().toString();
        }
        return null;
    }

    public String getLinkID() {
        DownloadLinkSandBox downloadLinkSandBox = this.getDownloadLink();
        return downloadLinkSandBox != null ? downloadLinkSandBox.getLinkID() : null;
    }

    public String getHashInfo() {
        DownloadLinkSandBox downloadLinkSandBox = this.getDownloadLink();
        return downloadLinkSandBox != null ? downloadLinkSandBox.getHashInfo() : null;
    }

    public void setProperty(String key, Object value) {
        DownloadLinkSandBox downloadLinkSandBox = this.getDownloadLink();
        if (downloadLinkSandBox != null) {
            downloadLinkSandBox.setProperty(key, value);
        }
    }

    public Map<String, Object> getProperties() {
        DownloadLinkSandBox downloadLinkSandBox = this.getDownloadLink();
        return downloadLinkSandBox != null ? downloadLinkSandBox.getProperties() : null;
    }

    private boolean canStore(Object value) {
        return value == null || Clazz.isPrimitive(value.getClass()) || JsonKeyValueStorage.isWrapperType(value.getClass()) || value instanceof Storable;
    }

    public ArchiveSandbox getArchive() {
        if (this.link == null || ArchiveValidator.EXTENSION == null) {
            return null;
        }
        Archive archive = ArchiveValidator.EXTENSION.getArchiveByFactory((ArchiveFactory)new CrawledLinkFactory(this.link));
        if (archive != null) {
            return new ArchiveSandbox(archive);
        }
        ArrayList<CrawledLink> list = new ArrayList<CrawledLink>();
        list.add(this.link);
        List archives = ArchiveValidator.getArchivesFromPackageChildren(list);
        return archives == null || archives.size() == 0 ? null : new ArchiveSandbox((Archive)archives.get(0));
    }

    public String getComment() {
        if (this.link != null) {
            return this.link.getComment();
        }
        return null;
    }

    public void setComment(String comment) {
        if (this.link != null) {
            this.link.setComment(comment);
        }
    }

    public void setEnabled(boolean b) {
        if (this.link != null) {
            this.link.setEnabled(b);
        }
    }

    public String getDownloadPath() {
        if (this.link == null) {
            switch (CrossSystem.getOSFamily()) {
                case WINDOWS: {
                    return "c:\\I am a dummy folder\\Test.txt";
                }
            }
            return "/mnt/Text.txt";
        }
        String downloadFolder = this.getPackage().getDownloadFolder();
        if (this.link.isNameSet()) {
            return new File(downloadFolder, this.link.getName()).getAbsolutePath();
        }
        return this.link.getDownloadLink().getFileOutput(downloadFolder, false, false);
    }

    @ScriptAPI(description="Sets a new filename", parameters={"new Name"})
    public void setName(String name) {
        if (this.link != null) {
            this.link.setName(name);
        }
    }

    public String getUrl() {
        if (this.link != null) {
            return this.link.getURL();
        }
        return null;
    }

    public long getBytesTotal() {
        if (this.link != null) {
            return this.link.getSize();
        }
        return -1L;
    }

    public long getBytesTotalVerified() {
        DownloadLinkSandBox downloadLinkSandBox = this.getDownloadLink();
        return downloadLinkSandBox != null ? downloadLinkSandBox.getBytesTotalVerified() : -1L;
    }

    public String getName() {
        if (this.link == null) {
            return "Test.txt";
        }
        return this.link.getName();
    }

    public String getForcedName() {
        if (this.isNameSet()) {
            return this.getName();
        }
        DownloadLinkSandBox downloadLinkSandBox = this.getDownloadLink();
        return downloadLinkSandBox != null ? downloadLinkSandBox.getForcedName() : null;
    }

    public String getFinalName() {
        DownloadLinkSandBox downloadLinkSandBox = this.getDownloadLink();
        return downloadLinkSandBox != null ? downloadLinkSandBox.getFinalName() : null;
    }

    public boolean isNameSet() {
        return this.link != null && this.link.isNameSet();
    }

    public CrawledPackageSandbox getPackage() {
        if (this.link == null) {
            return new CrawledPackageSandbox();
        }
        CrawledPackage pkg = this.link.getParentNode();
        if (pkg != null) {
            return new CrawledPackageSandbox(pkg);
        }
        return null;
    }

    public LinkInfoSandbox getLinkInfo() {
        if (this.link == null) {
            return null;
        }
        return new LinkInfoSandbox(this.link.getLinkInfo());
    }

    public String getHost() {
        if (this.link != null) {
            return this.link.getHost();
        }
        return null;
    }

    public boolean isEnabled() {
        return this.link != null && this.link.isEnabled();
    }

    public String toString() {
        return "CrawledLink Instance: " + this.getName();
    }
}

