/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.eventscripter.sandboxobjects;

import java.util.ArrayList;
import java.util.List;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.linkcrawler.CrawledPackageView;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.PackageController;
import org.appwork.utils.Application;
import org.jdownloader.controlling.Priority;
import org.jdownloader.extensions.eventscripter.ScriptAPI;
import org.jdownloader.extensions.eventscripter.sandboxobjects.ArchiveSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.CrawledLinkSandbox;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.ArchiveValidator;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTableModel;

@ScriptAPI(description="The context linkgabber list package")
public class CrawledPackageSandbox {
    private final CrawledPackage filePackage;

    public CrawledPackageSandbox(CrawledPackage parentNode) {
        this.filePackage = parentNode;
    }

    public CrawledPackageSandbox() {
        this(null);
    }

    public long getAddedDate() {
        if (this.filePackage != null) {
            return this.filePackage.getCreated();
        }
        return -1L;
    }

    public int hashCode() {
        if (this.filePackage != null) {
            return this.filePackage.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CrawledPackageSandbox) {
            return ((CrawledPackageSandbox)obj).filePackage == this.filePackage;
        }
        return super.equals(obj);
    }

    public String getPriority() {
        if (this.filePackage != null) {
            return this.filePackage.getPriorityEnum().name();
        }
        return Priority.DEFAULT.name();
    }

    public void setPriority(String priority) {
        if (this.filePackage != null) {
            try {
                this.filePackage.setPriorityEnum(Priority.valueOf((String)priority));
            }
            catch (Throwable e) {
                this.filePackage.setPriorityEnum(Priority.DEFAULT);
            }
        }
    }

    public ArchiveSandbox[] getArchives() {
        if (this.filePackage == null) {
            return null;
        }
        final ArrayList list = new ArrayList();
        this.filePackage.getModifyLock().runReadLock(new Runnable(){

            @Override
            public void run() {
                List archives = ArchiveValidator.getArchivesFromPackageChildren((List)CrawledPackageSandbox.this.filePackage.getChildren());
                if (archives != null) {
                    for (Archive archive : archives) {
                        list.add(new ArchiveSandbox(archive));
                    }
                }
            }
        });
        return list.toArray(new ArchiveSandbox[0]);
    }

    public boolean remove() {
        PackageController controller;
        if (this.filePackage != null && (controller = this.filePackage.getControlledBy()) != null) {
            controller.removePackage((AbstractPackageNode)this.filePackage);
            return true;
        }
        return false;
    }

    public CrawledLinkSandbox[] getDownloadLinks() {
        if (this.filePackage == null) {
            return null;
        }
        final ArrayList ret = new ArrayList();
        this.filePackage.getModifyLock().runReadLock(new Runnable(){

            @Override
            public void run() {
                for (CrawledLink link : CrawledPackageSandbox.this.filePackage.getChildren()) {
                    ret.add(new CrawledLinkSandbox(link));
                }
            }
        });
        return ret.toArray(new CrawledLinkSandbox[0]);
    }

    public boolean isExpanded() {
        return this.filePackage != null && this.filePackage.isExpanded();
    }

    public void setExpanded(boolean b) {
        if (this.filePackage != null) {
            if (Application.isHeadless()) {
                this.filePackage.setExpanded(b);
            } else {
                LinkGrabberTableModel.getInstance().setFilePackageExpand(b, new AbstractPackageNode[]{this.filePackage});
            }
        }
    }

    public int indexOf(CrawledLinkSandbox link) {
        if (this.filePackage != null && link != null && link.link != null) {
            return this.filePackage.indexOf(link.link);
        }
        return -1;
    }

    public long getBytesTotal() {
        if (this.filePackage == null) {
            return 0L;
        }
        return new CrawledPackageView(this.filePackage).aggregate().getFileSize();
    }

    public String getComment() {
        if (this.filePackage == null) {
            return null;
        }
        return this.filePackage.getComment();
    }

    public void setComment(String comment) {
        if (this.filePackage != null) {
            this.filePackage.setComment(comment);
        }
    }

    public void setName(String name) {
        if (this.filePackage != null) {
            this.filePackage.setName(name);
        }
    }

    public String getDownloadFolder() {
        if (this.filePackage == null) {
            return Application.getResource((String)"").getAbsolutePath();
        }
        return LinkTreeUtils.getDownloadDirectory((AbstractNode)this.filePackage).getAbsolutePath();
    }

    public long getModifiedDate() {
        if (this.filePackage == null) {
            return this.filePackage.getModified();
        }
        return -1L;
    }

    public void setDownloadFolder(String downloadFolder) {
        if (this.filePackage != null) {
            this.filePackage.setDownloadFolder(downloadFolder);
        }
    }

    public String getUUID() {
        if (this.filePackage != null) {
            return this.filePackage.getUniqueID().toString();
        }
        return null;
    }

    public String toString() {
        return "CrawledPackage Instance: " + this.getName();
    }

    public String getName() {
        if (this.filePackage == null) {
            return "Example CrawledPackage Name";
        }
        return this.filePackage.getName();
    }
}

