/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.eventscripter.sandboxobjects;

import java.io.File;
import java.util.Map;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.PackageInfo;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.Priority;
import org.jdownloader.extensions.eventscripter.ScriptAPI;
import org.jdownloader.extensions.eventscripter.sandboxobjects.CrawledLinkSandbox;

public class PackagizerLinkSandbox {
    private final CrawledLink link;
    private CrawledLinkSandbox crawledLinkSandbox = null;

    public PackagizerLinkSandbox(CrawledLink link) {
        this.link = link;
    }

    public int hashCode() {
        if (this.link != null) {
            return this.link.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PackagizerLinkSandbox) {
            return ((PackagizerLinkSandbox)obj).link == this.link;
        }
        return super.equals(obj);
    }

    public PackagizerLinkSandbox() {
        this(null);
    }

    public long getBytesTotal() {
        return this.link != null ? this.link.getSize() : -1L;
    }

    public boolean isEnabled() {
        return this.link != null && this.link.isEnabled();
    }

    public void setEnabled(boolean e) {
        if (this.link != null) {
            this.link.setEnabled(e);
        }
    }

    public String getHost() {
        return this.link != null ? this.link.getHost() : null;
    }

    public String getName() {
        return this.link != null ? this.link.getName() : null;
    }

    public void setName(String name) {
        if (this.link != null) {
            this.link.setName(name);
        }
    }

    @ScriptAPI(description="Get the Link Priority (HIGHEST|HIGHER|HIGH|DEFAULT|LOWER)")
    public String getPriority() {
        return this.link != null ? this.link.getPriority().name() : null;
    }

    public int getChunks() {
        return this.link != null ? this.link.getChunks() : -1;
    }

    public void setChunks(int chunks) {
        if (this.link != null) {
            this.link.setChunks(chunks);
        }
    }

    public String getDownloadFolder() {
        if (this.link != null) {
            PackageInfo dpi = this.link.getDesiredPackageInfo();
            return dpi == null ? null : dpi.getDestinationFolder();
        }
        return null;
    }

    public void setDownloadFolder(String destinationFolder) {
        if (this.link != null) {
            PackageInfo packageInfo = this.link.getDesiredPackageInfo();
            if (packageInfo == null) {
                packageInfo = new PackageInfo();
            }
            if (StringUtils.isNotEmpty((String)destinationFolder)) {
                destinationFolder = CrossSystem.fixPathSeparators((String)(destinationFolder + File.separator));
            }
            packageInfo.setDestinationFolder(destinationFolder);
            this.link.setDesiredPackageInfo(packageInfo);
        }
    }

    public String getURL() {
        return this.link != null ? this.link.getURL() : null;
    }

    public String getLinkState() {
        return this.link != null ? this.link.getLinkState().name() : null;
    }

    public String[] getSourceUrls() {
        return this.link != null ? this.link.getSourceUrls() : null;
    }

    public String getPackageName() {
        if (this.link != null) {
            PackageInfo dpi = this.link.getDesiredPackageInfo();
            return dpi == null ? null : dpi.getName();
        }
        return null;
    }

    public void setPackageName(String name) {
        if (this.link != null) {
            PackageInfo packageInfo = this.link.getDesiredPackageInfo();
            if (packageInfo == null) {
                packageInfo = new PackageInfo();
            }
            packageInfo.setName(name);
            this.link.setDesiredPackageInfo(packageInfo);
        }
    }

    public CrawledLinkSandbox getCrawledLink() {
        if (this.crawledLinkSandbox != null) {
            return this.crawledLinkSandbox;
        }
        if (this.link != null) {
            this.crawledLinkSandbox = new CrawledLinkSandbox(this.link);
            return this.crawledLinkSandbox;
        }
        return null;
    }

    public Object getProperty(String key) {
        CrawledLinkSandbox crawledLinkSandbox = this.getCrawledLink();
        if (crawledLinkSandbox != null) {
            return crawledLinkSandbox.getProperty(key);
        }
        return null;
    }

    public Map<String, Object> getProperties() {
        CrawledLinkSandbox crawledLinkSandbox = this.getCrawledLink();
        if (crawledLinkSandbox != null) {
            return crawledLinkSandbox.getProperties();
        }
        return null;
    }

    public void setProperty(String key, Object value) {
        CrawledLinkSandbox crawledLinkSandbox = this.getCrawledLink();
        if (crawledLinkSandbox != null) {
            crawledLinkSandbox.setProperty(key, value);
        }
    }

    @ScriptAPI(description="Sets the Link Priority", parameters={"HIGHEST|HIGHER|HIGH|DEFAULT|LOWER"})
    public void setPriority(String priority) {
        if (this.link != null) {
            this.link.setPriority(Priority.valueOf((String)priority));
        }
    }

    public String getComment() {
        return this.link != null ? this.link.getComment() : null;
    }

    public void setComment(String comment) {
        if (this.link != null) {
            this.link.setComment(comment);
        }
    }

    @ScriptAPI(description="If true, the link will automove to the downloadlist")
    public boolean isAutoConfirmEnabled() {
        return this.link != null && this.link.isAutoConfirmEnabled();
    }

    @ScriptAPI(description="If true, the link will automove to the downloadlist")
    public void setAutoConfirmEnabled(boolean b) {
        if (this.link != null) {
            this.link.setAutoConfirmEnabled(b);
        }
    }

    @ScriptAPI(description="If true, the link will autostart download after beeing confirmed")
    public boolean isAutoStartEnabled() {
        return this.link != null && this.link.isAutoStartEnabled();
    }

    @ScriptAPI(description="If true, the link will autostart download after beeing confirmed")
    public void setAutoStartEnabled(boolean b) {
        if (this.link != null) {
            this.link.setAutoStartEnabled(b);
        }
    }
}

