/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.eventscripter.sandboxobjects;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import jd.controlling.AccountController;
import jd.controlling.TaskQueue;
import jd.controlling.accountchecker.AccountChecker;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadSession;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogJob;
import jd.controlling.downloadcontroller.ProxyInfoHistory;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.proxy.AbstractProxySelectorImpl;
import jd.controlling.proxy.ProxyController;
import jd.controlling.reconnect.Reconnecter;
import jd.plugins.Account;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.MigPanel;
import org.appwork.uio.CloseReason;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.InputDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Application;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Files;
import org.appwork.utils.Hash;
import org.appwork.utils.IO;
import org.appwork.utils.ModifyLock;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.extmanager.DevNullLogger;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.processes.ProcessBuilderFactory;
import org.appwork.utils.processes.ProcessOutput;
import org.appwork.utils.reflection.Clazz;
import org.appwork.utils.speedmeter.SpeedMeterInterface;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.appwork.utils.swing.dialog.InputDialog;
import org.jdownloader.api.RemoteAPIController;
import org.jdownloader.controlling.packagizer.PackagizerController;
import org.jdownloader.extensions.eventscripter.EnvironmentException;
import org.jdownloader.extensions.eventscripter.ScriptAPI;
import org.jdownloader.extensions.eventscripter.ScriptEntry;
import org.jdownloader.extensions.eventscripter.ScriptReferenceThread;
import org.jdownloader.extensions.eventscripter.ScriptThread;
import org.jdownloader.extensions.eventscripter.T;
import org.jdownloader.extensions.eventscripter.Utils;
import org.jdownloader.extensions.eventscripter.sandboxobjects.BrowserSandBox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.CrawledLinkSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.CrawledPackageSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.DownloadLinkSandBox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.EnvironmentSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.FilePackageSandBox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.FilePathSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.FilePathSandbox17;
import org.jdownloader.extensions.eventscripter.sandboxobjects.ModifyLockSandBox;
import org.jdownloader.gui.notify.BasicNotify;
import org.jdownloader.gui.notify.BubbleNotify;
import org.jdownloader.gui.notify.gui.AbstractNotifyWindow;
import org.jdownloader.gui.views.ArraySet;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.WaitingSkipReason;
import org.jdownloader.scripting.JavaScriptEngineFactory;
import org.jdownloader.settings.SoundSettings;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptEnvironment {
    @ScriptAPI(description="JDownloader Installation Directory")
    public static String JD_HOME = Application.getResource((String)"").getAbsolutePath();
    private static LogSource LOGGER = LogController.getInstance().getLogger("ScriptEnvironment");
    private static HashMap<ScriptEntry, HashMap<String, Object>> SCRIPT_PROPERTIES = new HashMap();
    private static final WeakHashMap<ReentrantReadWriteLock, String> LOCKS = new WeakHashMap();
    private static final HashMap<File, AtomicInteger> FILE_LOCKS = new HashMap();

    @ScriptAPI(description="Show a Message Box", parameters={"myObject1", "MyObject2", "..."}, example="alert(JD_HOME);")
    public static void alert(Object ... objects) {
        Object[] args = JavaScriptEngineFactory.convertJavaScriptToJava((Object[])objects);
        String message = null;
        if (args != null && args.length == 1 && args[0] instanceof String) {
            message = args[0].toString();
        } else {
            try {
                message = JSonStorage.serializeToJson((Object)(args != null && args.length == 1 ? args[0] : args));
            }
            catch (Exception e1) {
                try {
                    message = ScriptEnvironment.format(ScriptEnvironment.toJson(args != null && args.length == 1 ? args[0] : args));
                }
                catch (Exception e2) {
                    message = StringUtils.valueOfOrNull((Object)(args != null && args.length == 1 ? args[0] : args));
                }
            }
        }
        ScriptEnvironment.showMessageDialog(message);
    }

    @ScriptAPI(description="disable permission checks")
    public static void disablePermissionChecks() {
        ScriptThread env = ScriptEnvironment.getScriptThread();
        if (env != null) {
            env.setCheckPermissions(false);
        }
    }

    @ScriptAPI(description="enable/disable alert with textbox and copy&paste")
    public static void setAdvancedAlert(boolean b) {
        ScriptThread env = ScriptEnvironment.getScriptThread();
        if (env != null) {
            env.setAdvancedAlert(b);
        }
    }

    @ScriptAPI(description="enable/disable notification on exceptions")
    public static void setNotifyOnException(boolean b) {
        ScriptThread env = ScriptEnvironment.getScriptThread();
        if (env != null) {
            env.setNotifyOnException(b);
        }
    }

    @ScriptAPI(description="enable/disable script on exceptions")
    public static void setDisableOnException(boolean b) {
        ScriptThread env = ScriptEnvironment.getScriptThread();
        if (env != null) {
            env.setDisableOnException(b);
        }
    }

    @ScriptAPI(description="is current script run in synchronous mode?")
    public static boolean isSynchronous() {
        ScriptThread env = ScriptEnvironment.getScriptThread();
        return env != null && env.isSynchronous();
    }

    @ScriptAPI(description="enable permission checks")
    public static void enablePermissionChecks() {
        ScriptThread env = ScriptEnvironment.getScriptThread();
        if (env != null) {
            env.setCheckPermissions(true);
        }
    }

    static synchronized void askForPermission(final String string) throws EnvironmentException {
        String md5;
        ScriptThread env = ScriptEnvironment.getScriptThread();
        if (env.isCheckPermissions() && !env.isPermissionSet(md5 = Hash.getMD5((String)env.getScript().getScript()))) {
            ConfirmDialog d = new ConfirmDialog(544, T.T.permission_title(), T.T.permission_msg(env.getScript().getName(), env.getScript().getEventTrigger().getLabel(), string), (Icon)new AbstractIcon("server", 32), T.T.allow(), T.T.deny()){

                public String getDontShowAgainKey() {
                    return "ASK_FOR_PERMISSION_" + md5 + "_" + string;
                }

                protected LogInterface getLogger() {
                    return new DevNullLogger();
                }

                protected int getPreferredWidth() {
                    return 600;
                }

                public boolean isRemoteAPIEnabled() {
                    return true;
                }

                public void windowClosing(WindowEvent arg0) {
                    this.setReturnmask(false);
                    this.dispose();
                }
            };
            d.setDoNotShowAgainSelected(true);
            if (d.show().getCloseReason() != CloseReason.OK) {
                throw new EnvironmentException("Security Warning: User Denied Access to " + string);
            }
            if (d.isDontShowAgainSelected()) {
                env.setPermissionSet(md5);
            }
        }
    }

    @ScriptAPI(description="Call the MyJDownloader API locally (no network involved), see API Docs here https://my.jdownloader.org/developers/", parameters={"\"namespace\"", "\"methodname\"", "parameter1", "parameter2", "..."}, example="callAPI(\"downloadsV2\", \"queryLinks\", { \"name\": true})")
    public static Object callAPI(String namespace, String method, Object ... parameters) throws EnvironmentException {
        ScriptEnvironment.askForPermission("call the Remote API: " + namespace + "/" + method);
        try {
            Object[] args = JavaScriptEngineFactory.convertJavaScriptToJava((Object[])parameters);
            Object ret = RemoteAPIController.getInstance().call(namespace, method, args);
            ScriptThread env = ScriptEnvironment.getScriptThread();
            String js = "(function(){ return " + JSonStorage.serializeToJson((Object)ret) + ";}());";
            Object retObject = env.evalTrusted(js);
            return retObject;
        }
        catch (Throwable e) {
            throw new EnvironmentException(e);
        }
    }

    @ScriptAPI(description="Call a local Process asynchronous", parameters={"\"myCallBackFunction\"|null", "\"commandline1\"", "\"commandline2\"", "\"...\""}, example="callAsync(function(exitCode,stdOut,errOut){ alert(\"Closed Notepad\");},\"notepad.exe\",JD_HOME+\"\\\\license.txt\");")
    public static void callAsync(final Function callback, final String ... commands) throws EnvironmentException {
        ScriptEnvironment.askForPermission("Execute a local process");
        try {
            final ScriptThread env = ScriptEnvironment.getScriptThread();
            if (commands != null && commands.length > 0) {
                new ScriptReferenceThread(env){

                    @Override
                    public void run() {
                        block6: {
                            try {
                                try {
                                    ProcessOutput ret = ProcessBuilderFactory.runCommand((String[])commands);
                                    if (callback == null) break block6;
                                    if (CrossSystem.getOSFamily() == CrossSystem.OSFamily.WINDOWS) {
                                        this.executeCallback(callback, ret.getExitCode(), new String(ret.getStdOutString("cp850").getBytes("UTF-8"), "UTF-8"), new String(ret.getErrOutString("cp850").getBytes("UTF-8"), "UTF-8"));
                                        break block6;
                                    }
                                    this.executeCallback(callback, ret.getExitCode(), ret.getStdOutString("UTF-8"), ret.getErrOutString("UTF-8"));
                                }
                                catch (IOException e) {
                                    if (callback != null) {
                                        this.executeCallback(callback, -1, null, Exceptions.getStackTrace((Throwable)e));
                                    }
                                    env.getLogger().log((Throwable)e);
                                    env.notifyAboutException(e);
                                }
                            }
                            catch (Throwable e) {
                                env.notifyAboutException(e);
                            }
                        }
                    }
                }.start();
            }
        }
        catch (Throwable e) {
            throw new EnvironmentException(e);
        }
    }

    @ScriptAPI(description="Call a local Process. Blocks Until the process returns", parameters={"\"commandline1\"", "\"commandline2\"", "\"...\""}, example="var pingResultString = callSync(\"ping\",\"jdownloader.org\");")
    public static String callSync(String ... commands) throws EnvironmentException {
        ScriptEnvironment.askForPermission("Execute a local process");
        try {
            ProcessBuilder pb = ProcessBuilderFactory.create((String[])commands);
            pb.redirectErrorStream(true);
            ProcessOutput ret = ProcessBuilderFactory.runCommand((ProcessBuilder)pb);
            return ret.getStdOutString();
        }
        catch (Throwable e) {
            throw new EnvironmentException(e);
        }
    }

    protected static void collectClasses(Class<? extends Object> cl, ArraySet<Class<?>> clazzes) {
        for (Method m : cl.getDeclaredMethods()) {
            if (cl == ScriptEnvironment.class && m.getAnnotation(ScriptAPI.class) == null || m.getReturnType() == Object.class || !Modifier.isPublic(m.getModifiers()) || Clazz.isPrimitive(m.getReturnType()) || Clazz.isPrimitiveWrapper(m.getReturnType()) || Clazz.isString(m.getReturnType())) continue;
            if (clazzes.add(m.getReturnType())) {
                ScriptEnvironment.collectClasses(m.getReturnType(), clazzes);
            }
            for (Class<?> clazz : m.getParameterTypes()) {
                if (clazz == Object.class || Clazz.isPrimitive(clazz) || Clazz.isPrimitiveWrapper(clazz) || Clazz.isString(clazz) || !clazzes.add(clazz)) continue;
                ScriptEnvironment.collectClasses(clazz, clazzes);
            }
            for (AnnotatedElement annotatedElement : cl.getFields()) {
                if (((Field)annotatedElement).getType() == Object.class || !Modifier.isPublic(m.getModifiers()) || Clazz.isPrimitive(((Field)annotatedElement).getType()) || Clazz.isPrimitiveWrapper(((Field)annotatedElement).getType()) || Clazz.isString(((Field)annotatedElement).getType()) || !clazzes.add(((Field)annotatedElement).getType())) continue;
                ScriptEnvironment.collectClasses(((Field)annotatedElement).getType(), clazzes);
            }
        }
    }

    @ScriptAPI(description="Delete a file or a directory", parameters={"path", "recursive"}, example="var myBooleanResult=deleteFile(JD_HOME+\"/mydirectory/\",false);")
    public static boolean deleteFile(String filepath, boolean recursive) throws EnvironmentException {
        ScriptEnvironment.askForPermission("delete a local fole or directory");
        try {
            if (recursive) {
                Files.deleteRecursiv((File)new File(filepath), (boolean)true);
            } else {
                new File(filepath).delete();
            }
            return !new File(filepath).exists();
        }
        catch (Throwable e) {
            throw new EnvironmentException(e);
        }
    }

    protected static boolean doCollectClass(Class<? extends Object> cl) {
        Package pkg = cl.getPackage();
        Package sPkg = ScriptEnvironment.class.getPackage();
        return pkg != null && pkg.getName().startsWith(sPkg.getName());
    }

    private static String format(String js) {
        ScriptThread env = ScriptEnvironment.getScriptThread();
        try {
            env.ensureLibrary("js_beautifier.js");
            String parametername = "text_" + System.currentTimeMillis();
            ScriptableObject.putProperty((Scriptable)env.getScope(), (String)parametername, (Object)js);
            String ret = env.evalTrusted("js_beautify(" + parametername + ", {   });") + "";
            return ret;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return js;
        }
    }

    public static String getAPIDescription(ArraySet<Class<?>> triggerClazzes) {
        StringBuilder sb = new StringBuilder();
        ArraySet clazzes = new ArraySet();
        sb.append("/* =============== ").append("Global API").append(" =============== */").append("\r\n");
        ScriptEnvironment.getAPIDescriptionForClass(sb, ScriptEnvironment.class);
        sb.append("/* =========  Properties =========*/\r\n");
        for (Field f : Utils.sort(ScriptEnvironment.class.getDeclaredFields())) {
            ScriptAPI ann = f.getAnnotation(ScriptAPI.class);
            if (ann == null) continue;
            sb.append("//").append(ann.description()).append(";\r\n");
            String simpleName = f.getType().getSimpleName();
            boolean isArray = f.getType().isArray();
            if (isArray) {
                simpleName = simpleName.replaceFirst("\\[\\]$", "");
            }
            sb.append("var my").append(simpleName.substring(0, 1).toUpperCase(Locale.ENGLISH)).append(simpleName.substring(1)).append(" = ");
            if (isArray) {
                sb.append(" [] = ");
            }
            sb.append(f.getName()).append(";\r\n");
            if (!StringUtils.isNotEmpty((String)ann.example())) continue;
            sb.append(ann.example()).append("\r\n");
        }
        ScriptEnvironment.collectClasses(ScriptEnvironment.class, clazzes);
        clazzes.addAll(triggerClazzes);
        Collections.sort(clazzes, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                return Utils.cleanUpClass(o1.getSimpleName()).compareTo(Utils.cleanUpClass(o2.getSimpleName()));
            }
        });
        sb.append("/* =============== ").append("Classes").append(" =============== */").append("\r\n");
        for (Class cl : clazzes) {
            if (!ScriptEnvironment.doCollectClass(cl)) continue;
            sb.append("/* === ").append(Utils.cleanUpClass(cl.getSimpleName())).append(" === */").append("\r\n");
            ScriptEnvironment.getAPIDescriptionForClass(sb, cl);
        }
        return sb.toString();
    }

    public static void getAPIDescriptionForClass(StringBuilder sb, Class<?> cl) {
        ScriptAPI clazzAnn = cl.getAnnotation(ScriptAPI.class);
        if (clazzAnn != null && StringUtils.isNotEmpty((String)clazzAnn.description())) {
            sb.append("/* ").append(clazzAnn.description()).append("*/").append("\r\n");
        }
        sb.append("/* =========  Methods =========*/\r\n");
        for (Method m : Utils.sort(cl.getDeclaredMethods())) {
            boolean isDeprecated;
            if (!Modifier.isPublic(m.getModifiers()) || "hashCode".equals(m.getName()) && m.getParameterTypes().length == 0 || "equals".equals(m.getName()) && m.getParameterTypes().length == 1 && m.getParameterTypes()[0] == Object.class) continue;
            ScriptAPI ann = m.getAnnotation(ScriptAPI.class);
            if (cl == ScriptEnvironment.class && ann == null) continue;
            boolean bl = isDeprecated = m.getAnnotation(Deprecated.class) != null;
            if (!Clazz.isVoid(m.getReturnType())) {
                boolean isArray;
                String simpleName = m.getReturnType().getSimpleName();
                boolean bl2 = isArray = m.getReturnType().isArray() || List.class.isAssignableFrom(m.getReturnType());
                if (isArray) {
                    simpleName = simpleName.replaceFirst("\\[\\]$", "");
                }
                sb.append("var ").append(Utils.toMy(Utils.cleanUpClass(simpleName))).append(" = ");
                if (isArray) {
                    sb.append(" [] = ");
                }
            }
            if (cl == ScriptEnvironment.class) {
                sb.append(m.getName());
            } else {
                sb.append(Utils.toMy(Utils.cleanUpClass(cl.getSimpleName()))).append(".").append(m.getName());
            }
            sb.append("(");
            boolean first = true;
            int i = 0;
            for (Class<?> p : m.getParameterTypes()) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(Utils.toMy(p.getSimpleName()));
                if (ann != null && ann.parameters().length == m.getParameterTypes().length && !StringUtils.isEmpty((String)ann.parameters()[i])) {
                    sb.append("/*").append(ann.parameters()[i]).append("*/");
                }
                ++i;
            }
            sb.append(");");
            if (ann != null && StringUtils.isNotEmpty((String)ann.description())) {
                sb.append("/*").append(ann.description()).append("*/");
            }
            if (isDeprecated) {
                sb.append("/*DEPRECATED, this method may be removed in future version*/");
            }
            sb.append("\r\n");
            if (ann == null || !StringUtils.isNotEmpty((String)ann.example())) continue;
            sb.append("/* Example: */");
            sb.append(ann.example());
            sb.append("\r\n");
        }
    }

    @ScriptAPI(description="Set the Speedlimit in bytes/second. Values<=0 -> Disable Limiter", parameters={"speedlimit in bytes/second"})
    public static void setSpeedlimit(int bps) throws EnvironmentException {
        if (bps > 0) {
            CFG_GENERAL.DOWNLOAD_SPEED_LIMIT.setValue((Object)bps);
            CFG_GENERAL.DOWNLOAD_SPEED_LIMIT_ENABLED.setValue((Object)true);
        } else {
            CFG_GENERAL.DOWNLOAD_SPEED_LIMIT_ENABLED.setValue((Object)false);
        }
    }

    @ScriptAPI(description="Get a DownloadList Link by it's uuid", parameters={"uuid"})
    public static DownloadLinkSandBox getDownloadLinkByUUID(long uuid) throws EnvironmentException {
        try {
            DownloadLink link = (DownloadLink)DownloadController.getInstance().getLinkByID(uuid);
            if (link != null) {
                return new DownloadLinkSandBox(link);
            }
            return null;
        }
        catch (Throwable e) {
            throw new EnvironmentException(e);
        }
    }

    @ScriptAPI(description="Get a CrawledLink Link by it's uuid", parameters={"uuid"})
    public static CrawledLinkSandbox getCrawledLinkByUUID(long uuid) throws EnvironmentException {
        try {
            CrawledLink link = (CrawledLink)LinkCollector.getInstance().getLinkByID(uuid);
            if (link != null) {
                return new CrawledLinkSandbox(link);
            }
            return null;
        }
        catch (Throwable e) {
            throw new EnvironmentException(e);
        }
    }

    @ScriptAPI(description="Get a DownloadList Package by it's uuid", parameters={"uuid"})
    public static FilePackageSandBox getDownloadPackageByUUID(long uuid) throws EnvironmentException {
        try {
            FilePackage pkg = (FilePackage)DownloadController.getInstance().getPackageByID(uuid);
            if (pkg != null) {
                return new FilePackageSandBox(pkg);
            }
            return null;
        }
        catch (Throwable e) {
            throw new EnvironmentException(e);
        }
    }

    @ScriptAPI(description="Get a CrawledLink Package by it's uuid", parameters={"uuid"})
    public static CrawledPackageSandbox getCrawledPackageByUUID(long uuid) throws EnvironmentException {
        try {
            CrawledPackage pkg = (CrawledPackage)LinkCollector.getInstance().getPackageByID(uuid);
            if (pkg != null) {
                return new CrawledPackageSandbox(pkg);
            }
            return null;
        }
        catch (Throwable e) {
            throw new EnvironmentException(e);
        }
    }

    @ScriptAPI(description="Get a FilePath Object", parameters={"Path to a file or folder"})
    public static FilePathSandbox getPath(String fileOrUrl) {
        if (Application.getJavaVersion() >= Application.JAVA17) {
            return new FilePathSandbox17(fileOrUrl);
        }
        return new FilePathSandbox(fileOrUrl);
    }

    @ScriptAPI(description="Get the current path separator / or \\")
    public static String getPathSeparator() {
        return File.separator;
    }

    @ScriptAPI(description="Gets the value of the specified environment variable", parameters={"environment variable"})
    public static String getEnv(String variable) throws EnvironmentException {
        try {
            return System.getenv(variable);
        }
        catch (SecurityException e) {
            throw new EnvironmentException(e);
        }
    }

    @ScriptAPI(description="Gets the system property indicated by the specified key.", parameters={"system property key", "default value"})
    public static String getProperty(String key, String defaultValue) throws EnvironmentException {
        try {
            return System.getProperty(key, defaultValue);
        }
        catch (SecurityException e) {
            throw new EnvironmentException(e);
        }
    }

    @ScriptAPI(description="Get an Environment Object")
    public static EnvironmentSandbox getEnvironment() throws EnvironmentException {
        return new EnvironmentSandbox();
    }

    @ScriptAPI(description="Get an Browser Object")
    public static BrowserSandBox getBrowser() throws EnvironmentException {
        ScriptEnvironment.askForPermission("load resources from the internet");
        return new BrowserSandBox();
    }

    @ScriptAPI(description="Open a website or path in your default browser/file explorer", parameters={"URL"}, example="openURL(\"https://jdownloader.org\");")
    public static void openURL(String url) throws EnvironmentException {
        ScriptEnvironment.askForPermission("open resource in your default browser/file explorer");
        try {
            CrossSystem.openURL((String)url);
        }
        catch (Throwable e) {
            throw new EnvironmentException(e);
        }
    }

    @ScriptAPI(description="Loads a website (Method: GET) and returns the source code", parameters={"URL"}, example="var myhtmlSourceString=getPage(\"https://jdownloader.org\");")
    public static String getPage(String fileOrUrl) throws EnvironmentException {
        BrowserSandBox browser = ScriptEnvironment.getBrowser();
        try {
            return browser.getPage(fileOrUrl);
        }
        catch (Throwable e) {
            throw new EnvironmentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScriptAPI(description="Get a Property. Set global to true if you want to access a global property", parameters={"\"key\"", "global(boolean)"}, example="var value=getProperty(\"myobject\", false);")
    public static Object getProperty(String key, boolean global) throws EnvironmentException {
        try {
            if (global) {
                return PackagizerController.getGlobalProperty((String)key);
            }
            HashMap<ScriptEntry, HashMap<String, Object>> hashMap = SCRIPT_PROPERTIES;
            synchronized (hashMap) {
                HashMap<String, Object> store = SCRIPT_PROPERTIES.get(ScriptEnvironment.getScriptThread().getScript());
                if (store == null) {
                    return null;
                }
                return store.get(key);
            }
        }
        catch (Throwable e) {
            throw new EnvironmentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScriptAPI(description="Get a ModifyLock.", parameters={"\"key\""}, example="var lock=getModifyLock(\"lockID\");")
    public static ModifyLockSandBox getModifyLock(String id) {
        WeakHashMap<ReentrantReadWriteLock, String> weakHashMap = LOCKS;
        synchronized (weakHashMap) {
            ScriptThread thread = (ScriptThread)Thread.currentThread();
            for (Map.Entry<ReentrantReadWriteLock, String> lockEntry : LOCKS.entrySet()) {
                if (!StringUtils.equals((String)lockEntry.getValue(), (String)id)) continue;
                ReentrantReadWriteLock lock = lockEntry.getKey();
                thread.addLock(lock);
                return new ModifyLockSandBox(new ModifyLock(lock));
            }
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            thread.addLock(lock);
            LOCKS.put(lock, id);
            return new ModifyLockSandBox(new ModifyLock(lock));
        }
    }

    public static Collection<Class<?>> getRequiredClasses() {
        ArraySet clazzes = new ArraySet();
        ScriptEnvironment.collectClasses(ScriptEnvironment.class, clazzes);
        if (Application.getJavaVersion() >= Application.JAVA17) {
            clazzes.add(FilePathSandbox17.class);
            ScriptEnvironment.collectClasses(FilePathSandbox17.class, clazzes);
        }
        return clazzes;
    }

    @ScriptAPI(description="Get current timestamp in ms")
    public static long getCurrentTimeStamp() {
        return System.currentTimeMillis();
    }

    @ScriptAPI(description="Get a list of all running downloadlinks")
    public static DownloadLinkSandBox[] getRunningDownloadLinks() {
        Set list = DownloadWatchDog.getInstance().getRunningDownloadLinks();
        DownloadLinkSandBox[] ret = new DownloadLinkSandBox[list.size()];
        int i = 0;
        for (SingleDownloadController dlc : list) {
            ret[i++] = new DownloadLinkSandBox(dlc.getDownloadLink());
        }
        return ret;
    }

    @ScriptAPI(description="Get a list of all packages")
    public static FilePackageSandBox[] getAllFilePackages() {
        ArrayList list = DownloadController.getInstance().getPackagesCopy();
        FilePackageSandBox[] ret = new FilePackageSandBox[list.size()];
        int i = 0;
        for (FilePackage pkg : list) {
            ret[i++] = new FilePackageSandBox(pkg);
        }
        return ret;
    }

    @ScriptAPI(description="Create a Checksum for a file. Types: e.g. CRC32, MD5, SHA-1, SHA-256")
    public static String getChecksum(String type, String path) throws EnvironmentException {
        ScriptEnvironment.askForPermission("Create Checksum of local file");
        try {
            File rel = new File(path);
            if (!rel.isAbsolute()) {
                rel = Application.getResource((String)path);
            }
            if (StringUtils.equalsIgnoreCase((String)"CRC32", (String)type)) {
                return String.valueOf(Hash.getCRC32((File)rel));
            }
            return Hash.getFileHash((File)rel, (String)type);
        }
        catch (Throwable e) {
            throw new EnvironmentException(e);
        }
    }

    @ScriptAPI(description="Create a Checksum for a String. Types: e.g. CRC32, MD5, SHA-1, SHA-256")
    public static String getStringChecksum(String type, String string) throws EnvironmentException {
        try {
            if (string == null) {
                return null;
            }
            byte[] bytes = string.getBytes("UTF-8");
            if (StringUtils.equalsIgnoreCase((String)"CRC32", (String)type)) {
                return String.valueOf(Hash.getCRC32((byte[])bytes));
            }
            return Hash.getHash((InputStream)new ByteArrayInputStream(bytes), (String)type, (long)-1L, (boolean)true);
        }
        catch (Throwable e) {
            throw new EnvironmentException(e);
        }
    }

    @ScriptAPI(description="Get a list of all crawledpackages")
    public static CrawledPackageSandbox[] getAllCrawledPackages() {
        ArrayList list = LinkCollector.getInstance().getPackagesCopy();
        CrawledPackageSandbox[] ret = new CrawledPackageSandbox[list.size()];
        int i = 0;
        for (CrawledPackage pkg : list) {
            ret[i++] = new CrawledPackageSandbox(pkg);
        }
        return ret;
    }

    @ScriptAPI(description="Remove a downloadlink by uuid")
    public static boolean removeDownloadLinkByUUID(String uuid) {
        DownloadLink link = (DownloadLink)DownloadController.getInstance().getLinkByID(Long.parseLong(uuid));
        return link != null && new DownloadLinkSandBox(link).remove();
    }

    @ScriptAPI(description="Remove a package by uuid")
    public static boolean removeFilePackageByUUID(String uuid) {
        FilePackage pkg = (FilePackage)DownloadController.getInstance().getPackageByID(Long.parseLong(uuid));
        return pkg != null && new FilePackageSandBox(pkg).remove();
    }

    @ScriptAPI(description="Remove a crawledlink by uuid")
    public static boolean removeCrawledLinkByUUID(String uuid) {
        CrawledLink link = (CrawledLink)LinkCollector.getInstance().getLinkByID(Long.parseLong(uuid));
        return link != null && new CrawledLinkSandbox(link).remove();
    }

    @ScriptAPI(description="Remove a crawledpackage by uuid")
    public static boolean removeCrawledPackageByUUID(String uuid) {
        CrawledPackage pkg = (CrawledPackage)LinkCollector.getInstance().getPackageByID(Long.parseLong(uuid));
        return pkg != null && new CrawledPackageSandbox(pkg).remove();
    }

    @ScriptAPI(description="Get a list of all downloadlinks")
    public static DownloadLinkSandBox[] getAllDownloadLinks() {
        List links = DownloadController.getInstance().getAllChildren();
        DownloadLinkSandBox[] ret = new DownloadLinkSandBox[links.size()];
        int i = 0;
        for (DownloadLink link : links) {
            ret[i++] = new DownloadLinkSandBox(link);
        }
        return ret;
    }

    @ScriptAPI(description="Get a list of all crawledlinks")
    public static CrawledLinkSandbox[] getAllCrawledLinks() {
        List links = LinkCollector.getInstance().getAllChildren();
        CrawledLinkSandbox[] ret = new CrawledLinkSandbox[links.size()];
        int i = 0;
        for (CrawledLink link : links) {
            ret[i++] = new CrawledLinkSandbox(link);
        }
        return ret;
    }

    @ScriptAPI(description="Get a list of all running packages")
    public static FilePackageSandBox[] getRunningDownloadPackages() {
        Set list = DownloadWatchDog.getInstance().getRunningFilePackages();
        FilePackageSandBox[] ret = new FilePackageSandBox[list.size()];
        int i = 0;
        for (FilePackage dlc : list) {
            ret[i++] = new FilePackageSandBox(dlc);
        }
        return ret;
    }

    private static ScriptThread getScriptThread() {
        Thread ct = Thread.currentThread();
        if (ct instanceof ScriptThread) {
            return (ScriptThread)ct;
        }
        if (ct instanceof ScriptReferenceThread) {
            return ((ScriptReferenceThread)ct).getScriptThread();
        }
        throw new IllegalStateException();
    }

    @ScriptAPI(description="Get current total Download Speed in bytes/second")
    public static long getTotalSpeed() {
        return DownloadWatchDog.getInstance().getDownloadSpeedManager().getSpeed();
    }

    @ScriptAPI(description="Get current average Download Speed in bytes/second")
    public static long getAverageSpeed() {
        return DownloadWatchDog.getInstance().getDownloadSpeedManager().getSpeedMeter().getValue(SpeedMeterInterface.Resolution.SECONDS);
    }

    @ScriptAPI(description="Stop Downloads")
    public static void stopDownloads() {
        DownloadWatchDog.getInstance().stopDownloads();
    }

    @ScriptAPI(description="Start Downloads")
    public static void startDownloads() {
        DownloadWatchDog.getInstance().startDownloads();
    }

    @ScriptAPI(description="Pause/Unpause Downloads")
    public static void setDownloadsPaused(boolean paused) {
        DownloadWatchDog.getInstance().pauseDownloadWatchDog(paused);
    }

    @ScriptAPI(description="Check if Download Controller is in IDLE State")
    public static boolean isDownloadControllerIdle() {
        return DownloadWatchDog.getInstance().isIdle();
    }

    @ScriptAPI(description="Check if Download Controller is in PAUSE State")
    public static boolean isDownloadControllerPaused() {
        return DownloadWatchDog.getInstance().isPaused();
    }

    @ScriptAPI(description="Check if Download Controller is in RUNNING State")
    public static boolean isDownloadControllerRunning() {
        return DownloadWatchDog.getInstance().isRunning();
    }

    @ScriptAPI(description="Check if Download Controller is in STOPPING State (Still running, but stop has been pressed)")
    public static boolean isDownloadControllerStopping() {
        return DownloadWatchDog.getInstance().isStopping();
    }

    @ScriptAPI(description="Log to stderr and to JDownloader Log Files")
    public static void log(Object ... objects) {
        if (objects != null && objects.length == 1) {
            if (Clazz.isPrimitiveWrapper(objects[0].getClass()) || Clazz.isString(objects[0].getClass())) {
                LOGGER.info(objects[0] + "");
                return;
            }
            if (objects.length > 0) {
                if (objects[0] != null && objects[0].getClass().getPackage().getName().equals(DownloadLinkSandBox.class.getPackage().getName())) {
                    LOGGER.info(objects[0].toString());
                    return;
                }
                try {
                    try {
                        LOGGER.info(JSonStorage.serializeToJson((Object)objects[0]));
                    }
                    catch (Throwable e) {
                        LOGGER.info(ScriptEnvironment.format(ScriptEnvironment.toJson(objects[0])));
                    }
                }
                catch (Throwable e) {
                    LOGGER.info(objects[0] + "");
                }
                return;
            }
        }
        try {
            try {
                LOGGER.info(JSonStorage.serializeToJson((Object)objects));
            }
            catch (Throwable e) {
                LOGGER.info(ScriptEnvironment.format(ScriptEnvironment.toJson(objects)));
            }
        }
        catch (Throwable e) {
            LOGGER.info(objects + "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScriptAPI(description="Play a Wav Audio file", parameters={"myFilePathOrUrl"}, example="playWavAudio(JD_HOME+\"/themes/standard/org/jdownloader/sounds/captcha.wav\");")
    public static void playWavAudio(String fileOrUrl) throws EnvironmentException {
        try {
            Clip clip;
            AudioInputStream stream;
            block19: {
                stream = null;
                clip = null;
                try {
                    stream = AudioSystem.getAudioInputStream(new File(fileOrUrl));
                    AudioFormat format = stream.getFormat();
                    DataLine.Info info = new DataLine.Info(Clip.class, format);
                    if (!AudioSystem.isLineSupported(info)) break block19;
                    clip = (Clip)AudioSystem.getLine(info);
                    clip.open(stream);
                    try {
                        FloatControl gainControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
                        float db = 20.0f * (float)Math.log((float)((SoundSettings)JsonConfig.create(SoundSettings.class)).getCaptchaSoundVolume() / 100.0f);
                        gainControl.setValue(Math.max(-80.0f, db));
                        BooleanControl muteControl = (BooleanControl)clip.getControl(BooleanControl.Type.MUTE);
                        muteControl.setValue(true);
                        muteControl.setValue(false);
                    }
                    catch (Exception e) {
                        LoggerFactory.getDefaultLogger().log((Throwable)e);
                    }
                    final AtomicBoolean runningFlag = new AtomicBoolean(true);
                    clip.addLineListener(new LineListener(){

                        @Override
                        public void update(LineEvent event) {
                            if (event.getType() == LineEvent.Type.STOP) {
                                runningFlag.set(false);
                            }
                        }
                    });
                    clip.start();
                    Thread.sleep(1000L);
                    while (clip.isRunning() && runningFlag.get()) {
                        Thread.sleep(100L);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (clip != null) {
                            Clip finalClip = clip;
                            Thread thread = new Thread(finalClip){
                                final /* synthetic */ Clip val$finalClip;
                                {
                                    this.val$finalClip = clip;
                                }

                                @Override
                                public void run() {
                                    this.val$finalClip.close();
                                }
                            };
                            thread.setName("AudioStop");
                            thread.setDaemon(true);
                            thread.start();
                            thread.join(2000L);
                        }
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                if (clip != null) {
                    Clip finalClip = clip;
                    Thread thread = new /* invalid duplicate definition of identical inner class */;
                    thread.setName("AudioStop");
                    thread.setDaemon(true);
                    thread.start();
                    thread.join(2000L);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable e) {
            throw new EnvironmentException(e);
        }
    }

    @ScriptAPI(description="Loads a website (METHOD: POST) and returns the source code", parameters={"URL", "PostData"}, example="var myhtmlSourceString=postPage(\"https://support.jdownloader.org/index.php\",\"searchquery=captcha\");")
    public static String postPage(String url, String post) throws EnvironmentException {
        BrowserSandBox browser = ScriptEnvironment.getBrowser();
        try {
            return browser.postPage(url, post);
        }
        catch (Throwable e) {
            throw new EnvironmentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ScriptAPI(description="Read a text file", parameters={"filepath"}, example="var myString=readFile(JD_HOME+\"/license.txt\");")
    public static String readFile(String filepath) throws EnvironmentException {
        ScriptEnvironment.askForPermission("read a local file");
        try {
            File file = new File(filepath);
            Object lock = ScriptEnvironment.requestLock(file);
            try {
                Object object = lock;
                synchronized (object) {
                    String string = IO.readFileToString((File)file);
                    return string;
                }
            }
            finally {
                ScriptEnvironment.unLock(file);
            }
        }
        catch (Throwable e) {
            throw new EnvironmentException(e);
        }
    }

    @ScriptAPI(description="Request a reconnect", parameters={}, example="requestReconnect();")
    public static void requestReconnect() throws EnvironmentException {
        try {
            DownloadWatchDog.getInstance().requestReconnect(false);
        }
        catch (InterruptedException e) {
            throw new EnvironmentException(e);
        }
    }

    @ScriptAPI(description="Return current reconnect status", example="var reconnectStatus=getReconnectState();")
    public static String getReconnectState() {
        DownloadSession session = DownloadWatchDog.getInstance().getSession();
        if (session == null) {
            return null;
        }
        DownloadSession.SessionState state = session.getSessionState();
        switch (state) {
            case RECONNECT_REQUESTED: 
            case RECONNECT_RUNNING: {
                return state.name();
            }
        }
        return null;
    }

    @ScriptAPI(description="Refresh all premium accounts", parameters={"true|false (Wait for account checks)", "true|false (Force Check)"}, example="refreshAccounts(true,true);")
    public static void refreshAccounts(final boolean wait, final boolean force) throws EnvironmentException {
        QueueAction<Void, InterruptedException> action = new QueueAction<Void, InterruptedException>(){

            protected Void run() throws InterruptedException {
                ArrayList<AccountChecker.AccountCheckJob> jobs = new ArrayList<AccountChecker.AccountCheckJob>();
                for (Account acc : AccountController.getInstance().list()) {
                    if (acc.getPlugin() == null || !acc.isEnabled() || !acc.isValid()) continue;
                    AccountChecker.AccountCheckJob job = AccountChecker.getInstance().check(acc, force);
                    if (!wait || job == null) continue;
                    jobs.add(job);
                }
                for (AccountChecker.AccountCheckJob job : jobs) {
                    while (!job.isChecked()) {
                        Thread.sleep(100L);
                    }
                }
                return null;
            }
        };
        try {
            if (wait) {
                TaskQueue.getQueue().addWait((QueueAction)action);
            } else {
                TaskQueue.getQueue().add((QueueAction)action);
            }
        }
        catch (InterruptedException e) {
            throw new EnvironmentException(e);
        }
    }

    @ScriptAPI(description="Perform a reconnect and wait for it", parameters={}, example="var success= doReconnect();")
    public static boolean doReconnect() throws EnvironmentException {
        try {
            return DownloadWatchDog.getInstance().requestReconnect(true) == Reconnecter.ReconnectResult.SUCCESSFUL;
        }
        catch (InterruptedException e) {
            throw new EnvironmentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScriptAPI(description="Perform a fake reconnect and optionally wait for it", parameters={"true|false (Wait for fake reconnect)"}, example="fakeReconnect(false);")
    public static void fakeReconnect(boolean wait) throws EnvironmentException {
        final AtomicBoolean executedFlag = new AtomicBoolean(false);
        DownloadWatchDog.getInstance().enqueueJob(new DownloadWatchDogJob(){

            public boolean isHighPriority() {
                return true;
            }

            public void interrupt() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(DownloadSession currentSession) {
                try {
                    ProxyInfoHistory proxyInfoHistory = currentSession.getProxyInfoHistory();
                    proxyInfoHistory.validate();
                    List reconnects = proxyInfoHistory.list(WaitingSkipReason.CAUSE.IP_BLOCKED, null);
                    if (reconnects != null) {
                        for (ProxyInfoHistory.WaitingSkipReasonContainer reconnect : reconnects) {
                            if (!reconnect.getProxySelector().isReconnectSupported()) continue;
                            reconnect.invalidate();
                        }
                    }
                }
                finally {
                    AtomicBoolean atomicBoolean = executedFlag;
                    synchronized (atomicBoolean) {
                        executedFlag.set(true);
                        executedFlag.notifyAll();
                    }
                }
            }
        });
        if (wait) {
            try {
                AtomicBoolean atomicBoolean = executedFlag;
                synchronized (atomicBoolean) {
                    if (!executedFlag.get()) {
                        executedFlag.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                throw new EnvironmentException(e);
            }
        }
    }

    @ScriptAPI(description="Perform a sleep and wait for x milliseconds", parameters={"milliseconds"}, example="sleep(1000);")
    public static void sleep(int millis) throws EnvironmentException {
        try {
            if (millis > 0) {
                Thread.sleep(millis);
            }
        }
        catch (InterruptedException e) {
            throw new EnvironmentException(e);
        }
    }

    @ScriptAPI(description="(experimental) Get proxy list", parameters={""}, example="experimental_proxylist();")
    public static String experimental_proxylist() throws EnvironmentException {
        List selectedObjects = ProxyController.getInstance().getList();
        StringBuilder sb = new StringBuilder();
        for (AbstractProxySelectorImpl pi : selectedObjects) {
            String str = pi.toExportString();
            if (str == null) continue;
            if (sb.length() > 0) {
                sb.append("\r\n");
            }
            sb.append(str);
        }
        return sb.toString();
    }

    @ScriptAPI(description="(experimental) Get proxy banlist", parameters={""}, example="experimental_proxybanlist();")
    public static String experimental_proxybanlist() throws EnvironmentException {
        List selectedObjects = ProxyController.getInstance().getList();
        StringBuilder sb = new StringBuilder();
        for (AbstractProxySelectorImpl pi : selectedObjects) {
            String str_temp;
            String str = pi.getBanList().toString();
            if (str == null || str == "" || str == "[]" || (str_temp = pi.toExportString()) == null) continue;
            str = str_temp + ": " + str;
            if (sb.length() > 0) {
                sb.append("\r\n");
            }
            sb.append(str);
        }
        return sb.toString();
    }

    @ScriptAPI(description="Loads a Javascript file or url. ATTENTION. The loaded script can access the API as well.", parameters={"myFilePathOrUrl"}, example="require(\"https://raw.githubusercontent.com/douglascrockford/JSON-js/master/json.js\");")
    public static void require(String fileOrUrl) throws EnvironmentException {
        ScriptEnvironment.askForPermission("load external JavaScript");
        try {
            ScriptEnvironment.getScriptThread().requireJavascript(fileOrUrl);
        }
        catch (Throwable e) {
            throw new EnvironmentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScriptAPI(description="Set a Property. This property will be available until JD-exit or a script overwrites it. if global is true, the property will be available for al scripts", parameters={"\"key\"", "anyValue", "global(boolean)"}, example="var oldValue=setProperty(\"myobject\", { \"name\": true}, false);")
    public static Object setProperty(String key, Object value, boolean global) throws EnvironmentException {
        try {
            if (global) {
                return PackagizerController.putGlobalProperty((String)key, (Object)value);
            }
            HashMap<ScriptEntry, HashMap<String, Object>> hashMap = SCRIPT_PROPERTIES;
            synchronized (hashMap) {
                HashMap<String, Object> store = SCRIPT_PROPERTIES.get(ScriptEnvironment.getScriptThread().getScript());
                if (store == null) {
                    store = new HashMap();
                    SCRIPT_PROPERTIES.put(ScriptEnvironment.getScriptThread().getScript(), store);
                }
                return store.put(key, value);
            }
        }
        catch (Throwable e) {
            throw new EnvironmentException(e);
        }
    }

    @ScriptAPI(description="Show a Notification", parameters={"Map: notification settings(title, message, iconKey, timeout)"}, example="displayNotification({\"title\":\"Ping\",\"message\":\"Nice\",\"iconKey\":\"stop\",\"timeout\":1000})")
    public static void displayNotification(final Map<String, Object> notification) {
        if (Application.isHeadless()) {
            return;
        }
        BubbleNotify.getInstance().show(new BubbleNotify.AbstractNotifyWindowFactory(){

            public AbstractNotifyWindow<?> buildAbstractNotifyWindow() {
                String title = StringUtils.valueOrEmpty((String)StringUtils.valueOfOrNull(notification.get("title")));
                String text = StringUtils.valueOrEmpty((String)StringUtils.valueOfOrNull(notification.get("message")));
                String iconKey = StringUtils.valueOfOrNull(notification.get("iconKey"));
                BasicNotify ret = new BasicNotify(title, text, (Icon)(iconKey == null ? new AbstractIcon("info", 32) : new AbstractIcon(iconKey, 32)));
                Number timeout = (Number)notification.get("timeout");
                if (timeout != null) {
                    ret.setTimeout(timeout.intValue());
                }
                return ret;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScriptAPI(description="Show a Input Dialog", parameters={"inputDialogMap"}, example="showInputDialog({\"message\":\"Are you a bot?\",\"multiLine\":false,\"default\":\"yes\"})")
    public static String showInputDialog(final Map<String, Object> inputDialogMap) {
        ScriptThread env = ScriptEnvironment.getScriptThread();
        final String id = T.T.showConfirmDialog_title(env.getScript().getName(), env.getScript().getEventTrigger().getLabel());
        final AtomicReference dialogReference = new AtomicReference();
        new Thread(id){
            {
                super(x0);
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String message = StringUtils.valueOrEmpty((String)StringUtils.valueOfOrNull(inputDialogMap.get("message")));
                    int flags = 0;
                    if (Boolean.TRUE.equals(inputDialogMap.get("multiLine"))) {
                        flags |= 0x40;
                    }
                    if (message != null && message.matches("<html>.+</html>")) {
                        flags |= 0x80;
                    }
                    String defaultText = StringUtils.valueOrEmpty((String)StringUtils.valueOfOrNull(inputDialogMap.get("default")));
                    InputDialog inputDialog = new InputDialog(flags, id, message, defaultText){

                        protected int getPreferredWidth() {
                            return 600;
                        }

                        public String getDontShowAgainKey() {
                            return null;
                        }

                        public boolean isRemoteAPIEnabled() {
                            return true;
                        }

                        public Dialog.ModalityType getModalityType() {
                            return Dialog.ModalityType.MODELESS;
                        }

                        public void pack() {
                            this.getDialog().pack();
                        }
                    };
                    InputDialogInterface dialog = (InputDialogInterface)UIOManager.I().show(InputDialogInterface.class, (UserIODefinition)inputDialog);
                    dialogReference.set(dialog);
                }
                finally {
                    AtomicReference atomicReference = dialogReference;
                    synchronized (atomicReference) {
                        dialogReference.compareAndSet(null, Boolean.FALSE);
                        dialogReference.notifyAll();
                    }
                }
            }
        }.start();
        AtomicReference atomicReference = dialogReference;
        synchronized (atomicReference) {
            while (dialogReference.get() == null) {
                try {
                    dialogReference.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
        }
        if (dialogReference.get() instanceof InputDialogInterface) {
            try {
                ((InputDialogInterface)dialogReference.get()).throwCloseExceptions();
                return ((InputDialogInterface)dialogReference.get()).getText();
            }
            catch (DialogNoAnswerException dialogNoAnswerException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScriptAPI(description="Show a Confirm Dialog", parameters={"message", "okOption", "cancelOption"}, example="showConfirmDialog(\"Do you like this method?\",\"yes\",\"no\")")
    public static int showConfirmDialog(final String message, final String okOption, final String cancelOption) {
        final ScriptThread env = ScriptEnvironment.getScriptThread();
        final String id = T.T.showConfirmDialog_title(env.getScript().getName(), env.getScript().getEventTrigger().getLabel());
        final AtomicReference dialogReference = new AtomicReference();
        new Thread(id){
            private final int flags;
            {
                super(x0);
                this.setDaemon(true);
                this.flags = message != null && message.matches("<html>.+</html>") ? 192 : 64;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ConfirmDialog confirmDialog = new ConfirmDialog(this.flags, id, message, (Icon)new AbstractIcon("question", 32), okOption, cancelOption){

                        protected int getPreferredWidth() {
                            return 600;
                        }

                        public String getDontShowAgainKey() {
                            return null;
                        }

                        public boolean isRemoteAPIEnabled() {
                            return true;
                        }

                        protected void modifyTextPane(JTextPane textField) {
                        }

                        public Dialog.ModalityType getModalityType() {
                            return Dialog.ModalityType.MODELESS;
                        }

                        protected JTextComponent addMessageComponent(MigPanel p) {
                            JTextPane textField = new JTextPane();
                            this.modifyTextPane(textField);
                            Font font = textField.getFont();
                            if (BinaryLogic.containsAll((int)this.flagMask, (int[])new int[]{128})) {
                                textField.setContentType("text/html");
                                textField.addHyperlinkListener(new HyperlinkListener(){

                                    @Override
                                    public void hyperlinkUpdate(HyperlinkEvent e) {
                                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                            CrossSystem.openURL((URL)e.getURL());
                                        }
                                    }
                                });
                            } else {
                                textField.setContentType("text/plain");
                            }
                            textField.setFont(font);
                            textField.setText(this.getMessage());
                            if (env.isAdvancedAlert()) {
                                textField.setEditable(true);
                            } else {
                                textField.setEditable(false);
                            }
                            textField.setBackground(null);
                            textField.setOpaque(false);
                            if (env.isAdvancedAlert()) {
                                textField.setFocusable(true);
                            } else {
                                textField.setFocusable(false);
                            }
                            textField.setForeground(new JLabel().getForeground());
                            textField.putClientProperty("Synthetica.opaque", Boolean.FALSE);
                            textField.setCaretPosition(0);
                            if (BinaryLogic.containsAll((int)this.flagMask, (int[])new int[]{64})) {
                                p.add((Component)new JScrollPane(textField), (Object)"pushx,growx");
                            } else {
                                p.add((Component)textField);
                            }
                            return textField;
                        }

                        public void pack() {
                            this.getDialog().pack();
                        }
                    };
                    ConfirmDialogInterface dialog = (ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)confirmDialog);
                    dialogReference.set(dialog);
                }
                finally {
                    AtomicReference atomicReference = dialogReference;
                    synchronized (atomicReference) {
                        dialogReference.compareAndSet(null, Boolean.FALSE);
                        dialogReference.notifyAll();
                    }
                }
            }
        }.start();
        AtomicReference atomicReference = dialogReference;
        synchronized (atomicReference) {
            while (dialogReference.get() == null) {
                try {
                    dialogReference.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
        }
        if (dialogReference.get() instanceof ConfirmDialogInterface) {
            try {
                ((ConfirmDialogInterface)dialogReference.get()).throwCloseExceptions();
                return 1;
            }
            catch (DialogNoAnswerException dialogNoAnswerException) {
                // empty catch block
            }
        }
        return 0;
    }

    private static void showMessageDialog(final String string) {
        final ScriptThread env = ScriptEnvironment.getScriptThread();
        final int flags = string != null && string.matches("<html>.+</html>") ? 208 : 80;
        final String id = T.T.showMessageDialog_title(env.getScript().getName(), env.getScript().getEventTrigger().getLabel());
        new Thread(id){
            {
                super(x0);
                this.setDaemon(true);
            }

            @Override
            public void run() {
                UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)new ConfirmDialog(flags, id, string, (Icon)new AbstractIcon("info", 32), null, null){

                    protected int getPreferredWidth() {
                        return 600;
                    }

                    public boolean isRemoteAPIEnabled() {
                        return false;
                    }

                    protected void modifyTextPane(JTextPane textField) {
                    }

                    public Dialog.ModalityType getModalityType() {
                        return Dialog.ModalityType.MODELESS;
                    }

                    protected JTextComponent addMessageComponent(MigPanel p) {
                        JTextPane textField = new JTextPane();
                        this.modifyTextPane(textField);
                        Font font = textField.getFont();
                        if (BinaryLogic.containsAll((int)this.flagMask, (int[])new int[]{128})) {
                            textField.setContentType("text/html");
                            textField.addHyperlinkListener(new HyperlinkListener(){

                                @Override
                                public void hyperlinkUpdate(HyperlinkEvent e) {
                                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                        CrossSystem.openURL((URL)e.getURL());
                                    }
                                }
                            });
                        } else {
                            textField.setContentType("text/plain");
                        }
                        textField.setFont(font);
                        textField.setText(this.getMessage());
                        if (env.isAdvancedAlert()) {
                            textField.setEditable(true);
                        } else {
                            textField.setEditable(false);
                        }
                        textField.setBackground(null);
                        textField.setOpaque(false);
                        if (env.isAdvancedAlert()) {
                            textField.setFocusable(true);
                        } else {
                            textField.setFocusable(false);
                        }
                        textField.setForeground(new JLabel().getForeground());
                        textField.putClientProperty("Synthetica.opaque", Boolean.FALSE);
                        textField.setCaretPosition(0);
                        if (BinaryLogic.containsAll((int)this.flagMask, (int[])new int[]{64})) {
                            p.add((Component)new JScrollPane(textField), (Object)"pushx,growx");
                        } else {
                            p.add((Component)textField);
                        }
                        return textField;
                    }

                    public void pack() {
                        this.getDialog().pack();
                    }
                });
            }
        }.start();
    }

    public static Object toJSObject(Object ret) {
        ScriptThread env = ScriptEnvironment.getScriptThread();
        String js = "(function(){ return " + JSonStorage.serializeToJson((Object)ret) + ";}());";
        return env.evalTrusted(js);
    }

    public static String toJson(Object ret) {
        ScriptThread env = ScriptEnvironment.getScriptThread();
        String js = "(function(){ return JSON.stringify(" + JSonStorage.serializeToJson((Object)ret) + ");}());";
        return (String)env.evalTrusted(js);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object requestLock(File name) {
        HashMap<File, AtomicInteger> hashMap = FILE_LOCKS;
        synchronized (hashMap) {
            AtomicInteger existingLock = FILE_LOCKS.get(name);
            if (existingLock == null) {
                AtomicInteger newLock = new AtomicInteger(1);
                FILE_LOCKS.put(name, newLock);
                return newLock;
            }
            existingLock.incrementAndGet();
            return existingLock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unLock(File name) {
        HashMap<File, AtomicInteger> hashMap = FILE_LOCKS;
        synchronized (hashMap) {
            AtomicInteger existingLock = FILE_LOCKS.get(name);
            if (existingLock != null && existingLock.decrementAndGet() == 0) {
                FILE_LOCKS.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScriptAPI(description="Write a text file", parameters={"filepath", "myText", "append"}, example="writeFile(JD_HOME+\"/log.txt\",JSON.stringify(this)+\"\\r\\n\",true);")
    public static void writeFile(String filepath, String string, boolean append) throws EnvironmentException {
        ScriptEnvironment.askForPermission("create a local file and write to it");
        try {
            File file = new File(filepath);
            Object lock = ScriptEnvironment.requestLock(file);
            try {
                Object object = lock;
                synchronized (object) {
                    IO.writeStringToFile((File)file, (String)string, (boolean)append);
                }
            }
            finally {
                ScriptEnvironment.unLock(file);
            }
        }
        catch (Throwable e) {
            throw new EnvironmentException(e);
        }
    }
}

