/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jd.http.Authentication;
import jd.http.AuthenticationFactory;
import jd.http.Browser;
import jd.http.Request;
import org.appwork.utils.Regex;
import org.appwork.utils.net.URLHelper;

public abstract class AbstractAuthenticationFactory
implements AuthenticationFactory {
    protected CopyOnWriteArrayList<Authentication> authentications = new CopyOnWriteArrayList();

    protected boolean requiresAuthentication(Request request) {
        return request.getHttpConnection().getResponseCode() == 401 && this.getWWWAuthenticate(request) != null;
    }

    public boolean containsAuthentication(Authentication authentication) {
        return authentication != null && this.getAuthentications().contains(authentication);
    }

    public boolean addAuthentication(Authentication authentication) {
        return authentication != null && this.getAuthentications().addIfAbsent(authentication);
    }

    public boolean removeAuthentication(Authentication authentication) {
        return authentication != null && this.getAuthentications().remove(authentication);
    }

    public CopyOnWriteArrayList<Authentication> getAuthentications() {
        return this.authentications;
    }

    protected UserInfo getUserInfo(Request request) {
        String[] ret = URLHelper.getUserInfo((URL)request.getURL());
        if (ret == null) {
            return null;
        }
        return new UserInfo(ret[0], ret[1]);
    }

    protected abstract Authentication buildBasicAuthentication(Browser var1, Request var2, String var3);

    protected abstract Authentication buildDigestAuthentication(Browser var1, Request var2, String var3);

    protected abstract Authentication buildBearerAuthentication(Browser var1, Request var2, String var3);

    @Override
    public boolean retry(Authentication authentication, Browser browser, Request request) {
        return authentication != null && this.containsAuthentication(authentication) && authentication.retry(browser, request);
    }

    protected String getRealm(Request request) {
        List<String> wwwAuthenticateMethods = this.getWWWAuthenticate(request);
        if (wwwAuthenticateMethods != null) {
            for (String wwwAuthenticateMethod : wwwAuthenticateMethods) {
                String realm = new Regex(wwwAuthenticateMethod, "realm\\s*=\\s*\"(.*?)\"").getMatch(0);
                if (realm == null) continue;
                return realm;
            }
        }
        return null;
    }

    protected List<String> getWWWAuthenticate(Request request) {
        return request.getResponseHeaders("WWW-Authenticate");
    }

    @Override
    public Authentication buildAuthentication(Browser browser, Request request) {
        List<String> wwwAuthenticateMethods;
        if (request.getAuthentication() == null && this.requiresAuthentication(request) && (wwwAuthenticateMethods = this.getWWWAuthenticate(request)) != null) {
            String realm = this.getRealm(request);
            for (String wwwAuthenticateMethod : wwwAuthenticateMethods) {
                Authentication ret;
                if (wwwAuthenticateMethod.matches("(?i)^\\s*Basic.*")) {
                    ret = this.buildBasicAuthentication(browser, request, realm);
                    if (ret == null) continue;
                    this.addAuthentication(ret);
                    return ret;
                }
                if (wwwAuthenticateMethod.matches("(?i)^\\s*Digest.*")) {
                    ret = this.buildDigestAuthentication(browser, request, realm);
                    if (ret == null) continue;
                    this.addAuthentication(ret);
                    return ret;
                }
                if (!wwwAuthenticateMethod.matches("(?i)^\\s*Bearer.*") || (ret = this.buildBearerAuthentication(browser, request, realm)) == null) continue;
                this.addAuthentication(ret);
                return ret;
            }
        }
        return null;
    }

    @Override
    public Authentication authorize(Browser browser, Request request) {
        for (Authentication authentication : this.getAuthentications()) {
            if (!authentication.authorize(browser, request)) continue;
            return authentication;
        }
        return null;
    }

    protected class UserInfo {
        protected final String user;
        protected final String pass;

        protected UserInfo(String user, String pass) {
            this.user = user;
            this.pass = pass;
        }
    }
}

