/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import jd.http.Authentication;
import jd.http.Browser;
import jd.http.Request;
import jd.nutils.encoding.Encoding;
import org.appwork.utils.StringUtils;

public class BasicAuthentication
extends Authentication {
    public BasicAuthentication(String host, String username, String password, String realm) {
        super(false, host, username, password, realm);
    }

    @Override
    public boolean authorize(Browser browser, Request request) {
        if (StringUtils.endsWithCaseInsensitive((String)request.getURL().getHost(), (String)this.getHost()) && !this.isProxyAuthentication()) {
            String userInfo = StringUtils.valueOrEmpty((String)this.getUsername()) + ":" + StringUtils.valueOrEmpty((String)this.getPassword());
            String auth = Encoding.Base64Encode((String)userInfo);
            request.getHeaders().put("Authorization", "Basic " + auth);
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BasicAuthentication)) {
            return false;
        }
        BasicAuthentication other = (BasicAuthentication)obj;
        if (!StringUtils.equals((String)this.getHost(), (String)other.getHost())) {
            return false;
        }
        if (!StringUtils.equals((String)this.getUsername(), (String)other.getUsername())) {
            return false;
        }
        if (!StringUtils.equals((String)this.getPassword(), (String)other.getPassword())) {
            return false;
        }
        return StringUtils.equals((String)this.getRealm(), (String)other.getRealm());
    }

    public int hashCode() {
        return BasicAuthentication.class.hashCode();
    }

    @Override
    public boolean retry(Browser browser, Request request) {
        return false;
    }

    public String toString() {
        return "Basic-Authorization[Host:" + this.getHost() + "|Realm:" + this.getRealm() + "|Username:" + this.getUsername() + "|Password:" + this.getPassword() + "]";
    }
}

