/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import jd.http.BrowserSettings;
import jd.http.ProxySelectorInterface;
import org.appwork.utils.logging2.LogInterface;

public class BrowserSettingsThread
extends Thread
implements BrowserSettings {
    private ProxySelectorInterface proxySelector;
    private boolean debug;
    private boolean verbose;
    protected LogInterface logger;

    public BrowserSettingsThread() {
        this.copySettings();
    }

    public BrowserSettingsThread(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
        this.copySettings();
    }

    public BrowserSettingsThread(ThreadGroup group, Runnable target) {
        super(group, target);
        this.copySettings();
    }

    public BrowserSettingsThread(ThreadGroup group, String name) {
        super(group, name);
        this.copySettings();
    }

    public BrowserSettingsThread(Runnable r) {
        super(r);
        this.copySettings();
    }

    public BrowserSettingsThread(Runnable r, String name) {
        super(r, name);
        this.copySettings();
    }

    public BrowserSettingsThread(String name) {
        super(name);
        this.copySettings();
    }

    private void copySettings() {
        Thread currentThread = Thread.currentThread();
        if (currentThread != null && currentThread instanceof BrowserSettings) {
            BrowserSettings settings = (BrowserSettings)((Object)currentThread);
            this.proxySelector = settings.getProxySelector();
            this.debug = settings.isDebug();
            this.verbose = settings.isVerbose();
            this.logger = settings.getLogger();
        }
    }

    public static ProxySelectorInterface getThreadProxySelector() {
        Thread currentThread = Thread.currentThread();
        if (currentThread != null && currentThread instanceof BrowserSettings) {
            BrowserSettings settings = (BrowserSettings)((Object)currentThread);
            return settings.getProxySelector();
        }
        return null;
    }

    @Override
    public ProxySelectorInterface getProxySelector() {
        return this.proxySelector;
    }

    @Override
    public LogInterface getLogger() {
        return this.logger;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setProxySelector(ProxySelectorInterface proxy) {
        this.proxySelector = proxy;
    }

    @Override
    public void setDebug(boolean b) {
        this.debug = b;
    }

    @Override
    public void setLogger(LogInterface logger) {
        this.logger = logger;
    }

    @Override
    public void setVerbose(boolean b) {
        this.verbose = b;
    }
}

