/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.util.Date;
import java.util.Locale;
import jd.http.Browser;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.logging2.extmanager.LoggerFactory;

public class Cookie {
    private String path = null;
    private String host = null;
    private String value = null;
    private String key = null;
    private Boolean secure = null;
    private String domain = null;
    private long hostTime = -1L;
    private long creationTime = System.currentTimeMillis();
    private long expireTime = -1L;

    public Boolean isSecure() {
        return this.secure;
    }

    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    public Cookie() {
    }

    public Cookie(String host, String key, String value) {
        this.setHost(host);
        this.setKey(key);
        this.setValue(value);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Cookie)) {
            return false;
        }
        Cookie other = (Cookie)obj;
        if (!StringUtils.equalsIgnoreCase((String)this.getHost(), (String)other.getHost())) {
            return false;
        }
        if (!StringUtils.equals((String)this.getKey(), (String)other.getKey())) {
            return false;
        }
        return StringUtils.equals((String)this.getPath(), (String)other.getPath());
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getDomain() {
        return this.domain;
    }

    public long getExpireDate() {
        return this.expireTime;
    }

    public String getHost() {
        return this.host;
    }

    public long getHostTime() {
        return this.hostTime;
    }

    public String getKey() {
        return this.key;
    }

    public String getPath() {
        if (this.path != null) {
            return this.path;
        }
        return "/";
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return (this.getHost() + "_" + this.getKey().toLowerCase(Locale.ENGLISH)).hashCode();
    }

    public boolean isExpired() {
        if (this.expireTime == -1L) {
            return false;
        }
        if (this.hostTime == -1L) {
            return false;
        }
        long timediff = this.creationTime - this.hostTime;
        long check = System.currentTimeMillis() - timediff;
        boolean expired = check > this.expireTime;
        return expired;
    }

    public void setCreationTime(long time) {
        this.creationTime = time;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setExpireDate(long time) {
        this.expireTime = time;
    }

    public void setExpires(String expires) {
        if (expires == null) {
            this.expireTime = -1L;
            return;
        }
        Date expireDate = TimeFormatter.parseDateString((String)expires);
        if (expireDate != null) {
            this.expireTime = expireDate.getTime();
            return;
        }
        this.expireTime = -1L;
        LoggerFactory.getDefaultLogger().severe("Cookie: no Format for " + expires + " found!");
    }

    public void setHost(String host) {
        this.host = Browser.getHost(host);
    }

    public void setHostTime(long time) {
        this.hostTime = time;
    }

    public void setHostTime(String date) {
        if (date == null) {
            this.hostTime = -1L;
            return;
        }
        Date responseDate = TimeFormatter.parseDateString((String)date);
        if (responseDate != null) {
            this.hostTime = responseDate.getTime();
            return;
        }
        this.hostTime = -1L;
        LoggerFactory.getDefaultLogger().severe("Cookie: no Format for " + date + " found!");
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setPath(String path) {
        this.path = StringUtils.isEmpty((String)path) ? null : path;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return this.getKey() + "=" + this.getValue() + " @" + this.getHost();
    }

    protected synchronized void update(Cookie cookie2) {
        this.setCreationTime(cookie2.getCreationTime());
        this.setExpireDate(cookie2.getExpireDate());
        this.setValue(cookie2.getValue());
        this.setHostTime(cookie2.getHostTime());
    }
}

