/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.dialog;

import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import jd.controlling.AccountController;
import jd.controlling.accountchecker.AccountChecker;
import jd.gui.swing.dialog.HosterChooserTable;
import jd.gui.swing.dialog.InputOKButtonAdapter;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.RefreshAction;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.PluginForHost;
import net.miginfocom.swing.MigLayout;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.swing.components.ExtTextField;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.ListFocusTraversalPolicy;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.appwork.utils.swing.dialog.ProgressDialog;
import org.appwork.utils.swing.dialog.dimensor.DialogDimensor;
import org.appwork.utils.swing.dialog.dimensor.RememberLastDialogDimension;
import org.appwork.utils.swing.dialog.locator.DialogLocator;
import org.appwork.utils.swing.dialog.locator.RememberRelativeDialogLocator;
import org.jdownloader.gui.InputChangedCallbackInterface;
import org.jdownloader.gui.sponsor.SponsorUtils;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.accounts.AccountBuilderInterface;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.UpdateRequiredClassNotFoundException;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.plugins.controller.host.PluginFinder;
import org.jdownloader.translate._JDT;

public class AddAccountDialog
extends AbstractDialog<Integer>
implements InputChangedCallbackInterface {
    private HosterChooserTable hosterTable;
    private JPanel content;
    private final PluginClassLoader.PluginClassLoaderChild cl;
    protected MouseAdapter mouseAdapter;
    private ExtTextField filter;
    private JLabel header2;
    private JButton link;
    private List<Component> inputComponents;
    private final PluginForHost preSelectedPlugin;
    private Account preFillAccount;
    private AccountBuilderInterface currentAccountBuilder;

    public static void showDialog(PluginForHost preSelectedPlugin, Account preFillAccount) {
        try {
            while (true) {
                AddAccountDialog dialog = new AddAccountDialog(preSelectedPlugin, preFillAccount);
                Dialog.getInstance().showDialog((AbstractDialog)dialog);
                if (dialog.getHoster() == null) {
                    return;
                }
                Account accountToAdd = dialog.getAccount();
                accountToAdd.setHoster(dialog.getHoster().getDisplayName());
                if (AddAccountDialog.addAccount(accountToAdd)) {
                    return;
                }
                preSelectedPlugin = dialog.getHoster().getPrototype(null);
                preFillAccount = accountToAdd;
            }
        }
        catch (DialogNoAnswerException dialog) {
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
    }

    public static boolean addAccount(Account ac) throws DialogNoAnswerException {
        AccountInfo ai;
        try {
            AddAccountDialog.checkAccount(ac);
        }
        catch (DialogNoAnswerException e) {
            throw e;
        }
        catch (Throwable e) {
            Dialog.getInstance().showExceptionDialog(_GUI.T.accountdialog_check_failed(), _GUI.T.accountdialog_check_failed_msg(), e);
        }
        Account.AccountError error = ac.getError();
        String errorMessage = ac.getErrorString();
        if (StringUtils.isEmpty((String)errorMessage) && (ai = ac.getAccountInfo()) != null) {
            errorMessage = ai.getStatus();
        }
        if (error != null) {
            switch (error) {
                case PLUGIN_ERROR: {
                    if (StringUtils.isEmpty((String)errorMessage)) {
                        errorMessage = _JDT.T.AccountController_updateAccountInfo_status_plugin_defect();
                    }
                    Dialog.getInstance().showMessageDialog(_GUI.T.accountdialog_check_invalid(errorMessage));
                    return false;
                }
                case EXPIRED: {
                    Dialog.getInstance().showConfirmDialog(0, _GUI.T.accountdialog_check_expired_title(), _GUI.T.accountdialog_check_expired(ac.getUser()), null, _GUI.T.accountdialog_check_expired_renew(), null);
                    AccountController.getInstance().addAccount(ac, false);
                    return true;
                }
                case TEMP_DISABLED: {
                    if (StringUtils.isEmpty((String)errorMessage)) {
                        errorMessage = _GUI.T.accountdialog_check_failed();
                    }
                    Dialog.getInstance().showMessageDialog(_GUI.T.accountdialog_check_result(errorMessage));
                    AccountController.getInstance().addAccount(ac, false);
                    return true;
                }
            }
            if (StringUtils.isEmpty((String)errorMessage)) {
                errorMessage = _GUI.T.accountdialog_check_failed_msg();
            }
            Dialog.getInstance().showMessageDialog(_GUI.T.accountdialog_check_invalid(errorMessage));
            return false;
        }
        String message = null;
        AccountInfo ai2 = ac.getAccountInfo();
        if (ai2 != null) {
            message = ai2.getStatus();
        }
        if (StringUtils.isEmpty(message)) {
            message = _GUI.T.lit_yes();
        }
        Dialog.getInstance().showMessageDialog(_GUI.T.accountdialog_check_valid(message));
        AccountController.getInstance().addAccount(ac, false);
        if (ac.isMultiHost()) {
            RefreshAction.displayMultihosterDetailOverviewHelpDialog();
        }
        return true;
    }

    public static ProgressDialog checkAccount(final Account ac) throws Throwable {
        ProgressDialog pd = new ProgressDialog(new ProgressDialog.ProgressGetter(){

            public void run() throws Exception {
                PluginForHost hostPlugin = new PluginFinder().assignPlugin(ac, true);
                if (hostPlugin != null) {
                    ac.setPlugin(hostPlugin);
                }
                AccountChecker.AccountCheckJob job = AccountChecker.getInstance().check(ac, true);
                job.waitChecked();
            }

            public String getString() {
                return null;
            }

            public int getProgress() {
                return -1;
            }

            public String getLabelString() {
                return null;
            }
        }, 0, _GUI.T.accountdialog_check(), _GUI.T.accountdialog_check_msg(), ac.getDomainInfo().getFavIcon());
        try {
            Dialog.getInstance().showDialog((AbstractDialog)pd);
        }
        catch (DialogCanceledException e) {
            if (pd.getThrowable() == null) {
                throw e;
            }
            throw pd.getThrowable();
        }
        return pd;
    }

    private AddAccountDialog(PluginForHost preSelectedPlugin, Account preFillAccount) {
        super(256, _GUI.T.jd_gui_swing_components_AccountDialog_title(), null, _GUI.T.lit_save(), null);
        this.preFillAccount = preFillAccount;
        this.preSelectedPlugin = preSelectedPlugin;
        this.cl = PluginClassLoader.getInstance().getChild();
        this.setLocator((DialogLocator)new RememberRelativeDialogLocator("AddAccountDialog2", (Window)((Object)JDGui.getInstance().getMainFrame())));
        this.setDimensor((DialogDimensor)new RememberLastDialogDimension("AddAccountDialog2"));
    }

    protected Integer createReturnValue() {
        return this.getReturnmask();
    }

    protected void initFocus(JComponent focus) {
    }

    public JComponent layoutDialogContent() {
        Collection allPLugins = HostPluginController.getInstance().list();
        ArrayList<LazyHostPlugin> plugins = new ArrayList<LazyHostPlugin>();
        for (LazyHostPlugin lhp : allPLugins) {
            if (!lhp.isPremium()) continue;
            plugins.add(lhp);
        }
        if (plugins.size() == 0) {
            throw new RuntimeException("No Plugins Loaded Exception");
        }
        this.filter = new ExtTextField(){
            private static final long serialVersionUID = 1L;

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                Composite comp = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(3, 0.6f));
                new AbstractIcon("search", 16).paintIcon((Component)((Object)this), (Graphics)g2, 3, 3);
                g2.setComposite(comp);
            }
        };
        this.filter.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                AddAccountDialog.this.filter.selectAll();
            }
        });
        this.filter.setHelpText("Search Plugins");
        this.filter.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40) {
                    AddAccountDialog.this.hosterTable.onKeyDown();
                }
                if (e.getKeyCode() == 38) {
                    AddAccountDialog.this.hosterTable.onKeyUp();
                }
            }
        });
        this.filter.setBorder((Border)BorderFactory.createCompoundBorder(this.filter.getBorder(), BorderFactory.createEmptyBorder(0, 20, 0, 0)));
        this.hosterTable = new HosterChooserTable(plugins){
            private LazyHostPlugin lazyHostPlugin;
            {
                this.lazyHostPlugin = null;
            }

            protected void processEvent(AWTEvent e) {
                if (e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 9) {
                    AddAccountDialog.this.content.dispatchEvent(e);
                    return;
                }
                super.processEvent(e);
            }

            protected boolean processKeyBinding(KeyStroke stroke, KeyEvent evt, int condition, boolean pressed) {
                return super.processKeyBinding(stroke, evt, condition, pressed);
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                if (e.getValueIsAdjusting() || this.getModel().isTableSelectionClearing()) {
                    return;
                }
                try {
                    PluginForHost ret;
                    PluginForHost plg;
                    this.scrollToSelection(0);
                    LazyHostPlugin selected = this.getSelectedPlugin();
                    PluginForHost pluginForHost = plg = selected != null ? selected.newInstance(AddAccountDialog.this.cl) : null;
                    if (!(plg == null || this.lazyHostPlugin != null && this.lazyHostPlugin.equals((Object)plg.getLazyP()) || (ret = AddAccountDialog.this.updatePanel(plg)) == null)) {
                        this.lazyHostPlugin = ret.getLazyP();
                    }
                }
                catch (UpdateRequiredClassNotFoundException e1) {
                    e1.printStackTrace();
                }
            }
        };
        this.filter.getDocument().addDocumentListener(new DocumentListener(){
            private DelayedRunnable delayedRefresh = new DelayedRunnable(200L, 1000L){
                String lastText;
                {
                    this.lastText = null;
                }

                public String getID() {
                    return "AddAccountDialog";
                }

                public void delayedrun() {
                    new EDTRunner(){

                        protected void runInEDT() {
                            String text = AddAccountDialog.this.filter.getText();
                            if (!StringUtils.equals((String)lastText, (String)text)) {
                                lastText = text;
                                AddAccountDialog.this.hosterTable.refresh(text);
                            }
                        }
                    }.waitForEDT();
                }
            };

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.delayedRefresh.resetAndStart();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.delayedRefresh.resetAndStart();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.delayedRefresh.resetAndStart();
            }
        });
        this.link = new JButton((Icon)new AbstractIcon("money", 16));
        this.link.setText(_GUI.T.gui_menu_action_premium_buy_name());
        this.link.setToolTipText(_GUI.T.gui_menu_action_premium_buy_name());
        this.link.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LazyHostPlugin selected = AddAccountDialog.this.hosterTable.getSelectedPlugin();
                AccountController.openAfflink((LazyHostPlugin)selected, null, (String)"accountmanager/table");
            }
        });
        this.link.setFocusable(false);
        this.content = new JPanel((LayoutManager)new MigLayout("ins 0, wrap 1", "[grow,fill]"));
        this.content.add((Component)this.header(_GUI.T.AddAccountDialog_layoutDialogContent_choosehoster_()), "gapleft 15,spanx,pushx,growx");
        this.content.add((Component)this.filter, "gapleft 32,pushx,growx");
        JScrollPane sp = new JScrollPane((Component)((Object)this.hosterTable));
        this.content.add((Component)sp, "gapleft 32,pushy,growy");
        sp.setFocusable(false);
        sp.getVerticalScrollBar().setFocusable(false);
        sp.getViewport().setFocusable(false);
        this.content.add((Component)this.link, "height 20!,gapleft 32");
        this.header2 = this.header(_GUI.T.AddAccountDialog_layoutDialogContent_enterlogininfo());
        this.content.add((Component)this.header2, "gapleft 15,spanx,pushx,growx,gaptop 15");
        LazyHostPlugin lazyp = this.getPreselectedHost();
        if (lazyp != null) {
            this.hosterTable.setSelectedPlugin(lazyp);
        }
        this.getDialog().addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent windowevent) {
            }

            @Override
            public void windowGainedFocus(WindowEvent windowevent) {
                Component focusOwner = AddAccountDialog.this.getDialog().getFocusOwner();
                if (focusOwner != null) {
                    return;
                }
                AddAccountDialog.this.getDialog().removeWindowFocusListener((WindowFocusListener)this);
                AddAccountDialog.this.focusFirstInputComponent();
            }
        });
        this.getDialog().setMinimumSize(new Dimension(400, 300));
        return this.content;
    }

    protected LazyHostPlugin getPreselectedHost() {
        String preSelectedHost;
        if (this.preSelectedPlugin != null) {
            return this.preSelectedPlugin.getLazyP();
        }
        HostPluginController hc = HostPluginController.getInstance();
        LazyHostPlugin ret = hc.get(preSelectedHost = SponsorUtils.getSponsor().getPreSelectedInAddAccountDialog());
        if (ret != null) {
            return ret;
        }
        ret = hc.get("rapidgator.net");
        if (ret != null) {
            return ret;
        }
        ret = (LazyHostPlugin)hc.list().iterator().next();
        return ret;
    }

    protected int getPreferredWidth() {
        return 600;
    }

    protected int getPreferredHeight() {
        return 450;
    }

    public LazyHostPlugin getHoster() {
        return this.hosterTable.getSelectedPlugin();
    }

    private Account getAccount() {
        AccountBuilderInterface accountBuilder = this.currentAccountBuilder;
        if (accountBuilder == null) {
            return null;
        }
        return accountBuilder.getAccount();
    }

    private PluginForHost updatePanel(PluginForHost selectedPlugin) {
        try {
            if (this.content == null) {
                return null;
            }
            if (selectedPlugin == null) {
                selectedPlugin = this.getPreselectedHost().newInstance(this.cl);
            }
            this.link.setText(_GUI.T.gui_menu_action_premium_buy_name2(selectedPlugin.getHost()));
            this.header2.setText(_GUI.T.AddAccountDialog_layoutDialogContent_enterlogininfo2(selectedPlugin.getHost()));
            if (this.currentAccountBuilder != null) {
                this.preFillAccount = this.currentAccountBuilder.getAccount();
                if (this.preFillAccount != null && StringUtils.firstNotEmpty((String[])new String[]{this.preFillAccount.getUser(), this.preFillAccount.getPass()}) == null) {
                    this.preFillAccount = null;
                }
                this.content.remove(this.currentAccountBuilder.getComponent());
            }
            AccountBuilderInterface accountFactory = this.currentAccountBuilder = selectedPlugin.getAccountFactory((InputChangedCallbackInterface)this);
            JComponent comp = accountFactory.getComponent();
            this.content.add((Component)comp, "gapleft 32,spanx");
            if (this.preFillAccount != null) {
                accountFactory.setAccount(this.preFillAccount);
            } else if (accountFactory.handleClipboardAutoFill()) {
                accountFactory.validateInputs();
            }
            ArrayList<Object> focusOrder = new ArrayList<Object>();
            focusOrder.add(this.filter);
            this.inputComponents = ListFocusTraversalPolicy.getFocusableComponents((Container)comp);
            focusOrder.addAll(this.inputComponents);
            focusOrder.add(this.okButton);
            focusOrder.add(this.cancelButton);
            this.dialog.setFocusTraversalPolicyProvider(true);
            this.dialog.setFocusTraversalPolicy((FocusTraversalPolicy)new ListFocusTraversalPolicy(focusOrder));
            this.onChangedInput(null);
            return selectedPlugin;
        }
        catch (UpdateRequiredClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.hosterTable != null && this.hosterTable.getSelectedPlugin() != null && this.currentAccountBuilder != null && this.currentAccountBuilder.validateInputs()) {
                super.actionPerformed(e);
            }
        } else {
            super.actionPerformed(e);
        }
    }

    private JLabel header(String buyAndAddPremiumAccount_layoutDialogContent_get) {
        JLabel ret = SwingUtils.toBold((JLabel)new JLabel(buyAndAddPremiumAccount_layoutDialogContent_get));
        ret.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ret.getForeground()));
        return ret;
    }

    public void windowGainedFocus(WindowEvent e) {
        super.windowGainedFocus(e);
        this.focusFirstInputComponent();
    }

    public void onChangedInput(Object component) {
        InputOKButtonAdapter.register(this, this.currentAccountBuilder);
    }

    protected void focusFirstInputComponent() {
        this.filter.requestFocus();
    }
}

