/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui;

import de.javasoft.plaf.synthetica.SyntheticaRootPaneUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import jd.SecondLevelLaunch;
import jd.config.ConfigContainer;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.gui.swing.jdgui.FlashController;
import jd.gui.swing.jdgui.JDownloaderMainFrame;
import jd.gui.swing.jdgui.MainFrameClosingHandler;
import jd.gui.swing.jdgui.MainTabbedPane;
import jd.gui.swing.jdgui.TopRightPainter;
import jd.gui.swing.jdgui.WarnLevel;
import jd.gui.swing.jdgui.components.StatusBarImpl;
import jd.gui.swing.jdgui.components.speedmeter.SpeedMeterPanel;
import jd.gui.swing.jdgui.components.toolbar.MainToolBar;
import jd.gui.swing.jdgui.interfaces.View;
import jd.gui.swing.jdgui.menu.JDMenuBar;
import jd.gui.swing.jdgui.views.myjd.MyJDownloaderView;
import jd.gui.swing.jdgui.views.settings.ConfigurationView;
import jd.gui.swing.jdgui.views.settings.sidebar.AddonConfig;
import net.miginfocom.swing.MigLayout;
import org.appwork.Counter;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.components.ExtButton;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.uio.CloseReason;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Application;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.Files;
import org.appwork.utils.Hash;
import org.appwork.utils.IO;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.speedmeter.SpeedMeterInterface;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.DefaultButtonPanel;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.DialogHandler;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.appwork.utils.swing.dialog.InternDialog;
import org.appwork.utils.swing.dialog.OwnerFinder;
import org.appwork.utils.swing.dialog.WindowStack;
import org.appwork.utils.swing.dialog.WindowZHandler;
import org.appwork.utils.swing.dialog.locator.DialogLocator;
import org.appwork.utils.swing.dialog.locator.RememberRelativeDialogLocator;
import org.appwork.utils.swing.locator.AbstractLocator;
import org.appwork.utils.swing.locator.CenterOfScreenLocator;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.crosssystem.idlegetter.IdleGetter;
import org.jdownloader.gui.GuiUtils;
import org.jdownloader.gui.KeyObserver;
import org.jdownloader.gui.helpdialogs.HelpDialog;
import org.jdownloader.gui.helpdialogs.MessageConfig;
import org.jdownloader.gui.jdtrayicon.TrayConfig;
import org.jdownloader.gui.jdtrayicon.TrayExtension;
import org.jdownloader.gui.notify.BubbleNotify;
import org.jdownloader.gui.sponsor.Sponsor;
import org.jdownloader.gui.sponsor.SponsorUtils;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.DownloadsView;
import org.jdownloader.gui.views.downloads.contextmenumanager.MenuManagerDownloadTableContext;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberView;
import org.jdownloader.gui.views.linkgrabber.contextmenu.MenuManagerLinkgrabberTableContext;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.FrameStatus;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.SilentModeSettings;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.settings.staticreferences.CFG_SILENTMODE;
import org.jdownloader.updatev2.InstallLog;
import org.jdownloader.updatev2.RestartController;
import org.jdownloader.updatev2.RestartRequest;
import org.jdownloader.updatev2.SmartRlyExitRequest;
import org.jdownloader.updatev2.SmartRlyRestartRequest;
import org.jdownloader.updatev2.UpdateController;
import org.jdownloader.updatev2.UpdateHandler;
import org.jdownloader.updatev2.UpdaterListener;

public class JDGui
implements UpdaterListener,
OwnerFinder {
    private static final String TITLE_PATTERN_UPDATE = "\\|([^\\|]*)\\#UPDATENOTIFY([^\\|]*)\\|";
    private static final String TITLE_PATTERN_TITLE = "\\|([^\\|]*)\\#TITLE([^\\|]*)\\|";
    private static final String TITLE_PATTERN_SPEED_AVERAGE = "\\|([^\\|]*)\\#AVGSPEED([^\\|]*)\\|";
    private static final String TITLE_PATTERN_RUNNING_DOWNLOADS = "\\|([^\\|]*)\\#RUNNING_DOWNLOADS([^\\|]*)\\|";
    private static final String TITLE_PATTERN_SPEED = "\\|([^\\|]*)\\#SPEED([^\\|]*)\\|";
    private static volatile JDGui INSTANCE;
    private MainFrameClosingHandler closingHandler;
    private DownloadsView downloadView;
    private Thread initThread = null;
    private LinkGrabberView linkgrabberView;
    private LogSource logger;
    protected JDownloaderMainFrame mainFrame;
    private MainTabbedPane mainTabbedPane;
    private JDMenuBar menuBar;
    private StatusBarImpl statusBar;
    private MainToolBar toolBar;
    private final TrayExtension tray;
    private Thread trayIconChecker;
    private JPanel waitingPane;
    private volatile Timer speedInTitleUpdater;
    private boolean busy;
    protected FrameStatus stateForNextVisible = null;
    private final FlashController flashController = new FlashController();

    public static JDGui getInstance() {
        return INSTANCE;
    }

    public static void help(final String title, final String msg, final Icon icon) {
        Timer timer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpDialog.showIfAllowed((MessageConfig)new MessageConfig(32, title, msg, icon));
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    private JDGui() {
        this.logger = LogController.getInstance().getLogger("Gui");
        this.initFrame("JDownloader");
        AbstractDialog.setDefaultRoot((Window)((Object)this.getMainFrame()));
        this.updateTitle();
        this.mainFrame.setName("MAINFRAME");
        UpdateController.getInstance().getEventSender().addListener((EventListener)((Object)this), true);
        this.initDialogLocators();
        AbstractDialog.setGlobalOwnerFinder((OwnerFinder)this);
        this.initDefaults();
        this.initComponents();
        this.setWindowIcon();
        this.layoutComponents();
        this.tray = new TrayExtension();
        try {
            this.tray.init();
        }
        catch (Exception e1) {
            this.logger.log((Throwable)e1);
        }
        this.initLocationAndDimension();
        this.initToolTipSettings();
        this.initUpdateFrameListener();
        this.initCaptchaToFrontListener();
        this.initShiftControlSWindowResetKeyListener();
        SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                JDGui.this.onGuiInitComplete();
            }
        });
        this.initSilentModeHooks();
        KeyObserver.getInstance();
        BubbleNotify.getInstance();
        this.setSpeedInTitleUpdaterEnabled(CFG_GUI.SPEED_IN_WINDOW_TITLE.getValue() != GraphicalUserInterfaceSettings.ShowSpeedInWindowTitleTrigger.NEVER);
        CFG_GUI.SPEED_IN_WINDOW_TITLE.getStorageHandler().getEventSender().addListener((EventListener)new GenericConfigEventListener<Object>(){

            public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
                JDGui.this.setSpeedInTitleUpdaterEnabled(CFG_GUI.SPEED_IN_WINDOW_TITLE.getValue() != GraphicalUserInterfaceSettings.ShowSpeedInWindowTitleTrigger.NEVER);
            }

            public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
            }
        });
        this.getMainFrame().setAlwaysOnTop(CFG_GUI.MAIN_WINDOW_ALWAYS_ON_TOP.isEnabled());
        CFG_GUI.MAIN_WINDOW_ALWAYS_ON_TOP.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                new EDTRunner(){

                    protected void runInEDT() {
                        JDGui.this.getMainFrame().setAlwaysOnTop(CFG_GUI.MAIN_WINDOW_ALWAYS_ON_TOP.isEnabled());
                    }
                };
            }

            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
            }
        });
        SecondLevelLaunch.UPDATE_HANDLER_SET.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                final UpdateHandler handler = UpdateController.getInstance().getHandler();
                if (handler != null) {
                    handler.setGuiAlwaysOnTop(CFG_GUI.MAIN_WINDOW_ALWAYS_ON_TOP.isEnabled());
                    CFG_GUI.MAIN_WINDOW_ALWAYS_ON_TOP.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

                        public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                            handler.setGuiAlwaysOnTop(CFG_GUI.MAIN_WINDOW_ALWAYS_ON_TOP.isEnabled());
                        }

                        public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
                        }
                    });
                }
            }
        });
        this.getMainFrame().addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                JDGui.this.menuBar.repaint();
                JDGui.this.toolBar.repaint();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                JDGui.this.menuBar.repaint();
                JDGui.this.toolBar.repaint();
            }
        });
    }

    private void setSpeedInTitleUpdaterEnabled(final boolean enabled) {
        new EDTRunner(){

            protected void runInEDT() {
                if (JDGui.this.speedInTitleUpdater != null) {
                    JDGui.this.speedInTitleUpdater.stop();
                    JDGui.this.speedInTitleUpdater = null;
                }
                if (enabled) {
                    JDGui.this.speedInTitleUpdater = new Timer(1000, new ActionListener(){
                        boolean lastIsRunning = false;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (JDGui.this.speedInTitleUpdater == e.getSource()) {
                                boolean isRunning = DownloadWatchDog.getInstance().isRunning();
                                if (this.lastIsRunning != isRunning || isRunning) {
                                    this.lastIsRunning = isRunning;
                                    JDGui.this.updateTitle();
                                }
                            } else {
                                ((Timer)e.getSource()).stop();
                            }
                        }
                    });
                    JDGui.this.speedInTitleUpdater.setRepeats(true);
                    JDGui.this.speedInTitleUpdater.start();
                }
            }
        };
    }

    public void disposeView(View view) {
        if (view == null) {
            return;
        }
        if ((view = this.mainTabbedPane.getComponentEquals(view)) == null) {
            return;
        }
        this.mainTabbedPane.remove(view);
    }

    public Window findDialogOwner(AbstractDialog<?> dialogModel, WindowStack windowStack) {
        return AbstractDialog.DEFAULT_OWNER_FINDER.findDialogOwner(dialogModel, windowStack);
    }

    public void flashTaskbar() {
        if (((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).isTaskBarFlashEnabled()) {
            new EDTRunner(){

                protected void runInEDT() {
                    int state = JDGui.this.mainFrame.getExtendedState();
                    try {
                        if (state == FrameStatus.ExtendedState.ICONIFIED.getId()) {
                            GuiUtils.flashWindow((Window)((Object)JDGui.this.mainFrame), (boolean)true);
                        } else {
                            GuiUtils.flashWindow((Window)((Object)JDGui.this.mainFrame), (boolean)false);
                        }
                    }
                    catch (Exception e) {
                        JDGui.this.logger.log((Throwable)e);
                    }
                }
            };
        }
    }

    public MainFrameClosingHandler getClosingHandler() {
        return this.closingHandler;
    }

    public Thread getInitThread() {
        return this.initThread;
    }

    public LogSource getLogger() {
        return this.logger;
    }

    public JDownloaderMainFrame getMainFrame() {
        return this.mainFrame;
    }

    public MainTabbedPane getMainTabbedPane() {
        return this.mainTabbedPane;
    }

    public StatusBarImpl getStatusBar() {
        return this.statusBar;
    }

    public TrayExtension getTray() {
        return this.tray;
    }

    public void initCaptchaToFrontListener() {
        this.mainFrame.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                if (e.getOppositeWindow() == null) {
                    for (Window w : Window.getWindows()) {
                        Window owner;
                        if (!(w instanceof InternDialog) || ((InternDialog)w).getDialogModel().isDisposed() || (owner = ((InternDialog)w).getOwner()) != null || !w.isVisible()) continue;
                        WindowManager.getInstance().setZState(w, WindowManager.FrameState.TO_FRONT_FOCUSED);
                    }
                }
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
    }

    private void initComponents() {
        this.menuBar = JDMenuBar.getInstance();
        this.statusBar = new StatusBarImpl();
        this.waitingPane = new JPanel();
        this.waitingPane.setOpaque(false);
        this.mainTabbedPane = MainTabbedPane.getInstance();
        this.toolBar = MainToolBar.getInstance();
        this.toolBar.registerAccelerators(this);
        this.downloadView = new DownloadsView();
        this.linkgrabberView = new LinkGrabberView();
        this.mainTabbedPane.addTab((View)this.downloadView);
        this.mainTabbedPane.addTab((View)this.linkgrabberView);
        SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                new EDTRunner(){

                    protected void runInEDT() {
                        if (((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).isConfigViewVisible()) {
                            JDGui.this.mainTabbedPane.addTab(ConfigurationView.getInstance());
                        }
                        if (((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).isMyJDownloaderViewVisible()) {
                            JDGui.this.mainTabbedPane.addTab(MyJDownloaderView.getInstance());
                        }
                        long maxHeap = -1L;
                        try {
                            MemoryUsage memory = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
                            maxHeap = memory.getMax();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (maxHeap > 0L && maxHeap < 0x6400000L) {
                            new Thread("AskForRestart"){

                                @Override
                                public void run() {
                                    ConfirmDialog d = new ConfirmDialog(1056, _GUI.T.MEMORY_RESTART_TITLE(), _GUI.T.MEMORY_RESTART_MSG(), (Icon)new AbstractIcon("restart", 32), _GUI.T.lit_restart(), null){

                                        public Dialog.ModalityType getModalityType() {
                                            return Dialog.ModalityType.MODELESS;
                                        }

                                        protected DefaultButtonPanel getDefaultButtonPanel() {
                                            DefaultButtonPanel ret = super.getDefaultButtonPanel();
                                            ret.add((Component)new ExtButton((AbstractAction)new AppAction(){
                                                {
                                                    this.setName(_GUI.T.memory_chat());
                                                }

                                                public void actionPerformed(ActionEvent e) {
                                                    CrossSystem.openURL((String)"https://jdownloader.org/knowledge/chat");
                                                }
                                            }));
                                            return ret;
                                        }
                                    };
                                    UIOManager.I().show(null, (UserIODefinition)d);
                                    if (d.getCloseReason() == CloseReason.OK) {
                                        RestartController.getInstance().asyncRestart((RestartRequest)new SmartRlyRestartRequest(true));
                                    }
                                }
                            }.start();
                        }
                    }
                };
                SecondLevelLaunch.EXTENSIONS_LOADED.executeWhenReached(new Runnable(){

                    @Override
                    public void run() {
                        MenuManagerDownloadTableContext.getInstance().getMenuData();
                        MenuManagerLinkgrabberTableContext.getInstance().getMenuData();
                    }
                });
            }
        });
        this.mainTabbedPane.setSelectedComponent((Component)this.downloadView);
        if (CrossSystem.isMac()) {
            KeyStroke closeKey = KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            this.mainTabbedPane.getInputMap(2).put(closeKey, "closeWindow");
            this.mainTabbedPane.getActionMap().put("closeWindow", new AbstractAction(){
                private static final long serialVersionUID = 9149139888018750308L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    new EDTHelper<Object>(){

                        public Object edtRun() {
                            WindowManager.getInstance().setVisible((Window)((Object)JDGui.this.getMainFrame()), false, WindowManager.FrameState.OS_DEFAULT);
                            return null;
                        }
                    }.start();
                }
            });
        }
    }

    private void initDefaults() {
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.out.println("WIndow Closing " + e);
                if (e.getComponent() == JDGui.this.getMainFrame()) {
                    if (JDGui.this.closingHandler != null) {
                        System.out.println("Close Handler");
                        JDGui.this.closingHandler.windowClosing(e);
                        return;
                    }
                    if (CrossSystem.isMac()) {
                        new EDTHelper<Object>(){

                            public Object edtRun() {
                                WindowManager.getInstance().setVisible((Window)((Object)JDGui.this.getMainFrame()), false, WindowManager.FrameState.OS_DEFAULT);
                                return null;
                            }
                        }.start();
                        return;
                    }
                    RestartController.getInstance().exitAsynch((ShutdownRequest)new SmartRlyExitRequest());
                }
            }
        });
        ToolTipManager.sharedInstance().setReshowDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(6000);
    }

    public void initDialogLocators() {
        RememberRelativeDialogLocator locator = new RememberRelativeDialogLocator("", (Window)((Object)this.mainFrame)){

            private String getAutoWindowID(Window window) {
                Class<?> windowClass;
                if (window instanceof InternDialog) {
                    AbstractDialog dialog = ((InternDialog)window).getDialogModel();
                    windowClass = dialog.getClass();
                } else {
                    windowClass = window.getClass();
                }
                String title = "";
                if (window instanceof Dialog) {
                    title = ((Dialog)window).getTitle();
                }
                if (StringUtils.isEmpty((String)title) && window instanceof Frame) {
                    title = ((Frame)window).getTitle();
                }
                return windowClass.getName().replaceAll("[\\d\\$]+$", "") + "-" + Hash.getMD5((String)title);
            }

            protected String getID(Window frame) {
                try {
                    return this.getAutoWindowID(frame);
                }
                catch (Exception e) {
                    JDGui.this.logger.log((Throwable)e);
                    return super.getID(frame);
                }
            }

            public void onClose(AbstractDialog<?> abstractDialog, ComponentEvent event) {
                if (!abstractDialog.hasBeenMoved()) {
                    return;
                }
                super.onClose(abstractDialog, event);
            }
        };
        AbstractDialog.setDefaultLocator((DialogLocator)locator);
        locator.setFallbackLocator(new DialogLocator(){

            public Point getLocationOnScreen(AbstractDialog<?> abstractDialog) {
                if (abstractDialog.getDialog().getParent() != null && abstractDialog.getDialog().getParent().isShowing()) {
                    return AbstractDialog.LOCATE_CENTER_OF_SCREEN.getLocationOnScreen(abstractDialog);
                }
                GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gd.getDefaultConfiguration());
                Rectangle bounds = gd.getDefaultConfiguration().getBounds();
                bounds.y += insets.top;
                bounds.x += insets.left;
                bounds.width -= insets.left + insets.right;
                bounds.height -= insets.top + insets.bottom;
                Point ret = AbstractLocator.validate((Point)new Point(bounds.width - abstractDialog.getDialog().getSize().width, bounds.height - abstractDialog.getDialog().getSize().height), (Window)abstractDialog.getDialog());
                return ret;
            }

            public void onClose(AbstractDialog<?> abstractDialog, ComponentEvent event) {
            }
        });
        AbstractDialog.ZHANDLER = new WindowZHandler(){

            public WindowManager.FrameState getWindowStateOnVisible(AbstractDialog<?> d) {
                for (Window w : Window.getWindows()) {
                    if (!WindowManager.getInstance().hasFocus(w)) continue;
                    return WindowManager.FrameState.TO_FRONT_FOCUSED;
                }
                return CFG_GUI.CFG.getNewDialogFrameState();
            }
        };
    }

    private void initFrame(String string) {
        this.mainFrame = new JDownloaderMainFrame(string, this.logger);
    }

    public void initLocationAndDimension() {
        this.initThread = new Thread("initLocationAndDimension"){

            @Override
            public void run() {
                try {
                    new EDTHelper<Void>(){

                        public Void edtRun() {
                            JDGui.this.internalInitLocationAndDimension(JDGui.this.mainFrame, (LogInterface)JDGui.this.logger, ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).getLastFrameStatus(), JDGui.this.tray == null || !((TrayConfig)JDGui.this.tray.getSettings()).isEnabled() || !((TrayConfig)JDGui.this.tray.getSettings()).isStartMinimizedEnabled(), true);
                            return null;
                        }
                    }.waitForEDT();
                }
                finally {
                    JDGui.this.initThread = null;
                }
            }
        };
        this.initThread.start();
    }

    public void initShiftControlSWindowResetKeyListener() {
        if (CrossSystem.isMac()) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(new KeyEventPostProcessor(){

                @Override
                public boolean postProcessKeyEvent(KeyEvent e) {
                    if (e.getID() == 402 && e.isShiftDown() && e.isControlDown() && e.getKeyCode() == 83) {
                        try {
                            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                            JDGui.this.mainFrame.setExtendedState(0);
                            JDGui.this.mainFrame.setSize(new Dimension(800, 600));
                            Rectangle abounds = JDGui.this.mainFrame.getBounds();
                            JDGui.this.mainFrame.setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
                            LoggerFactory.getDefaultLogger().info("Center MainFrame");
                            return true;
                        }
                        catch (Exception ee) {
                            LoggerFactory.getDefaultLogger().log((Throwable)ee);
                        }
                    }
                    return false;
                }
            });
        }
    }

    public void initSilentModeHooks() {
        org.appwork.utils.swing.dialog.Dialog.getInstance().setHandler(new DialogHandler(){

            public <T> T showDialog(AbstractDialog<T> dialog) throws DialogClosedException, DialogCanceledException {
                try {
                    dialog.forceDummyInit();
                    try {
                        if (dialog.evaluateDontShowAgainFlag()) {
                            int mask = dialog.getReturnmask();
                            if (BinaryLogic.containsSome((int)mask, (int[])new int[]{64})) {
                                throw new DialogClosedException(mask);
                            }
                            if (BinaryLogic.containsSome((int)mask, (int[])new int[]{4})) {
                                throw new DialogCanceledException(mask);
                            }
                            if (!BinaryLogic.containsSome((int)mask, (int[])new int[]{2})) {
                                throw new DialogCanceledException(mask | 0x40);
                            }
                            return (T)dialog.getReturnValue();
                        }
                    }
                    catch (DialogNoAnswerException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        JDGui.this.logger.log((Throwable)e);
                    }
                    boolean silentModeActive = JDGui.this.isSilentModeActive();
                    if (silentModeActive && CFG_SILENTMODE.ON_DIALOG_DURING_SILENT_MODE_ACTION.getValue() == SilentModeSettings.DialogDuringSilentModeAction.CANCEL_DIALOG) {
                        throw new DialogClosedException(64);
                    }
                    if (!SwingUtilities.isEventDispatchThread()) {
                        long countdown = -1L;
                        if (dialog.isCountdownFlagEnabled()) {
                            long countdownDif = dialog.getCountdown();
                            countdown = System.currentTimeMillis() + countdownDif;
                        }
                        if (countdown < 0L && CFG_SILENTMODE.ON_DIALOG_DURING_SILENT_MODE_ACTION.getValue() == SilentModeSettings.DialogDuringSilentModeAction.WAIT_IN_BACKGROUND_UNTIL_WINDOW_GETS_FOCUS_OR_TIMEOUT) {
                            countdown = System.currentTimeMillis() + (Long)CFG_SILENTMODE.ON_DIALOG_DURING_SILENT_MODE_ACTION_TIMEOUT.getValue();
                        }
                        if (silentModeActive) {
                            JDGui.this.flashTaskbar();
                        }
                        while (JDGui.this.isSilentModeActive()) {
                            if (countdown > 0L) {
                                Thread.sleep(Math.min(Math.max(1L, countdown - System.currentTimeMillis()), 250L));
                                if (System.currentTimeMillis() <= countdown) continue;
                                dialog.onTimeout();
                                Thread.interrupted();
                                int mask = dialog.getReturnmask();
                                if (BinaryLogic.containsSome((int)mask, (int[])new int[]{64})) {
                                    throw new DialogClosedException(mask);
                                }
                                if (BinaryLogic.containsSome((int)mask, (int[])new int[]{4})) {
                                    throw new DialogCanceledException(mask);
                                }
                                try {
                                    return (T)dialog.getReturnValue();
                                }
                                catch (Exception e) {
                                    JDGui.this.logger.log((Throwable)e);
                                    throw new DialogClosedException(96);
                                }
                            }
                            Thread.sleep(250L);
                        }
                    }
                }
                catch (InterruptedException e) {
                    throw new DialogClosedException(256, (Throwable)e);
                }
                catch (DialogClosedException e) {
                    throw e;
                }
                catch (DialogCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    JDGui.this.logger.log((Throwable)e);
                }
                dialog.resetDummyInit();
                return (T)org.appwork.utils.swing.dialog.Dialog.getInstance().getDefaultHandler().showDialog(dialog);
            }
        });
    }

    private void initToolTipSettings() {
        ToolTipController.getInstance().setClassicToolstipsEnabled(CFG_GUI.TOOLTIP_ENABLED.isEnabled());
        ToolTipManager.sharedInstance().setEnabled(CFG_GUI.TOOLTIP_ENABLED.isEnabled());
        CFG_GUI.TOOLTIP_ENABLED.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
            }

            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                ToolTipController.getInstance().setClassicToolstipsEnabled(CFG_GUI.TOOLTIP_ENABLED.isEnabled());
                ToolTipManager.sharedInstance().setEnabled(CFG_GUI.TOOLTIP_ENABLED.isEnabled());
            }
        });
    }

    public void initUpdateFrameListener() {
        this.mainFrame.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                UpdateController.getInstance().setGuiToFront((JFrame)((Object)JDGui.this.mainFrame));
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
                UpdateController.getInstance().setGuiToFront((JFrame)((Object)JDGui.this.mainFrame));
            }
        });
    }

    public void internalInitLocationAndDimension(final JDownloaderMainFrame mainFrame, final LogInterface logger, FrameStatus stat, final boolean setVisible, final boolean setExtendedState) {
        GraphicsDevice lastScreen;
        boolean noOrInvalidLocation;
        if (stat == null) {
            stat = new FrameStatus();
        }
        FrameStatus status = stat;
        Dimension dim = null;
        if (status.getWidth() > 50 && status.getHeight() > 50) {
            dim = new Dimension(status.getWidth(), status.getHeight());
        }
        if (dim == null) {
            dim = new Dimension(1024, 728);
        }
        Point loc = new Point(status.getX(), status.getY());
        boolean bl = noOrInvalidLocation = loc.x == -1 && loc.y == -1 || !status.isLocationSet();
        if (noOrInvalidLocation) {
            Rectangle usableDefaultBounds = SwingUtils.getUsableScreenBounds((GraphicsDevice)GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
            loc = new Point(usableDefaultBounds.x, usableDefaultBounds.y);
        }
        if ((lastScreen = SwingUtils.getScreenByID((String)status.getScreenID())) == null && !noOrInvalidLocation) {
            lastScreen = SwingUtils.getScreenByLocation((Point)new Point(loc.x + 30, loc.y + 30));
        }
        if (setExtendedState) {
            switch (status.getExtendedState()) {
                case MAXIMIZED_BOTH: {
                    GraphicsDevice screenByCoordinates = SwingUtils.getScreenByLocation((Point)new Point(loc.x + 30, loc.y + 30));
                    if (screenByCoordinates != null && screenByCoordinates.equals(lastScreen)) break;
                    loc = new CenterOfScreenLocator().getCenterLocationByWindowBounds(new Rectangle(loc, dim));
                }
            }
        }
        if (noOrInvalidLocation || lastScreen == null) {
            loc = new CenterOfScreenLocator().getCenterLocationByWindowBounds(new Rectangle(loc, dim));
        }
        logger.info("Check if Screen Location are ok " + loc + " - " + dim);
        if (loc != null) {
            try {
                loc = AbstractLocator.correct((Point)loc, (Dimension)dim);
            }
            catch (Throwable e) {
                loc = null;
                logger.log(e);
            }
        }
        Integer state = null;
        state = status.isSilentShutdown() && !status.isActive() ? Integer.valueOf(1) : (status.getExtendedState() == FrameStatus.ExtendedState.ICONIFIED ? Integer.valueOf(0) : Integer.valueOf(status.getExtendedState().getId()));
        final Dimension finalDim = dim;
        final WindowManager.WindowExtendedState extendedState = WindowManager.WindowExtendedState.get((int)state);
        this.stateForNextVisible = stat;
        final Point finalLocation = loc;
        new EDTRunner(){

            protected void runInEDT() {
                mainFrame.setSize(finalDim);
                if (finalLocation != null) {
                    mainFrame.setLocationByPlatform(false);
                    mainFrame.setLocation(finalLocation);
                } else {
                    mainFrame.setLocationByPlatform(true);
                }
                mainFrame.setMinimumSize(new Dimension(400, 100));
                mainFrame.setPreferredSize(finalDim);
                mainFrame.pack();
                if (setVisible) {
                    if (setExtendedState && extendedState != null) {
                        WindowManager.getInstance().setExtendedState((Frame)((Object)mainFrame), extendedState);
                    }
                    JDGui.this.stateForNextVisible = null;
                    WindowManager.getInstance().setVisible((Window)((Object)mainFrame), true, WindowManager.FrameState.OS_DEFAULT);
                }
                if (CrossSystem.isMac() && !mainFrame.isUndecorated()) {
                    mainFrame.addComponentListener(new ComponentAdapter(){
                        private String screenID;

                        @Override
                        public void componentMoved(ComponentEvent e) {
                            String newScreenID = mainFrame.getGraphicsConfiguration().getDevice().getIDstring();
                            if (!StringUtils.equals((String)newScreenID, (String)this.screenID)) {
                                if (mainFrame.getRootPane().getUI().toString().contains("SyntheticaRootPaneUI")) {
                                    ((SyntheticaRootPaneUI)mainFrame.getRootPane().getUI()).setMaximizedBounds((Frame)((Object)mainFrame));
                                    logger.info("Set Mainframe MaximizedBounds to: " + mainFrame.getMaximizedBounds());
                                }
                                this.screenID = newScreenID;
                            }
                        }
                    });
                }
            }
        }.waitForEDT();
    }

    protected void internalSetWaiting(final boolean b) {
        if (this.busy == b) {
            return;
        }
        this.busy = b;
        new EDTHelper<Object>(){

            public Object edtRun() {
                JDGui.this.getMainFrame().setGlassPane(JDGui.this.waitingPane);
                JDGui.this.waitingPane.setCursor(Cursor.getPredefinedCursor(3));
                JDGui.this.getMainFrame().getGlassPane().setVisible(b);
                return null;
            }
        }.waitForEDT();
    }

    public boolean isCurrentPanel(final Panels panelID) {
        return (Boolean)new EDTHelper<Boolean>(){

            public Boolean edtRun() {
                switch (panelID) {
                    case DOWNLOADLIST: {
                        return JDGui.this.downloadView == JDGui.this.mainTabbedPane.getSelectedComponent();
                    }
                    case LINKGRABBER: {
                        return JDGui.this.linkgrabberView == JDGui.this.mainTabbedPane.getSelectedComponent();
                    }
                }
                return false;
            }
        }.getReturnValue();
    }

    public boolean isSilentModeActive() {
        Boolean ret;
        long idleTime = IdleGetter.getInstance().getIdleTimeSinceLastUserInput();
        long maxIdleTime = CFG_SILENTMODE.CFG.getAutoSilentModeInIdleState();
        if (maxIdleTime > 0L) {
            if (idleTime >= maxIdleTime) {
                System.out.println("Silent mode:Idle:" + idleTime + "|Max:" + maxIdleTime);
                return true;
            }
            System.out.println("No idle:" + idleTime + "|Max:" + maxIdleTime);
        }
        return (ret = (Boolean)new EDTHelper<Boolean>(){

            public Boolean edtRun() {
                if (JDGui.this.getMainFrame().hasFocus() || JDGui.this.getMainFrame().isActive()) {
                    JDGui.this.logger.info("SilentMode: Mainframe has Focus: ");
                    return false;
                }
                if (UpdateController.getInstance().getHandler() != null && GuiUtils.isActiveWindow((Window)UpdateController.getInstance().getHandler().getGuiFrame())) {
                    JDGui.this.logger.info("SilentMode: Updater Frame is Active");
                    return false;
                }
                for (Window w : Window.getWindows()) {
                    if (!w.hasFocus() && !w.isActive()) continue;
                    JDGui.this.logger.info("SilentMode: No SilentMode. Active Window: " + w);
                    return false;
                }
                if (JDGui.this.tray.isEnabled() && JDGui.this.tray.isActive()) {
                    JDGui.this.logger.info("SilentMode: Tray");
                    return false;
                }
                if (CFG_SILENTMODE.MANUAL_ENABLED.isEnabled()) {
                    JDGui.this.logger.info("SilentMode: MANUEL true");
                    return true;
                }
                switch (CFG_SILENTMODE.CFG.getAutoTrigger()) {
                    case JD_IN_TASKBAR: {
                        if (JDGui.this.getMainFrame().getState() != 1 || !JDGui.this.getMainFrame().isVisible()) break;
                        JDGui.this.logger.info("SilentMode: auto task true");
                        return true;
                    }
                    case JD_IN_TRAY: {
                        if (JDGui.this.getMainFrame().isVisible()) break;
                        JDGui.this.logger.info("SilentMode: auto tray true");
                        return true;
                    }
                    default: {
                        JDGui.this.logger.info("SilentMode: auto false");
                        return false;
                    }
                }
                JDGui.this.logger.info("SilentMode: else false");
                return false;
            }
        }.getReturnValue()) == Boolean.TRUE;
    }

    private boolean initFlatLafMacToolbar() {
        if (!CrossSystem.isMac()) {
            return false;
        }
        if (!ReflectionUtils.isInstanceOf((String)"com.formdev.flatlaf.FlatLaf", (Object)UIManager.getLookAndFeel())) {
            return false;
        }
        try {
            return (Boolean)ReflectionUtils.getFieldValue((String)"com.formdev.flatlaf.util.SystemInfo", (String)"isMacFullWindowContentSupported", null, Boolean.TYPE);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void layoutComponents() {
        JPanel contentPane = new JPanel((LayoutManager)new MigLayout("ins 0, wrap 1", "[grow,fill]", "[grow,fill]0[shrink]"));
        contentPane.add(this.mainTabbedPane);
        contentPane.add((Component)this.statusBar, "dock SOUTH");
        this.mainFrame.setContentPane(contentPane);
        this.mainFrame.setJMenuBar(this.menuBar);
        if (this.initFlatLafMacToolbar()) {
            this.mainFrame.getRootPane().putClientProperty("apple.awt.transparentTitleBar", true);
            this.mainFrame.getRootPane().putClientProperty("apple.awt.fullWindowContent", true);
            this.mainFrame.getRootPane().putClientProperty("apple.awt.windowTitleVisible", false);
            this.mainFrame.getRootPane().putClientProperty("FlatLaf.macOS.windowButtonsSpacing", "medium");
            JPanel placeholder = new JPanel();
            JPanel toolBarPanel = new JPanel(new BorderLayout());
            placeholder.putClientProperty("FlatLaf.fullWindowContent.buttonsPlaceholder", "mac zeroInFullScreen");
            toolBarPanel.add((Component)placeholder, "Before");
            toolBarPanel.add((Component)this.toolBar, "Center");
            this.mainFrame.getContentPane().add((Component)toolBarPanel, "North");
        } else {
            this.mainFrame.add(this.toolBar, "dock NORTH");
        }
    }

    protected void onGuiInitComplete() {
        this.mainTabbedPane.notifyCurrentTab();
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            public long getMaxDuration() {
                return 10000L;
            }

            public void onShutdown(ShutdownRequest shutdownRequest) {
                new EDTHelper<Object>(){

                    public Object edtRun() {
                        JDGui.this.mainTabbedPane.onClose();
                        JDGui.this.tray.dispose();
                        FrameStatus framestatus = FrameStatus.create((JFrame)((Object)JDGui.this.mainFrame), (FrameStatus)((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).getLastFrameStatus());
                        ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).setLastFrameStatus(framestatus);
                        WindowManager.getInstance().setVisible((Window)((Object)JDGui.this.getMainFrame()), false, WindowManager.FrameState.OS_DEFAULT);
                        return null;
                    }
                }.getReturnValue();
            }
        });
        SecondLevelLaunch.INIT_COMPLETE.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                final Sponsor sp = SponsorUtils.getSponsor();
                if (sp != null) {
                    new EDTRunner(){

                        protected void runInEDT() {
                            MainTabbedPane.getInstance().setTopRightPainter((TopRightPainter)sp);
                        }
                    };
                }
            }
        });
        FileCreationManager.getInstance().mkdir(Application.getResource((String)"/tmp/update/self/JDU"));
        new Thread(){

            @Override
            public void run() {
                JDGui.this.logger.info("Update bug Finder");
                int counter = -1;
                try {
                    JDGui.this.logger.info("Find Counter");
                    counter = Counter.VALUE;
                    JDGui.this.logger.info(Application.getJarFile(Counter.class).getAbsolutePath());
                    JDGui.this.logger.info("Done: " + counter);
                }
                catch (Throwable e) {
                    JDGui.this.logger.log(e);
                }
                long start = System.currentTimeMillis();
                while (UpdateController.getInstance().getHandler() == null) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (System.currentTimeMillis() - start <= 30000L) continue;
                    JDGui.this.logger.info("Handler null");
                    return;
                }
                JDGui.this.logger.info("Gogogo " + counter);
                if (counter != 1) {
                    try {
                        JDGui.this.logger.info("Delete jdu");
                        Files.deleteRecursiv((File)Application.getResource((String)"update/versioninfo/JDU"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        JDGui.this.logger.info("Delete extensioncache");
                        Files.deleteRecursiv((File)Application.getTempResource((String)"extensioncache"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    File rev = Application.getResource((String)"/tmp/update/self/JDU/rev");
                    JDGui.this.logger.info("create dummy rev");
                    if (!rev.exists()) {
                        FileCreationManager.getInstance().mkdir(rev.getParentFile());
                        try {
                            IO.writeStringToFile((File)rev, (String)"0");
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    JDGui.this.logger.info("Show Message");
                    org.appwork.utils.swing.dialog.Dialog.getInstance().showMessageDialog("This is a very important Update. You should run this NOW!");
                    JDGui.this.logger.info("Init update");
                    UpdateController.getInstance().setGuiVisible(true);
                    UpdateController.getInstance().runUpdateChecker(true);
                }
            }
        }.start();
    }

    public void onUpdatesAvailable(boolean selfupdate, InstallLog installlog) {
        new EDTRunner(){

            protected void runInEDT() {
                JDGui.this.updateTitle();
            }
        };
    }

    public void requestPanel(final Panels panel) {
        new EDTHelper<Object>(){

            public Object edtRun() {
                switch (panel) {
                    case DOWNLOADLIST: {
                        JDGui.this.mainTabbedPane.setSelectedComponent((Component)JDGui.this.downloadView);
                        break;
                    }
                    case LINKGRABBER: {
                        JDGui.this.mainTabbedPane.setSelectedComponent((Component)JDGui.this.linkgrabberView);
                        break;
                    }
                    default: {
                        JDGui.this.mainTabbedPane.setSelectedComponent((Component)JDGui.this.downloadView);
                    }
                }
                return null;
            }
        }.start();
    }

    public View getCurrentView() {
        return (View)new EDTHelper<View>(){

            public View edtRun() {
                return JDGui.this.mainTabbedPane.getSelectedView();
            }
        }.getReturnValue();
    }

    public void setClosingHandler(MainFrameClosingHandler closingHandler) {
        this.closingHandler = closingHandler;
    }

    public void setContent(View view, boolean setActive) {
        if (!this.mainTabbedPane.contains(view)) {
            this.mainTabbedPane.addTab(view);
        }
        if (setActive) {
            this.mainTabbedPane.setSelectedComponent(view);
        }
    }

    public void setFrameState(WindowManager.FrameState toFrontFocused) {
        switch (toFrontFocused) {
            case OS_DEFAULT: {
                if (this.isSilentModeActive()) {
                    this.flashTaskbar();
                    break;
                }
                if (WindowManager.getInstance().getExtendedState((Frame)((Object)this.mainFrame)) == WindowManager.WindowExtendedState.ICONIFIED) {
                    WindowManager.getInstance().setExtendedState((Frame)((Object)this.mainFrame), WindowManager.WindowExtendedState.NORMAL);
                }
                WindowManager.getInstance().setVisible((Window)((Object)this.mainFrame), true, toFrontFocused);
                break;
            }
            case TO_BACK: {
                this.flashTaskbar();
                break;
            }
            case TO_FRONT: {
                if (this.isSilentModeActive()) {
                    this.flashTaskbar();
                    break;
                }
                if (WindowManager.getInstance().getExtendedState((Frame)((Object)this.mainFrame)) == WindowManager.WindowExtendedState.ICONIFIED) {
                    WindowManager.getInstance().setExtendedState((Frame)((Object)this.mainFrame), WindowManager.WindowExtendedState.NORMAL);
                }
                WindowManager.getInstance().setVisible((Window)((Object)this.mainFrame), true, toFrontFocused);
                break;
            }
            case TO_FRONT_FOCUSED: {
                if (this.isSilentModeActive()) {
                    this.flashTaskbar();
                    break;
                }
                if (WindowManager.getInstance().getExtendedState((Frame)((Object)this.mainFrame)) == WindowManager.WindowExtendedState.ICONIFIED) {
                    WindowManager.getInstance().setExtendedState((Frame)((Object)this.mainFrame), WindowManager.WindowExtendedState.NORMAL);
                }
                WindowManager.getInstance().setVisible((Window)((Object)this.mainFrame), true, toFrontFocused);
            }
        }
    }

    public void setFrameStatus(final int id) {
        new EDTRunner(){

            protected void runInEDT() {
                switch (id) {
                    case 1: {
                        JDGui.this.mainFrame.setState(6);
                        WindowManager.getInstance().setVisible((Window)((Object)JDGui.this.mainFrame), true, WindowManager.FrameState.OS_DEFAULT);
                        break;
                    }
                    case 0: {
                        JDGui.this.mainFrame.setState(1);
                        break;
                    }
                    case 3: {
                        if (GuiUtils.isActiveWindow((Window)((Object)JDGui.this.getMainFrame()))) break;
                        JDGui.this.mainFrame.setState(0);
                        WindowManager.getInstance().setVisible((Window)((Object)JDGui.this.mainFrame), true, WindowManager.FrameState.OS_DEFAULT);
                        break;
                    }
                    case 5: {
                        if (!GuiUtils.isActiveWindow((Window)((Object)JDGui.this.getMainFrame()))) {
                            if (JDGui.this.isSilentModeActive()) {
                                JDGui.this.flashTaskbar();
                                return;
                            }
                            if (WindowManager.getInstance().getExtendedState((Frame)((Object)JDGui.this.mainFrame)) == WindowManager.WindowExtendedState.ICONIFIED) {
                                WindowManager.getInstance().setExtendedState((Frame)((Object)JDGui.this.mainFrame), WindowManager.WindowExtendedState.NORMAL);
                            }
                            WindowManager.getInstance().setVisible((Window)((Object)JDGui.this.mainFrame), true, WindowManager.FrameState.TO_FRONT_FOCUSED);
                            if (!JDGui.this.tray.isEnabled()) break;
                            JDGui.this.setWindowToTray(false);
                            break;
                        }
                        JDGui.this.logger.info("No To Top. We already have focus");
                        break;
                    }
                    case 4: {
                        if (!GuiUtils.isActiveWindow((Window)((Object)JDGui.this.getMainFrame()))) {
                            if (JDGui.this.isSilentModeActive()) {
                                JDGui.this.flashTaskbar();
                                return;
                            }
                            if (WindowManager.getInstance().getExtendedState((Frame)((Object)JDGui.this.mainFrame)) == WindowManager.WindowExtendedState.ICONIFIED) {
                                WindowManager.getInstance().setExtendedState((Frame)((Object)JDGui.this.mainFrame), WindowManager.WindowExtendedState.NORMAL);
                            }
                            WindowManager.getInstance().setVisible((Window)((Object)JDGui.this.mainFrame), true, WindowManager.FrameState.TO_FRONT);
                            if (!JDGui.this.tray.isEnabled()) break;
                            JDGui.this.setWindowToTray(false);
                            break;
                        }
                        JDGui.this.logger.info("No To Top. We already have focus");
                    }
                }
            }
        };
    }

    public void setWaiting(boolean b) {
        this.internalSetWaiting(b);
    }

    private void setWindowIcon() {
        ArrayList<Image> list = new ArrayList<Image>();
        list.add(NewTheme.I().getImage("logo/jd_logo_64_64", 64));
        list.add(NewTheme.I().getImage("logo/jd_logo_64_64", 48));
        list.add(NewTheme.I().getImage("logo/jd_logo_64_64", 32));
        list.add(NewTheme.I().getImage("logo/jd_logo_64_64", 20));
        list.add(NewTheme.I().getImage("logo/jd_logo_64_64", 19));
        list.add(NewTheme.I().getImage("logo/jd_logo_64_64", 18));
        list.add(NewTheme.I().getImage("logo/jd_logo_64_64", 17));
        list.add(NewTheme.I().getImage("logo/jd_logo_128_128", -1));
        this.mainFrame.setIconImages(list);
    }

    public void setWindowToTray(final boolean minimize) {
        new EDTHelper<Object>(){

            public Object edtRun() {
                FrameStatus.ExtendedState estate = FrameStatus.ExtendedState.get((JFrame)((Object)JDGui.this.getMainFrame()));
                if (!minimize) {
                    if (estate == null) {
                        JDGui.this.logger.info("Bad ExtendedState \r\n" + JDGui.this.getMainFrame().getExtendedState());
                        estate = FrameStatus.ExtendedState.NORMAL;
                    }
                    FrameStatus frameState = JDGui.this.getMainFrame().getLatestFrameStatus();
                    if (JDGui.this.stateForNextVisible != null) {
                        frameState = JDGui.this.stateForNextVisible;
                        JDGui.this.stateForNextVisible = null;
                    }
                    JDGui.this.logger.info("Reset frame to \r\n" + JSonStorage.serializeToJson((Object)frameState));
                    if (frameState != null) {
                        if (frameState.getExtendedState() == null) {
                            JDGui.this.logger.info("Bad ExtendedState in Framestate ");
                        } else {
                            estate = frameState.getExtendedState();
                        }
                    }
                    switch (estate) {
                        case MAXIMIZED_BOTH: {
                            boolean locationSet = false;
                            if (frameState != null) {
                                JDGui.this.getMainFrame().setSize(frameState.getWidth(), frameState.getHeight());
                                GraphicsDevice screen = SwingUtils.getScreenByLocation((int)(frameState.getX() + 30), (int)(frameState.getY() + 30));
                                if (screen != null && StringUtils.equals((String)screen.getIDstring(), (String)frameState.getScreenID())) {
                                    JDGui.this.getMainFrame().setLocation(frameState.getX(), frameState.getY());
                                    locationSet = true;
                                }
                            }
                            if (locationSet) break;
                            Point center = new CenterOfScreenLocator().getLocationOnScreen((Window)((Object)JDGui.this.getMainFrame()));
                            if (center != null) {
                                JDGui.this.getMainFrame().setLocation(center);
                                break;
                            }
                            JDGui.this.getMainFrame().setLocationByPlatform(true);
                        }
                    }
                    WindowManager.getInstance().setVisible((Window)((Object)JDGui.this.getMainFrame()), true, WindowManager.FrameState.TO_FRONT_FOCUSED);
                    switch (estate) {
                        case MAXIMIZED_BOTH: {
                            WindowManager.getInstance().setExtendedState((Frame)((Object)JDGui.this.getMainFrame()), WindowManager.WindowExtendedState.MAXIMIZED_BOTH);
                            break;
                        }
                        default: {
                            WindowManager.getInstance().setExtendedState((Frame)((Object)JDGui.this.getMainFrame()), WindowManager.WindowExtendedState.NORMAL);
                        }
                    }
                    if (JDGui.this.trayIconChecker != null) {
                        JDGui.this.trayIconChecker.interrupt();
                        JDGui.this.trayIconChecker = null;
                    }
                } else {
                    if (estate == FrameStatus.ExtendedState.ICONIFIED) {
                        WindowManager.getInstance().hide((Window)((Object)JDGui.this.getMainFrame()));
                    } else if (CrossSystem.isLinux()) {
                        WindowManager.getInstance().hide((Window)((Object)JDGui.this.getMainFrame()));
                    } else {
                        JDGui.this.getMainFrame().addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowIconified(WindowEvent e) {
                                JDGui.this.getMainFrame().removeWindowListener(this);
                                WindowManager.getInstance().hide((Window)((Object)JDGui.this.getMainFrame()));
                            }
                        });
                        WindowManager.getInstance().setExtendedState((Frame)((Object)JDGui.this.getMainFrame()), WindowManager.WindowExtendedState.ICONIFIED);
                    }
                    JDGui.this.trayIconChecker = new Thread(){

                        @Override
                        public void run() {
                            boolean reInitNeeded = false;
                            while (Thread.currentThread() == JDGui.this.trayIconChecker) {
                                boolean reInitTrayIcon;
                                block7: {
                                    try {
                                        Thread.sleep(15000L);
                                    }
                                    catch (InterruptedException e) {
                                        break;
                                    }
                                    reInitTrayIcon = false;
                                    try {
                                        reInitTrayIcon = 0 == SystemTray.getSystemTray().getTrayIcons().length;
                                    }
                                    catch (UnsupportedOperationException e) {
                                        if (reInitNeeded) break block7;
                                        reInitNeeded = true;
                                        JDGui.this.logger.severe("TrayIcon gone?! WTF? We will try to restore as soon as possible");
                                    }
                                }
                                if (!reInitTrayIcon) continue;
                                JDGui.this.tray.initGUI(false);
                                try {
                                    if (SystemTray.getSystemTray().getTrayIcons().length <= 0) continue;
                                    reInitNeeded = false;
                                    JDGui.this.logger.severe("TrayIcon restored!");
                                }
                                catch (UnsupportedOperationException unsupportedOperationException) {}
                            }
                        }
                    };
                    JDGui.this.trayIconChecker.setDaemon(true);
                    JDGui.this.trayIconChecker.setName("TrayIconRestore");
                    JDGui.this.trayIconChecker.start();
                }
                return null;
            }
        }.start();
    }

    protected void showConfigPanel(ConfigContainer container) {
        String name = "";
        if (container.getTitle() != null) {
            name = container.getTitle();
        } else if (container.getGroup() != null && container.getGroup().getName() != null) {
            name = container.getGroup().getName();
        }
        Icon icon = null;
        if (container.getIcon() != null) {
            icon = container.getIcon();
        } else if (container.getGroup() != null && container.getGroup().getIcon() != null) {
            icon = container.getGroup().getIcon();
        }
        AddonConfig addonConfig = AddonConfig.getInstance(container, "_2", false);
        JScrollPane scrollPane = new JScrollPane(addonConfig.getPanel());
        scrollPane.setBorder(null);
        scrollPane.setHorizontalScrollBarPolicy(31);
    }

    protected void updateTitle() {
        String title = "JDownloader 2";
        title = this.generateTitle(title);
        this.getMainFrame().setTitle(title);
    }

    private String generateTitle(String title) {
        String pattern = CFG_GUI.CFG.getTitlePattern();
        pattern = pattern.replaceAll(TITLE_PATTERN_TITLE, "$1" + title + "$2");
        switch (CFG_GUI.CFG.getSpeedInWindowTitle()) {
            case ALWAYS: {
                pattern = this.updateTitle(pattern);
                break;
            }
            case WHEN_WINDOW_IS_MINIMIZED: {
                if (WindowManager.getInstance().getExtendedState((Frame)((Object)this.getMainFrame())) == WindowManager.WindowExtendedState.ICONIFIED) {
                    pattern = this.updateTitle(pattern);
                    break;
                }
                pattern = pattern.replaceAll(TITLE_PATTERN_SPEED, "");
                pattern = pattern.replaceAll(TITLE_PATTERN_SPEED_AVERAGE, "");
                break;
            }
            default: {
                pattern = pattern.replaceAll(TITLE_PATTERN_SPEED, "");
                pattern = pattern.replaceAll(TITLE_PATTERN_SPEED_AVERAGE, "");
            }
        }
        pattern = UpdateController.getInstance().hasPendingUpdates() ? pattern.replaceAll(TITLE_PATTERN_UPDATE, "$1" + _GUI.T.JDGui_updateTitle_updates_available2() + "$2") : pattern.replaceAll(TITLE_PATTERN_UPDATE, "");
        int running = DownloadWatchDog.getInstance().getActiveDownloads();
        pattern = DownloadWatchDog.getInstance().isRunning() ? pattern.replaceAll(TITLE_PATTERN_RUNNING_DOWNLOADS, "$1" + running + "$2") : pattern.replaceAll(TITLE_PATTERN_RUNNING_DOWNLOADS, "");
        return pattern.trim();
    }

    protected String updateTitle(String pattern) {
        int speed = DownloadWatchDog.getInstance().getDownloadSpeedManager().getSpeed();
        pattern = DownloadWatchDog.getInstance().isRunning() ? pattern.replaceAll(TITLE_PATTERN_SPEED, "$1" + SizeFormatter.formatBytes((long)Math.max(0, speed)) + "$2") : pattern.replaceAll(TITLE_PATTERN_SPEED, "");
        long speedAverage = -1L;
        SpeedMeterPanel sm = MainToolBar.getInstance().getSpeedMeter();
        if (sm != null) {
            speedAverage = sm.getAverageSpeed();
        }
        if (speedAverage < 0L) {
            speedAverage = DownloadWatchDog.getInstance().getDownloadSpeedManager().getSpeedMeter().getValue(SpeedMeterInterface.Resolution.SECONDS);
        }
        pattern = DownloadWatchDog.getInstance().isRunning() ? pattern.replaceAll(TITLE_PATTERN_SPEED_AVERAGE, "$1" + SizeFormatter.formatBytes((long)Math.max(0L, speedAverage)) + "$2") : pattern.replaceAll(TITLE_PATTERN_SPEED_AVERAGE, "");
        return pattern;
    }

    public static JDGui init() {
        return (JDGui)new EDTHelper<JDGui>(){

            public JDGui edtRun() {
                JDGui ret = INSTANCE;
                if (ret == null) {
                    ret = new JDGui();
                    INSTANCE = ret;
                }
                return ret;
            }
        }.getReturnValue();
    }

    public static boolean bugme(WarnLevel requestedLevel) {
        GraphicalUserInterfaceSettings.RlyWarnLevel rlyWarnLevel = CFG_GUI.CFG.getRlyWarnLevel();
        switch (rlyWarnLevel) {
            case DISABLED: {
                return false;
            }
            case HIGH: {
                return true;
            }
        }
        switch (requestedLevel) {
            case LOW: {
                return false;
            }
            case NORMAL: {
                return GraphicalUserInterfaceSettings.RlyWarnLevel.NORMAL.equals((Object)rlyWarnLevel);
            }
            case SEVERE: {
                return true;
            }
        }
        return true;
    }

    public boolean badLaunchCheck() {
        return Boolean.TRUE.equals(new EDTHelper<Boolean>(){

            public Boolean edtRun() {
                if (!(JDGui.this.getMainFrame().isVisible() || JDGui.this.tray != null && ((TrayConfig)JDGui.this.tray.getSettings()).isEnabled() && ((TrayConfig)JDGui.this.tray.getSettings()).isStartMinimizedEnabled())) {
                    ShutdownController.getInstance().requestShutdown(true);
                    return false;
                }
                return true;
            }
        }.getReturnValue());
    }

    public void onUpdaterStatusUpdate(String label, Icon icon, double progress) {
    }

    public static void executeWhenGuiInitComplete(Runnable runnable) {
        SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(runnable);
    }

    public FlashController getFlashController() {
        return this.flashController;
    }

    static {
        if (Application.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public static enum Panels {
        DOWNLOADLIST,
        LINKGRABBER;

    }
}

