/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.components.premiumbar;

import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import jd.gui.swing.jdgui.components.premiumbar.AccountTooltip;
import jd.gui.swing.jdgui.components.premiumbar.ServiceCollection;
import jd.gui.swing.jdgui.components.premiumbar.ServicePanel;
import jd.gui.swing.jdgui.components.premiumbar.TinyProgressBar;
import jd.plugins.Account;
import org.appwork.swing.components.ExtMergedIcon;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.jdownloader.DomainInfo;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public class AccountServiceCollection
extends ServiceCollection<Account> {
    private static final long serialVersionUID = -6958497120849521678L;
    private DomainInfo domainInfo;
    private boolean enabled;
    private HashSet<Account> hashSet;
    private Boolean account_type_multi = null;
    private Boolean account_type_captcha_solver = null;
    private long lastValidTimeStamp = -1L;
    private int invalid;
    private boolean inuse;
    private volatile Icon icon = null;

    public DomainInfo getDomainInfo() {
        return this.domainInfo;
    }

    @Override
    protected boolean isInUse() {
        return this.inuse;
    }

    public AccountServiceCollection(DomainInfo domainInfo) {
        this.domainInfo = domainInfo;
        this.enabled = false;
        this.inuse = false;
        this.invalid = 0;
        this.hashSet = new HashSet();
    }

    @Override
    public JComponent createIconComponent(ServicePanel servicePanel) {
        return new TinyProgressBar(servicePanel, this);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && CFG_GENERAL.USE_AVAILABLE_ACCOUNTS.isEnabled();
    }

    @Override
    public boolean add(Account acc) {
        if (!this.hashSet.add(acc)) {
            return false;
        }
        if (this.account_type_multi == null && acc.isMultiHost()) {
            this.account_type_multi = acc.isMultiHost();
        } else if (this.account_type_captcha_solver == null && acc.isCaptchaSolverPlugin()) {
            this.account_type_captcha_solver = true;
        }
        if (acc.isEnabled()) {
            this.enabled = true;
        }
        if (!acc.isValid()) {
            ++this.invalid;
        } else if (acc.isEnabled()) {
            this.inuse = true;
        }
        this.lastValidTimeStamp = Math.max(acc.getLastValidTimestamp(), this.lastValidTimeStamp);
        boolean ret = super.add(acc);
        this.icon = null;
        return ret;
    }

    public boolean isMulti() {
        if (this.size() == 1) {
            return ((Account)this.get(0)).isMultiHost();
        }
        return Boolean.TRUE.equals(this.account_type_multi);
    }

    public boolean isCaptchaSolver() {
        if (this.size() == 1) {
            return ((Account)this.get(0)).isCaptchaSolverPlugin();
        }
        return Boolean.TRUE.equals(this.account_type_captcha_solver);
    }

    protected void disableMulti() {
        this.account_type_multi = false;
    }

    @Override
    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = !this.inuse && this.invalid > 0 ? new ExtMergedIcon((Icon)this.domainInfo, 0, 0).add((Icon)new AbstractIcon("error", 12), 6, 6) : (this.invalid > 0 ? new ExtMergedIcon((Icon)this.domainInfo, 0, 0).add((Icon)new AbstractIcon("warning", 12), 6, 6) : this.domainInfo.getFavIcon());
        }
        return this.icon;
    }

    @Override
    protected long getLastActiveTimestamp() {
        return this.lastValidTimeStamp;
    }

    @Override
    protected String getName() {
        return this.domainInfo.getTld();
    }

    @Override
    public ExtTooltip createTooltip(ServicePanel owner) {
        return new AccountTooltip(owner, this);
    }

    @Override
    public int getInvalidCount() {
        return this.invalid;
    }
}

