/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.accountmanager.orderpanel;

import java.awt.event.ActionEvent;
import java.util.List;
import jd.controlling.TaskQueue;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.orderpanel.HosterRuleTable;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.hosterrule.AccountUsageRule;
import org.jdownloader.controlling.hosterrule.HosterRuleController;
import org.jdownloader.gui.translate._GUI;

public class RemoveAction
extends AppAction {
    private static final long serialVersionUID = 1L;
    private HosterRuleTable table;
    private boolean force = false;
    private List<AccountUsageRule> selection = null;

    public RemoveAction(HosterRuleTable table) {
        this.table = table;
        this.setName(_GUI.T.literally_remove());
        this.setIconKey("remove");
    }

    public RemoveAction(List<AccountUsageRule> selection2, boolean force) {
        this.force = force;
        this.selection = selection2;
        this.setName(_GUI.T.literally_remove());
        this.setIconKey("remove");
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        final List finalSelection = this.selection != null ? this.selection : (this.table != null ? this.table.getModel().getSelectedObjects() : null);
        if (finalSelection != null && finalSelection.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (AccountUsageRule account : finalSelection) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(account.getHoster());
            }
            try {
                if (!this.force) {
                    Dialog.getInstance().showConfirmDialog(64, _GUI.T.accountUsageRule_remove_action_title(finalSelection.size()), _GUI.T.accountUsageRule_remove_action_msg(finalSelection.size() <= 1 ? sb.toString() : "\r\n" + sb.toString()));
                }
                TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        for (AccountUsageRule account : finalSelection) {
                            HosterRuleController.getInstance().remove(account);
                        }
                        return null;
                    }
                });
            }
            catch (DialogNoAnswerException e1) {
                e1.printStackTrace();
            }
        }
    }

    public boolean isEnabled() {
        if (this.table != null) {
            return super.isEnabled();
        }
        return this.selection != null && this.selection.size() > 0;
    }
}

