/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.accountmanager.orderpanel.dialog;

import java.util.Date;
import java.util.EventListener;
import javax.swing.JComponent;
import jd.controlling.accountchecker.AccountChecker;
import jd.controlling.accountchecker.AccountCheckerEventListener;
import jd.gui.swing.jdgui.GUIUtils;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.orderpanel.AccountInterface;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.orderpanel.AccountWrapper;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.orderpanel.GroupWrapper;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.orderpanel.dialog.GroupRuleColumn;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.orderpanel.dialog.PackageColumn;
import jd.nutils.Formatter;
import jd.plugins.Account;
import jd.plugins.AccountTrafficView;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.columns.ExtDateColumn;
import org.appwork.swing.exttable.columns.ExtProgressColumn;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.swing.exttable.tree.ExtTreeTableModel;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.swing.renderer.RendererMigPanel;
import org.jdownloader.controlling.hosterrule.FreeAccountReference;
import org.jdownloader.gui.translate._GUI;

public class HosterPriorityTableModel
extends ExtTreeTableModel<AccountInterface>
implements AccountCheckerEventListener {
    private volatile boolean checkRunning = false;

    public HosterPriorityTableModel() {
        super("HosterPriorityTableModel");
        AccountChecker.getInstance().getEventSender().addListener((EventListener)((Object)this), true);
        this.checkRunning = AccountChecker.getInstance().isRunning();
    }

    public void onCheckStarted() {
        this.checkRunning = true;
        this.fireTableDataChanged();
    }

    public void onCheckStopped() {
        this.checkRunning = false;
        this.fireTableDataChanged();
    }

    protected void initColumns() {
        this.addColumn((ExtColumn)new PackageColumn());
        this.addColumn((ExtColumn)new GroupRuleColumn());
        this.addColumn((ExtColumn)new ExtTextColumn<AccountInterface>(_GUI.T.premiumaccounttablemodel_column_user()){
            private static final long serialVersionUID = -8070328156326837828L;

            public boolean isHidable() {
                return false;
            }

            public int getDefaultWidth() {
                return this.getMinWidth();
            }

            public boolean isSortable(AccountInterface obj) {
                return false;
            }

            public int getMinWidth() {
                return 100;
            }

            public boolean isEditable(AccountInterface obj) {
                return false;
            }

            protected void setStringValue(String value, AccountInterface object) {
            }

            public String getStringValue(AccountInterface value) {
                return GUIUtils.getAccountName(value.getUser());
            }
        });
        this.addColumn((ExtColumn)new ExtDateColumn<AccountInterface>(_GUI.T.premiumaccounttablemodel_column_expiredate()){
            private static final long serialVersionUID = 5067606909520874358L;

            public boolean isEnabled(AccountInterface obj) {
                return obj.isEnabled();
            }

            public int getMaxWidth() {
                return 100;
            }

            public boolean isSortable(AccountInterface obj) {
                return false;
            }

            public int getDefaultWidth() {
                return this.getMinWidth();
            }

            public int getMinWidth() {
                return 100;
            }

            protected String getDateFormatString() {
                return Account.getExpireDateFormatString((Object)((Object)this));
            }

            protected Date getDate(AccountInterface o2, Date date) {
                if (o2 instanceof AccountWrapper) {
                    return ((AccountWrapper)o2).getExpireDate();
                }
                return null;
            }
        });
        this.addColumn((ExtColumn)new ExtProgressColumn<AccountInterface>(_GUI.T.premiumaccounttablemodel_column_trafficleft()){
            private static final long serialVersionUID = -8376056840172682617L;
            private final JComponent empty;
            {
                this.empty = new RendererMigPanel("ins 0", "[]", "[]");
            }

            public boolean isEnabled(AccountInterface obj) {
                return obj.isEnabled();
            }

            public boolean isSortable(AccountInterface obj) {
                return false;
            }

            public int getMinWidth() {
                return 120;
            }

            protected boolean isIndeterminated(AccountInterface value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof AccountWrapper) {
                    AccountWrapper aw = (AccountWrapper)value;
                    if (aw.getAccount() instanceof FreeAccountReference) {
                        return false;
                    }
                    if (HosterPriorityTableModel.this.checkRunning) {
                        return AccountChecker.getInstance().contains(aw.getAccount().getAccount());
                    }
                    if (aw.isValid() && aw.getAccount().isEnabled() && aw.isTempDisabled()) {
                        return true;
                    }
                }
                return false;
            }

            public JComponent getRendererComponent(AccountInterface value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof GroupWrapper) {
                    return this.empty;
                }
                JComponent ret = super.getRendererComponent((Object)value, isSelected, hasFocus, row, column);
                return ret;
            }

            protected String getString(AccountInterface value, long current, long total) {
                if (value instanceof AccountWrapper) {
                    AccountWrapper accountWrapper = (AccountWrapper)value;
                    if (!accountWrapper.isValid()) {
                        return "";
                    }
                    long timeout = -1L;
                    if (accountWrapper.getAccount().isEnabled() && accountWrapper.isTempDisabled() && (timeout = accountWrapper.getTmpDisabledTimeout() - System.currentTimeMillis()) > 0L) {
                        return _GUI.T.premiumaccounttablemodel_column_trafficleft_tempdisabled(TimeFormatter.formatMilliSeconds((long)timeout, (int)0));
                    }
                    AccountTrafficView accountTrafficView = accountWrapper.getAccount().getAccountTrafficView();
                    if (accountTrafficView == null) {
                        return "";
                    }
                    if (accountTrafficView.isUnlimitedTraffic()) {
                        return _GUI.T.premiumaccounttablemodel_column_trafficleft_unlimited();
                    }
                    return Formatter.formatReadable((long)accountTrafficView.getTrafficLeft()) + "/" + Formatter.formatReadable((long)accountTrafficView.getTrafficMax());
                }
                return "";
            }

            protected long getMax(AccountInterface value) {
                if (value instanceof AccountWrapper) {
                    AccountWrapper accountWrapper = (AccountWrapper)value;
                    if (!accountWrapper.isValid()) {
                        return 100L;
                    }
                    AccountTrafficView accountTrafficView = accountWrapper.getAccount().getAccountTrafficView();
                    if (accountTrafficView == null) {
                        return 100L;
                    }
                    if (accountTrafficView.isUnlimitedTraffic()) {
                        return 100L;
                    }
                    return accountTrafficView.getTrafficMax();
                }
                return 100L;
            }

            protected long getValue(AccountInterface value) {
                if (value instanceof AccountWrapper) {
                    AccountWrapper accountWrapper = (AccountWrapper)value;
                    if (!accountWrapper.isValid()) {
                        return 0L;
                    }
                    AccountTrafficView accountTrafficView = accountWrapper.getAccount().getAccountTrafficView();
                    if (accountTrafficView == null) {
                        return 0L;
                    }
                    if (accountTrafficView.isUnlimitedTraffic()) {
                        return 100L;
                    }
                    return accountTrafficView.getTrafficLeft();
                }
                return -1L;
            }
        });
    }
}

