/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.packagizer;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import jd.gui.swing.jdgui.views.settings.panels.packagizer.PackagizerFilter;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.appwork.utils.swing.dialog.ExtFileChooserDialog;
import org.appwork.utils.swing.dialog.FileChooserSelectionMode;
import org.appwork.utils.swing.dialog.FileChooserType;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.packagizer.PackagizerController;
import org.jdownloader.controlling.packagizer.PackagizerRule;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.logging.LogController;
import org.jdownloader.translate._JDT;

public class ImportAction
extends AppAction {
    public static final String EXT = ".packagizer";
    private static final long serialVersionUID = 1L;

    public ImportAction(PackagizerFilter packagizer) {
        this.setIconKey("import");
        this.setName(_GUI.T.LinkgrabberFilter_LinkgrabberFilter_import());
        this.setTooltipText(_JDT.T.ImportAction_tt());
    }

    public void actionPerformed(ActionEvent e) {
        try {
            ExtFileChooserDialog d = new ExtFileChooserDialog(0, _GUI.T.Packagizer_import_dialog_title(), null, null);
            d.setFileSelectionMode(FileChooserSelectionMode.FILES_ONLY);
            d.setFileFilter(new FileFilter[]{new FileFilter(){

                @Override
                public String getDescription() {
                    return "*.packagizer";
                }

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || StringUtils.endsWithCaseInsensitive((String)f.getName(), (String)ImportAction.EXT);
                }
            }});
            d.setType(FileChooserType.OPEN_DIALOG);
            d.setMultiSelection(true);
            Dialog.I().showDialog((AbstractDialog)d);
            File[] files = d.getSelection();
            if (files == null || files.length == 0) {
                return;
            }
            ArrayList all = new ArrayList();
            for (File file : files) {
                List contents;
                if (!file.isFile()) continue;
                try {
                    contents = (List)JSonStorage.restoreFromString((String)IO.readFileToString((File)file), (TypeRef)new TypeRef<ArrayList<PackagizerRule>>(){});
                }
                catch (Throwable e1) {
                    LogController.CL().log(e1);
                    Dialog.getInstance().showExceptionDialog(_GUI.T.lit_error_occured(), file.getAbsolutePath() + "-" + e1.getMessage(), e1);
                    continue;
                }
                if (contents == null || contents.size() == 0) {
                    Dialog.getInstance().showErrorDialog(_GUI.T.LinkgrabberFilter_LinkgrabberFilter_import_invalid(file.getName()));
                    continue;
                }
                all.addAll(contents);
            }
            PackagizerController.getInstance().addAll(all);
        }
        catch (DialogNoAnswerException e1) {
            LogController.CL().log((Throwable)e1);
        }
    }
}

