/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.packagizer;

import java.awt.event.ActionEvent;
import java.util.List;
import jd.controlling.TaskQueue;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.WarnLevel;
import jd.gui.swing.jdgui.views.settings.panels.packagizer.PackagizerFilterTable;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.packagizer.PackagizerController;
import org.jdownloader.controlling.packagizer.PackagizerRule;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.translate._JDT;

public class RemoveAction
extends AppAction {
    private static final long serialVersionUID = -477419276505058907L;
    private List<PackagizerRule> selected;
    private PackagizerFilterTable table;
    private boolean ignoreSelection = false;

    public RemoveAction(PackagizerFilterTable table) {
        this.table = table;
        this.ignoreSelection = true;
        this.setName(_GUI.T.literally_remove());
        this.setIconKey("remove");
    }

    public RemoveAction(PackagizerFilterTable table, List<PackagizerRule> selected, boolean force) {
        this.table = table;
        this.selected = selected;
        this.setName(_GUI.T.literally_remove());
        this.setIconKey("remove");
    }

    protected boolean rly(String msg) {
        try {
            Dialog.getInstance().showConfirmDialog(32, _GUI.T.literall_are_you_sure(), msg, null, null, null);
            return true;
        }
        catch (DialogClosedException e) {
            e.printStackTrace();
        }
        catch (DialogCanceledException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (JDGui.bugme(WarnLevel.NORMAL) && !this.rly(_JDT.T.RemoveAction_actionPerformed_rly_msg())) {
            return;
        }
        final List remove = this.selected != null ? this.selected : this.table.getModel().getSelectedObjects();
        if (remove != null && remove.size() > 0) {
            TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    for (PackagizerRule rule : remove) {
                        if (rule.isStaticRule()) continue;
                        PackagizerController.getInstance().remove(rule);
                    }
                    return null;
                }
            });
        }
    }

    public boolean isEnabled() {
        if (this.ignoreSelection) {
            return super.isEnabled();
        }
        if (this.selected != null) {
            for (PackagizerRule rule : this.selected) {
                if (rule.isStaticRule()) continue;
                return true;
            }
        }
        return false;
    }
}

