/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.urlordertable;

import java.awt.Component;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTableHeaderRenderer;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtCheckColumn;
import org.appwork.swing.exttable.columns.ExtTextAreaColumn;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.renderer.RendererMigPanel;
import org.jdownloader.controlling.DefaultDownloadLinkViewImpl;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.UrlDisplayEntry;
import org.jdownloader.settings.UrlDisplayType;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public class UrlOrderTableModel
extends ExtTableModel<UrlDisplayEntry>
implements GenericConfigEventListener<Object> {
    public UrlOrderTableModel() {
        super("UrlOrderTableModel");
        CFG_GENERAL.URL_ORDER.getEventSender().addListener((EventListener)((Object)this), true);
        this.update();
    }

    private void update() {
        new EDTRunner(){

            protected void runInEDT() {
                DefaultDownloadLinkViewImpl.DISPLAY_URL_TYPE.getClass();
                ArrayList<UrlDisplayEntry> lst = new ArrayList<UrlDisplayEntry>();
                UrlDisplayEntry[] newOrder = CFG_GENERAL.CFG.getUrlOrder();
                HashSet<Object> dupe = new HashSet<Object>();
                if (newOrder != null) {
                    for (UrlDisplayEntry urlDisplayEntry : newOrder) {
                        try {
                            if (!dupe.add(UrlDisplayType.valueOf((String)urlDisplayEntry.getType()))) continue;
                            lst.add(urlDisplayEntry);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                for (UrlDisplayEntry urlDisplayEntry : UrlDisplayType.values()) {
                    if (!dupe.add(urlDisplayEntry)) continue;
                    lst.add(new UrlDisplayEntry(urlDisplayEntry.name(), true));
                }
                UrlOrderTableModel.this._fireTableStructureChanged(lst, true);
            }
        };
    }

    public boolean move(List<UrlDisplayEntry> transferData, int dropRow) {
        try {
            ArrayList newdata = new ArrayList(this.getTableData().size());
            ArrayList before = new ArrayList(this.getTableData().subList(0, dropRow));
            ArrayList after = new ArrayList(this.getTableData().subList(dropRow, this.getTableData().size()));
            before.removeAll(transferData);
            after.removeAll(transferData);
            newdata.addAll(before);
            newdata.addAll(transferData);
            newdata.addAll(after);
            CFG_GENERAL.CFG.setUrlOrder(newdata.toArray(new UrlDisplayEntry[0]));
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    protected void initColumns() {
        this.addColumn((ExtColumn)new ExtCheckColumn<UrlDisplayEntry>(_GUI.T.premiumaccounttablemodel_column_enabled()){
            private final JComponent empty;
            {
                this.empty = new RendererMigPanel("ins 0", "[]", "[]");
            }

            public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
                ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer((ExtColumn)this, jTableHeader){
                    private final Icon ok;
                    {
                        this.ok = NewTheme.I().getIcon("ok", 14);
                    }

                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        this.setIcon(this.ok);
                        this.setHorizontalAlignment(0);
                        this.setText(null);
                        return this;
                    }
                };
                return ret;
            }

            public int getMaxWidth() {
                return 30;
            }

            public JComponent getRendererComponent(UrlDisplayEntry value, boolean isSelected, boolean hasFocus, int row, int column) {
                JComponent ret = super.getRendererComponent((Object)value, isSelected, hasFocus, row, column);
                return ret;
            }

            public boolean isSortable(UrlDisplayEntry obj) {
                return false;
            }

            public boolean isHidable() {
                return false;
            }

            protected boolean getBooleanValue(UrlDisplayEntry value) {
                return value.isEnabled();
            }

            public boolean isEditable(UrlDisplayEntry obj) {
                return true;
            }

            protected void setBooleanValue(boolean value, UrlDisplayEntry object) {
                object.setEnabled(!object.isEnabled());
                CFG_GENERAL.CFG.setUrlOrder(UrlOrderTableModel.this.getTableData().toArray(new UrlDisplayEntry[0]));
            }
        });
        this.addColumn((ExtColumn)new ExtTextAreaColumn<UrlDisplayEntry>(_GUI.T.UrlOrderTableModel_type()){

            public boolean isHidable() {
                return false;
            }

            public boolean isSortable(UrlDisplayEntry obj) {
                return false;
            }

            public boolean isEnabled(UrlDisplayEntry obj) {
                return obj.isEnabled();
            }

            public int getMaxWidth() {
                return 300;
            }

            public int getMinWidth() {
                return 64;
            }

            protected boolean isDefaultResizable() {
                return false;
            }

            public int getDefaultWidth() {
                return 140;
            }

            public String getStringValue(UrlDisplayEntry value) {
                return UrlDisplayType.valueOf((String)value.getType()).getTranslatedName();
            }
        });
        this.addColumn((ExtColumn)new ExtTextAreaColumn<UrlDisplayEntry>(_GUI.T.UrlOrderTableModel_type_desc()){

            public boolean isHidable() {
                return false;
            }

            public boolean isEnabled(UrlDisplayEntry obj) {
                return obj.isEnabled();
            }

            public boolean isSortable(UrlDisplayEntry obj) {
                return false;
            }

            public String getStringValue(UrlDisplayEntry value) {
                return UrlDisplayType.valueOf((String)value.getType()).getTranslatedDescription();
            }
        });
    }

    public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
        this.update();
    }

    public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
        this.update();
    }
}

