/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.laf;

import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.MetalLookAndFeel;
import jd.SecondLevelLaunch;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.synthetica.SyntheticaHelper;
import org.appwork.swing.synthetica.SyntheticaSettings;
import org.appwork.uio.UIOManager;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.LAFManagerInterface;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.appwork.utils.swing.windowmanager.WindowsWindowManager;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.updatev2.UpdateController;
import org.jdownloader.updatev2.gui.LAFOptions;
import org.jdownloader.updatev2.gui.LookAndFeelType;

public class LookAndFeelController
implements LAFManagerInterface {
    private static final LookAndFeelController INSTANCE = new LookAndFeelController();
    private GraphicalUserInterfaceSettings config = (GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class);
    private LogSource logger = LogController.getInstance().getLogger(this.getClass().getName());
    public static final String DEFAULT_PREFIX = "LAF_CFG";
    private static boolean uiInitated = false;

    public static LookAndFeelController getInstance() {
        return INSTANCE;
    }

    private LookAndFeelController() {
        SecondLevelLaunch.UPDATE_HANDLER_SET.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                CFG_GUI.LOOK_AND_FEEL_THEME.getEventSender().addListener((EventListener)new GenericConfigEventListener<Enum>(){

                    public void onConfigValueModified(KeyHandler<Enum> keyHandler, Enum newValue) {
                        LookAndFeelController.this.handleThemesInstallation();
                    }

                    public void onConfigValidatorError(KeyHandler<Enum> keyHandler, Enum invalidValue, ValidationException validateException) {
                    }
                });
                LookAndFeelController.this.handleThemesInstallation();
            }
        });
    }

    protected void handleThemesInstallation() {
        if (UpdateController.getInstance().getHandler() == null) {
            return;
        }
        LookAndFeelType lafTheme = CFG_GUI.CFG.getLookAndFeelTheme();
        if (lafTheme == null) {
            lafTheme = LookAndFeelType.DEFAULT;
            CFG_GUI.CFG.setLookAndFeelTheme(lafTheme);
        }
        if (LookAndFeelType.DEFAULT.equals((Object)lafTheme) || lafTheme.getExtensionID() == null) {
            return;
        }
        if (!lafTheme.isSupported()) {
            return;
        }
        if (UpdateController.getInstance().isExtensionInstalled(lafTheme.getExtensionID()) && lafTheme.isAvailable()) {
            return;
        }
        if (UIOManager.I().showConfirmDialog(0, _GUI.T.LookAndFeelController_handleThemesInstallation_title_(), _GUI.T.LookAndFeelController_handleThemesInstallation_message_(lafTheme.name()), (Icon)new AbstractIcon("updaterIcon0", 64), null, null)) {
            final LookAndFeelType finalLafTheme = lafTheme;
            new Thread("Install Extension"){

                @Override
                public void run() {
                    try {
                        UpdateController.getInstance().setGuiVisible(true);
                        if (UpdateController.getInstance().isExtensionInstalled(finalLafTheme.getExtensionID())) {
                            UpdateController.getInstance().runExtensionsFullUpdate(new ArrayList<String>(Arrays.asList(finalLafTheme.getExtensionID())));
                        } else {
                            UpdateController.getInstance().runExtensionInstallation(finalLafTheme.getExtensionID());
                        }
                        while (true) {
                            Thread.sleep(500L);
                            if (UpdateController.getInstance().isRunning()) {
                                UpdateController.getInstance().waitForUpdate();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        LoggerFactory.getDefaultLogger().log((Throwable)e);
                    }
                }
            }.start();
        } else {
            CFG_GUI.CFG.setLookAndFeelTheme(LookAndFeelType.DEFAULT);
        }
    }

    private void initLookAndFeel(LookAndFeel laf) {
        if (ReflectionUtils.isInstanceOf((String)"de.javasoft.plaf.synthetica.SyntheticaLookAndFeel", (Object)laf)) {
            ExtTooltip.setForgroundColor((Color)LAFOptions.getInstance().getColorForTooltipForeground());
            UIManager.put("Appwork.Tooltip.Foreground", LAFOptions.getInstance().getColorForTooltipForeground());
        } else if (ReflectionUtils.isInstanceOf((String)"com.formdev.flatlaf.FlatLaf", (Object)laf)) {
            UIManager.put("ScrollBar.width", 14);
            if (LAFOptions.getInstance().getCfg().isWindowDecorationEnabled()) {
                System.setProperty("flatlaf.useWindowDecorations", "true");
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
            } else {
                System.setProperty("flatlaf.useWindowDecorations", "false");
                JFrame.setDefaultLookAndFeelDecorated(false);
                JDialog.setDefaultLookAndFeelDecorated(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void setUIManager() {
        block54: {
            long t;
            block51: {
                if (uiInitated) {
                    return;
                }
                uiInitated = true;
                if (Application.isHeadless()) {
                    return;
                }
                this.initWindowManager();
                t = System.currentTimeMillis();
                String laf = null;
                try {
                    String customLookAndFeel = this.config.getCustomLookAndFeelClass();
                    if (StringUtils.isNotEmpty((String)customLookAndFeel)) {
                        try {
                            Class.forName(customLookAndFeel);
                            laf = customLookAndFeel;
                        }
                        catch (Throwable e) {
                            this.logger.log(e);
                        }
                    }
                    if (laf == null) {
                        LookAndFeelType theme = this.config.getLookAndFeelTheme();
                        laf = theme == null || !theme.isAvailable() ? LookAndFeelType.DEFAULT.getClazz() : theme.getClazz();
                    }
                }
                catch (Throwable e) {
                    this.logger.log(e);
                    laf = LookAndFeelType.DEFAULT.getClazz();
                }
                finally {
                    LoggerFactory.getDefaultLogger().info("Use Look & Feel: " + laf);
                }
                if (laf.contains("Synthetica") || laf.equals(LookAndFeelType.DEFAULT.getClazz()) || laf.equals(LookAndFeelType.JD_PLAIN.getClazz())) {
                    String liz;
                    block50: {
                        liz = null;
                        try {
                            URL url = Application.getRessourceURL((String)"cfg/synthetica-license.key");
                            if (url != null) {
                                liz = IO.readURLToString((URL)url);
                            }
                            if (liz != null || Application.isJared(LookAndFeelController.class)) break block50;
                            url = Application.getRessourceURL((String)"");
                            File bin = new File(url.toURI());
                            File db = new File(bin.getParent(), ".svn/wc.db");
                            if (db.isFile()) {
                                String str = IO.readFileToString((File)db);
                                if (!str.contains("svn://svn.jdownloader.org/jdownloader") && !str.contains("SQLite format")) break block50;
                                str = null;
                                if (!Application.getResource((String)"JDownloader.jar").exists()) break block50;
                                JarFile jf = null;
                                try {
                                    jf = new JarFile(Application.getResource((String)"JDownloader.jar"));
                                    JarEntry je = jf.getJarEntry("cfg/synthetica-license.key");
                                    liz = IO.readInputStreamToString((InputStream)jf.getInputStream(je));
                                    break block50;
                                }
                                finally {
                                    if (jf != null) {
                                        jf.close();
                                    }
                                }
                            }
                            String str = IO.readFileToString((File)new File(bin.getParent(), ".svn/entries"));
                            if (str == null || !str.contains("svn://svn.jdownloader.org/jdownloader/trunk")) break block50;
                            str = null;
                            if (!Application.getResource((String)"JDownloader.jar").isFile()) break block50;
                            JarFile jf = null;
                            try {
                                jf = new JarFile(Application.getResource((String)"JDownloader.jar"));
                                JarEntry je = jf.getJarEntry("cfg/synthetica-license.key");
                                liz = IO.readInputStreamToString((InputStream)jf.getInputStream(je));
                            }
                            finally {
                                if (jf != null) {
                                    jf.close();
                                }
                            }
                        }
                        catch (Exception url) {
                            // empty catch block
                        }
                    }
                    LAFOptions.init((String)laf);
                    if (Application.isHeadless()) {
                        SyntheticaHelper.setLicense((String)liz);
                    } else {
                        new SyntheticaHelper((SyntheticaSettings)LAFOptions.getInstance().getCfg()).load(laf, liz);
                    }
                    this.initLookAndFeel(UIManager.getLookAndFeel());
                    break block51;
                }
                UIManager.setLookAndFeel(laf);
                LAFOptions.init((String)laf);
                this.initLookAndFeel(UIManager.getLookAndFeel());
            }
            try {
                String theme = LAFOptions.getInstance().getCfg().getIconSetID();
                NewTheme.getInstance().setTheme(theme);
                if (!StringUtils.equals((String)"standard", (String)theme) && StringUtils.isNotEmpty((String)theme) && !StringUtils.startsWithCaseInsensitive((String)theme, (String)"my-")) {
                    SecondLevelLaunch.UPDATE_HANDLER_SET.executeWhenReached(new Runnable(theme){
                        final /* synthetic */ String val$theme;
                        {
                            this.val$theme = string;
                        }

                        @Override
                        public void run() {
                            if (Application.isJared(null)) {
                                SecondLevelLaunch.INIT_COMPLETE.executeWhenReached(new Runnable(){

                                    @Override
                                    public void run() {
                                        String extensionID = "iconset-" + val$theme;
                                        if (!UpdateController.getInstance().isExtensionInstalled(extensionID)) {
                                            try {
                                                UpdateController.getInstance().setGuiVisible(true);
                                                UpdateController.getInstance().runExtensionInstallation(extensionID);
                                            }
                                            catch (InterruptedException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
            LoggerFactory.getDefaultLogger().info("LAF init: " + (System.currentTimeMillis() - t));
            break block54;
            catch (Throwable e) {
                block53: {
                    block52: {
                        LogV3.log((Throwable)e);
                        LookAndFeel currentLaf = UIManager.getLookAndFeel();
                        if (currentLaf == null || currentLaf instanceof MetalLookAndFeel) break block52;
                        LogV3.info((String)("Don't set System look and feel " + currentLaf + " is already set"));
                        try {
                            String theme = LAFOptions.getInstance().getCfg().getIconSetID();
                            NewTheme.getInstance().setTheme(theme);
                            if (!StringUtils.equals((String)"standard", (String)theme) && StringUtils.isNotEmpty((String)theme) && !StringUtils.startsWithCaseInsensitive((String)theme, (String)"my-")) {
                                SecondLevelLaunch.UPDATE_HANDLER_SET.executeWhenReached(new /* invalid duplicate definition of identical inner class */);
                            }
                        }
                        catch (Throwable e2) {
                            LoggerFactory.getDefaultLogger().log(e2);
                        }
                        LoggerFactory.getDefaultLogger().info("LAF init: " + (System.currentTimeMillis() - t));
                        return;
                    }
                    try {
                        String systemLookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
                        UIManager.setLookAndFeel(systemLookAndFeelClassName);
                        LAFOptions.init((String)systemLookAndFeelClassName);
                        this.initLookAndFeel(UIManager.getLookAndFeel());
                        {
                            catch (ClassNotFoundException e1) {
                                e1.printStackTrace();
                                break block53;
                            }
                            catch (InstantiationException e1) {
                                e1.printStackTrace();
                                break block53;
                            }
                            catch (IllegalAccessException e1) {
                                e1.printStackTrace();
                                break block53;
                            }
                            catch (UnsupportedLookAndFeelException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            String theme = LAFOptions.getInstance().getCfg().getIconSetID();
                            NewTheme.getInstance().setTheme(theme);
                            if (!StringUtils.equals((String)"standard", (String)theme) && StringUtils.isNotEmpty((String)theme) && !StringUtils.startsWithCaseInsensitive((String)theme, (String)"my-")) {
                                SecondLevelLaunch.UPDATE_HANDLER_SET.executeWhenReached(new /* invalid duplicate definition of identical inner class */);
                            }
                        }
                        catch (Throwable e3) {
                            LoggerFactory.getDefaultLogger().log(e3);
                        }
                        LoggerFactory.getDefaultLogger().info("LAF init: " + (System.currentTimeMillis() - t));
                        throw throwable;
                    }
                }
                try {
                    String theme = LAFOptions.getInstance().getCfg().getIconSetID();
                    NewTheme.getInstance().setTheme(theme);
                    if (!StringUtils.equals((String)"standard", (String)theme) && StringUtils.isNotEmpty((String)theme) && !StringUtils.startsWithCaseInsensitive((String)theme, (String)"my-")) {
                        SecondLevelLaunch.UPDATE_HANDLER_SET.executeWhenReached(new /* invalid duplicate definition of identical inner class */);
                    }
                }
                catch (Throwable e4) {
                    LoggerFactory.getDefaultLogger().log(e4);
                }
                LoggerFactory.getDefaultLogger().info("LAF init: " + (System.currentTimeMillis() - t));
            }
        }
    }

    private void initWindowManager() {
        WindowManager wm = WindowManager.getInstance();
        if (wm instanceof WindowsWindowManager && CrossSystem.isWindows()) {
            final WindowsWindowManager wwm = (WindowsWindowManager)wm;
            wwm.setAltWorkaroundEnabled(CFG_GUI.CFG.isWindowsWindowManagerAltKeyWorkaroundEnabled());
            wwm.setAltWorkaroundKeys(CFG_GUI.CFG.getWindowsWindowManagerAltKeyCombi());
            try {
                CFG_GUI.CFG.setWindowsWindowManagerForegroundLockTimeout(WindowsWindowManager.readForegroundLockTimeout());
            }
            catch (Exception e) {
                CFG_GUI.CFG.setWindowsWindowManagerForegroundLockTimeout(-1);
                this.logger.log((Throwable)e);
            }
            CFG_GUI.WINDOWS_WINDOW_MANAGER_FOREGROUND_LOCK_TIMEOUT.getEventSender().addListener((EventListener)new GenericConfigEventListener<Integer>(){

                public void onConfigValidatorError(KeyHandler<Integer> keyHandler, Integer invalidValue, ValidationException validateException) {
                }

                public void onConfigValueModified(KeyHandler<Integer> keyHandler, Integer newValue) {
                    try {
                        if (newValue >= 0 && newValue != WindowsWindowManager.readForegroundLockTimeout()) {
                            WindowsWindowManager.writeForegroundLockTimeout((int)newValue);
                            Dialog.getInstance().showMessageDialog(_GUI.T.LookAndFeelController_onConfigValueModified_reboot_required());
                        }
                    }
                    catch (Exception e) {
                        LookAndFeelController.this.logger.log((Throwable)e);
                        Dialog.getInstance().showExceptionDialog(_GUI.T.lit_error_occured(), e.getMessage(), (Throwable)e);
                    }
                }
            });
            CFG_GUI.WINDOWS_WINDOW_MANAGER_ALT_KEY_WORKAROUND_ENABLED.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

                public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
                }

                public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                    wwm.setAltWorkaroundEnabled(Boolean.TRUE.equals(newValue));
                }
            });
            CFG_GUI.WINDOWS_WINDOW_MANAGER_ALT_KEY_COMBI.getEventSender().addListener((EventListener)new GenericConfigEventListener<int[]>(){

                public void onConfigValueModified(KeyHandler<int[]> keyHandler, int[] newValue) {
                    wwm.setAltWorkaroundKeys(CFG_GUI.CFG.getWindowsWindowManagerAltKeyCombi());
                }

                public void onConfigValidatorError(KeyHandler<int[]> keyHandler, int[] invalidValue, ValidationException validateException) {
                }
            });
        }
    }

    public void init() {
        this.setUIManager();
    }
}

