/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.container;

import java.io.File;
import java.security.Key;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import jd.controlling.linkcrawler.ArchiveInfo;
import jd.controlling.linkcrawler.CrawledLink;
import jd.parser.Regex;
import jd.plugins.ContainerStatus;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.PluginException;
import jd.plugins.PluginsC;
import jd.plugins.hoster.Ftp;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.uio.CloseReason;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.StringUtils;
import org.appwork.utils.XML;
import org.appwork.utils.encoding.Base64;
import org.jdownloader.gui.dialog.AskContainerPasswordDialog;
import org.jdownloader.gui.dialog.AskContainerPasswordDialogInterface;
import org.jdownloader.plugins.components.containers.ContainerConfig;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class SFDL
extends PluginsC {
    private static final Pattern PATTERN_COMMON_FILENAME_SCHEME_WITH_PASSWORD = Pattern.compile("^([^\\{]+)\\{\\{(.*?)\\}\\}\\.sfdl$", 2);
    private static final Object PWLOCK = new Object();
    public static final ContainerConfig CFG = (ContainerConfig)JsonConfig.create(ContainerConfig.class);

    public SFDL() {
        super("SFDL", "file:/.+\\.sfdl$", "$Revision: 13393 $");
    }

    public SFDL newPluginInstance() {
        return new SFDL();
    }

    public ContainerStatus callDecryption(File sfdlFile) {
        ContainerStatus cs = new ContainerStatus(sfdlFile);
        try {
            NodeList downloadFiles;
            NodeList downloadFiles2;
            DocumentBuilder documentBuilder = XML.newSecureFactory().newDocumentBuilder();
            Document document = documentBuilder.parse(sfdlFile);
            boolean sfdl_AuthRequired = Boolean.TRUE.equals(SFDL.getObject(document, "AuthRequired"));
            boolean sdfl_Encrypted = Boolean.TRUE.equals(SFDL.getObject(document, "Encrypted"));
            boolean sfdl_BulkFolderMode = Boolean.TRUE.equals(SFDL.getObject(document, "BulkFolderMode"));
            Object maxDownloadThreads = SFDL.getObject(document, "MaxDownloadThreads");
            String sfdl_Description = SFDL.getNode(document, "Description");
            String sfdl_Uploader = SFDL.getNode(document, "Uploader");
            String sfdl_Host = SFDL.getNode(document, "Host");
            int sfdl_Port = Integer.parseInt(SFDL.getNode(document, "Port"));
            String sfdl_Username = SFDL.getNode(document, "Username");
            String sfdl_Password = SFDL.getNode(document, "Password");
            String sfdl_DefaultPath = SFDL.getNode(document, "DefaultPath");
            Regex filenameSchemeWithPassword = new Regex((Object)sfdlFile.getName(), PATTERN_COMMON_FILENAME_SCHEME_WITH_PASSWORD);
            ArchiveInfo archiveInfo = null;
            FilePackage fp = FilePackage.getInstance();
            String passwordFromFilename = null;
            if (filenameSchemeWithPassword.patternFind()) {
                fp.setName(filenameSchemeWithPassword.getMatch(0));
                archiveInfo = new ArchiveInfo();
                archiveInfo.addExtractionPassword(passwordFromFilename);
                passwordFromFilename = filenameSchemeWithPassword.getMatch(1);
            } else {
                fp.setName(sfdlFile.getName());
            }
            String validpassword = null;
            if (sdfl_Encrypted) {
                this.logger.info("SFDL is password protected");
                List<String> pwlist = this.getSFDLPasswordList();
                if (passwordFromFilename != null) {
                    pwlist.remove(passwordFromFilename);
                    pwlist.add(0, passwordFromFilename);
                }
                String decodedValue = null;
                if (pwlist.size() > 0) {
                    for (String pw : pwlist) {
                        decodedValue = this.decrypt(sfdl_Host, pw);
                        if (decodedValue == null) continue;
                        this.logger.info("Found valid password in passwordlist: " + pw);
                        validpassword = pw;
                        break;
                    }
                    if (validpassword == null) {
                        this.logger.info("Failed to find valid password in passwordlist");
                    }
                }
                if (decodedValue == null) {
                    int counter = 0;
                    do {
                        String pw;
                        if (!StringUtils.isEmpty((String)(pw = this.getUserInputContainerPassword(sfdlFile)))) {
                            decodedValue = this.decrypt(sfdl_Host, pw);
                            if (decodedValue != null) {
                                this.logger.info("User entered valid password: " + pw);
                                validpassword = pw;
                                break;
                            }
                            this.logger.info("User entered invalid password: " + pw);
                            continue;
                        }
                        this.logger.info("User entered invalid/empty password");
                    } while (++counter <= 2);
                }
                if (decodedValue == null) {
                    this.logger.info("Failed to find password");
                    cs.setStatus(16);
                    return cs;
                }
                this.addPassword(validpassword);
                sfdl_Host = decodedValue;
                sfdl_Description = this.decrypt(sfdl_Description, validpassword);
                sfdl_Uploader = this.decrypt(sfdl_Uploader, validpassword);
                sfdl_Username = this.decrypt(sfdl_Username, validpassword);
                sfdl_Password = this.decrypt(sfdl_Password, validpassword);
                sfdl_DefaultPath = this.decrypt(sfdl_DefaultPath, validpassword);
                if (sfdl_Username == null || sfdl_Password == null) {
                    sfdl_Username = "anonymous";
                    sfdl_Password = "anonymous@anonymous.com";
                }
            }
            ArrayList<String> sfdl_BulkFolderPathArray = new ArrayList<String>();
            ArrayList<String> sfdl_FileListArray = new ArrayList<String>();
            ArrayList<Long> sfdl_FileSizeArray = new ArrayList<Long>();
            if (sfdl_BulkFolderMode) {
                downloadFiles2 = document.getElementsByTagName("BulkFolderPath");
                for (int i = 0; i < downloadFiles2.getLength(); ++i) {
                    String value = downloadFiles2.item(i).getTextContent();
                    if (sdfl_Encrypted) {
                        value = this.decrypt(value, validpassword);
                    }
                    sfdl_BulkFolderPathArray.add(value);
                }
            } else {
                downloadFiles2 = document.getElementsByTagName("FileFullPath");
                NodeList fileSizes = document.getElementsByTagName("FileSize");
                for (int i = 0; i < downloadFiles2.getLength(); ++i) {
                    String value = downloadFiles2.item(i).getTextContent();
                    if (sdfl_Encrypted) {
                        value = this.decrypt(value, validpassword);
                    }
                    sfdl_FileListArray.add(value);
                    sfdl_FileSizeArray.add(Long.valueOf(fileSizes.item(i).getTextContent()));
                }
            }
            ArrayList<DownloadLink> ret = new ArrayList<DownloadLink>();
            if (sfdl_BulkFolderMode) {
                downloadFiles = document.getElementsByTagName("BulkFolderPath");
                this.logger.info("Found " + downloadFiles.getLength() + " FTP folders");
                for (int i = 0; i < downloadFiles.getLength(); ++i) {
                    String ftpFolderPath = downloadFiles.item(i).getTextContent();
                    String ftpurl = this.getURL(ftpFolderPath, sdfl_Encrypted, validpassword, sfdl_AuthRequired, sfdl_Username, sfdl_Password, sfdl_Host, sfdl_Port);
                    if (!ftpurl.endsWith("/")) {
                        ftpurl = ftpurl + "/";
                    }
                    this.logger.info("Result: " + ftpurl);
                    DownloadLink ftpfolder = new DownloadLink(null, null, "ftp", ftpurl + "#max_depth=-1", true);
                    ret.add(ftpfolder);
                }
            } else {
                downloadFiles = document.getElementsByTagName("FileFullPath");
                NodeList fileSizes = document.getElementsByTagName("FileSize");
                this.logger.info("Found " + downloadFiles.getLength() + " FTP files");
                for (int i = 0; i < downloadFiles.getLength(); ++i) {
                    String ftpFilePath = downloadFiles.item(i).getTextContent();
                    String ftpurl = this.getURL(ftpFilePath, sdfl_Encrypted, validpassword, sfdl_AuthRequired, sfdl_Username, sfdl_Password, sfdl_Host, sfdl_Port);
                    this.logger.info("Result: " + ftpurl);
                    DownloadLink ftpfile = new DownloadLink(Ftp.createURLForThisPlugin((String)ftpurl), true);
                    if (fileSizes.getLength() == downloadFiles.getLength()) {
                        long filesize = Long.valueOf(fileSizes.item(i).getTextContent());
                        ftpfile.setDownloadSize(filesize);
                    }
                    ftpfile.setAvailableStatus(DownloadLink.AvailableStatus.UNCHECKABLE);
                    if (fp != null) {
                        ftpfile._setFilePackage(fp);
                    }
                    ret.add(ftpfile);
                }
            }
            ArrayList<CrawledLink> crawledLinks = new ArrayList<CrawledLink>(ret.size());
            for (DownloadLink result : ret) {
                Number num;
                if (maxDownloadThreads != null && maxDownloadThreads instanceof Number && (num = (Number)maxDownloadThreads).intValue() >= 1) {
                    result.setProperty("MAX_FTP_CONNECTIONS", maxDownloadThreads);
                }
                CrawledLink crawledLink = new CrawledLink(result);
                if (archiveInfo != null) {
                    crawledLink.setArchiveInfo(archiveInfo);
                }
                crawledLinks.add(crawledLink);
            }
            this.cls = crawledLinks;
            cs.setStatus(2);
            return cs;
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            cs.setStatus(4);
            return cs;
        }
    }

    protected String getURL(String ftpFilePath, boolean sdfl_Encrypted, String decryptPassword, boolean sfdl_AuthRequired, String sfdl_Username, String sfdl_Password, String sfdl_Host, int sfdl_Port) {
        if (sdfl_Encrypted) {
            ftpFilePath = this.decrypt(ftpFilePath, decryptPassword);
        }
        ftpFilePath = ftpFilePath.replaceAll(" ", "%20");
        String ret = "ftp://";
        if (sfdl_AuthRequired) {
            if (sfdl_Username == null) {
                sfdl_Username = "anonymous";
            }
            ret = ret + sfdl_Username;
            if (sfdl_Password != null) {
                ret = ret + ":" + sfdl_Password;
            }
            ret = ret + "@";
        }
        ret = ret + sfdl_Host;
        if (sfdl_Port != 21) {
            ret = ret + ":" + sfdl_Port;
        }
        ret = ret + ftpFilePath;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPassword(String pw) {
        if (StringUtils.isEmpty((String)pw)) {
            return;
        }
        Object object = PWLOCK;
        synchronized (object) {
            List<String> ret = this.getSFDLPasswordList();
            if (ret.indexOf(pw) == 0) {
                return;
            }
            ret.remove(pw);
            ret.add(0, pw);
            CFG.setSFDLContainerPasswordList(ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getSFDLPasswordList() {
        Object object = PWLOCK;
        synchronized (object) {
            CopyOnWriteArrayList<String> ret = CFG.getSFDLContainerPasswordList();
            if (ret == null || ret.size() == 0) {
                ret = new CopyOnWriteArrayList<String>();
            } else if (!(ret instanceof CopyOnWriteArrayList)) {
                ret = new CopyOnWriteArrayList<String>(ret);
            }
            return ret;
        }
    }

    public String getUserInputContainerPassword(File file) throws PluginException {
        AskContainerPasswordDialogInterface handle = (AskContainerPasswordDialogInterface)UIOManager.I().show(AskContainerPasswordDialogInterface.class, (UserIODefinition)new AskContainerPasswordDialog("Enter container password", "Enter password for container file: " + file.getName(), file));
        if (handle.getCloseReason() == CloseReason.OK) {
            String password = handle.getText();
            return password;
        }
        return null;
    }

    private String decrypt(String encodedString, String password) {
        try {
            byte[] data = Base64.decode((String)encodedString);
            MessageDigest md5pass = MessageDigest.getInstance("MD5");
            byte[] pass = md5pass.digest(password.getBytes("UTF-8"));
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(data, 0, 16));
            SecretKeySpec keyspec = new SecretKeySpec(pass, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            cipher.init(2, (Key)keyspec, iv);
            byte[] decrypted = cipher.doFinal(data);
            if (decrypted.length < 17) {
                return null;
            }
            byte[] return_byte = Arrays.copyOfRange(decrypted, 16, decrypted.length);
            return new String(return_byte, "UTF-8");
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            return null;
        }
    }

    private static String getNode(Document document, String node) {
        NodeList chk = document.getElementsByTagName(node);
        if (chk.getLength() > 0) {
            return new String(chk.item(0).getTextContent());
        }
        return null;
    }

    private static Object getObject(Document document, String node) {
        String objectString = SFDL.getNode(document, node);
        return JSonStorage.restoreFromString((String)objectString, (TypeRef)TypeRef.OBJECT);
    }

    public String[] encrypt(String plain) {
        return null;
    }

    public boolean hideLinks() {
        return true;
    }

    protected boolean canBePasswordProtected() {
        return true;
    }
}

