/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.container.sft;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.Inflater;
import org.appwork.utils.IO;
import org.jdownloader.container.sft.DelphiFormBinLoader;
import org.jdownloader.container.sft.RC4;
import org.jdownloader.container.sft.sftContainer;
import org.jdownloader.container.sft.sftContainerV4;
import org.jdownloader.container.sft.sftContainerV8;

public class sftBinary {
    public static final int MAX_SIZE = 0x800000;
    public static final int HEADER_SIZE = 64;
    public static final byte[] MAGIC = "\u00001F99569B3ZA94Q13A5DBKDKDTTISSSTFFBV5345HFUFHFGHKHKKGFJHHESASOOSIWOA5DB771GFGDFCTSDFF264RFFJKWJWR799CILDSL894DPOMCYWWR334343NG48DHRFQYL569POH11SUJR4334RFCTSDFF264RFFHS677HUZT567MNVX99CILDSLFCTSDFF264RFF894DPOMCYWWR3343OWBV4584JHHDGJFCCCSEWQ967HDHFGRKKFSDFJ".getBytes();

    public static sftContainer load(File file) throws Exception {
        byte[] rawFileData = IO.readFile((File)file, (int)0x800000);
        String sftMagic = new String(Arrays.copyOfRange(rawFileData, 3, 6));
        sftContainer container = null;
        if (sftMagic.equals("SFT")) {
            int sftVersion = Integer.parseInt(new String(Arrays.copyOfRange(rawFileData, 7, 8)));
            switch (sftVersion) {
                case 4: {
                    container = sftBinary.sft04_decrypt(rawFileData);
                    break;
                }
                case 8: {
                    container = sftBinary.sft08_decrypt(rawFileData);
                    break;
                }
                default: {
                    throw new Exception("unsupported sft version: v" + Integer.toHexString(sftVersion));
                }
            }
        } else {
            throw new Exception("unknown file format");
        }
        return container;
    }

    protected static sftContainer sft04_decrypt(byte[] rawFileData) throws Exception {
        byte[] body = new byte[rawFileData.length * 10];
        Inflater decompresser = new Inflater();
        decompresser.setInput(rawFileData, 64, rawFileData.length - 64);
        int decompressedLength = decompresser.inflate(body);
        body = Arrays.copyOf(body, decompressedLength);
        byte[] header = Arrays.copyOfRange(rawFileData, 1, 66);
        header[header.length - 2] = -1;
        header[header.length - 1] = -1;
        byte[] sha1_key = MessageDigest.getInstance("SHA-1").digest(header);
        RC4 rc4 = new RC4(sha1_key);
        for (int dpos = 0; dpos < body.length; dpos += 8192) {
            int end = dpos + 8192;
            if (end > body.length) {
                end = body.length;
            }
            byte[] body_block = Arrays.copyOfRange(body, dpos, end);
            rc4.encode(body_block);
            for (int i = dpos; i < end; ++i) {
                body[i] = body_block[i - dpos];
            }
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(body);
        DataInputStream ois = new DataInputStream(bis);
        DelphiFormBinLoader dfm = new DelphiFormBinLoader(ois);
        return new sftContainerV4(dfm);
    }

    protected static sftContainer sft08_decrypt(byte[] rawFileData) throws Exception {
        byte[] header = Arrays.copyOf(rawFileData, 64);
        byte[] body = Arrays.copyOfRange(rawFileData, 64, rawFileData.length);
        byte[] magicDecryptionKey = sftBinary.sft08_getMagicDecryptionKeyFromHeader(header);
        RC4 rc4 = new RC4(Arrays.copyOf(magicDecryptionKey, 128));
        for (int dpos = 0; dpos < body.length; dpos += 8192) {
            int end = dpos + 8192;
            if (end > body.length) {
                end = body.length;
            }
            byte[] body_block = Arrays.copyOfRange(body, dpos, end);
            rc4.encode(body_block);
            for (int i = dpos; i < end; ++i) {
                body[i] = body_block[i - dpos];
            }
        }
        body = sftBinary.sft08_lmaaDudeDecrypt(body);
        ByteArrayInputStream bis = new ByteArrayInputStream(body);
        DataInputStream ois = new DataInputStream(bis);
        DelphiFormBinLoader dfm = new DelphiFormBinLoader(ois);
        return new sftContainerV8(dfm, magicDecryptionKey);
    }

    protected static byte[] sft08_getMagicDecryptionKeyFromHeader(byte[] header) {
        byte[] magicDecryptionKey = new byte[192];
        byte[] output1 = (byte[])header.clone();
        byte[] output2 = (byte[])header.clone();
        byte[] output3 = (byte[])header.clone();
        sftBinary.sft08_keyRunExec(1, output1);
        sftBinary.sft08_keyRunExec(2, output2);
        sftBinary.sft08_keyRunExec(3, output3);
        int i = 0;
        int resultIndex = 0;
        do {
            magicDecryptionKey[resultIndex] = (byte)(output1[i + 1] | 1);
            magicDecryptionKey[resultIndex + 1] = (byte)(output3[i + 1] | 3);
            magicDecryptionKey[resultIndex + 2] = (byte)(output2[i + 1] | 1);
            magicDecryptionKey[resultIndex + 3] = (i & 1) == 0 ? (byte)(output1[i + 1] ^ output3[i + 1] | 1) : (byte)(output2[i + 1] & output3[i + 1] | output1[i + 1] | 3);
            resultIndex += 4;
        } while (++i != 48);
        return magicDecryptionKey;
    }

    protected static void sft08_keyRunExec(int i, byte[] header) {
        byte result1;
        int constMagicValue1 = 8;
        byte[] sftFileBackup = (byte[])header.clone();
        sftFileBackup[0] = 0;
        header[0] = 0;
        int BL = 2;
        int a = header[8] & 0xFF;
        header[1] = result1 = (byte)(header[((header[a % 51] & 0xFF) + a) % 40] ^ header[8]);
        int e = 0;
        int f = 0;
        int g = 0;
        int special = 0;
        int AL = 0;
        int DL = 0;
        int result = 0;
        switch (i) {
            case 1: {
                do {
                    e = (header[1] & 0xFF | 8) % 31 + 8 & 0xFF;
                    e = e + MAGIC[header[1] & 0xFF] % 8 & 0xFF;
                    f = sftFileBackup[(header[BL - 1] & 0xFF) % e] & 0xFF;
                    g = (header[1] & 0xFF | 8) % 31 + 8 & 0xFF;
                    g = g + MAGIC[header[1] & 0xFF] % 8 & 0xFF;
                    g = (g ^ BL) & 0xFF;
                    special = BL <= 2 ? MAGIC[BL] & 0xFF : header[BL - 2] & 0xFF;
                    result = MAGIC[f] ^ MAGIC[g] & special;
                    header[BL] = (byte)(result & 0xFF);
                } while (++BL != 49);
                break;
            }
            case 2: {
                do {
                    e = (header[1] & 0xFF | 8) % 31 + 8;
                    e = e + MAGIC[header[1] & 0xFF] % 8 & 0xFF;
                    f = sftFileBackup[BL % 43 + 8] & 0xFF;
                    int multi = (sftFileBackup[8] & 0xFF) * f;
                    AL = sftFileBackup[multi % e] & 0xFF;
                    DL = MAGIC[sftFileBackup[61 - BL & 0xFF] & 0xFF] & 0xFF;
                    header[BL] = (byte)(AL | DL);
                } while (++BL != 49);
                break;
            }
            case 3: {
                do {
                    e = (header[1] & 0xFF | 8) % 31 + 8;
                    e = e + MAGIC[header[1] & 0xFF] % 8 & 0xFF;
                    f = MAGIC[sftFileBackup[BL + 8 & 0xFF] & 0xFF] % e & 0xFF;
                    result = (sftFileBackup[f] & 0xFF ^ (MAGIC[BL] | header[BL - 1]) & 0xFF) & 0xFF;
                    header[BL] = (byte)result;
                } while (++BL != 49);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected static byte[] sft08_lmaaDudeDecrypt(byte[] body) throws Exception {
        int blockPos = 0;
        int totalSize = 0;
        ArrayList<byte[]> blocks = new ArrayList<byte[]>();
        while (blockPos < body.length) {
            int blockSize = (body[blockPos + 1] & 0xFF) << 8 | body[blockPos] & 0xFF;
            byte[] block = Arrays.copyOfRange(body, blockPos += 2, blockPos + blockSize);
            block = sftBinary.sft08_lmaaDudeDecryptBlock(block);
            blockPos += blockSize;
            totalSize += block.length;
            blocks.add(block);
        }
        byte[] body_decrypt = new byte[totalSize];
        blockPos = 0;
        for (byte[] block : blocks) {
            System.arraycopy(block, 0, body_decrypt, blockPos, block.length);
            blockPos += block.length;
        }
        return body_decrypt;
    }

    protected static byte[] sft08_lmaaDudeDecryptBlock(byte[] srcBuff) throws Exception {
        byte[] dstBuff = new byte[32768];
        int dstPos = 0;
        int srcPos = 0;
        if (srcBuff[srcPos++] == 128) {
            throw new UnsupportedOperationException("routine not implemented (id: 1)");
        }
        int EBP_C = 0;
        int EBP11 = 0;
        while (srcPos < srcBuff.length) {
            if (EBP11 == 0) {
                EBP_C = ((srcBuff[srcPos] & 0xFF) << 8) + (srcBuff[srcPos + 1] & 0xFF);
                EBP_C &= 0xFFFF;
                EBP11 = 16;
                srcPos += 2;
            }
            if ((EBP_C & 0x8000) == 0) {
                dstBuff[dstPos++] = srcBuff[srcPos++];
            } else {
                int EBP_A = ((srcBuff[srcPos] & 0xFF) << 4) + ((srcBuff[srcPos + 1] & 0xFF) >> 4);
                if (EBP_A == 0) {
                    throw new UnsupportedOperationException("routine not implemented (id: 2)");
                }
                int EBP_E = (srcBuff[srcPos + 1] & 0xF) + 2;
                for (int i = 0; i <= EBP_E; ++i) {
                    dstBuff[i + dstPos] = dstBuff[dstPos - EBP_A + i];
                }
                srcPos += 2;
                dstPos += EBP_E + 1;
            }
            EBP_C = EBP_C << 1 & 0xFFFF;
            EBP11 = (byte)(EBP11 - 1);
        }
        return Arrays.copyOf(dstBuff, dstPos);
    }
}

