/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils.zip;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.nutils.Formatter;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.JDK8BufferHelper;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.DownloadLinkAggregator;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.ExtractionProgress;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public class SharedMemoryState
implements GenericConfigEventListener<Boolean> {
    private static final SharedMemoryState INSTANCE = new SharedMemoryState();
    private static final int VERSION = 2;
    private static final int SLEEP_TIME = 1000;
    private static final String sharedName = "JDownloader";
    private final AtomicReference<Thread> updateThread = new AtomicReference<Object>(null);
    private final LogSource logger = LogController.CL((boolean)false);

    private SharedMemoryState() {
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            public void setHookPriority(int priority) {
                super.setHookPriority(Integer.MAX_VALUE);
            }

            public String toString() {
                return "ShutdownEvent: SharedMemoryState";
            }

            public void onShutdown(ShutdownRequest shutdownRequest) {
                SharedMemoryState.getInstance().stopUpdates();
            }
        });
        CFG_GENERAL.SHARED_MEMORY_STATE_ENABLED.getEventSender().addListener((EventListener)((Object)this));
    }

    public static SharedMemoryState getInstance() {
        return INSTANCE;
    }

    public synchronized void startUpdates() {
        Thread currentThread = this.updateThread.get();
        if (CrossSystem.isWindows() && (currentThread == null || !currentThread.isAlive())) {
            WinNT.HANDLE sharedFile = null;
            try {
                final WinNT.HANDLE finalSharedFile = sharedFile = Kernel32.INSTANCE.CreateFileMapping(WinBase.INVALID_HANDLE_VALUE, null, 4, 0, 1024, sharedName);
                final Pointer finalSharedMemory = Kernel32.INSTANCE.MapViewOfFile(sharedFile, 2, 0, 0, 1024);
                finalSharedMemory.setInt(0L, 2);
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            ByteBuffer byteBuffer = ByteBuffer.allocate(128);
                            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                            while (Thread.currentThread() == SharedMemoryState.this.updateThread.get()) {
                                try {
                                    2.sleep(1000L);
                                    SharedMemoryState.getInstance().updateState(finalSharedMemory, byteBuffer);
                                }
                                catch (InterruptedException th) {
                                    // empty catch block
                                    break;
                                }
                            }
                        }
                        catch (Throwable th) {
                            SharedMemoryState.this.logger.log(th);
                        }
                        finally {
                            SharedMemoryState.this.closeSharedFile(finalSharedFile, finalSharedMemory);
                            SharedMemoryState.this.updateThread.compareAndSet(Thread.currentThread(), null);
                        }
                    }
                };
                thread.setName("SharedMemoryStateThread");
                thread.setDaemon(true);
                this.updateThread.set(thread);
                thread.start();
            }
            catch (Throwable th) {
                this.logger.log(th);
                this.closeSharedFile(sharedFile, null);
            }
        }
    }

    protected void closeSharedFile(WinNT.HANDLE sharedFile, Pointer sharedMemory) {
        try {
            if (sharedFile != null && !WinBase.INVALID_HANDLE_VALUE.equals((Object)sharedFile)) {
                if (sharedMemory != null) {
                    sharedMemory.setMemory(4L, 1024L, (byte)0);
                }
                Kernel32.INSTANCE.CloseHandle(sharedFile);
            }
        }
        catch (Throwable th) {
            this.logger.log(th);
        }
    }

    public void stopUpdates() {
        Thread thread = this.updateThread.getAndSet(null);
        if (thread != null) {
            thread.interrupt();
        }
    }

    protected void updateState(Pointer sharedMemory, ByteBuffer buf) {
        int bps = Math.max(0, DownloadWatchDog.getInstance().getDownloadSpeedManager().getSpeed());
        DownloadLinkAggregator dla = new DownloadLinkAggregator(DownloadController.getInstance().getSelectionInfo());
        long totalDl = dla.getTotalBytes();
        long curDl = dla.getBytesLoaded();
        long remain = Math.max(0L, totalDl - curDl);
        long eta = dla.getEta();
        List jobs = ExtractionExtension.getInstance().getJobQueue().getJobs();
        for (ExtractionController controller : jobs) {
            ExtractionProgress progress = controller.getExtractionProgress();
            if (progress == null) continue;
            eta = Math.max(eta, progress.getETA() / 1000L);
        }
        JDK8BufferHelper.clear((Buffer)buf);
        buf.putInt(2);
        buf.putLong(bps);
        buf.putLong(totalDl);
        buf.putLong(curDl);
        buf.putLong(remain);
        buf.putLong(Math.max(0L, eta));
        buf.putLong(DownloadWatchDog.getInstance().getActiveDownloads());
        buf.putLong(DownloadWatchDog.getInstance().getDownloadSpeedManager().connections());
        buf.putLong(DownloadWatchDog.getInstance().getRunningFilePackages().size());
        try {
            byte[] etas = Formatter.formatSeconds(eta).replace(":", " ").getBytes("ISO-8859-1");
            buf.putInt(etas.length);
            buf.put(etas);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.log((Throwable)e);
            buf.putInt(0);
        }
        sharedMemory.write(0L, buf.array(), 0, 128);
    }

    public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
        if (Boolean.TRUE.equals(newValue)) {
            this.startUpdates();
        } else {
            this.stopUpdates();
        }
    }
}

