/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import jd.captcha.JAntiCaptcha;
import jd.captcha.configuration.JACScript;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.utils.Utilities;
import org.jdownloader.logging.LogController;

public class LetterComperator {
    private static final int ANBCOLOR = 0xFF0000;
    private static final int ANBFILTEREDCOLOR = 0xFFCCCC;
    private static final int BNACOLOR = 255;
    private static final int BNAFILTEREDCOLOR = 0xCCCCFF;
    private static final int BOTHCOLOR = 0x660099;
    public static boolean CREATEINTERSECTIONLETTER = false;
    public static String[] MATCH_TABLE = null;
    public static final int PERFECTMATCH = 1;
    public static final int QUICKSCANMATCH = 2;
    public static final int QUICKSCANPERFECTMATCH = 3;
    private Letter a = null;
    private Letter b = null;
    private int[] bc = new int[2];
    private Vector<Vector<Integer>> bothElements = new Vector();
    private int bothElementsNum;
    private double cleftFaktor;
    private double coverageFaktorA = 0.0;
    private double coverageFaktorAWeight;
    private double coverageFaktorB = 0.0;
    private double coverageFaktorBWeight;
    private int detectionType;
    private double divider;
    private Vector<Integer> element;
    private int[][] elementGrid;
    private double errorAWeight;
    private double errorbWeight;
    private Object[] extensionCodeArguments = new Object[]{null, 0.0};
    private Method extensionCodeMethod = null;
    private Class<?>[] extensionCodeParameterTypes = new Class[]{LetterComperator.class, Double.class};
    private double extensionError = 0.0;
    private double heightFaktor = 0.0;
    private int[] imgOffset;
    private double intersectionAHeightFaktor;
    private double intersectionAHeightWeight;
    private double intersectionAWidthFaktor;
    private double intersectionAWidthWeight;
    private int[] intersectionDimension;
    private double intersectionDimensionWeight;
    private int[][] intersectionGrid = new int[0][0];
    private int intersectionHeight = 0;
    private Letter intersectionLetter = new Letter();
    private int intersectionStartX = 0;
    private int intersectionStartY = 0;
    private int intersectionWidth = 0;
    private JACScript jas;
    private double localHeightPercent;
    private double localWidthPercent;
    private int minCleftSize;
    private int[] offset;
    private int overlayNoiseSize;
    private JAntiCaptcha owner;
    private int pixelAll;
    private int pixelANotB = 0;
    private int pixelBNotA = 0;
    private int pixelBoth = 0;
    private double pixelErrorA = 0.0;
    private double pixelErrorB = 0.0;
    private double prescanDivider;
    private int preScanFaktor;
    private int preScanFilter;
    private double preValityPercent;
    private double reliability;
    private int scanStepX;
    private int scanStepY;
    private int scanTime = -1;
    private int scanVarianceX = -1;
    private int scanVarianceY = -1;
    private double tmpCoverageFaktorA;
    private double tmpCoverageFaktorB;
    private double tmpErrorA;
    private double tmpErrorB;
    private double tmpErrorTotal;
    private double tmpExtensionError = 0.0;
    private double tmpHeightAFaktor;
    private double tmpHeightFaktor;
    private int tmpPixelAButNotB;
    private int tmpPixelBButNotA;
    private int tmpPixelBoth = 0;
    private double tmpPreScanValue;
    private double tmpWidthAFaktor;
    private double tmpWidthFaktor;
    private double totalPixelError = 0.0;
    private double valityPercent = 10000.0;
    private double widthFaktor = 0.0;
    private int[] position;

    public LetterComperator(Letter a, Letter b) {
        this.a = a;
        this.b = b;
    }

    private int[] coordinatesFromAToB(int x, int y, int xx, int yy, int[] con) {
        con[0] = x - xx;
        con[1] = y - yy;
        return con;
    }

    public Letter getA() {
        return this.a;
    }

    public Letter getB() {
        return this.b;
    }

    public int getBothElementsNum() {
        return this.bothElementsNum;
    }

    public double getCoverageFaktorA() {
        return this.coverageFaktorA;
    }

    public double getCoverageFaktorB() {
        return this.coverageFaktorB;
    }

    public String getDecodedValue() {
        if (this.b == null || this.b.getDecodedValue() == null || this.b.getDecodedValue().length() != 1) {
            return "-";
        }
        return this.b.getDecodedValue();
    }

    public int getDetectionType() {
        return this.detectionType;
    }

    public Letter getDifference() {
        try {
            int xx = this.imgOffset[0];
            int yy = this.imgOffset[1];
            int left = this.offset[0];
            int top = this.offset[1];
            int tmpIntersectionWidth = this.intersectionDimension[0];
            int tmpIntersectionHeight = this.intersectionDimension[1];
            int[][] g = new int[tmpIntersectionWidth][tmpIntersectionHeight];
            for (int x = 0; x < tmpIntersectionWidth; ++x) {
                block8: for (int y = 0; y < tmpIntersectionHeight; ++y) {
                    g[x][y] = this.getA().getMaxPixelValue();
                    int pixelType = this.getPixelType(x, y, xx, yy, left, top);
                    switch (pixelType) {
                        case 0: {
                            continue block8;
                        }
                        case 1: {
                            if (this.hasNeighbour(x, y, xx, yy, left, top, pixelType) > this.overlayNoiseSize) {
                                // empty if block
                            }
                            g[x][y] = 0;
                            continue block8;
                        }
                        case 2: {
                            if (this.hasNeighbour(x, y, xx, yy, left, top, pixelType) <= this.overlayNoiseSize) continue block8;
                            g[x][y] = 0;
                            continue block8;
                        }
                    }
                }
            }
            Letter ret = this.getA().createLetter();
            int[] l = this.getA().getLocation();
            ret.setLocation(new int[]{l[0] + left, l[1] + top});
            ret.setGrid(g);
            ret.clean();
            return ret;
        }
        catch (Exception e) {
            return this.getA();
        }
    }

    private Integer getElement(int x, int y, int xx, int yy, int left, int top, int pixelType, int[][] elementGrid, Vector<Integer> counter) {
        if (x < 0 || y < 0 || x >= elementGrid.length || elementGrid.length == 0 || y >= elementGrid[0].length) {
            return null;
        }
        if (elementGrid[x][y] != 0) {
            return null;
        }
        int pt = this.getPixelType(x, y, xx, yy, left, top);
        if (pt == pixelType) {
            counter.add(pixelType);
            elementGrid[x][y] = pixelType + 100;
            this.getElement(x - 1, y, xx, yy, left, top, pt, elementGrid, counter);
            this.getElement(x - 1, y - 1, xx, yy, left, top, pt, elementGrid, counter);
            this.getElement(x, y - 1, xx, yy, left, top, pt, elementGrid, counter);
            this.getElement(x + 1, y - 1, xx, yy, left, top, pt, elementGrid, counter);
            this.getElement(x + 1, y, xx, yy, left, top, pt, elementGrid, counter);
            this.getElement(x + 1, y + 1, xx, yy, left, top, pt, elementGrid, counter);
            this.getElement(x, y + 1, xx, yy, left, top, pt, elementGrid, counter);
            this.getElement(x - 1, y + 1, xx, yy, left, top, pt, elementGrid, counter);
        }
        return null;
    }

    public double getExtensionError() {
        return this.extensionError;
    }

    public double getHeightFaktor() {
        return this.heightFaktor;
    }

    public double getIdentificationReliability() {
        return this.getValityPercent() - this.getReliability();
    }

    public int[] getImgOffset() {
        return this.imgOffset;
    }

    public Letter getIntersection() {
        try {
            int left = this.offset[0];
            int top = this.offset[1];
            int tmpIntersectionWidth = this.intersectionDimension[0];
            int tmpIntersectionHeight = this.intersectionDimension[1];
            int[][] g = new int[tmpIntersectionWidth][tmpIntersectionHeight];
            for (int x = 0; x < tmpIntersectionWidth; ++x) {
                for (int y = 0; y < tmpIntersectionHeight; ++y) {
                    g[x][y] = this.a.getPixelValue(x + left, y + top);
                }
            }
            Letter ret = this.getA().createLetter();
            int[] l = this.getA().getLocation();
            ret.setLocation(new int[]{l[0] + left, l[1] + top});
            ret.setGrid(g);
            ret.clean();
            return ret;
        }
        catch (Exception e) {
            LogController.CL().log((Throwable)e);
            return this.getA();
        }
    }

    public double getIntersectionAHeightFaktor() {
        return this.intersectionAHeightFaktor;
    }

    public double getIntersectionAWidthFaktor() {
        return this.intersectionAWidthFaktor;
    }

    public int[] getIntersectionDimension() {
        return this.intersectionDimension;
    }

    public int getIntersectionHeight() {
        return this.intersectionHeight;
    }

    public Letter getIntersectionLetter() {
        return this.intersectionLetter;
    }

    public int getIntersectionStartX() {
        return this.intersectionStartX;
    }

    public int getIntersectionStartY() {
        return this.intersectionStartY;
    }

    public int getIntersectionWidth() {
        return this.intersectionWidth;
    }

    public double getLocalHeightPercent() {
        return this.localHeightPercent;
    }

    public int[] getOffset() {
        return this.offset;
    }

    public void setOffset(int[] offset) {
        this.offset = offset;
    }

    public JAntiCaptcha getOwner() {
        return this.owner;
    }

    public int getPixelANotB() {
        return this.pixelANotB;
    }

    public int getPixelBNotA() {
        return this.pixelBNotA;
    }

    public int getPixelBoth() {
        return this.pixelBoth;
    }

    public double getPixelErrorA() {
        return this.pixelErrorA;
    }

    public double getPixelErrorB() {
        return this.pixelErrorB;
    }

    public int getPixelType(int x, int y, int xx, int yy, int left, int top) {
        int va = this.a.getPixelValue(x + left, y + top);
        this.bc = this.coordinatesFromAToB(x + left, y + top, xx, yy, this.bc);
        int vb = this.b.getPixelValue(this.bc[0], this.bc[1]);
        if (va < 0 || vb < 0) {
            return -2;
        }
        if (vb == 0 && va == 0) {
            return 0;
        }
        if (vb == 0) {
            return 1;
        }
        if (va == 0) {
            return 2;
        }
        return -1;
    }

    public double getPreValityPercent() {
        return this.preValityPercent;
    }

    public double getRealValityValue() {
        return this.valityPercent;
    }

    public double getReliability() {
        return this.reliability;
    }

    public int getScanTime() {
        return this.scanTime;
    }

    public int getScanVarianceX() {
        if (this.scanVarianceX >= 0) {
            return this.scanVarianceX;
        }
        return this.jas.getInteger("scanVarianceX");
    }

    public int getScanVarianceY() {
        if (this.scanVarianceX >= 0) {
            return this.scanVarianceY;
        }
        return this.jas.getInteger("scanVarianceY");
    }

    public double getTmpExtensionError() {
        return this.tmpExtensionError;
    }

    public double getTotalPixelError() {
        return this.totalPixelError;
    }

    public double getValityPercent() {
        return Math.min(100.0, this.valityPercent);
    }

    public double getWidthFaktor() {
        return this.widthFaktor;
    }

    public int hasNeighbour(int x, int y, int xx, int yy, int left, int top, int pixelType) {
        int ret = 0;
        int faktor = 1;
        for (int xt = -faktor; xt <= faktor; ++xt) {
            for (int yt = -faktor; yt <= faktor; ++yt) {
                if (xt == 0 && yt == 0 || this.getPixelType(x + xt, y + yt, xx, yy, left, top) != pixelType) continue;
                ++ret;
            }
        }
        return ret;
    }

    public boolean isCreateIntersectionLetter() {
        return CREATEINTERSECTIONLETTER;
    }

    public void run() {
        String matches;
        if (MATCH_TABLE != null && this.getA().getId() > -1 && MATCH_TABLE.length > this.getA().getId() && !(matches = MATCH_TABLE[this.getA().getId()]).contains(this.getB().getDecodedValue())) {
            return;
        }
        this.scan();
    }

    /*
     * Unable to fully structure code
     */
    private void scan() {
        startTime = System.currentTimeMillis();
        bestValue = 20000.0;
        this.preValityPercent = 20000.0;
        this.tmpPreScanValue = 20000.0;
        vx = this.getScanVarianceX();
        vy = this.getScanVarianceY();
        vx = Math.min(vx, this.b.getWidth());
        vy = Math.min(vy, this.b.getHeight());
        scanXFrom = -vx;
        scanXTo = this.a.getWidth() - this.b.getWidth() + vx;
        scanYFrom = -vy;
        scanYTo = this.a.getHeight() - this.b.getHeight() + vy;
        if (scanXTo < scanXFrom) {
            tmp = scanXTo;
            scanXTo = scanXFrom;
            scanXFrom = tmp;
        }
        if (scanYTo < scanYFrom) {
            tmp = scanYTo;
            scanYTo = scanYFrom;
            scanYFrom = tmp;
        }
        tmpIntersection = null;
        if (this.isCreateIntersectionLetter()) {
            tmpIntersection = new Letter();
        }
        xx = Utilities.getJumperStart(scanXFrom, scanXTo);
        while (Utilities.checkJumper(xx, scanXFrom, scanXTo)) {
            yy = Utilities.getJumperStart(scanYFrom, scanYTo);
            while (Utilities.checkJumper(yy, scanYFrom, scanYTo)) {
                block11: {
                    left = Math.max(0, xx);
                    right = Math.min(xx + this.b.getWidth(), this.a.getWidth());
                    top = Math.max(0, yy);
                    bottom = Math.min(yy + this.b.getHeight(), this.a.getHeight());
                    tmpIntersectionWidth = right - left;
                    tmpIntersectionHeight = bottom - top;
                    if (tmpIntersectionWidth <= 0 || tmpIntersectionHeight <= 0) break block11;
                    if (this.isCreateIntersectionLetter()) {
                        tmpIntersection = new Letter();
                        tmpIntersection.setOwner(this.owner);
                        this.intersectionGrid = new int[tmpIntersectionWidth][tmpIntersectionHeight];
                        tmpIntersection.setGrid(this.intersectionGrid);
                    }
                    if (this.preScanFilter <= 0) ** GOTO lbl-1000
                    this.tmpPreScanValue = this.scanPreIntersection(xx, yy, left, top, tmpIntersectionWidth, tmpIntersectionHeight);
                    if ((int)this.tmpPreScanValue > this.preScanFilter) {
                        if (this.preValityPercent > this.tmpPreScanValue) {
                            this.setPreValityPercent(this.tmpPreScanValue);
                        }
                    } else if ((value = this.scanIntersection(xx, yy, left, top, tmpIntersectionWidth, tmpIntersectionHeight)) < bestValue) {
                        bestValue = value;
                        this.setExtensionError(this.tmpExtensionError);
                        this.setValityPercent(value);
                        this.setHeightFaktor(this.tmpHeightFaktor);
                        this.setWidthFaktor(this.tmpWidthFaktor);
                        this.setIntersectionHeight(tmpIntersectionHeight);
                        this.setIntersectionWidth(tmpIntersectionWidth);
                        this.setIntersectionStartX(xx);
                        this.setIntersectionStartY(yy);
                        this.setPosition(left, top);
                        this.setBothElementNum(this.bothElements.size());
                        this.setCoverageFaktorA(this.tmpCoverageFaktorA);
                        this.setCoverageFaktorB(this.tmpCoverageFaktorB);
                        this.setPixelErrorA(this.tmpErrorA);
                        this.setPreValityPercent(this.tmpPreScanValue);
                        this.setPixelErrorB(this.tmpErrorB);
                        this.setPixelANotB(this.tmpPixelAButNotB);
                        this.setPixelBNotA(this.tmpPixelBButNotA);
                        this.setPixelBoth(this.tmpPixelBoth);
                        this.intersectionAHeightFaktor = 0.0;
                        this.intersectionAWidthFaktor = 0.0;
                        this.setIntersectionAHeightFaktor(this.tmpHeightAFaktor);
                        this.setIntersectionAWidthFaktor(this.tmpWidthAFaktor);
                        this.setTotalPixelError(this.tmpErrorTotal);
                        if (this.isCreateIntersectionLetter()) {
                            this.setIntersectionLetter(tmpIntersection);
                        }
                    }
                }
                yy = Utilities.nextJump(yy, scanYFrom, scanYTo, 1);
            }
            xx = Utilities.nextJump(xx, scanXFrom, scanXTo, 1);
        }
        this.scanTime = (int)(System.currentTimeMillis() - startTime);
    }

    private void setPosition(int left, int top) {
        this.position = new int[]{left, top};
    }

    public int[] getPosition() {
        return this.position;
    }

    public void setPosition(int[] position) {
        this.position = position;
    }

    private double scanIntersection(int xx, int yy, int left, int top, int tmpIntersectionWidth, int tmpIntersectionHeight) {
        this.offset = new int[]{left, top};
        this.imgOffset = new int[]{xx, yy};
        this.intersectionDimension = new int[]{tmpIntersectionWidth, tmpIntersectionHeight};
        this.pixelAll = 0;
        this.tmpPixelBButNotA = 0;
        this.tmpPixelAButNotB = 0;
        this.tmpPixelBoth = 0;
        this.tmpCoverageFaktorA = 0.0;
        this.tmpCoverageFaktorB = 0.0;
        this.bothElements.removeAllElements();
        this.elementGrid = new int[tmpIntersectionWidth][tmpIntersectionHeight];
        for (int x = 0; x < tmpIntersectionWidth; x += this.scanStepX) {
            block8: for (int y = 0; y < tmpIntersectionHeight; y += this.scanStepY) {
                int pixelType = this.getPixelType(x, y, xx, yy, left, top);
                ++this.pixelAll;
                switch (pixelType) {
                    case 0: {
                        if (this.isCreateIntersectionLetter()) {
                            this.intersectionGrid[x][y] = 0x660099;
                        }
                        if (this.cleftFaktor > 0.0) {
                            this.element = new Vector<Integer>();
                            this.getElement(x, y, xx, yy, left, top, pixelType, this.elementGrid, this.element);
                            if (this.element.size() > this.minCleftSize) {
                                this.bothElements.add(this.element);
                            }
                        }
                        ++this.tmpPixelBoth;
                        continue block8;
                    }
                    case 1: {
                        if (this.overlayNoiseSize <= 0 || this.hasNeighbour(x, y, xx, yy, left, top, pixelType) > this.overlayNoiseSize) {
                            ++this.tmpPixelBButNotA;
                            if (!this.isCreateIntersectionLetter()) continue block8;
                            this.intersectionGrid[x][y] = 255;
                            continue block8;
                        }
                        if (!this.isCreateIntersectionLetter()) continue block8;
                        this.intersectionGrid[x][y] = 0xCCCCFF;
                        continue block8;
                    }
                    case 2: {
                        if (this.overlayNoiseSize <= 0 || this.hasNeighbour(x, y, xx, yy, left, top, pixelType) > this.overlayNoiseSize) {
                            ++this.tmpPixelAButNotB;
                            if (!this.isCreateIntersectionLetter()) continue block8;
                            this.intersectionGrid[x][y] = 0xFF0000;
                            continue block8;
                        }
                        if (!this.isCreateIntersectionLetter()) continue block8;
                        this.intersectionGrid[x][y] = 0xFFCCCC;
                        continue block8;
                    }
                    default: {
                        if (!this.isCreateIntersectionLetter()) continue block8;
                        this.intersectionGrid[x][y] = 0xFFFFFF;
                    }
                }
            }
        }
        if (this.pixelAll > 0 && (this.bothElements.size() > 0 || this.cleftFaktor == 0.0)) {
            this.tmpErrorA = (double)this.tmpPixelAButNotB / (double)(this.tmpPixelBoth + this.tmpPixelAButNotB);
            this.tmpErrorB = (double)this.tmpPixelBButNotA / (double)(this.tmpPixelBButNotA + this.tmpPixelBoth);
            this.tmpErrorTotal = this.tmpErrorA * this.errorAWeight + this.tmpErrorB * this.errorbWeight;
            this.tmpCoverageFaktorA = 1.0 - (double)this.tmpPixelBoth / ((double)this.a.getElementPixel() / (double)(this.scanStepX * this.scanStepY));
            this.tmpCoverageFaktorB = 1.0 - (double)this.tmpPixelBoth / ((double)this.b.getElementPixel() / (double)(this.scanStepX * this.scanStepY));
            this.setLocalHeightPercent((double)tmpIntersectionHeight / (double)this.b.getHeight());
            this.localWidthPercent = (double)tmpIntersectionWidth / (double)this.b.getWidth();
            double lhp = 1.0 - this.getLocalHeightPercent();
            double lwp = 1.0 - this.localWidthPercent;
            this.tmpHeightFaktor = lhp * lhp;
            this.tmpWidthFaktor = lwp * lwp;
            this.tmpHeightAFaktor = 1.0 - (double)tmpIntersectionHeight / (double)this.a.getHeight();
            this.tmpWidthAFaktor = 1.0 - (double)tmpIntersectionWidth / (double)this.a.getWidth();
            double tmpError = this.tmpErrorTotal;
            tmpError += Math.min(1.0, this.tmpCoverageFaktorA) * this.coverageFaktorAWeight;
            tmpError += Math.min(1.0, this.tmpCoverageFaktorB) * this.coverageFaktorBWeight;
            tmpError += Math.min(1.0, this.tmpHeightFaktor) * this.intersectionDimensionWeight;
            tmpError += Math.min(1.0, this.tmpWidthFaktor) * this.intersectionDimensionWeight;
            tmpError += Math.min(1.0, this.tmpHeightAFaktor) * this.intersectionAHeightWeight;
            tmpError += Math.min(1.0, this.tmpWidthAFaktor) * this.intersectionAWidthWeight;
            if (this.bothElements.size() > 0) {
                tmpError += (double)(this.bothElements.size() - 1) * this.cleftFaktor;
            }
            this.tmpExtensionError = 0.0;
            if (this.extensionCodeMethod != null) {
                try {
                    this.extensionCodeArguments[1] = tmpError / this.divider;
                    this.extensionCodeMethod.invoke(null, this.extensionCodeArguments);
                }
                catch (Exception e) {
                    LogController.CL().log((Throwable)e);
                }
            }
            tmpError += this.tmpExtensionError;
            tmpError /= this.divider;
            if ((double)this.tmpPixelBoth * this.owner.getJas().getDouble("inverseFontWeight") < (double)(tmpIntersectionHeight * tmpIntersectionWidth)) {
                this.tmpErrorTotal = 100.0;
                this.tmpErrorB = 100.0;
                this.tmpErrorA = 100.0;
                tmpError = 100.0;
            }
            return 100.0 * tmpError;
        }
        return 10000.0;
    }

    private double scanPreIntersection(int xx, int yy, int left, int top, int tmpIntersectionWidth, int tmpIntersectionHeight) {
        int yStep = Math.max(1, tmpIntersectionHeight / (this.preScanFaktor + 1));
        this.tmpPixelBoth = 0;
        this.tmpPixelBButNotA = 0;
        this.tmpPixelAButNotB = 0;
        this.pixelAll = 0;
        for (int y = yStep; y <= tmpIntersectionHeight - yStep; y += yStep) {
            block6: for (int x = 0; x < tmpIntersectionWidth; ++x) {
                ++this.pixelAll;
                int pixelType = this.getPixelType(x, y, xx, yy, left, top);
                switch (pixelType) {
                    case 0: {
                        ++this.tmpPixelBoth;
                        continue block6;
                    }
                    case 1: {
                        ++this.tmpPixelBButNotA;
                        continue block6;
                    }
                    case 2: {
                        ++this.tmpPixelAButNotB;
                    }
                }
            }
        }
        if (this.pixelAll > 0) {
            this.tmpErrorA = (double)this.tmpPixelAButNotB / (double)(this.tmpPixelBoth + this.tmpPixelAButNotB);
            this.tmpErrorB = (double)this.tmpPixelBButNotA / (double)(this.tmpPixelBButNotA + this.tmpPixelBoth);
            this.tmpErrorTotal = this.tmpErrorA * this.errorAWeight + this.tmpErrorB * this.errorbWeight;
            this.setLocalHeightPercent((double)tmpIntersectionHeight / (double)this.b.getHeight());
            this.localWidthPercent = (double)tmpIntersectionWidth / (double)this.b.getWidth();
            double lhp = 1.0 - this.getLocalHeightPercent();
            double lwp = 1.0 - this.localWidthPercent;
            this.tmpHeightFaktor = lhp * lhp;
            this.tmpWidthFaktor = lwp * lwp;
            double tmpError = this.tmpErrorTotal;
            tmpError += Math.min(1.0, this.tmpHeightFaktor) * this.intersectionDimensionWeight;
            tmpError += Math.min(1.0, this.tmpWidthFaktor) * this.intersectionDimensionWeight;
            tmpError += Math.min(1.0, this.tmpHeightAFaktor) * this.intersectionAHeightWeight;
            tmpError += Math.min(1.0, this.tmpWidthAFaktor) * this.intersectionAWidthWeight;
            tmpError /= this.prescanDivider;
            return (int)(100.0 * (tmpError *= 1.2));
        }
        return 100.0;
    }

    public void setA(Letter a) {
        this.a = a;
    }

    public void setB(Letter b) {
        this.b = b;
    }

    private void setBothElementNum(int i) {
        this.bothElementsNum = i;
    }

    private void setCoverageFaktorA(double coverageFaktor) {
        this.coverageFaktorA = coverageFaktor;
    }

    private void setCoverageFaktorB(double coverageFaktor) {
        this.coverageFaktorB = coverageFaktor;
    }

    public void setCreateIntersectionLetter(boolean createIntersectionLetter) {
        CREATEINTERSECTIONLETTER = createIntersectionLetter;
    }

    public void setDetectionType(int matchtype) {
        this.detectionType = matchtype;
    }

    public void setExtensionError(double extensionError) {
        this.extensionError = extensionError;
    }

    public void setHeightFaktor(double heightPercent) {
        this.heightFaktor = heightPercent;
    }

    public void setIntersectionAHeightFaktor(double intersectionAHeightFaktor) {
        this.intersectionAHeightFaktor = intersectionAHeightFaktor;
    }

    public void setIntersectionAWidthFaktor(double intersectionAWidthFaktor) {
        this.intersectionAWidthFaktor = intersectionAWidthFaktor;
    }

    private void setIntersectionHeight(int intersectionHeight) {
        this.intersectionHeight = intersectionHeight;
    }

    private void setIntersectionLetter(Letter intersection) {
        this.intersectionLetter = intersection;
    }

    private void setIntersectionStartX(int intersectionStartX) {
        this.intersectionStartX = intersectionStartX;
    }

    private void setIntersectionStartY(int intersectionStartY) {
        this.intersectionStartY = intersectionStartY;
    }

    private void setIntersectionWidth(int intersectionWidth) {
        this.intersectionWidth = intersectionWidth;
    }

    public void setLocalHeightPercent(double localHeightPercent) {
        this.localHeightPercent = localHeightPercent;
    }

    public void setOwner(JAntiCaptcha owner) {
        this.owner = owner;
        this.jas = owner.getJas();
        this.errorAWeight = this.jas.getDouble("errorAWeight");
        this.errorbWeight = this.jas.getDouble("errorBWeight");
        this.coverageFaktorAWeight = this.jas.getDouble("coverageFaktorAWeight");
        this.coverageFaktorBWeight = this.jas.getDouble("coverageFaktorBWeight");
        this.intersectionDimensionWeight = this.jas.getDouble("intersectionDimensionWeight");
        this.intersectionAHeightWeight = this.jas.getDouble("intersectionAHeightWeight");
        this.intersectionAWidthWeight = this.jas.getDouble("intersectionAWidthWeight");
        this.cleftFaktor = this.jas.getDouble("cleftFaktor");
        this.minCleftSize = this.jas.getInteger("minCleftSize");
        this.preScanFilter = this.jas.getInteger("preScanFilter");
        this.preScanFaktor = this.jas.getInteger("preScanFaktor");
        this.overlayNoiseSize = this.jas.getInteger("overlayNoiseSize");
        this.scanStepX = this.jas.getInteger("scanstepx");
        this.scanStepY = this.jas.getInteger("scanstepy");
        this.prescanDivider = this.jas.getDouble("prescandivider");
        this.divider = this.jas.getDouble("divider");
        this.extensionCodeArguments[0] = this;
        if (this.jas.getString("comparatorExtension").length() > 0) {
            String[] ref = this.jas.getString("comparatorExtension").split("\\.");
            if (ref.length != 2) {
                LogController.CL().severe("comparatorExtension should have the format Class.Method");
            }
            String cl = ref[0];
            String methodname = ref[1];
            try {
                Class<?> newClass = Class.forName("jd.captcha.specials." + cl);
                this.extensionCodeMethod = newClass.getMethod(methodname, this.extensionCodeParameterTypes);
            }
            catch (Exception e) {
                LogController.CL().log((Throwable)e);
            }
        }
    }

    private void setPixelANotB(int pixelANotB) {
        this.pixelANotB = pixelANotB;
    }

    private void setPixelBNotA(int pixelBNotA) {
        this.pixelBNotA = pixelBNotA;
    }

    private void setPixelBoth(int pixelBoth) {
        this.pixelBoth = pixelBoth;
    }

    private void setPixelErrorA(double pixelErrorA) {
        this.pixelErrorA = pixelErrorA;
    }

    private void setPixelErrorB(double pixelErrorB) {
        this.pixelErrorB = pixelErrorB;
    }

    private void setPreValityPercent(double value) {
        this.preValityPercent = value;
    }

    public void setReliability(double d) {
        this.reliability = d;
    }

    public void setScanVariance(int x, int y) {
        this.scanVarianceX = x;
        this.scanVarianceY = y;
    }

    public void setTmpExtensionError(double tmpExtensionError) {
        this.tmpExtensionError = tmpExtensionError;
    }

    private void setTotalPixelError(double totalPixelError) {
        this.totalPixelError = totalPixelError;
    }

    public void setValityPercent(double bestValue) {
        this.valityPercent = bestValue;
    }

    public void setWidthFaktor(double widthPercent) {
        this.widthFaktor = widthPercent;
    }

    public String toString() {
        Hashtable<String, Object> hs = new Hashtable<String, Object>();
        hs.put("DecodedValue", this.getDecodedValue());
        hs.put("widthFaktor", this.getWidthFaktor() + "/" + this.getWidthFaktor() * this.intersectionDimensionWeight);
        hs.put("heightFaktor", this.getHeightFaktor() + "/" + this.getHeightFaktor() * this.intersectionDimensionWeight);
        hs.put("pixelErrorA", this.getPixelErrorA());
        hs.put("pixelErrorB", this.getPixelErrorB());
        hs.put("pixelErrorTotal", this.getTotalPixelError());
        hs.put("ValidtyPercent", this.getValityPercent());
        hs.put("pixelAButNotB", this.getPixelANotB());
        hs.put("pixelBButNotA", this.getPixelBNotA());
        hs.put("pixelBoth", this.getPixelBoth());
        hs.put("coverageA", this.getCoverageFaktorA() + "/" + this.getCoverageFaktorA() * this.coverageFaktorAWeight);
        hs.put("coverageB", this.getCoverageFaktorB() + "/" + this.getCoverageFaktorB() * this.coverageFaktorBWeight);
        hs.put("bothElements", this.getBothElementsNum());
        hs.put("preCompare", this.getPreValityPercent());
        hs.put("realValityValue", this.getRealValityValue());
        hs.put("widthAFaktor", this.getIntersectionAWidthFaktor() + "/" + this.getIntersectionAWidthFaktor() * this.intersectionAWidthWeight + "(" + this.intersectionAWidthWeight + ")");
        hs.put("heightAFaktor", this.getIntersectionAHeightFaktor() + "/" + this.getIntersectionAHeightFaktor() * this.intersectionAHeightWeight + "(" + this.intersectionAHeightWeight + ")");
        hs.put("extensionError", this.getExtensionError());
        double t = this.getRealValityValue() * 6.0 / 100.0;
        double tmpError = this.getTotalPixelError();
        StringBuilder calc = new StringBuilder("Error= ");
        calc.append(this.getTotalPixelError());
        calc.append(" (totalPixelError) ");
        calc.append(this.getTotalPixelError() * 100.0 / t);
        calc.append("\r\n");
        tmpError += Math.min(1.0, this.getCoverageFaktorA()) * this.coverageFaktorAWeight;
        calc.append(Math.round(Math.min(1.0, this.getCoverageFaktorA()) * this.coverageFaktorAWeight * 100.0 / t));
        calc.append("%          + ");
        calc.append(Math.min(1.0, this.getCoverageFaktorA()) * this.coverageFaktorAWeight);
        calc.append('=');
        calc.append(tmpError);
        calc.append(" (coverage A)\r\n");
        tmpError += Math.min(1.0, this.getCoverageFaktorB()) * this.coverageFaktorBWeight;
        calc.append(Math.round(Math.min(1.0, this.getCoverageFaktorB()) * this.coverageFaktorBWeight * 100.0 / t));
        calc.append("%          + ");
        calc.append(Math.min(1.0, this.getCoverageFaktorB()) * this.coverageFaktorBWeight);
        calc.append('=');
        calc.append(tmpError);
        calc.append(" (coverage B)\r\n");
        tmpError += Math.min(1.0, this.getHeightFaktor()) * this.intersectionDimensionWeight;
        calc.append(Math.round(Math.min(1.0, this.getHeightFaktor()) * this.intersectionDimensionWeight * 100.0 / t));
        calc.append("%          + ");
        calc.append(Math.min(1.0, this.getHeightFaktor()) * this.intersectionDimensionWeight);
        calc.append('=');
        calc.append(tmpError);
        calc.append(" (BHeightFaktor)\r\n");
        tmpError += Math.min(1.0, this.getWidthFaktor()) * this.intersectionDimensionWeight;
        calc.append(Math.round(Math.min(1.0, this.getWidthFaktor()) * this.intersectionDimensionWeight * 100.0 / t));
        calc.append("%          + ");
        calc.append(Math.min(1.0, this.getWidthFaktor()) * this.intersectionDimensionWeight);
        calc.append('=');
        calc.append(tmpError);
        calc.append(" (BWidthFaktor)\r\n");
        tmpError += Math.min(1.0, this.getIntersectionAHeightFaktor()) * this.intersectionAHeightWeight;
        calc.append(Math.round(Math.min(1.0, this.getIntersectionAHeightFaktor()) * this.intersectionAHeightWeight * 100.0 / t));
        calc.append("%          + ");
        calc.append(Math.min(1.0, this.getIntersectionAHeightFaktor()) * this.intersectionAHeightWeight);
        calc.append('=');
        calc.append(tmpError);
        calc.append(" (AHeightFaktor)\r\n");
        tmpError += Math.min(1.0, this.getIntersectionAWidthFaktor()) * this.intersectionAWidthWeight;
        calc.append(Math.round(Math.min(1.0, this.getIntersectionAWidthFaktor()) * this.intersectionAWidthWeight * 100.0 / t));
        calc.append("%          + ");
        calc.append(Math.min(1.0, this.getIntersectionAWidthFaktor()) * this.intersectionAWidthWeight);
        calc.append('=');
        calc.append(tmpError);
        calc.append(" (AWidthFaktor)\r\n");
        tmpError += (double)(this.getBothElementsNum() - 1) * this.cleftFaktor;
        calc.append(Math.round((double)(this.getBothElementsNum() - 1) * this.cleftFaktor * 100.0 / t));
        calc.append("%          + ");
        calc.append((double)(this.getBothElementsNum() - 1) * this.cleftFaktor);
        calc.append('=');
        calc.append(tmpError);
        calc.append(" (CleftFaktor)\r\n");
        tmpError += this.getExtensionError();
        calc.append(Math.round(this.getExtensionError() * 100.0 / t));
        calc.append("%          + ");
        calc.append(this.getExtensionError());
        calc.append('=');
        calc.append(tmpError);
        calc.append(" (ExtensionError)\r\n");
        tmpError /= this.divider;
        calc.append('/');
        calc.append(this.divider);
        calc.append(new char[]{' ', '=', ' '});
        calc.append(tmpError);
        calc.append(" => ");
        calc.append(tmpError * 100.0);
        calc.append(new char[]{'%', ' '});
        hs.put("totalFaktor", tmpError);
        return tmpError * 100.0 + "% " + hs.toString() + "\r\n" + calc.toString();
    }
}

