/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha;

import java.io.File;
import java.io.IOException;
import jd.captcha.JAntiCaptcha;
import jd.captcha.LetterComperator;
import jd.captcha.pixelgrid.BinLetters;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.LevenshteinLetter;

public class LevenShteinLetterComperator {
    public LevenshteinLetter[] letterDB;
    public boolean onlySameWidth = false;
    public int costs = 6;
    public boolean detectVerticalOffset = false;
    public boolean detectHorizonalOffset = false;

    public void run(Letter letter) {
        if (this.letterDB.length == 0 || letter.getWidth() == 0 || letter.getHeight() == 0) {
            return;
        }
        LevenshteinLetter b = new LevenshteinLetter(letter);
        int best = 0;
        int bestdist = Integer.MAX_VALUE;
        int[] bestOffset = null;
        for (int i = 0; i < this.letterDB.length; ++i) {
            int[] dist;
            if (this.onlySameWidth && this.letterDB[i].getWidth() != b.getWidth() || (dist = this.getLevenshteinDistance(b, this.letterDB[i], bestdist)) == null || bestdist <= dist[0]) continue;
            bestOffset = dist;
            bestdist = dist[0];
            best = i;
        }
        if (bestOffset == null) {
            return;
        }
        Letter bestLetter = this.letterDB[best].toLetter();
        letter.detected = new LetterComperator(letter, bestLetter);
        letter.detected.setOffset(new int[]{bestOffset[1], bestOffset[2]});
        letter.detected.setValityPercent(75.0 * (double)bestdist / (double)this.costs / (double)letter.getArea());
        letter.setDecodedValue(bestLetter.getDecodedValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(final Letter[] letters) {
        Thread[] ths = new Thread[letters.length];
        final LevenShteinLetterComperator lv = this;
        for (int i = 0; i < ths.length; ++i) {
            final int j = i;
            ths[i] = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    lv.run(letters[j]);
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        this.notify();
                    }
                }
            });
            ths[i].start();
        }
        for (Thread thread : ths) {
            while (thread.isAlive()) {
                Thread thread2 = thread;
                synchronized (thread2) {
                    try {
                        thread.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public LevenShteinLetterComperator(JAntiCaptcha jac) {
        File letterDBBin = jac.getResourceFile("letters.bin");
        if (letterDBBin.exists()) {
            try {
                this.letterDB = new BinLetters(letterDBBin).readAll().toArray(new LevenshteinLetter[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.letterDB == null) {
            this.letterDB = new LevenshteinLetter[jac.letterDB.size()];
            for (int i = 0; i < this.letterDB.length; ++i) {
                this.letterDB[i] = new LevenshteinLetter(jac.letterDB.get(i));
            }
        }
    }

    public double getLevenshteinDistance(Letter a, Letter b) {
        int[] d = this.getLevenshteinDistance(new LevenshteinLetter(a), new LevenshteinLetter(b), Integer.MAX_VALUE);
        if (d != null) {
            a.detected = new LetterComperator(a, b);
            a.detected.setOffset(new int[]{d[1], d[2]});
            double ret = 75.0 * (double)d[0] / (double)this.costs / (double)a.getArea();
            a.detected.setValityPercent(ret);
            return ret;
        }
        return Double.MAX_VALUE;
    }

    private int getBounds(boolean[][] lengthLong, boolean[][] lengthShort, boolean detectOffset) {
        int d = lengthLong.length - lengthShort.length;
        if (!detectOffset) {
            return d / 2;
        }
        int bestDist = Integer.MAX_VALUE;
        int besti = 0;
        int lsm1 = lengthShort.length - 1;
        for (int i = 0; i < d; ++i) {
            int dist = this.getLevenshteinDistance(lengthLong[i], lengthShort[0]);
            if ((dist += this.getLevenshteinDistance(lengthLong[i + lsm1], lengthShort[lsm1])) >= bestDist) continue;
            bestDist = dist;
            besti = i;
        }
        return besti;
    }

    private int getBoundDiff(boolean[][] bba1, int start, int end) {
        int c;
        int i;
        int res = 0;
        for (i = 0; i < start; ++i) {
            for (c = 0; c < bba1[i].length; ++c) {
                if (!bba1[i][c]) continue;
                ++res;
            }
        }
        for (i = end; i < bba1.length; ++i) {
            for (c = 0; c < bba1[i].length; ++c) {
                if (!bba1[i][c]) continue;
                ++res;
            }
        }
        return res;
    }

    private int[] getLevenshteinDistance(LevenshteinLetter ba, LevenshteinLetter bb, int best) {
        int c;
        int res = 0;
        if (ba == null || bb == null) {
            return null;
        }
        boolean[][] bba1 = ba.horizontal;
        boolean[][] bbb1 = bb.horizontal;
        boolean[][] bba2 = ba.vertical;
        boolean[][] bbb2 = bb.vertical;
        int bounds1 = 0;
        int diff1 = bba1.length - bbb1.length;
        boolean swV = false;
        boolean swH = false;
        if (diff1 > 0) {
            bounds1 = this.getBounds(bba1, bbb1, this.detectVerticalOffset);
        } else if (diff1 < 0) {
            boolean[][] bac = bbb1;
            bbb1 = bba1;
            bba1 = bac;
            swV = true;
            bounds1 = this.getBounds(bba1, bbb1, this.detectVerticalOffset);
        } else {
            bounds1 = 0;
        }
        if (best < (res += this.getBoundDiff(bba1, bounds1, bbb1.length) * this.costs)) {
            return null;
        }
        int bounds2 = 0;
        int diff2 = bba2.length - bbb2.length;
        if (diff2 > 0) {
            bounds2 = this.getBounds(bba2, bbb2, this.detectHorizonalOffset);
        } else if (diff2 < 0) {
            boolean[][] bac = bbb2;
            bbb2 = bba2;
            bba2 = bac;
            swH = true;
            bounds2 = this.getBounds(bba2, bbb2, this.detectHorizonalOffset);
        } else {
            bounds2 = 0;
        }
        if (best < (res += this.getBoundDiff(bba2, bounds2, bbb2.length) * this.costs)) {
            return null;
        }
        for (c = 0; c < bbb1.length; ++c) {
            if (best >= (res += this.getLevenshteinDistance(bba1[c + bounds1], bbb1[c]))) continue;
            return null;
        }
        for (c = 0; c < bbb2.length; ++c) {
            if (best >= (res += this.getLevenshteinDistance(bba2[c + bounds2], bbb2[c]))) continue;
            return null;
        }
        return new int[]{res, swV ? -bounds1 : bounds1, swH ? -bounds2 : bounds2};
    }

    private int getLevenshteinDistance(boolean[] l1, boolean[] l2) {
        int i;
        if (l1 == null || l2 == null) {
            throw new IllegalArgumentException("Letter must not be null");
        }
        int n = l1.length;
        int m = l2.length;
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int n1 = n + 1;
        int[] p = new int[n1];
        int[] d = new int[n1];
        int[] c = new int[n1];
        int cost = 0;
        for (i = 1; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            int j1 = j;
            int j2 = --j1;
            --j2;
            boolean t_j = l2[j1];
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int i2;
                int i1 = i - 1;
                cost = l1[i1] == t_j ? 0 : this.costs;
                d[i] = Math.min(d[i1] + this.costs, Math.min(p[i] + this.costs, p[i1] + cost));
                if (i <= 1 || j <= 1 || l1[i1] != l2[j2] || l1[i2 = i1 - 1] != l2[j1]) continue;
                d[i] = Math.min(d[i], c[i2] + (cost > 0 ? 1 : cost));
            }
            for (i = 0; i <= n; ++i) {
                c[i] = p[i];
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }
}

