/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.pixelgrid;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import jd.captcha.JAntiCaptcha;
import jd.captcha.gui.ScrollPaneWindow;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelobject.PixelObject;
import jd.captcha.utils.Utilities;
import jd.nutils.Colors;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.logging.LogController;

public class PixelGrid {
    private static final long serialVersionUID = 1L;
    public int[][] grid;
    private int[] location = new int[]{0, 0};
    public JAntiCaptcha owner;
    public int[] pixel;
    protected int[][] tmpGrid;
    protected final LogSource logger;

    public void autoBottomTopAlign() {
        int avg = this.getAverage();
        double bestOL = Double.MAX_VALUE;
        int xOL = 0;
        int yOL = 0;
        double bestOR = Double.MAX_VALUE;
        int xOR = 0;
        int yOR = 0;
        double bestUL = Double.MAX_VALUE;
        int xUL = 0;
        int yUL = 0;
        double bestUR = Double.MAX_VALUE;
        int xUR = 0;
        int yUR = 0;
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                if (!this.isElement(this.getPixelValue(x, y), avg)) continue;
                int yy = y * y;
                int xx = x * x;
                int xd = this.getWidth() - x;
                int xxd = xd * xd;
                int yd = this.getHeight() - y;
                int yyd = yd * yd;
                double diff = Math.sqrt(xx + yy);
                if (diff < bestOL) {
                    xOL = x;
                    yOL = y;
                    bestOL = diff;
                }
                if ((diff = Math.sqrt(xxd + yy)) < bestOR) {
                    xOR = x;
                    yOR = y;
                    bestOR = diff;
                }
                if ((diff = Math.sqrt(xx + yyd)) < bestUL) {
                    xUL = x;
                    yUL = y;
                    bestUL = diff;
                }
                if (!((diff = Math.sqrt(xxd + yyd)) < bestUR)) continue;
                xUR = x;
                yUR = y;
                bestUR = diff;
            }
        }
        this.grid[xOL][yOL] = 0xFF0000;
        this.grid[xOR][yOR] = 65484;
        this.grid[xUR][yUR] = 0x3366FF;
        this.grid[xUL][yUL] = 0xFFCC33;
        boolean g = false;
        double distBest = this.getM(xOL, xOR, yOL, yOR);
        if (distBest == 0.0) {
            distBest = 1.0E-4;
        }
        double dist = this.getM(xUL, xUR, yUL, yUR);
        double distWBest = distBest / (double)((xOR - xOL + 1) / 4);
        boolean skipw = xOR - xOL < this.getWidth() / 3 || yOL > this.getHeight() / 3 || yOR > this.getHeight() / 3;
        double distW = dist == 0.0 ? distBest / (double)((xUR - xUL + 1) / 4) : dist / (double)((xUR - xUL + 1) / 4);
        if (skipw || Math.abs(distW) < Math.abs(distWBest)) {
            distWBest = distW;
            distBest = dist;
            g = true;
        }
        skipw = xUR - xUL < this.getHeight() / 3 || yUL < this.getHeight() * 2 / 3 || yUR < this.getHeight() * 2 / 3;
        System.out.println(distBest);
        int turn = 60;
        this.grid = g > true ? this.turn((double)(distBest * (double)turn)).grid : this.turn((double)(-distBest * (double)turn)).grid;
    }

    public void autoAlign() {
        int avg = this.getAverage();
        double bestOL = Double.MAX_VALUE;
        int xOL = 0;
        int yOL = 0;
        double bestOR = Double.MAX_VALUE;
        int xOR = 0;
        int yOR = 0;
        double bestUL = Double.MAX_VALUE;
        int xUL = 0;
        int yUL = 0;
        double bestUR = Double.MAX_VALUE;
        int xUR = 0;
        int yUR = 0;
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                if (!this.isElement(this.getPixelValue(x, y), avg)) continue;
                int yy = y * y;
                int xx = x * x;
                int xd = this.getWidth() - x;
                int xxd = xd * xd;
                int yd = this.getHeight() - y;
                int yyd = yd * yd;
                double diff = Math.sqrt(xx + yy);
                if (diff < bestOL) {
                    xOL = x;
                    yOL = y;
                    bestOL = diff;
                }
                if ((diff = Math.sqrt(xxd + yy)) < bestOR) {
                    xOR = x;
                    yOR = y;
                    bestOR = diff;
                }
                if ((diff = Math.sqrt(xx + yyd)) < bestUL) {
                    xUL = x;
                    yUL = y;
                    bestUL = diff;
                }
                if (!((diff = Math.sqrt(xxd + yyd)) < bestUR)) continue;
                xUR = x;
                yUR = y;
                bestUR = diff;
            }
        }
        this.grid[xOL][yOL] = 0xFF0000;
        this.grid[xOR][yOR] = 65484;
        this.grid[xUR][yUR] = 0x3366FF;
        this.grid[xUL][yUL] = 0xFFCC33;
        int g = 0;
        double distBest = this.getM(xOL, xOR, yOL, yOR);
        if (distBest == 0.0) {
            distBest = 1.0E-4;
        }
        double dist = this.getM(xUL, xUR, yUL, yUR);
        double distWBest = distBest / (double)((xOR - xOL + 1) / 4);
        boolean skipw = xOR - xOL < this.getWidth() / 3 || yOL > this.getHeight() / 3 || yOR > this.getHeight() / 3;
        double distW = dist == 0.0 ? distBest / (double)((xUR - xUL + 1) / 4) : dist / (double)((xUR - xUL + 1) / 4);
        if (skipw || Math.abs(distW) < Math.abs(distWBest)) {
            distWBest = distW;
            distBest = dist;
            g = 1;
        }
        skipw = xUR - xUL < this.getHeight() / 3 || yUL < this.getHeight() * 2 / 3 || yUR < this.getHeight() * 2 / 3;
        dist = this.getM(yOL, yUL, xOL, xUL);
        distW = dist == 0.0 ? distBest / (double)((yUL - yOL + 1) / 4) : dist / (double)((yUL - yOL + 1) / 4);
        if (skipw || Math.abs(distW) < Math.abs(distWBest)) {
            distWBest = distW;
            distBest = dist;
            g = 2;
        }
        skipw = yUL - yOL < this.getHeight() / 4 || xUL > this.getWidth() / 3 || xOL > this.getWidth() / 3;
        dist = this.getM(yOR, yUR, xOR, xUR);
        distW = dist == 0.0 ? distBest / (double)((yUR - yOR + 1) / 4) : dist / (double)((yUR - yOR + 1) / 4);
        if (skipw || Math.abs(distW) < Math.abs(distWBest)) {
            boolean bl = skipw = yUR - yOR < this.getHeight() / 4 || xUR > this.getHeight() * 2 / 3 || xOR > this.getWidth() * 2 / 3;
            if (!skipw) {
                distWBest = distW;
                distBest = dist;
                g = 3;
            }
        }
        int turn = 60;
        this.grid = g > 1 ? this.turn((double)(distBest * (double)turn)).grid : this.turn((double)(-distBest * (double)turn)).grid;
    }

    public PixelGrid turn(double angle) {
        if (angle == 0.0) {
            return this;
        }
        while (angle < 0.0) {
            angle += 360.0;
        }
        int newWidth = (int)(Math.abs(Math.cos((angle /= 180.0) * Math.PI) * (double)this.getWidth()) + Math.abs(Math.sin(angle * Math.PI) * (double)this.getHeight()));
        int newHeight = (int)(Math.abs(Math.sin(angle * Math.PI) * (double)this.getWidth()) + Math.abs(Math.cos(angle * Math.PI) * (double)this.getHeight()));
        PixelGrid l = new PixelGrid(newWidth, newHeight);
        int left = (newWidth - this.getWidth()) / 2;
        int top = (newHeight - this.getHeight()) / 2;
        int[][] newGrid = new int[newWidth][newHeight];
        for (int x = 0; x < newWidth; ++x) {
            for (int y = 0; y < newHeight; ++y) {
                int[] n = Utilities.turnCoordinates(x - left, y - top, this.getWidth() / 2, this.getHeight() / 2, -(angle * 180.0));
                newGrid[x][y] = n[0] < 0 || n[0] >= this.getWidth() || n[1] < 0 || n[1] >= this.getHeight() ? this.owner.getJas().getColorFaktor() - 1 : this.grid[n[0]][n[1]];
            }
        }
        l.setGrid(newGrid);
        return l;
    }

    private double getM(int x0, int x1, int y0, int y1) {
        return (double)(y0 - y1) / (double)(x0 - x1);
    }

    public static void fillLetter(Letter l) {
        int limit = 200;
        int[][] tmp = new int[l.getWidth()][l.getHeight()];
        for (int x = 0; x < l.getWidth(); ++x) {
            for (int y = 0; y < l.getHeight(); ++y) {
                if (l.grid[x][y] <= limit || tmp[x][y] == 1) continue;
                PixelObject p = new PixelObject(l);
                PixelGrid.recFill(p, l, x, y, tmp, 0);
                if (!p.isBordered() || p.getSize() >= 60) continue;
                l.fillWithObject(p, 0);
            }
        }
    }

    public static int[] getDimension(int[][] grid) {
        int x;
        int y;
        int y2;
        int x2;
        int topLines = 0;
        int bottomLines = 0;
        int leftLines = 0;
        int rightLines = 0;
        int width = grid.length;
        int height = grid[0].length;
        block0: for (x2 = 0; x2 < width; ++x2) {
            for (y2 = 0; y2 < height; ++y2) {
                if (grid[x2][y2] == 0) break block0;
            }
            ++leftLines;
        }
        block2: for (x2 = width - 1; x2 >= 0; --x2) {
            for (y2 = 0; y2 < height; ++y2) {
                if (grid[x2][y2] == 0) break block2;
            }
            ++rightLines;
        }
        if (leftLines >= width || width - rightLines > width) {
            return new int[]{0, 0};
        }
        block4: for (y = 0; y < height; ++y) {
            for (x = leftLines; x < width - rightLines; ++x) {
                if (grid[x][y] == 0) break block4;
            }
            ++topLines;
        }
        block6: for (y = height - 1; y >= 0; --y) {
            for (x = leftLines; x < width - rightLines; ++x) {
                if (grid[x][y] == 0) break block6;
            }
            ++bottomLines;
        }
        if (width - leftLines - rightLines < 0 || height - topLines - bottomLines < 0) {
            return new int[]{0, 0};
        }
        return new int[]{width - leftLines - rightLines, height - topLines - bottomLines};
    }

    public static int[][] getGridCopy(int[][] grid) {
        if (grid.length == 0) {
            return null;
        }
        int[][] ret = new int[grid.length][grid[0].length];
        for (int x = 0; x < grid.length; ++x) {
            for (int y = 0; y < grid[0].length; ++y) {
                ret[x][y] = grid[x][y];
            }
        }
        return ret;
    }

    public static int getGridHeight(int[][] grid) {
        if (grid.length == 0) {
            return 0;
        }
        return grid[0].length;
    }

    public static int getGridWidth(int[][] grid) {
        return grid.length;
    }

    public static int getMaxPixelValue(JAntiCaptcha owner) {
        return owner.getJas().getColorFaktor() - 1;
    }

    public static int getPixelValue(int x, int y, int[][] grid) {
        if (x < 0 || x >= grid.length) {
            return -1;
        }
        if (y < 0 || grid.length == 0 || y >= grid[0].length) {
            return -1;
        }
        return grid[x][y];
    }

    private static void recFill(PixelObject p, Letter l, int x, int y, int[][] tmp, int i) {
        ++i;
        if (x >= 0 && y >= 0 && x < l.getWidth() && y < l.getHeight() && l.grid[x][y] > 200 && tmp[x][y] != 1) {
            if (x == 0 || y == 0 || x == l.getWidth() - 1 || y == l.getHeight() - 1) {
                p.setBordered(false);
            }
            p.add(x, y, 0xFF0000);
            tmp[x][y] = 1;
            PixelGrid.recFill(p, l, x - 1, y, tmp, i);
            PixelGrid.recFill(p, l, x, y - 1, tmp, i);
            PixelGrid.recFill(p, l, x + 1, y, tmp, i);
            PixelGrid.recFill(p, l, x, y + 1, tmp, i);
        }
    }

    public static void setPixelValue(int x, int y, int[][] localGrid, int value) {
        try {
            localGrid[x][y] = value;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PixelGrid(int width, int height) {
        this.grid = new int[width][height];
        this.logger = LogController.CL();
    }

    public void blurIt(int faktor) {
        int[][] newGrid = new int[this.getWidth()][this.getHeight()];
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                PixelGrid.setPixelValue(x, y, newGrid, this.getAverage(x, y, faktor, faktor));
            }
        }
        this.grid = newGrid;
    }

    public boolean clean() {
        int x;
        boolean lineIsClear;
        int y;
        int y2;
        boolean rowIsClear;
        int x2;
        int topLines = 0;
        int bottomLines = 0;
        int leftLines = 0;
        int rightLines = 0;
        int avg = this.getAverage();
        for (x2 = 0; x2 < this.getWidth(); ++x2) {
            rowIsClear = true;
            for (y2 = 0; y2 < this.getHeight(); ++y2) {
                if (!this.isElement(this.getPixelValue(x2, y2), avg)) continue;
                rowIsClear = false;
                break;
            }
            if (!rowIsClear) break;
            ++leftLines;
        }
        for (x2 = this.getWidth() - 1; x2 >= 0; --x2) {
            rowIsClear = true;
            for (y2 = 0; y2 < this.getHeight(); ++y2) {
                if (!this.isElement(this.getPixelValue(x2, y2), avg)) continue;
                rowIsClear = false;
                break;
            }
            if (!rowIsClear) break;
            ++rightLines;
        }
        if (leftLines >= this.getWidth() || this.getWidth() - rightLines > this.getWidth()) {
            this.logger.severe("cleaning failed. nothing left1");
            this.grid = new int[0][0];
            return false;
        }
        for (y = 0; y < this.getHeight(); ++y) {
            lineIsClear = true;
            for (x = leftLines; x < this.getWidth() - rightLines; ++x) {
                if (!this.isElement(this.getPixelValue(x, y), avg)) continue;
                lineIsClear = false;
                break;
            }
            if (!lineIsClear) break;
            ++topLines;
        }
        for (y = this.getHeight() - 1; y >= 0; --y) {
            lineIsClear = true;
            for (x = leftLines; x < this.getWidth() - rightLines; ++x) {
                if (!this.isElement(this.getPixelValue(x, y), avg)) continue;
                lineIsClear = false;
                break;
            }
            if (!lineIsClear) break;
            ++bottomLines;
        }
        if (this.getWidth() - leftLines - rightLines < 0 || this.getHeight() - topLines - bottomLines < 0) {
            this.logger.severe("cleaning failed. nothing left");
            this.grid = new int[0][0];
            return false;
        }
        int[][] ret = new int[this.getWidth() - leftLines - rightLines][this.getHeight() - topLines - bottomLines];
        this.location[0] = this.location[0] + leftLines;
        this.location[1] = this.location[1] + topLines;
        for (int y3 = 0; y3 < this.getHeight() - topLines - bottomLines; ++y3) {
            for (x = 0; x < this.getWidth() - leftLines - rightLines; ++x) {
                ret[x][y3] = this.getPixelValue(x + leftLines, y3 + topLines);
            }
        }
        this.grid = ret;
        return true;
    }

    public void cleanByColor(int i, double d) {
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                if (!(Colors.getColorDifference((int)i, (int)this.getPixelValue(x, y)) < d)) continue;
                this.setPixelValue(x, y, this.getMaxPixelValue());
            }
        }
    }

    public void cleanBackgroundByColor(int avg) {
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                int dif = Math.abs(avg - this.getPixelValue(x, y));
                if (dif >= (int)((double)this.getMaxPixelValue() * this.owner.getJas().getDouble("BackgroundSampleCleanContrast"))) continue;
                this.setPixelValue(x, y, this.getMaxPixelValue());
            }
        }
    }

    public void cleanBackgroundBySample(int px, int py, int width, int height) {
        int avg = this.getAverage(px + width / 2, py + height / 2, width, height);
        this.cleanBackgroundByColor(avg);
    }

    public void colorObject(PixelObject object, int color) {
        for (int i = 0; i < object.getSize(); ++i) {
            this.setPixelValue(object.elementAt(i)[0], object.elementAt(i)[1], color);
        }
    }

    public Letter createLetter() {
        Letter ret = new Letter();
        ret.setOwner(this.owner);
        return ret;
    }

    public void crop(int leftPadding, int topPadding, int rightPadding, int bottomPadding) {
        int newWidth = this.getWidth() - (leftPadding + rightPadding);
        int newHeight = this.getHeight() - (topPadding + bottomPadding);
        int[][] newGrid = new int[newWidth][newHeight];
        this.location[0] = this.location[0] + leftPadding;
        this.location[1] = this.location[1] + topPadding;
        for (int x = 0; x < newWidth; ++x) {
            for (int y = 0; y < newHeight; ++y) {
                newGrid[x][y] = this.grid[x + leftPadding][y + topPadding];
            }
        }
        this.grid = newGrid;
    }

    public void desinx(double max, double omega, double phi) {
        omega = Math.PI * 2 / omega;
        int[][] tmp = new int[this.getWidth()][this.getHeight()];
        for (int y = 0; y < this.getHeight(); ++y) {
            int shift = (int)(max * Math.sin(omega * ((double)y + phi)));
            for (int x = 0; x < this.getWidth(); ++x) {
                tmp[x][y] = x + shift < this.getWidth() && x + shift >= 0 ? this.grid[x + shift][y] : 255;
            }
        }
        this.setGrid(tmp);
    }

    public void desiny(double max, double omega, double phi) {
        omega = Math.PI * 2 / omega;
        int[][] tmp = new int[this.getWidth()][this.getHeight()];
        for (int x = 0; x < this.getWidth(); ++x) {
            int shift = (int)(max * Math.sin(omega * ((double)x + phi)));
            for (int y = 0; y < this.getHeight(); ++y) {
                tmp[x][y] = y + shift < this.getHeight() && y + shift >= 0 ? this.grid[x][y + shift] : 255;
            }
        }
        this.setGrid(tmp);
    }

    public int getAverage() {
        int[] avg = new int[]{0, 0, 0};
        int i = 0;
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                int[] bv = Colors.hexToRgb((int)this.getPixelValue(x, y));
                avg[0] = avg[0] + bv[0];
                avg[1] = avg[1] + bv[1];
                avg[2] = avg[2] + bv[2];
                ++i;
            }
        }
        if (i == 0) {
            return 0;
        }
        avg[0] = avg[0] / i;
        avg[1] = avg[1] / i;
        avg[2] = avg[2] / i;
        return Colors.rgbToHex((int[])avg);
    }

    public int getAverage(int px, int py, int width, int height) {
        int[] avg = new int[]{0, 0, 0};
        int i = 0;
        int halfW = width / 2;
        int halfH = height / 2;
        if (width == 1 && px == 0) {
            width = 2;
        }
        if (height == 1 && py == 0) {
            height = 2;
        }
        for (int x = Math.max(0, px - halfW); x < Math.min(px + width - halfW, this.getWidth()); ++x) {
            for (int y = Math.max(0, py - halfH); y < Math.min(py + height - halfH, this.getHeight()); ++y) {
                int[] bv = Colors.hexToRgb((int)this.getPixelValue(x, y));
                avg[0] = avg[0] + bv[0];
                avg[1] = avg[1] + bv[1];
                avg[2] = avg[2] + bv[2];
                ++i;
            }
        }
        avg[0] = avg[0] / i;
        avg[1] = avg[1] / i;
        avg[2] = avg[2] / i;
        return Colors.rgbToHex((int[])avg);
    }

    public int getAverageWithoutPoint(int px, int py, int width, int height) {
        int[] avg = new int[]{0, 0, 0};
        int i = 0;
        int halfW = width / 2;
        int halfH = height / 2;
        if (width == 1 && px == 0) {
            width = 2;
        }
        if (height == 1 && py == 0) {
            height = 2;
        }
        for (int x = Math.max(0, px - halfW); x < Math.min(px + width - halfW, this.getWidth()); ++x) {
            for (int y = Math.max(0, py - halfH); y < Math.min(py + height - halfH, this.getHeight()); ++y) {
                if (x == px && y == py) continue;
                int[] bv = Colors.hexToRgb((int)this.getPixelValue(x, y));
                avg[0] = avg[0] + bv[0];
                avg[1] = avg[1] + bv[1];
                avg[2] = avg[2] + bv[2];
                ++i;
            }
        }
        if (i > 0) {
            avg[0] = avg[0] / i;
            avg[1] = avg[1] / i;
            avg[2] = avg[2] / i;
        }
        return Colors.rgbToHex((int[])avg);
    }

    protected Vector<PixelObject> getColorObjects(int letterNum) {
        this.logger.info("Max pixel value: " + this.getMaxPixelValue());
        HashMap<Integer[], PixelObject> map = new HashMap<Integer[], PixelObject>();
        this.logger.info("" + Colors.getColorDifference((int[])new int[]{0, 0, 204}, (int[])new int[]{0, 0, 184}));
        this.logger.info("" + Colors.getColorDifference((int[])new int[]{0, 0, 204}, (int[])new int[]{60, 10, 240}));
        this.logger.info("" + Colors.getColorDifference((int[])new int[]{255, 255, 255}, (int[])new int[]{0, 0, 0}));
        int avg = this.getAverage();
        int intensivity = 8;
        int h = this.getWidth() / letterNum / 4;
        Integer[] last = null;
        int d = 0;
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                Integer key = this.getPixelValue(x, y);
                int[] rgbA = Colors.hexToRgb((int)key);
                if (this.isElement(key, avg) || Colors.rgb2hsb((int)rgbA[0], (int)rgbA[1], (int)rgbA[2])[0] * 100.0f > 0.0f) {
                    if (map.get(key) == null) {
                        if (d++ < this.getHeight() * 2) {
                            d = 0;
                            int[] bv = Colors.hexToRgb((int)key);
                            boolean found = false;
                            if (last != null && Colors.getHueColorDifference((int[])bv, (int[])Colors.hexToRgb((int)((PixelObject)map.get(last)).getAverage())) < (double)intensivity) {
                                ((PixelObject)map.get(last)).add(x, y, key);
                                found = true;
                            } else {
                                Iterator iterator = map.keySet().iterator();
                                Iterator valsiter = map.values().iterator();
                                Integer[] bestKey = new Integer[]{-1, -1};
                                double bestValue = 255.0;
                                double dif = 255.0;
                                while (iterator.hasNext() && valsiter.hasNext()) {
                                    Integer[] key2 = (Integer[])iterator.next();
                                    PixelObject object = (PixelObject)valsiter.next();
                                    if (!(Math.abs((double)(x - key2[1] - object.getWidth())) < (double)h) || !((dif = Colors.getHueColorDifference((int[])bv, (int[])Colors.hexToRgb((int)object.getAverage()))) < bestValue)) continue;
                                    bestKey = key2;
                                    bestValue = dif;
                                }
                                if (bestValue < (double)intensivity) {
                                    ((PixelObject)map.get(bestKey)).add(x, y, key);
                                    found = true;
                                }
                            }
                            if (found) continue;
                            PixelObject object = new PixelObject(this);
                            object.add(x, y, key);
                            last = new Integer[]{key, x};
                            map.put(last, object);
                            continue;
                        }
                        PixelObject object = new PixelObject(this);
                        object.add(x, y, key);
                        last = new Integer[]{key, x};
                        map.put(last, object);
                        d = 0;
                        continue;
                    }
                    ((PixelObject)map.get(key)).add(x, y, key);
                    continue;
                }
                ++d;
            }
        }
        ArrayList<Object[]> els = new ArrayList<Object[]>();
        Iterator vals = map.values().iterator();
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext() && vals.hasNext()) {
            PixelObject ob = (PixelObject)vals.next();
            els.add(new Object[]{keys.next(), ob});
        }
        Collections.sort(els, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                Letter letter1 = ((PixelObject)o1[1]).toLetter();
                Letter letter2 = ((PixelObject)o2[1]).toLetter();
                if (letter1.getElementPixel() > letter2.getElementPixel()) {
                    return 1;
                }
                return 0;
            }
        });
        int c = map.size();
        if (c > letterNum) {
            Iterator iter = els.iterator();
            double addd = intensivity / 2;
            while (c > letterNum) {
                if (!iter.hasNext()) {
                    iter = els.iterator();
                    addd += 1.0;
                }
                Object[] thisel = (Object[])iter.next();
                Integer[] integers = (Integer[])thisel[0];
                PixelObject object = (PixelObject)thisel[1];
                Iterator iterator = els.iterator();
                Integer[] bestKey = null;
                PixelObject bestobj = null;
                double bestValue = Double.MAX_VALUE;
                double dif = Double.MAX_VALUE;
                double dif2 = Double.MAX_VALUE;
                while (iterator.hasNext()) {
                    Object[] it = (Object[])iterator.next();
                    PixelObject obj = (PixelObject)it[1];
                    Integer[] key2 = (Integer[])it[0];
                    if (key2 == integers) continue;
                    dif = key2[1] - integers[1];
                    dif2 = Math.abs((double)(key2[1] + obj.getWidth() - (integers[1] + object.getWidth())));
                    if (dif == 0.0 || dif2 == 0.0 || dif < 0.0 && dif + (double)obj.getWidth() > 0.0) {
                        ((PixelObject)map.get(key2)).add(object);
                        map.remove(integers);
                        iter.remove();
                        --c;
                        bestKey = null;
                        break;
                    }
                    if (Math.abs(dif) < bestValue) {
                        bestKey = key2;
                        bestobj = obj;
                        bestValue = Math.abs(dif);
                    }
                    if (!(dif2 < bestValue)) continue;
                    bestKey = key2;
                    bestobj = obj;
                    bestValue = dif2;
                }
                if (bestKey == null || !((dif = Colors.getHueColorDifference((int[])Colors.hexToRgb((int)bestobj.getAverage()), (int[])Colors.hexToRgb((int)object.getAverage()))) < addd)) continue;
                ((PixelObject)map.get(bestKey)).add(object);
                map.remove(integers);
                iter.remove();
                --c;
            }
        }
        ArrayList ar = new ArrayList();
        ar.addAll(map.keySet());
        Collections.sort(ar, new Comparator<Integer[]>(){

            @Override
            public int compare(Integer[] o1, Integer[] o2) {
                return o1[1].compareTo(o2[1]);
            }
        });
        Iterator iterator2 = ar.iterator();
        Vector<PixelObject> ret = new Vector<PixelObject>();
        while (iterator2.hasNext()) {
            PixelObject it = (PixelObject)map.get(iterator2.next());
            ret.add(it);
        }
        return ret;
    }

    public String getDim() {
        return "(" + this.getWidth() + "/" + this.getHeight() + ")";
    }

    public BufferedImage getFullImage() {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            this.logger.severe("Dimensionen falsch: " + this.getDim());
            return null;
        }
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D graphics = image.createGraphics();
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                graphics.setColor(new Color(this.getPixelValue(x, y) == 0 ? 0 : 0xFFFFFF));
                graphics.fillRect(x, y, 1, 1);
            }
        }
        return image;
    }

    public int[][] getGrid() {
        return this.grid;
    }

    public int[][] getGridCopy() {
        int[][] ret = new int[this.getWidth()][this.getHeight()];
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                ret[x][y] = this.grid[x][y];
            }
        }
        return ret;
    }

    public int getHeight() {
        if (this.grid.length == 0) {
            return 0;
        }
        return this.grid[0].length;
    }

    public BufferedImage getImage() {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            this.logger.severe("Dimensionen falsch: " + this.getDim());
            return null;
        }
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D graphics = image.createGraphics();
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                graphics.setColor(new Color(this.getPixelValue(x, y)));
                graphics.fillRect(x, y, 1, 1);
            }
        }
        return image;
    }

    public BufferedImage getImage(int faktor) {
        if (this.getWidth() * faktor <= 0 || this.getHeight() * faktor <= 0) {
            BufferedImage image = new BufferedImage(1, 1, 1);
            return image;
        }
        BufferedImage image = new BufferedImage(this.getWidth() * faktor, this.getHeight() * faktor, 1);
        Graphics2D graphics = image.createGraphics();
        for (int y = 0; y < this.getHeight() * faktor; y += faktor) {
            for (int x = 0; x < this.getWidth() * faktor; x += faktor) {
                graphics.setColor(new Color(this.getPixelValue(x / faktor, y / faktor)));
                graphics.fillRect(x, y, faktor, faktor);
            }
        }
        return image;
    }

    public int[] getLocation() {
        return this.location;
    }

    public int getMaxPixelValue() {
        return PixelGrid.getMaxPixelValue(this.owner);
    }

    public int getMaxPixelValue(double faktor) {
        return (int)((double)PixelGrid.getMaxPixelValue(this.owner) * faktor);
    }

    private void getObject(int x, int y, int[][] tmpGrid, PixelObject object) {
        if (x < 0 || y < 0 || tmpGrid.length <= x || tmpGrid[0].length <= y || tmpGrid[x][y] < 0) {
            return;
        }
        int localValue = PixelGrid.getPixelValue(x, y, tmpGrid);
        try {
            if (object.doesColorAverageFit(localValue)) {
                object.add(x, y, localValue);
                tmpGrid[x][y] = -1;
                this.getObject(x - 1, y, tmpGrid, object);
                if (this.owner.getJas().getBoolean("followXLines")) {
                    this.getObject(x - 1, y - 1, tmpGrid, object);
                }
                this.getObject(x, y - 1, tmpGrid, object);
                if (this.owner.getJas().getBoolean("followXLines")) {
                    this.getObject(x + 1, y - 1, tmpGrid, object);
                }
                this.getObject(x + 1, y, tmpGrid, object);
                if (this.owner.getJas().getBoolean("followXLines")) {
                    this.getObject(x + 1, y + 1, tmpGrid, object);
                }
                this.getObject(x, y + 1, tmpGrid, object);
                if (this.owner.getJas().getBoolean("followXLines")) {
                    this.getObject(x - 1, y + 1, tmpGrid, object);
                }
            }
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
        }
    }

    public Vector<PixelObject> getObjects(double contrast, double objectContrast) {
        int[][] tmpGrid = this.getGridCopy();
        Vector<PixelObject> ret = new Vector<PixelObject>();
        PixelObject lastObject = null;
        boolean showdebug = false;
        ScrollPaneWindow w = null;
        if (showdebug) {
            w = new ScrollPaneWindow();
        }
        if (showdebug) {
            w.setTitle("getObjects2");
        }
        if (showdebug) {
            w.setImage(0, 0, this.getImage());
        }
        int line = 1;
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                PixelObject object;
                int d;
                if (tmpGrid[x][y] < 0 || !((double)this.getPixelValue(x, y) <= objectContrast * (double)this.getMaxPixelValue())) continue;
                int dist = 100;
                if (lastObject != null) {
                    int xd = x - lastObject.getXMin() + lastObject.getWidth() / 2;
                    int yd = y - lastObject.getYMin() + lastObject.getHeight() / 2;
                    dist = xd * xd + yd * yd;
                }
                if (lastObject != null && lastObject.getArea() < this.owner.getJas().getInteger("minimumObjectArea") && dist < (d = this.owner.getJas().getInteger("minimumLetterWidth") / 2 + 1) * d) {
                    object = lastObject;
                    for (int i = 0; i < ret.size(); ++i) {
                        if (ret.elementAt(i) != object) continue;
                        ret.remove(i);
                        break;
                    }
                    this.logger.finer("Verfolge weiter Letztes Object: area:" + lastObject.getArea() + " dist: " + dist);
                } else {
                    object = new PixelObject(this);
                    object.setContrast(contrast);
                    object.setWhiteContrast(objectContrast);
                }
                if (showdebug && object.getArea() > 20) {
                    w.setImage(0, line, this.getImage());
                }
                int tmp = object.getSize();
                this.getObject(x, y, tmpGrid, object);
                if (tmp == object.getSize()) {
                    object = new PixelObject(this);
                    object.setContrast(contrast);
                    object.setWhiteContrast(objectContrast);
                    this.getObject(x, y, tmpGrid, object);
                }
                if (object.getArea() > 20) {
                    if (showdebug) {
                        w.setImage(1, line, this.getImage());
                    }
                    if (showdebug) {
                        w.setText(2, line, "Size: " + object.getSize());
                    }
                    if (showdebug) {
                        w.setText(3, line, "AVG: " + object.getAverage());
                    }
                    if (showdebug) {
                        w.setText(4, line, "Area: " + object.getArea());
                    }
                    if (showdebug) {
                        w.setImage(5, line, object.toLetter().getImage());
                    }
                    if (showdebug) {
                        w.setText(6, line, object.toLetter().getDim());
                    }
                }
                ++line;
                lastObject = object;
                for (int i = 0; i < ret.size(); ++i) {
                    if (object.getArea() <= ret.elementAt(i).getArea()) continue;
                    ret.add(i, object);
                    object = null;
                    break;
                }
                if (object == null) continue;
                ret.add(object);
            }
        }
        if (showdebug) {
            w.refreshUI();
        }
        return ret;
    }

    public int[] getPixel() {
        int[] pix = new int[this.getWidth() * this.getHeight()];
        int pixel = 0;
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                pix[pixel] = this.getPixelValue(x, y);
                ++pixel;
            }
        }
        return pix;
    }

    public int getPixelValue(int x, int y) {
        return PixelGrid.getPixelValue(x, y, this.grid);
    }

    public String getString() {
        int avg = this.getAverage();
        StringBuilder ret = new StringBuilder();
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                if (this.isElement(this.getPixelValue(x, y), avg)) {
                    ret.append('*');
                    continue;
                }
                ret.append((int)Math.floor(9 * (this.getPixelValue(x, y) / this.getMaxPixelValue())));
            }
            ret.append(new char[]{'\r', '\n'});
        }
        return ret.toString();
    }

    public int getWidth() {
        return this.grid.length;
    }

    public void invert() {
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                int[] a = Colors.hexToRgb((int)this.getMaxPixelValue());
                int[] b = Colors.hexToRgb((int)this.getPixelValue(x, y));
                a[0] = a[0] - b[0];
                a[1] = a[1] - b[1];
                a[2] = a[2] - b[2];
                this.setPixelValue(x, y, Colors.rgbToHex((int[])a));
            }
        }
    }

    public boolean isElement(int value, int avg) {
        return (double)value < (double)avg * this.owner.getJas().getDouble("RelativeContrast");
    }

    public void normalize() {
        this.normalize(1.0);
    }

    public void normalize(double multi) {
        this.normalize(multi, 0.0, 0.0);
    }

    public void normalize(double multi, double cutMax, double cutMin) {
        int akt;
        int max = 0;
        int min = Integer.MAX_VALUE;
        cutMin *= (double)this.getMaxPixelValue();
        cutMax *= (double)this.getMaxPixelValue();
        cutMax = (double)this.getMaxPixelValue() - cutMax;
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                akt = this.getPixelValue(x, y);
                if (akt < min && (double)akt > cutMin) {
                    min = akt;
                }
                if (akt <= max || !((double)akt < cutMax)) continue;
                max = akt;
            }
        }
        Double faktor = (double)(max - min) / (double)this.getMaxPixelValue();
        this.logger.fine(min + " <> " + max + " : " + faktor);
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                akt = this.getPixelValue(x, y);
                if ((double)akt <= cutMin) {
                    this.setPixelValue(x, y, 0);
                    continue;
                }
                if ((double)akt >= cutMax) {
                    this.setPixelValue(x, y, this.getMaxPixelValue());
                    continue;
                }
                akt -= min;
                akt = (int)((double)akt / faktor);
                akt = (int)((double)akt * multi);
                akt = Math.min(akt, this.getMaxPixelValue());
                akt = Math.max(akt, 0);
                this.setPixelValue(x, y, akt);
            }
        }
    }

    public void printGrid() {
    }

    public void reduceBlackNoise(int faktor) {
        this.reduceBlackNoise(faktor, 1.0);
    }

    public void reduceBlackNoise(int faktor, double contrast) {
        int avg = this.getAverage();
        int[][] newGrid = new int[this.getWidth()][this.getHeight()];
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                if (x == 0 && y == 0 && faktor < 3) {
                    newGrid[0][0] = this.grid[0][0];
                    continue;
                }
                int localAVG = this.getAverageWithoutPoint(x, y, faktor, faktor);
                if (this.isElement(this.getPixelValue(x, y), (int)((double)avg * contrast)) && (double)localAVG >= contrast * (double)this.getMaxPixelValue()) {
                    PixelGrid.setPixelValue(x, y, newGrid, localAVG);
                    continue;
                }
                PixelGrid.setPixelValue(x, y, newGrid, this.getPixelValue(x, y));
            }
        }
        this.grid = newGrid;
    }

    public void reduceWhiteNoise(int faktor) {
        this.reduceWhiteNoise(faktor, 1.0);
    }

    public void reduceWhiteNoise(int faktor, double contrast) {
        int avg = this.getAverage();
        int[][] newGrid = new int[this.getWidth()][this.getHeight()];
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                if (x == 0 && y == 0 && faktor < 3) {
                    newGrid[0][0] = this.grid[0][0];
                    continue;
                }
                if (this.isElement(this.getPixelValue(x, y), (int)((double)avg * contrast))) continue;
                PixelGrid.setPixelValue(x, y, newGrid, this.getAverageWithoutPoint(x, y, faktor, faktor));
            }
        }
        this.grid = newGrid;
    }

    public void removeBridges(int pixels, double middel) {
        int avg = this.getAverage();
        int[][] newGrid = new int[this.getWidth()][this.getHeight()];
        int ignorh2 = (int)((double)this.getHeight() / middel);
        int ignorh1 = this.getHeight() - ignorh2;
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                if (x < pixels || y < pixels || y > ignorh1 || y < ignorh2) {
                    newGrid[x][y] = this.grid[x][y];
                    continue;
                }
                if (this.isElement(this.getPixelValue(x, y), avg)) {
                    int c = 0;
                    int i = 0;
                    while (c <= pixels && y + i < this.getHeight() && (this.isElement(this.getPixelValue(x, y + i), avg) || this.isElement(this.getPixelValue(x + 1, y + i), avg) || this.isElement(this.getPixelValue(x - 1, y + i), avg) || this.isElement(this.getPixelValue(x + 1, y + i - 1), avg) || this.isElement(this.getPixelValue(x - 1, y + i - 1), avg))) {
                        ++c;
                        ++i;
                    }
                    i = 0;
                    while (c <= pixels && y - i > 0 && (this.isElement(this.getPixelValue(x, y - i), avg) || this.isElement(this.getPixelValue(x + 1, y - i), avg) || this.isElement(this.getPixelValue(x - 1, y - i), avg) || this.isElement(this.getPixelValue(x + 1, y - i - 1), avg) || this.isElement(this.getPixelValue(x - 1, y - i - 1), avg))) {
                        ++c;
                        ++i;
                    }
                    if (c <= pixels) {
                        PixelGrid.setPixelValue(x, y, newGrid, this.getMaxPixelValue());
                        continue;
                    }
                    newGrid[x][y] = this.grid[x][y];
                    continue;
                }
                newGrid[x][y] = this.grid[x][y];
            }
        }
        this.grid = newGrid;
    }

    public void removeObjectFromGrid(PixelObject object) {
        this.colorObject(object, this.getMaxPixelValue());
    }

    public void removeSmallObjects(double contrast, double objectContrast) {
        int tmp = this.owner.getJas().getInteger("minimumObjectArea");
        this.owner.getJas().set("minimumObjectArea", 0);
        Vector<PixelObject> ret = this.getObjects(contrast, objectContrast);
        this.owner.getJas().set("minimumObjectArea", tmp);
        for (int i = 1; i < ret.size(); ++i) {
            this.removeObjectFromGrid(ret.elementAt(i));
        }
    }

    public void removeSmallObjects(double contrast, double objectContrast, int maxSize) {
        int tmp = this.owner.getJas().getInteger("minimumObjectArea");
        this.owner.getJas().set("minimumObjectArea", 0);
        Vector<PixelObject> ret = this.getObjects(contrast, objectContrast);
        this.owner.getJas().set("minimumObjectArea", tmp);
        for (int i = 1; i < ret.size(); ++i) {
            if (ret.elementAt(i).getSize() >= maxSize) continue;
            this.removeObjectFromGrid(ret.elementAt(i));
        }
    }

    public void removeSmallObjects(double contrast, double objectContrast, int maxSize, int mindistx, int mindisty) {
        int tmp = this.owner.getJas().getInteger("minimumObjectArea");
        this.owner.getJas().set("minimumObjectArea", 0);
        Vector<PixelObject> ret = this.getObjects(contrast, objectContrast);
        this.owner.getJas().set("minimumObjectArea", tmp);
        block0: for (int i = 0; i < ret.size(); ++i) {
            PixelObject el = ret.elementAt(i);
            if (el.getSize() >= maxSize) continue;
            for (PixelObject o : ret) {
                if (el.getSize() < maxSize || !o.isTouching(el, true, mindistx, mindisty)) continue;
                continue block0;
            }
            this.removeObjectFromGrid(el);
        }
    }

    public void sampleDown(int faktor) {
        int newWidth = (int)Math.ceil((double)this.getWidth() / (double)faktor);
        int newHeight = (int)Math.ceil((double)this.getHeight() / (double)faktor);
        int[][] newGrid = new int[this.getWidth()][this.getHeight()];
        for (int x = 0; x < newWidth; ++x) {
            for (int y = 0; y < newHeight; ++y) {
                int newY;
                int newX;
                int gy;
                int gx;
                int localAVG = 0;
                int values = 0;
                for (gx = 0; gx < faktor; ++gx) {
                    for (gy = 0; gy < faktor; ++gy) {
                        newX = x * faktor + gx;
                        newY = y * faktor + gy;
                        if (newX > this.getWidth() || newY > this.getHeight()) continue;
                        localAVG = Colors.mixColors((int)localAVG, (int)this.getPixelValue(newX, newY), (int)values, (int)1);
                        ++values;
                    }
                }
                for (gx = 0; gx < faktor; ++gx) {
                    for (gy = 0; gy < faktor; ++gy) {
                        newX = x * faktor + gx;
                        newY = y * faktor + gy;
                        PixelGrid.setPixelValue(newX, newY, newGrid, localAVG);
                    }
                }
            }
        }
        this.grid = newGrid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveImageasJpg(File file) {
        BufferedImage bimg = null;
        bimg = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        bimg.setRGB(0, 0, this.getWidth(), this.getHeight(), this.getPixel(), 0, this.getWidth());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            ImageProvider.writeImage((RenderedImage)bimg, (String)"jpg", (OutputStream)fos);
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
        }
        finally {
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public void setGrid(int[][] letterGrid) {
        this.grid = letterGrid;
    }

    public void setGridCopy(int[][] grid, int leftPadding, int topPadding, int rightPadding, int bottomPadding) {
        int newWidth = PixelGrid.getGridWidth(grid) - (leftPadding + rightPadding);
        int newHeight = PixelGrid.getGridHeight(grid) - (topPadding + bottomPadding);
        int[][] newGrid = new int[newWidth][newHeight];
        this.location[0] = 0;
        this.location[1] = 0;
        for (int x = 0; x < newWidth; ++x) {
            for (int y = 0; y < newHeight; ++y) {
                newGrid[x][y] = grid[x + leftPadding][y + topPadding];
            }
        }
        this.grid = newGrid;
    }

    public void setLocation(int[] loc) {
        this.location = loc;
    }

    public void setOrgGrid(int[][] grid) {
        this.tmpGrid = grid;
    }

    public void setOwner(JAntiCaptcha owner) {
        this.owner = owner;
    }

    public void setPixel(int[] pixel) {
        this.pixel = pixel;
        int i = 0;
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                this.grid[x][y] = pixel[i++];
            }
        }
    }

    public void setPixelValue(int x, int y, int value) {
        PixelGrid.setPixelValue(x, y, this.grid, value);
    }

    public void testColor() {
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                this.setPixelValue(x, y, this.getPixelValue(x, y));
            }
        }
    }

    public void toBlackAndWhite() {
        this.toBlackAndWhite(1.0);
    }

    public void toBlackAndWhite(double contrast) {
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                this.setPixelValue(x, y, this.isElement(this.getPixelValue(x, y), (int)((double)this.getMaxPixelValue() * contrast)) ? 0 : this.getMaxPixelValue());
            }
        }
    }

    public String toHsbColorString() {
        StringBuilder ret = new StringBuilder();
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                int[] rgb = Colors.hexToRgb((int)this.getPixelValue(x, y));
                float[] hsb = Colors.rgb2hsb((int)rgb[0], (int)rgb[1], (int)rgb[2]);
                ret.append("y(");
                ret.append(y);
                ret.append(")x(");
                ret.append(x);
                ret.append(")=");
                ret.append(hsb[0] * 100.0f);
                ret.append('\n');
            }
        }
        return ret.toString();
    }
}

