/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import jd.nutils.ColorSpaceConverter;
import jd.nutils.Colors;

public class ColoredObject {
    private static double getDiff(double[] din99a, double[] din99b) {
        double dif0 = din99a[0] - din99b[0];
        double dif1 = din99a[1] - din99b[1];
        double dif2 = din99a[2] - din99b[2];
        return Math.sqrt(dif0 * dif0 + dif1 * dif1 + dif2 * dif2);
    }

    private static boolean getRGBDist(int a, int b, double dist) {
        float[] ca = new Color(a).getRGBColorComponents(null);
        float[] cb = new Color(b).getRGBColorComponents(null);
        for (int i = 0; i < cb.length; ++i) {
            if (!((double)Math.abs(ca[i] - cb[i]) > dist)) continue;
            return false;
        }
        return true;
    }

    public static List<PixelObject> getObjects(PixelGrid grid, double tollerance, int neighbourradius, int maxObjects) {
        double[][][] din99Grid = new double[grid.getWidth()][grid.getHeight()][];
        ColorSpaceConverter csc = new ColorSpaceConverter();
        ArrayList<PixelObject> ret = new ArrayList<PixelObject>();
        double tr = tollerance / 8.0;
        double trgb = tollerance * 3.0;
        for (int x = 0; x < grid.getWidth(); ++x) {
            for (int y = 0; y < grid.getHeight(); ++y) {
                int c = grid.getGrid()[x][y];
                if (c == 0xFFFFFF || c < 0) continue;
                PixelObject n = new PixelObject(grid);
                n.add(x, y, grid.getGrid()[x][y]);
                double[] din99a = din99Grid[x][y];
                ArrayList<PixelObject> merge = new ArrayList<PixelObject>();
                for (PixelObject o : ret) {
                    double diff;
                    int[] atk;
                    double cd;
                    if (!o.isTouching(x, y, true, neighbourradius, neighbourradius) || !ColoredObject.getRGBDist(c, o.getAverage(), trgb)) continue;
                    if (din99a == null) {
                        din99Grid[x][y] = csc.RGBtoDIN99(Colors.getRGB((int)c));
                        din99a = din99Grid[x][y];
                    }
                    if ((cd = ColoredObject.getDiff(din99a, csc.RGBtoDIN99(Colors.getRGB((int)o.getAverage())))) < tollerance) {
                        merge.add(o);
                        continue;
                    }
                    if (!(cd < tollerance * 2.0) || (atk = o.getNextPixel(x, y)) == null) continue;
                    double[] atkc = din99Grid[atk[0]][atk[1]];
                    if (atkc == null) {
                        din99Grid[x][y] = csc.RGBtoDIN99(Colors.getRGB((int)grid.getGrid()[atk[0]][atk[1]]));
                        atkc = din99Grid[x][y];
                    }
                    if (!((diff = ColoredObject.getDiff(din99a, atkc)) < tr)) continue;
                    merge.add(o);
                }
                if (merge.size() == 0) {
                    ret.add(n);
                    continue;
                }
                if (merge.size() == 1) {
                    ((PixelObject)merge.get(0)).add(n);
                    continue;
                }
                for (PixelObject po : merge) {
                    ret.remove(po);
                    n.add(po);
                }
                ret.add(n);
            }
        }
        if (maxObjects != -1) {
            while (ret.size() > maxObjects) {
                PixelObject smallest = null;
                for (PixelObject o : ret) {
                    if (smallest == null) {
                        smallest = o;
                        continue;
                    }
                    if (o.getSize() >= smallest.getSize()) continue;
                    smallest = o;
                }
                double[] din99a = csc.RGBtoDIN99(Colors.getRGB((int)smallest.getAverage()));
                double best = Double.MAX_VALUE;
                ret.remove(smallest);
                PixelObject mergeob = null;
                for (PixelObject pixelObject : ret) {
                    double[] din99b = csc.RGBtoDIN99(Colors.getRGB((int)pixelObject.getAverage()));
                    double dist = ColoredObject.getDiff(din99a, din99b);
                    if (!(best > dist)) continue;
                    best = dist;
                    mergeob = pixelObject;
                }
                if (mergeob != null) {
                    mergeob.add(smallest);
                    continue;
                }
                ret.add(smallest);
            }
        }
        return ret;
    }
}

