/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import jd.captcha.JAntiCaptcha;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.utils.GifDecoder;
import jd.nutils.Colors;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.seamless.util.io.IO;

public class GifBlackCleaner {
    public static void main(String[] args) throws IOException, InterruptedException, DialogClosedException, DialogCanceledException {
        byte[] bytes = IO.readBytes((File)new File("animatedBlack.gif"));
        BufferedImage image = GifBlackCleaner.toBufferedImage(new ByteArrayInputStream(bytes));
        Dialog.getInstance().showConfirmDialog(0, "Image", "", new ImageIcon(image), null, null);
    }

    private static void cleanBlack(int x, int y, int[][] grid) {
        for (int x1 = Math.max(x - 2, 0); x1 < Math.min(x + 2, grid.length); ++x1) {
            for (int y1 = Math.max(y - 2, 0); y1 < Math.min(y + 2, grid[0].length); ++y1) {
                if (grid[x1][y1] != 0) continue;
                grid[x1][y1] = 0xFFFFFF;
                GifBlackCleaner.cleanBlack(x1, y1, grid);
            }
        }
    }

    public static BufferedImage toBufferedImage(InputStream is) throws InterruptedException {
        int i;
        int bl1;
        int y;
        JAntiCaptcha jac = new JAntiCaptcha();
        jac.getJas().setColorType("RGB");
        GifDecoder d = new GifDecoder();
        d.read(is);
        int n = d.getFrameCount();
        Captcha[] frames = new Captcha[d.getFrameCount()];
        for (int i2 = 0; i2 < n; ++i2) {
            BufferedImage frame = d.getFrame(i2);
            frames[i2] = jac.createCaptcha(frame);
        }
        int[][] grid = new int[frames[0].getWidth()][frames[0].getHeight()];
        for (int x = 0; x < grid.length; ++x) {
            for (y = 0; y < grid[0].length; ++y) {
                int max = 0;
                HashMap<Integer, Integer> colors = new HashMap<Integer, Integer>();
                int colorsCount = 0;
                for (int i3 = 0; i3 < frames.length; ++i3) {
                    float[] hsb = Colors.rgb2hsb((int)frames[i3].getGrid()[x][y]);
                    int distance = Colors.getRGBDistance((int)frames[i3].getGrid()[x][y]);
                    if (!colors.containsKey(frames[i3].getGrid()[x][y])) {
                        colors.put(frames[i3].getGrid()[x][y], 1);
                        ++colorsCount;
                    } else {
                        colors.put(frames[i3].getGrid()[x][y], (Integer)colors.get(frames[i3].getGrid()[x][y]) + 1);
                    }
                    if ((double)hsb[2] < 0.2 && distance < 100) continue;
                    max = Math.max(max, frames[i3].getGrid()[x][y]);
                }
                int mainColor = 0;
                int mainCount = 0;
                for (Map.Entry col : colors.entrySet()) {
                    if ((Integer)col.getValue() <= mainCount || (Integer)col.getKey() <= 10) continue;
                    mainCount = (Integer)col.getValue();
                    mainColor = (Integer)col.getKey();
                }
                grid[x][y] = mainColor;
            }
        }
        int gl1 = grid[0].length - 1;
        for (int x = 0; x < grid.length; ++x) {
            bl1 = 0;
            int bl2 = 0;
            for (i = Math.max(0, x - 6); i < Math.min(grid.length, x + 6); ++i) {
                if (grid[i][0] == 0) {
                    ++bl1;
                }
                if (grid[i][gl1] != 0) continue;
                ++bl2;
            }
            if (bl1 == 12) {
                GifBlackCleaner.cleanBlack(x, 0, grid);
            }
            if (bl2 != 12) continue;
            GifBlackCleaner.cleanBlack(x, gl1, grid);
        }
        gl1 = grid.length - 1;
        for (y = 0; y < grid.length; ++y) {
            bl1 = 0;
            int bl2 = 0;
            for (i = Math.max(0, y - 6); i < Math.min(grid[0].length, y + 6); ++i) {
                if (grid[0][i] == 0) {
                    ++bl1;
                }
                if (grid[gl1][i] != 0) continue;
                ++bl2;
            }
            if (bl1 == 12) {
                GifBlackCleaner.cleanBlack(0, y, grid);
            }
            if (bl2 != 12) continue;
            GifBlackCleaner.cleanBlack(gl1, y, grid);
        }
        frames[0].setGrid(grid);
        return frames[0].getImage(1);
    }
}

