/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.awt.image.BufferedImage;

public class Hq2x {
    protected static final long Amask = 0xFF000000L;
    protected static final long Ymask = 0xFF0000L;
    protected static final long Umask = 65280L;
    protected static final long Vmask = 255L;
    protected static final long trA = 0xF0000000L;
    protected static final long trY = 0x300000L;
    protected static final long trU = 1792L;
    protected static final long trV = 6L;

    protected static long abs(long v) {
        if (v >= 0L) {
            return v;
        }
        return -v;
    }

    protected static boolean diff(long w1, long w2) {
        long YUV2;
        long YUV1 = Hq2x.RGBA32toYUVA(w1);
        return Hq2x.abs((YUV1 & 0xFF000000L) - ((YUV2 = Hq2x.RGBA32toYUVA(w2)) & 0xFF000000L)) > 0xF0000000L || Hq2x.abs((YUV1 & 0xFF0000L) - (YUV2 & 0xFF0000L)) > 0x300000L || Hq2x.abs((YUV1 & 0xFF00L) - (YUV2 & 0xFF00L)) > 1792L || Hq2x.abs((YUV1 & 0xFFL) - (YUV2 & 0xFFL)) > 6L;
    }

    protected static long RGBA32toYUVA(long rgba) {
        long b = rgba & 0xFFL;
        long g = (rgba & 0xFF00L) >> 8;
        long r = (rgba & 0xFF0000L) >> 16;
        long a = (rgba & 0xFFFFFFFFFF000000L) >> 24;
        long Y = r + g + b >> 2;
        long u = 128L + (r - b >> 2);
        long v = 128L + (-r + 2L * g - b >> 3);
        return (a << 24) + (Y << 16) + (u << 8) + v;
    }

    /*
     * Opcode count of 14714 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    protected void hq2x_32(BufferedImage pIn, BufferedImage pOut) {
        int xres = pIn.getWidth();
        int yres = pIn.getHeight();
        long[] w = new long[10];
        for (int j = 0; j < yres; ++j) {
            int jj = j * 2;
            int prevline = j > 0 ? j - 1 : j;
            int nextline = j < yres - 1 ? j + 1 : j;
            block164: for (int i = 0; i < xres; ++i) {
                int ii = i * 2;
                w[2] = pIn.getRGB(i, prevline);
                w[5] = pIn.getRGB(i, j);
                w[8] = pIn.getRGB(i, nextline);
                if (i > 0) {
                    w[1] = pIn.getRGB(i - 1, prevline);
                    w[4] = pIn.getRGB(i - 1, j);
                    w[7] = pIn.getRGB(i - 1, nextline);
                } else {
                    w[1] = w[2];
                    w[4] = w[5];
                    w[7] = w[8];
                }
                if (i < xres - 1) {
                    w[3] = pIn.getRGB(i + 1, prevline);
                    w[6] = pIn.getRGB(i + 1, j);
                    w[9] = pIn.getRGB(i + 1, nextline);
                } else {
                    w[3] = w[2];
                    w[6] = w[5];
                    w[9] = w[8];
                }
                int pattern = 0;
                int flag = 1;
                long YUV1 = Hq2x.RGBA32toYUVA(w[5]);
                for (int k = 1; k <= 9; ++k) {
                    long YUV2;
                    if (k == 5) continue;
                    if (w[k] != w[5] && (Hq2x.abs((YUV1 & 0xFF000000L) - ((YUV2 = Hq2x.RGBA32toYUVA(w[k])) & 0xFF000000L)) > 0xF0000000L || Hq2x.abs((YUV1 & 0xFF0000L) - (YUV2 & 0xFF0000L)) > 0x300000L || Hq2x.abs((YUV1 & 0xFF00L) - (YUV2 & 0xFF00L)) > 1792L || Hq2x.abs((YUV1 & 0xFFL) - (YUV2 & 0xFFL)) > 6L)) {
                        pattern |= flag;
                    }
                    flag <<= 1;
                }
                switch (pattern) {
                    case 0: 
                    case 1: 
                    case 4: 
                    case 5: 
                    case 32: 
                    case 33: 
                    case 36: 
                    case 37: 
                    case 128: 
                    case 129: 
                    case 132: 
                    case 133: 
                    case 160: 
                    case 161: 
                    case 164: 
                    case 165: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 2: 
                    case 34: 
                    case 130: 
                    case 162: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 16: 
                    case 17: 
                    case 48: 
                    case 49: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 64: 
                    case 65: 
                    case 68: 
                    case 69: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 8: 
                    case 12: 
                    case 136: 
                    case 140: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 3: 
                    case 35: 
                    case 131: 
                    case 163: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 6: 
                    case 38: 
                    case 134: 
                    case 166: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 20: 
                    case 21: 
                    case 52: 
                    case 53: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 144: 
                    case 145: 
                    case 176: 
                    case 177: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 192: 
                    case 193: 
                    case 196: 
                    case 197: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                        continue block164;
                    }
                    case 96: 
                    case 97: 
                    case 100: 
                    case 101: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 40: 
                    case 44: 
                    case 168: 
                    case 172: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 9: 
                    case 13: 
                    case 137: 
                    case 141: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 18: 
                    case 50: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 80: 
                    case 81: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 72: 
                    case 76: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 10: 
                    case 138: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 66: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 24: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 7: 
                    case 39: 
                    case 135: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 148: 
                    case 149: 
                    case 180: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 224: 
                    case 225: 
                    case 228: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                        continue block164;
                    }
                    case 41: 
                    case 45: 
                    case 169: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 22: 
                    case 54: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 208: 
                    case 209: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 104: 
                    case 108: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 11: 
                    case 139: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 19: 
                    case 51: {
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp6(w[5], w[2], w[4]));
                            pOut.setRGB(ii + 1, jj, this.interp9(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 146: 
                    case 178: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp9(w[5], w[2], w[6]));
                            pOut.setRGB(ii + 1, jj + 1, this.interp6(w[5], w[6], w[8]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        continue block164;
                    }
                    case 84: 
                    case 85: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp6(w[5], w[6], w[2]));
                            pOut.setRGB(ii + 1, jj + 1, this.interp9(w[5], w[6], w[8]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        continue block164;
                    }
                    case 112: 
                    case 113: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                            continue block164;
                        }
                        pOut.setRGB(ii, jj + 1, this.interp6(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp9(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 200: 
                    case 204: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                            continue block164;
                        }
                        pOut.setRGB(ii, jj + 1, this.interp9(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp6(w[5], w[8], w[6]));
                        continue block164;
                    }
                    case 73: 
                    case 77: {
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp6(w[5], w[8], w[4]));
                            pOut.setRGB(ii, jj + 1, this.interp9(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 42: 
                    case 170: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp9(w[5], w[4], w[2]));
                            pOut.setRGB(ii, jj + 1, this.interp6(w[5], w[4], w[8]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 14: 
                    case 142: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp9(w[5], w[4], w[2]));
                            pOut.setRGB(ii + 1, jj, this.interp6(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 67: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 70: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 28: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 152: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 194: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                        continue block164;
                    }
                    case 98: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 56: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 25: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 26: 
                    case 31: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        }
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 82: 
                    case 214: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 88: 
                    case 248: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        }
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 74: 
                    case 107: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 27: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 86: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                        continue block164;
                    }
                    case 216: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 106: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 30: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 210: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 120: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                        continue block164;
                    }
                    case 75: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 29: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 198: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                        continue block164;
                    }
                    case 184: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 99: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 57: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 71: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 156: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 226: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                        continue block164;
                    }
                    case 60: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 195: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                        continue block164;
                    }
                    case 102: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 153: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 58: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp7(w[5], w[4], w[2]));
                        }
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp7(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 83: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp7(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp7(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 92: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp7(w[5], w[8], w[4]));
                        }
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp7(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 202: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp7(w[5], w[4], w[2]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp7(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                        continue block164;
                    }
                    case 78: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp7(w[5], w[4], w[2]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp7(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 154: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp7(w[5], w[4], w[2]));
                        }
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp7(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 114: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp7(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp7(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 89: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp7(w[5], w[8], w[4]));
                        }
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp7(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 90: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp7(w[5], w[4], w[2]));
                        }
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp7(w[5], w[2], w[6]));
                        }
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp7(w[5], w[8], w[4]));
                        }
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp7(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 23: 
                    case 55: {
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp6(w[5], w[2], w[4]));
                            pOut.setRGB(ii + 1, jj, this.interp9(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 150: 
                    case 182: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp9(w[5], w[2], w[6]));
                            pOut.setRGB(ii + 1, jj + 1, this.interp6(w[5], w[6], w[8]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        continue block164;
                    }
                    case 212: 
                    case 213: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp6(w[5], w[6], w[2]));
                            pOut.setRGB(ii + 1, jj + 1, this.interp9(w[5], w[6], w[8]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        continue block164;
                    }
                    case 240: 
                    case 241: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii, jj + 1, this.interp6(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp9(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 232: 
                    case 236: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                            continue block164;
                        }
                        pOut.setRGB(ii, jj + 1, this.interp9(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp6(w[5], w[8], w[6]));
                        continue block164;
                    }
                    case 105: 
                    case 109: {
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp6(w[5], w[8], w[4]));
                            pOut.setRGB(ii, jj + 1, this.interp9(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 43: 
                    case 171: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp9(w[5], w[4], w[2]));
                            pOut.setRGB(ii, jj + 1, this.interp6(w[5], w[4], w[8]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 15: 
                    case 143: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp9(w[5], w[4], w[2]));
                            pOut.setRGB(ii + 1, jj, this.interp6(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 124: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                        continue block164;
                    }
                    case 203: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                        continue block164;
                    }
                    case 62: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 211: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 118: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                        continue block164;
                    }
                    case 217: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 110: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 155: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 188: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 185: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 61: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 157: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 103: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 227: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                        continue block164;
                    }
                    case 230: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                        continue block164;
                    }
                    case 199: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                        continue block164;
                    }
                    case 220: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp7(w[5], w[8], w[4]));
                        }
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 158: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp7(w[5], w[4], w[2]));
                        }
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 234: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp7(w[5], w[4], w[2]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                        continue block164;
                    }
                    case 242: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp7(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 59: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        }
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp7(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 121: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        }
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp7(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 87: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp7(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 79: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp7(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 122: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp7(w[5], w[4], w[2]));
                        }
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp7(w[5], w[2], w[6]));
                        }
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        }
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp7(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 94: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp7(w[5], w[4], w[2]));
                        }
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        }
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp7(w[5], w[8], w[4]));
                        }
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp7(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 218: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp7(w[5], w[4], w[2]));
                        }
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp7(w[5], w[2], w[6]));
                        }
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp7(w[5], w[8], w[4]));
                        }
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 91: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        }
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp7(w[5], w[2], w[6]));
                        }
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp7(w[5], w[8], w[4]));
                        }
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp7(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 229: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                        continue block164;
                    }
                    case 167: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 173: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 181: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 186: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp7(w[5], w[4], w[2]));
                        }
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp7(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 115: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp7(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp7(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 93: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp7(w[5], w[8], w[4]));
                        }
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp7(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 206: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp7(w[5], w[4], w[2]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp7(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                        continue block164;
                    }
                    case 201: 
                    case 205: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp7(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                        continue block164;
                    }
                    case 46: 
                    case 174: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp7(w[5], w[4], w[2]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 147: 
                    case 179: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp7(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 116: 
                    case 117: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp7(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 189: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 231: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                        continue block164;
                    }
                    case 126: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        }
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                        continue block164;
                    }
                    case 219: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 125: {
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp6(w[5], w[8], w[4]));
                            pOut.setRGB(ii, jj + 1, this.interp9(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                        continue block164;
                    }
                    case 221: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp6(w[5], w[6], w[2]));
                            pOut.setRGB(ii + 1, jj + 1, this.interp9(w[5], w[6], w[8]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        continue block164;
                    }
                    case 207: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                            pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp9(w[5], w[4], w[2]));
                            pOut.setRGB(ii + 1, jj, this.interp6(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                        continue block164;
                    }
                    case 238: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                            continue block164;
                        }
                        pOut.setRGB(ii, jj + 1, this.interp9(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp6(w[5], w[8], w[6]));
                        continue block164;
                    }
                    case 190: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                            pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp9(w[5], w[2], w[6]));
                            pOut.setRGB(ii + 1, jj + 1, this.interp6(w[5], w[6], w[8]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 187: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        } else {
                            pOut.setRGB(ii, jj, this.interp9(w[5], w[4], w[2]));
                            pOut.setRGB(ii, jj + 1, this.interp6(w[5], w[4], w[8]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 243: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii, jj + 1, this.interp6(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp9(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 119: {
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp6(w[5], w[2], w[4]));
                            pOut.setRGB(ii + 1, jj, this.interp9(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                        continue block164;
                    }
                    case 233: 
                    case 237: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp10(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                        continue block164;
                    }
                    case 47: 
                    case 175: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp10(w[5], w[4], w[2]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 151: 
                    case 183: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp10(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 244: 
                    case 245: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp10(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 250: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        }
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 123: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                        continue block164;
                    }
                    case 95: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        }
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                        continue block164;
                    }
                    case 222: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 252: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        }
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp10(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 249: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[2]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp10(w[5], w[8], w[4]));
                        }
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 235: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[3], w[6]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp10(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                        continue block164;
                    }
                    case 111: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp10(w[5], w[4], w[2]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[6]));
                        continue block164;
                    }
                    case 63: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp10(w[5], w[4], w[2]));
                        }
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[9], w[8]));
                        continue block164;
                    }
                    case 159: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        }
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp10(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 215: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp10(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[7], w[4]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 246: {
                        pOut.setRGB(ii, jj, this.interp2(w[5], w[1], w[4]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp10(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 254: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[1]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        }
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        }
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp10(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 253: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[2]));
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[2]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp10(w[5], w[8], w[4]));
                        }
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp10(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 251: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[3]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp10(w[5], w[8], w[4]));
                        }
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 239: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp10(w[5], w[4], w[2]));
                        }
                        pOut.setRGB(ii + 1, jj, this.interp1(w[5], w[6]));
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp10(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[6]));
                        continue block164;
                    }
                    case 127: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp10(w[5], w[4], w[2]));
                        }
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp2(w[5], w[2], w[6]));
                        }
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp2(w[5], w[8], w[4]));
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[9]));
                        continue block164;
                    }
                    case 191: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp10(w[5], w[4], w[2]));
                        }
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp10(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[8]));
                        pOut.setRGB(ii + 1, jj + 1, this.interp1(w[5], w[8]));
                        continue block164;
                    }
                    case 223: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp2(w[5], w[4], w[2]));
                        }
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp10(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[7]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp2(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 247: {
                        pOut.setRGB(ii, jj, this.interp1(w[5], w[4]));
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp10(w[5], w[2], w[6]));
                        }
                        pOut.setRGB(ii, jj + 1, this.interp1(w[5], w[4]));
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp10(w[5], w[6], w[8]));
                        continue block164;
                    }
                    case 255: {
                        if (Hq2x.diff(w[4], w[2])) {
                            pOut.setRGB(ii, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj, this.interp10(w[5], w[4], w[2]));
                        }
                        if (Hq2x.diff(w[2], w[6])) {
                            pOut.setRGB(ii + 1, jj, (int)w[5]);
                        } else {
                            pOut.setRGB(ii + 1, jj, this.interp10(w[5], w[2], w[6]));
                        }
                        if (Hq2x.diff(w[8], w[4])) {
                            pOut.setRGB(ii, jj + 1, (int)w[5]);
                        } else {
                            pOut.setRGB(ii, jj + 1, this.interp10(w[5], w[8], w[4]));
                        }
                        if (Hq2x.diff(w[6], w[8])) {
                            pOut.setRGB(ii + 1, jj + 1, (int)w[5]);
                            continue block164;
                        }
                        pOut.setRGB(ii + 1, jj + 1, this.interp10(w[5], w[6], w[8]));
                    }
                }
            }
        }
    }

    protected int interp(long[] c, int[] nb) {
        this.normalize(c, nb);
        long total = 0L;
        long rf = 0L;
        for (int i = 0; i < c.length; ++i) {
            total += (long)nb[i];
            long r = c[i] & 0xFF0000L;
            rf += r * (long)nb[i];
        }
        rf = rf / total & 0xFF0000L;
        long gf = 0L;
        for (int i = 0; i < c.length; ++i) {
            long g = c[i] & 0xFF00L;
            gf += g * (long)nb[i];
        }
        gf = gf / total & 0xFF00L;
        long bf = 0L;
        for (int i = 0; i < c.length; ++i) {
            long b = c[i] & 0xFFL;
            bf += b * (long)nb[i];
        }
        bf = bf / total & 0xFFL;
        long af = 0L;
        for (int i = 0; i < c.length; ++i) {
            long a = c[i] & 0xFFFFFFFFFF000000L;
            af += a * (long)nb[i];
        }
        af = af / total & 0xFFFFFFFFFF000000L;
        return (int)(af + rf + gf + bf);
    }

    protected int interp(long c1, int nb1, long c2, int nb2, long c3, int nb3) {
        int total = nb1 + nb2 + nb3;
        long[] c = new long[]{c1, c2, c3};
        int[] nb = new int[]{nb1, nb2, nb3};
        this.normalize(c, nb);
        long r1 = c[0] & 0xFF0000L;
        long r2 = c[1] & 0xFF0000L;
        long r3 = c[2] & 0xFF0000L;
        long rf = (r1 * (long)nb[0] + r2 * (long)nb[1] + r3 * (long)nb[2]) / (long)total & 0xFF0000L;
        long g1 = c[0] & 0xFF00L;
        long g2 = c[1] & 0xFF00L;
        long g3 = c[2] & 0xFF00L;
        long gf = (g1 * (long)nb[0] + g2 * (long)nb[1] + g3 * (long)nb[2]) / (long)total & 0xFF00L;
        long b1 = c[0] & 0xFFL;
        long b2 = c[1] & 0xFFL;
        long b3 = c[2] & 0xFFL;
        long bf = (b1 * (long)nb[0] + b2 * (long)nb[1] + b3 * (long)nb[2]) / (long)total & 0xFFL;
        long a1 = c[0] & 0xFFFFFFFFFF000000L;
        long a2 = c[1] & 0xFFFFFFFFFF000000L;
        long a3 = c[2] & 0xFFFFFFFFFF000000L;
        long af = (a1 * (long)nb[0] + a2 * (long)nb[1] + a3 * (long)nb[2]) / (long)total & 0xFFFFFFFFFF000000L;
        return (int)(af + rf + gf + bf);
    }

    protected int interp1(long c1, long c2) {
        return this.interp(c1, 3, c2, 1, 0L, 0);
    }

    protected int interp10(long c1, long c2, long c3) {
        return this.interp(c1, 14, c2, 1, c3, 1);
    }

    protected int interp2(long c1, long c2, long c3) {
        return this.interp(c1, 2, c2, 1, c3, 1);
    }

    protected int interp5(long c1, long c2) {
        return this.interp(c1, 1, c2, 1, 0L, 0);
    }

    protected int interp6(long c1, long c2, long c3) {
        return this.interp(c1, 5, c2, 2, c3, 1);
    }

    protected int interp7(long c1, long c2, long c3) {
        return this.interp(c1, 6, c2, 1, c3, 1);
    }

    protected int interp9(long c1, long c2, long c3) {
        return this.interp(c3, 3, c1, 2, c2, 1);
    }

    protected void normalize(long[] c, int[] nb) {
        int i;
        long nc = 0L;
        for (i = c.length - 1; i >= 0; --i) {
            if ((c[i] & 0xFFFFFFFFFF000000L) == 0L) continue;
            nc = c[i];
        }
        for (i = 0; i < c.length; ++i) {
            if ((c[i] & 0xFFFFFFFFFF000000L) != 0L) continue;
            c[i] = nc & 0xFFFFFFL;
        }
    }

    public BufferedImage scale(BufferedImage img) {
        BufferedImage out = new BufferedImage(img.getWidth() * 2, img.getHeight() * 2, 2);
        this.hq2x_32(img, out);
        return out;
    }
}

